function k = getk(params, ys, sectors, countries)

    M_ = evalin('base', 'M_');
    M_.params = params;

    loadparameters = sprintf('%s = %.12f;', M_.param_names{1}, M_.params(1));
    for i=1:M_.param_nbr
        loadparameters = sprintf('%s %s = %.12f;', loadparameters, M_.param_names{i}, M_.params(i));
    end
    eval(loadparameters);

    M = numel(sectors);
    N = numel(countries);

    %set default return value
    k = NaN(N*(1+M^2), 1);

    % Initialize region-specific K
    getk_text1

    linie = 3;

    loadhuse = '';

    for i = 1:N
        for j = 1:M
            for l = 1:M
                loadhuse = sprintf('%s H_use_%u_%u_%s = @(k) k(%u);', loadhuse, j, l, countries{i}, linie);
                linie = linie+1;
            end
        end
    end

    eval(loadhuse);

    Y_VA_a_t = ys(strcmp('Y_VA_a_t', M_.endo_names));
    Y_VA_b_t = ys(strcmp('Y_VA_b_t', M_.endo_names));

    % Insert missing getk text
    getk_text2

    mc_1_a_t = ys(strcmp('mc_1_a_t', M_.endo_names));
    mc_2_a_t = ys(strcmp('mc_2_a_t', M_.endo_names));
    mc_3_a_t = ys(strcmp('mc_3_a_t', M_.endo_names));
    mc_4_a_t = ys(strcmp('mc_4_a_t', M_.endo_names));
    mc_5_a_t = ys(strcmp('mc_5_a_t', M_.endo_names));
    mc_6_a_t = ys(strcmp('mc_6_a_t', M_.endo_names));
    mc_7_a_t = ys(strcmp('mc_7_a_t', M_.endo_names));
    mc_8_a_t = ys(strcmp('mc_8_a_t', M_.endo_names));
    mc_9_a_t = ys(strcmp('mc_9_a_t', M_.endo_names));
    mc_10_a_t = ys(strcmp('mc_10_a_t', M_.endo_names));

    mc_1_b_t = ys(strcmp('mc_1_b_t', M_.endo_names));
    mc_2_b_t = ys(strcmp('mc_2_b_t', M_.endo_names));
    mc_3_b_t = ys(strcmp('mc_3_b_t', M_.endo_names));
    mc_4_b_t = ys(strcmp('mc_4_b_t', M_.endo_names));
    mc_5_b_t = ys(strcmp('mc_5_b_t', M_.endo_names));
    mc_6_b_t = ys(strcmp('mc_6_b_t', M_.endo_names));
    mc_7_b_t = ys(strcmp('mc_7_b_t', M_.endo_names));
    mc_8_b_t = ys(strcmp('mc_8_b_t', M_.endo_names));
    mc_9_b_t = ys(strcmp('mc_9_b_t', M_.endo_names));
    mc_10_b_t = ys(strcmp('mc_10_b_t', M_.endo_names));

    rk_a_t = ys(strcmp('rk_a_t', M_.endo_names));
    rk_b_t = ys(strcmp('rk_b_t', M_.endo_names));

    loadsectoraggregates = '';

    for i=1:N
        c = countries{i};
        for j = 1:M
            loadsectoraggregates = sprintf('%s Y_%u_%s = @(k) (C_%u_%s(k)+I_%u_%s(k)+H_use_%u_%s(k));\n', ...
                                           loadsectoraggregates, j, c, j, c, j, c, j, c);
            loadsectoraggregates = sprintf('%s H_%u_%s = @(k) (1-alphaH_%u_%s)*mc_%u_%s_t*Y_%u_%s(k);\n', ...
                                           loadsectoraggregates, j, c, j, c, j, c, j, c);
            for l = 1:M
                loadsectoraggregates = sprintf('%s H_%u_%u_%s = @(k) Psi_%u_%u_%s*H_%u_%s(k);\n', ...
                                               loadsectoraggregates, j, l, c, j, l, c, j, c);
            end
            loadsectoraggregates = sprintf('%s rk_%u_%s = @(k) alphaH_%u_%s*(1-alphaN_%u_%s)*mc_%u_%s_t*Y_%u_%s(k)/(omega_K_tild_%u_%s*K_%s(k));\n', ...
                                           loadsectoraggregates, j, c, j, c, j, c, j, c, j, c, j, c, c);
            loadsectoraggregates = sprintf('%s omega_K_%u_%s = @(k) omega_K_tild_%u_%s*(rk_%u_%s(k)/rk_%s_t)^(1/(1-upsi_K_%s));\n', ...
                                           loadsectoraggregates, j, c, j, c, j, c, c, c);
            loadsectoraggregates = sprintf('%s K_%u_%s = @(k) omega_K_%u_%s(k)*(rk_%s_t/rk_%u_%s(k))^(1/(1-upsi_K_%s))*K_%s(k);\n', ...
                                           loadsectoraggregates, j, c, j, c, c, j, c, c, c);
        end
    end

    eval(loadsectoraggregates)

    % Insert text for objective function
    getk_text3

    % Solve system of equations for vector k
    k = fsolve(fun, [repmat(20,[N,1]) ; zeros(N*M^2,1)+0.01], optimset('TolFun',1e-18,'Display','iter'));

end
