function hex = hashfile(varargin)
    % Return the MD5 hash of a collection of files.
    %
    % INPUTS:
    % - arg1, arg2, ...    [char]   names of the files to be hashed
    %
    % OUTPUTS:
    % - hex                [char]   MD5 hash of the files

    % Concatenate files into a temporary file
    fid = fopen('tmp.txt', 'w');
    for i=1:nargin
        filename = varargin{i};
        if isfile(filename)
            fprintf(fid, '%s\n', fileread(filename));
        else
            error('File %s does not exist.', filename);
        end
    end
    fclose(fid);

    % Compute MD5 hash
    if exist('OCTAVE_VERSION', 'builtin')
        hex = md5sum('tmp.txt');
    elseif isunix() % Works on Linux and Mac
        [~, hex] = system('md5sum tmp.txt');
        hex = strtrim(hex(1:32));
    else
        md = java.security.MessageDigest.getInstance('MD5');
        fid = fopen('tmp.txt', 'r');
        while ~feof(fid)
            line = fgets(fid);
            md.update(uint8(line));
        end
        fclose(fid);
        hex = sprintf('%02x', typecast(md.digest, 'uint8'));
    end

    % Delete temporary file
    delete('tmp.txt');

end
