function write_sensible_initial_conditions_for_steady_state(M_, oo_, kind, basename)

% Write a .mod file with sensible values for the steady state computation.
%
% I am only using this function because I am not familiar enough with
% the details of EMuSe. A smarter user should which variables must be
% 0 or 1 in the steady state, which variables should be between 0 and
% 1, which variables possibly greater than 1, ...

    if isempty(oo_)
        data = load('steady.mat');
        steady_state = data.steady_state;
    else
        steady_state = oo_.steady_state;
    end

    fid = fopen(sprintf('%s-%s.mod', basename, kind), 'w');

    fprintf(fid, 'initval;\n');

    for i=1:M_.endo_nbr
        ss = steady_state(i);
        if abs(ss-1)<1e-6
            value = 1;
        elseif abs(ss)<1e-6
            if strcmp(kind, 'one')
                value = 1;
            else
                value = 0;
            end
        elseif ss>0 && ss<1
            switch kind
              case 'one'
                value = 1;
              case 'deterministic'
                value = 0.05;
              case 'random'
                value = .5*rand;
              case 'noisy';
                value = 2;
                while value>1 || value<0
                    value = ss*exp(2*(rand-.5)*.5);
                end
              otherwise
                error('Third argument has not an admissible value.')
            end
        else
            switch kind
              case 'one'
                value = 1;
              case 'deterministic'
                value = 2;
              case 'random'
                value = 1+rand;
              case 'noisy';
                value = 0;
                while value<1
                    value = ss*exp(2*(rand-.5)*.5);
                end
              otherwise
                error('Third argument has not an admissible value.')
            end
        end
        fprintf(fid, '\t%s = %.4f;\n', M_.endo_names{i}, value);
    end

    fprintf(fid, 'end;\n');

    fclose(fid);

end
