%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                       %
%    THE ENVIRONMENTAL MULTI-SECTOR DSGE MODEL EMuSe                    %
%                                                                       %
%    EMuSe has been developed by the                                    %
%    Directorate General Economics of the Deutsche Bundesbank.          %
%                                                                       %
%    Authors:                                                           %
%    Natascha Hinterlang                                                %
%    Anika Martin                                                       %
%    Oke R�he                                                           %
%    Nikolai St�hler                                                    %
%    Johannes Strobel                                                   %
%                                                                       %
%    Contact: emuse@bundesbank.de                                       %
%                                                                       %
%    The authors are grateful to their colleagues in DG Economics,      %
%    DG Financial Stability and the Research Centre of Deutsche         %
%    Bundesbank, the Working Group on Econometric Modelling (WGEM) and  %
%    the Working Group on Forecasting (WGF) of the European System of   %
%    Central Banks (ESCB) as well as the members of the informal        %
%    network of modelling experts of the G7 Climate Change Mitigation   %
%    Working Group for their helpful discussions and valuable input     %
%    during the development of EMuSe.                                   %
%                                                                       %
%    If you use the EMuSe model, please cite                            %
%    Natascha Hinterlang, Anika Martin, Oke R�he,                       %
%    Nikolai St�hler and Johannes Strobel (2023),                       %
%    The Environmental Multi-Sector DSGE model EMuSe:                   %
%    A technical documentation,                                         %
%    Deutsche Bundesbank Technical Paper, No. 03/2023.                  %
%                                                                       %
%                                                                       %
% Access to EMuSe is only granted on the basis set out in the           %
% accompanying End User License Agreement (EULA).                       %
% Downloading, installing or using the EMuSe model implies acceptance   %
% of the EULA. If you do not agree to be bound by these terms,          %
% do not download, install or use the related Software and              %
% documentation. As further outlined in the EULA the Software           %
% is provided "as is", without any representation or warranty of any    %
% kind either express or implied.                                       %
%                                                                       %
% The Software and Derived Work from the Software may only be           %
% distributed and communicated together with a copy of the EULA and the %
% aforementioned notice.                                                %
%                                                                       %
%                                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Housekeeping
clear;
close all;
clc;

rootfolder = get_project_root();

addpath(sprintf('%sdynare-steady-state-toolbox%ssrc', rootfolder, filesep));

setup;

% Write and adjust auxiliary files in order to execute the optimization of intermediate inputs and capital:
make_getk_text(DSGE_sector, DSGE_country);

DEBUG_MODE = true;

% Write steady source file.
if ~isfile('steady.hash')
    hash = hashfile('getk_text1.m', 'getk_text2.m', 'getk_text3.m', 'getk.m', 'getp.m', 'setup.m', 'steady.mod');
    fid = fopen('steady.hash', 'w');
    fprintf(fid, '%s\n', hash);
    fclose(fid);
    dynare steady onlymacro savemacro
    copyfile('steady_macroexp.mod', 'simulation_steadystate.source');
    delete('steady_macroexp.mod');
    delete('steady.log');
else
    oldhash = strtrim(fileread('steady.hash'));
    newhash = hashfile('getk_text1.m', 'getk_text2.m', 'getk_text3.m', 'getk.m', 'getp.m', 'setup.m', 'steady.mod');
    if ~strcmp(oldhash, newhash)
        fid = fopen('steady.hash', 'w');
        fprintf(fid, '%s\n', newhash);
        fclose(fid);
        dynare steady onlymacro savemacro
        copyfile('steady_macroexp.mod', 'simulation_steadystate.source');
        delete('steady_macroexp.mod');
        delete('steady.log');
    end
end

% Execute perfect foresight exercise
dynare simulation
