function [ys, params, info] = steadystate(ys, exo, params)
% File created by write_steadystate_file routine, 28-Nov-2025 13:53:59.

info = 0;


% When solving the model, we take the calibration file as given. This file contains the sectoral parameter values. 
load(sprintf('%sdata%sCalibration_EU28_ROW_10.mat', get_project_root(), filesep));

% In order to match DSGE sector numbers with calibration sector codes (NACE):
NACE = string({'A','B','C','D','E','F','G_H_I','J','M_N', 'R_S'}); 
DSGE_sector = [1:size(NACE,2)];

% Match DSGE region names with the ones specified in calibration tool:
ISO = {'Reg_a', 'Reg_b'}; % Note: EU is reg_A, RoW is Reg_b
DSGE_country = {'a', 'b'};
params(1019) = 0.992^4;
params(1017) = 2;
params(1018) = 0.025*4;
params(1020) = 0.5;
ys(9) = 1;
ys(665) = 0.5725;
params(4) = 0.156;
params(512) = 1-params(4);
ys(1333) = 1;
ys(1334) = 1/params(1019);
ys(11) = ys(1334);
params(3) = 0.8^4;
ys(16) = exp(exo(1)/(1-params(3)));
epsi_carb_int_a_ts = 1;
rho_eps_carb_int_a = 0.8^4;
params(2) = 2;
ys(3) = 0.333;
ys(10) = 1;
ys(6) = ys(10)/params(1019)-(1-params(1018))*ys(10);
params(1021) = 1-0.9979^4;
ys(14) = exo(2);
ys(667) = ys(1334);
params(511) = 0.8^4;
ys(672) = exp(exo(14)/(1-params(511)));
epsi_carb_int_b_ts = 1;
rho_eps_carb_int_b = 0.8^4;
params(510) = 2;
ys(659) = 0.333;
ys(666) = 1;
ys(662) = ys(666)/params(1019)-(1-params(1018))*ys(666);
params(1021) = 1-0.9979^4;
ys(670) = exo(15);
cid = ismember(DSGE_country, {'a'});
sid = DSGE_sector==1;
params(20) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(18) = 0;
params(19) = 0;
ys(32) = 0;
sid = DSGE_sector==2;
params(70) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(68) = 0;
params(69) = 0;
ys(96) = 0;
sid = DSGE_sector==3;
params(120) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(118) = 0;
params(119) = 0;
ys(160) = 0;
sid = DSGE_sector==4;
params(170) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(168) = 0;
params(169) = 0;
ys(224) = 0;
sid = DSGE_sector==5;
params(220) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(218) = 0;
params(219) = 0;
ys(288) = 0;
sid = DSGE_sector==6;
params(270) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(268) = 0;
params(269) = 0;
ys(352) = 0;
sid = DSGE_sector==7;
params(320) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(318) = 0;
params(319) = 0;
ys(416) = 0;
sid = DSGE_sector==8;
params(370) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(368) = 0;
params(369) = 0;
ys(480) = 0;
sid = DSGE_sector==9;
params(420) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(418) = 0;
params(419) = 0;
ys(544) = 0;
sid = DSGE_sector==10;
params(470) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(468) = 0;
params(469) = 0;
ys(608) = 0;
cid = ismember(DSGE_country, {'b'});
sid = DSGE_sector==1;
params(528) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(526) = 0;
params(527) = 0;
ys(688) = 0;
sid = DSGE_sector==2;
params(578) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(576) = 0;
params(577) = 0;
ys(752) = 0;
sid = DSGE_sector==3;
params(628) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(626) = 0;
params(627) = 0;
ys(816) = 0;
sid = DSGE_sector==4;
params(678) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(676) = 0;
params(677) = 0;
ys(880) = 0;
sid = DSGE_sector==5;
params(728) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(726) = 0;
params(727) = 0;
ys(944) = 0;
sid = DSGE_sector==6;
params(778) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(776) = 0;
params(777) = 0;
ys(1008) = 0;
sid = DSGE_sector==7;
params(828) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(826) = 0;
params(827) = 0;
ys(1072) = 0;
sid = DSGE_sector==8;
params(878) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(876) = 0;
params(877) = 0;
ys(1136) = 0;
sid = DSGE_sector==9;
params(928) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(926) = 0;
params(927) = 0;
ys(1200) = 0;
sid = DSGE_sector==10;
params(978) = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
params(976) = 0;
params(977) = 0;
ys(1264) = 0;
cid = ismember(DSGE_country, {'a'});
params(505) = 1-1/0.9091;
params(506)  = 1-1/0.7511;
params(507) = 2;
params(508) = 2;
sid = DSGE_sector==1;
params(11) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(13) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(9) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(10) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(5) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(6) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==2;
params(61) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(63) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(59) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(60) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(55) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(56) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==3;
params(111) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(113) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(109) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(110) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(105) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(106) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==4;
params(161) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(163) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(159) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(160) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(155) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(156) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==5;
params(211) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(213) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(209) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(210) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(205) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(206) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==6;
params(261) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(263) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(259) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(260) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(255) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(256) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==7;
params(311) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(313) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(309) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(310) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(305) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(306) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==8;
params(361) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(363) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(359) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(360) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(355) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(356) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==9;
params(411) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(413) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(409) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(410) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(405) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(406) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==10;
params(461) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(463) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(459) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(460) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(455) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(456) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
ys(33) = (1 + exo(3))*ys(14)*params(20);
ys(34) = 1;
ys(30) = ys(34) - ys(33);
ys(37) = 1;
ys(50) = 1;
ys(27) = 1;
ys(28) = 1;
ys(26) = 1;
ys(61) = 1;
ys(63) = 1;
ys(65) = 1;
ys(67) = 1;
ys(69) = 1;
ys(71) = 1;
ys(73) = 1;
ys(75) = 1;
ys(77) = 1;
ys(79) = 1;
ys(97) = (1 + exo(3))*ys(14)*params(70);
ys(98) = 1;
ys(94) = ys(98) - ys(97);
ys(101) = 1;
ys(114) = 1;
ys(91) = 1;
ys(92) = 1;
ys(90) = 1;
ys(125) = 1;
ys(127) = 1;
ys(129) = 1;
ys(131) = 1;
ys(133) = 1;
ys(135) = 1;
ys(137) = 1;
ys(139) = 1;
ys(141) = 1;
ys(143) = 1;
ys(161) = (1 + exo(3))*ys(14)*params(120);
ys(162) = 1;
ys(158) = ys(162) - ys(161);
ys(165) = 1;
ys(178) = 1;
ys(155) = 1;
ys(156) = 1;
ys(154) = 1;
ys(189) = 1;
ys(191) = 1;
ys(193) = 1;
ys(195) = 1;
ys(197) = 1;
ys(199) = 1;
ys(201) = 1;
ys(203) = 1;
ys(205) = 1;
ys(207) = 1;
ys(225) = (1 + exo(3))*ys(14)*params(170);
ys(226) = 1;
ys(222) = ys(226) - ys(225);
ys(229) = 1;
ys(242) = 1;
ys(219) = 1;
ys(220) = 1;
ys(218) = 1;
ys(253) = 1;
ys(255) = 1;
ys(257) = 1;
ys(259) = 1;
ys(261) = 1;
ys(263) = 1;
ys(265) = 1;
ys(267) = 1;
ys(269) = 1;
ys(271) = 1;
ys(289) = (1 + exo(3))*ys(14)*params(220);
ys(290) = 1;
ys(286) = ys(290) - ys(289);
ys(293) = 1;
ys(306) = 1;
ys(283) = 1;
ys(284) = 1;
ys(282) = 1;
ys(317) = 1;
ys(319) = 1;
ys(321) = 1;
ys(323) = 1;
ys(325) = 1;
ys(327) = 1;
ys(329) = 1;
ys(331) = 1;
ys(333) = 1;
ys(335) = 1;
ys(353) = (1 + exo(3))*ys(14)*params(270);
ys(354) = 1;
ys(350) = ys(354) - ys(353);
ys(357) = 1;
ys(370) = 1;
ys(347) = 1;
ys(348) = 1;
ys(346) = 1;
ys(381) = 1;
ys(383) = 1;
ys(385) = 1;
ys(387) = 1;
ys(389) = 1;
ys(391) = 1;
ys(393) = 1;
ys(395) = 1;
ys(397) = 1;
ys(399) = 1;
ys(417) = (1 + exo(3))*ys(14)*params(320);
ys(418) = 1;
ys(414) = ys(418) - ys(417);
ys(421) = 1;
ys(434) = 1;
ys(411) = 1;
ys(412) = 1;
ys(410) = 1;
ys(445) = 1;
ys(447) = 1;
ys(449) = 1;
ys(451) = 1;
ys(453) = 1;
ys(455) = 1;
ys(457) = 1;
ys(459) = 1;
ys(461) = 1;
ys(463) = 1;
ys(481) = (1 + exo(3))*ys(14)*params(370);
ys(482) = 1;
ys(478) = ys(482) - ys(481);
ys(485) = 1;
ys(498) = 1;
ys(475) = 1;
ys(476) = 1;
ys(474) = 1;
ys(509) = 1;
ys(511) = 1;
ys(513) = 1;
ys(515) = 1;
ys(517) = 1;
ys(519) = 1;
ys(521) = 1;
ys(523) = 1;
ys(525) = 1;
ys(527) = 1;
ys(545) = (1 + exo(3))*ys(14)*params(420);
ys(546) = 1;
ys(542) = ys(546) - ys(545);
ys(549) = 1;
ys(562) = 1;
ys(539) = 1;
ys(540) = 1;
ys(538) = 1;
ys(573) = 1;
ys(575) = 1;
ys(577) = 1;
ys(579) = 1;
ys(581) = 1;
ys(583) = 1;
ys(585) = 1;
ys(587) = 1;
ys(589) = 1;
ys(591) = 1;
ys(609) = (1 + exo(3))*ys(14)*params(470);
ys(610) = 1;
ys(606) = ys(610) - ys(609);
ys(613) = 1;
ys(626) = 1;
ys(603) = 1;
ys(604) = 1;
ys(602) = 1;
ys(637) = 1;
ys(639) = 1;
ys(641) = 1;
ys(643) = 1;
ys(645) = 1;
ys(647) = 1;
ys(649) = 1;
ys(651) = 1;
ys(653) = 1;
ys(655) = 1;
sid = DSGE_sector==1;
sid2 = DSGE_sector==1;
params(45) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(46) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(47) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(48) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(49) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(50) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(51) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(52) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(53) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(54) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==2;
sid2 = DSGE_sector==1;
params(95) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(96) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(97) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(98) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(99) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(100) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(101) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(102) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(103) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(104) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==3;
sid2 = DSGE_sector==1;
params(145) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(146) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(147) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(148) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(149) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(150) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(151) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(152) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(153) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(154) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==4;
sid2 = DSGE_sector==1;
params(195) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(196) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(197) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(198) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(199) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(200) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(201) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(202) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(203) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(204) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==5;
sid2 = DSGE_sector==1;
params(245) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(246) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(247) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(248) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(249) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(250) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(251) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(252) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(253) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(254) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==6;
sid2 = DSGE_sector==1;
params(295) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(296) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(297) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(298) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(299) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(300) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(301) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(302) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(303) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(304) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==7;
sid2 = DSGE_sector==1;
params(345) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(346) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(347) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(348) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(349) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(350) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(351) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(352) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(353) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(354) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==8;
sid2 = DSGE_sector==1;
params(395) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(396) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(397) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(398) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(399) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(400) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(401) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(402) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(403) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(404) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==9;
sid2 = DSGE_sector==1;
params(445) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(446) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(447) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(448) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(449) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(450) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(451) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(452) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(453) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(454) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==10;
sid2 = DSGE_sector==1;
params(495) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(496) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(497) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(498) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(499) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(500) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(501) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(502) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(503) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(504) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
params(12) = 1-1/0.1;
params(62) = 1-1/0.1;
params(112) = 1-1/0.1;
params(162) = 1-1/0.1;
params(212) = 1-1/0.1;
params(262) = 1-1/0.1;
params(312) = 1-1/0.1;
params(362) = 1-1/0.1;
params(412) = 1-1/0.1;
params(462)= 1-1/0.1;
cid = ismember(DSGE_country, {'b'});
params(1013) = 1-1/0.9091;
params(1014)  = 1-1/0.7511;
params(1015) = 2;
params(1016) = 2;
sid = DSGE_sector==1;
params(519) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(521) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(517) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(518) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(513) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(514) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==2;
params(569) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(571) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(567) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(568) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(563) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(564) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==3;
params(619) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(621) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(617) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(618) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(613) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(614) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==4;
params(669) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(671) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(667) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(668) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(663) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(664) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==5;
params(719) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(721) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(717) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(718) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(713) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(714) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==6;
params(769) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(771) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(767) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(768) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(763) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(764) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==7;
params(819) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(821) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(817) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(818) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(813) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(814) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==8;
params(869) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(871) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(867) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(868) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(863) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(864) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==9;
params(919) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(921) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(917) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(918) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(913) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(914) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
sid = DSGE_sector==10;
params(969) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);
params(971) = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);
params(967) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);
params(968) = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);
params(963) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};
params(964) = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};
ys(689) = (1 + exo(16))*ys(670)*params(528);
ys(690) = 1;
ys(686) = ys(690) - ys(689);
ys(693) = 1;
ys(706) = 1;
ys(683) = 1;
ys(684) = 1;
ys(682) = 1;
ys(717) = 1;
ys(719) = 1;
ys(721) = 1;
ys(723) = 1;
ys(725) = 1;
ys(727) = 1;
ys(729) = 1;
ys(731) = 1;
ys(733) = 1;
ys(735) = 1;
ys(753) = (1 + exo(16))*ys(670)*params(578);
ys(754) = 1;
ys(750) = ys(754) - ys(753);
ys(757) = 1;
ys(770) = 1;
ys(747) = 1;
ys(748) = 1;
ys(746) = 1;
ys(781) = 1;
ys(783) = 1;
ys(785) = 1;
ys(787) = 1;
ys(789) = 1;
ys(791) = 1;
ys(793) = 1;
ys(795) = 1;
ys(797) = 1;
ys(799) = 1;
ys(817) = (1 + exo(16))*ys(670)*params(628);
ys(818) = 1;
ys(814) = ys(818) - ys(817);
ys(821) = 1;
ys(834) = 1;
ys(811) = 1;
ys(812) = 1;
ys(810) = 1;
ys(845) = 1;
ys(847) = 1;
ys(849) = 1;
ys(851) = 1;
ys(853) = 1;
ys(855) = 1;
ys(857) = 1;
ys(859) = 1;
ys(861) = 1;
ys(863) = 1;
ys(881) = (1 + exo(16))*ys(670)*params(678);
ys(882) = 1;
ys(878) = ys(882) - ys(881);
ys(885) = 1;
ys(898) = 1;
ys(875) = 1;
ys(876) = 1;
ys(874) = 1;
ys(909) = 1;
ys(911) = 1;
ys(913) = 1;
ys(915) = 1;
ys(917) = 1;
ys(919) = 1;
ys(921) = 1;
ys(923) = 1;
ys(925) = 1;
ys(927) = 1;
ys(945) = (1 + exo(16))*ys(670)*params(728);
ys(946) = 1;
ys(942) = ys(946) - ys(945);
ys(949) = 1;
ys(962) = 1;
ys(939) = 1;
ys(940) = 1;
ys(938) = 1;
ys(973) = 1;
ys(975) = 1;
ys(977) = 1;
ys(979) = 1;
ys(981) = 1;
ys(983) = 1;
ys(985) = 1;
ys(987) = 1;
ys(989) = 1;
ys(991) = 1;
ys(1009) = (1 + exo(16))*ys(670)*params(778);
ys(1010) = 1;
ys(1006) = ys(1010) - ys(1009);
ys(1013) = 1;
ys(1026) = 1;
ys(1003) = 1;
ys(1004) = 1;
ys(1002) = 1;
ys(1037) = 1;
ys(1039) = 1;
ys(1041) = 1;
ys(1043) = 1;
ys(1045) = 1;
ys(1047) = 1;
ys(1049) = 1;
ys(1051) = 1;
ys(1053) = 1;
ys(1055) = 1;
ys(1073) = (1 + exo(16))*ys(670)*params(828);
ys(1074) = 1;
ys(1070) = ys(1074) - ys(1073);
ys(1077) = 1;
ys(1090) = 1;
ys(1067) = 1;
ys(1068) = 1;
ys(1066) = 1;
ys(1101) = 1;
ys(1103) = 1;
ys(1105) = 1;
ys(1107) = 1;
ys(1109) = 1;
ys(1111) = 1;
ys(1113) = 1;
ys(1115) = 1;
ys(1117) = 1;
ys(1119) = 1;
ys(1137) = (1 + exo(16))*ys(670)*params(878);
ys(1138) = 1;
ys(1134) = ys(1138) - ys(1137);
ys(1141) = 1;
ys(1154) = 1;
ys(1131) = 1;
ys(1132) = 1;
ys(1130) = 1;
ys(1165) = 1;
ys(1167) = 1;
ys(1169) = 1;
ys(1171) = 1;
ys(1173) = 1;
ys(1175) = 1;
ys(1177) = 1;
ys(1179) = 1;
ys(1181) = 1;
ys(1183) = 1;
ys(1201) = (1 + exo(16))*ys(670)*params(928);
ys(1202) = 1;
ys(1198) = ys(1202) - ys(1201);
ys(1205) = 1;
ys(1218) = 1;
ys(1195) = 1;
ys(1196) = 1;
ys(1194) = 1;
ys(1229) = 1;
ys(1231) = 1;
ys(1233) = 1;
ys(1235) = 1;
ys(1237) = 1;
ys(1239) = 1;
ys(1241) = 1;
ys(1243) = 1;
ys(1245) = 1;
ys(1247) = 1;
ys(1265) = (1 + exo(16))*ys(670)*params(978);
ys(1266) = 1;
ys(1262) = ys(1266) - ys(1265);
ys(1269) = 1;
ys(1282) = 1;
ys(1259) = 1;
ys(1260) = 1;
ys(1258) = 1;
ys(1293) = 1;
ys(1295) = 1;
ys(1297) = 1;
ys(1299) = 1;
ys(1301) = 1;
ys(1303) = 1;
ys(1305) = 1;
ys(1307) = 1;
ys(1309) = 1;
ys(1311) = 1;
sid = DSGE_sector==1;
sid2 = DSGE_sector==1;
params(553) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(554) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(555) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(556) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(557) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(558) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(559) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(560) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(561) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(562) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==2;
sid2 = DSGE_sector==1;
params(603) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(604) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(605) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(606) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(607) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(608) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(609) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(610) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(611) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(612) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==3;
sid2 = DSGE_sector==1;
params(653) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(654) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(655) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(656) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(657) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(658) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(659) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(660) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(661) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(662) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==4;
sid2 = DSGE_sector==1;
params(703) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(704) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(705) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(706) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(707) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(708) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(709) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(710) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(711) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(712) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==5;
sid2 = DSGE_sector==1;
params(753) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(754) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(755) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(756) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(757) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(758) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(759) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(760) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(761) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(762) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==6;
sid2 = DSGE_sector==1;
params(803) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(804) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(805) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(806) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(807) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(808) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(809) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(810) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(811) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(812) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==7;
sid2 = DSGE_sector==1;
params(853) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(854) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(855) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(856) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(857) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(858) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(859) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(860) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(861) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(862) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==8;
sid2 = DSGE_sector==1;
params(903) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(904) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(905) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(906) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(907) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(908) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(909) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(910) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(911) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(912) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==9;
sid2 = DSGE_sector==1;
params(953) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(954) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(955) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(956) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(957) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(958) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(959) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(960) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(961) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(962) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid = DSGE_sector==10;
sid2 = DSGE_sector==1;
params(1003) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==2;
params(1004) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==3;
params(1005) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==4;
params(1006) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==5;
params(1007) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==6;
params(1008) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==7;
params(1009) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==8;
params(1010) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==9;
params(1011) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
sid2 = DSGE_sector==10;
params(1012) = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)};
params(520) = 1-1/0.1;
params(570) = 1-1/0.1;
params(620) = 1-1/0.1;
params(670) = 1-1/0.1;
params(720) = 1-1/0.1;
params(770) = 1-1/0.1;
params(820) = 1-1/0.1;
params(870) = 1-1/0.1;
params(920) = 1-1/0.1;
params(970)= 1-1/0.1;
getp;
kk = getk(params, ys, DSGE_sector, DSGE_country);
ys(4) = kk(1);
ys(660) = kk(2);
ys(62) = kk(3);
ys(64) = kk(4);
ys(66) = kk(5);
ys(68) = kk(6);
ys(70) = kk(7);
ys(72) = kk(8);
ys(74) = kk(9);
ys(76) = kk(10);
ys(78) = kk(11);
ys(80) = kk(12);
ys(126) = kk(13);
ys(128) = kk(14);
ys(130) = kk(15);
ys(132) = kk(16);
ys(134) = kk(17);
ys(136) = kk(18);
ys(138) = kk(19);
ys(140) = kk(20);
ys(142) = kk(21);
ys(144) = kk(22);
ys(190) = kk(23);
ys(192) = kk(24);
ys(194) = kk(25);
ys(196) = kk(26);
ys(198) = kk(27);
ys(200) = kk(28);
ys(202) = kk(29);
ys(204) = kk(30);
ys(206) = kk(31);
ys(208) = kk(32);
ys(254) = kk(33);
ys(256) = kk(34);
ys(258) = kk(35);
ys(260) = kk(36);
ys(262) = kk(37);
ys(264) = kk(38);
ys(266) = kk(39);
ys(268) = kk(40);
ys(270) = kk(41);
ys(272) = kk(42);
ys(318) = kk(43);
ys(320) = kk(44);
ys(322) = kk(45);
ys(324) = kk(46);
ys(326) = kk(47);
ys(328) = kk(48);
ys(330) = kk(49);
ys(332) = kk(50);
ys(334) = kk(51);
ys(336) = kk(52);
ys(382) = kk(53);
ys(384) = kk(54);
ys(386) = kk(55);
ys(388) = kk(56);
ys(390) = kk(57);
ys(392) = kk(58);
ys(394) = kk(59);
ys(396) = kk(60);
ys(398) = kk(61);
ys(400) = kk(62);
ys(446) = kk(63);
ys(448) = kk(64);
ys(450) = kk(65);
ys(452) = kk(66);
ys(454) = kk(67);
ys(456) = kk(68);
ys(458) = kk(69);
ys(460) = kk(70);
ys(462) = kk(71);
ys(464) = kk(72);
ys(510) = kk(73);
ys(512) = kk(74);
ys(514) = kk(75);
ys(516) = kk(76);
ys(518) = kk(77);
ys(520) = kk(78);
ys(522) = kk(79);
ys(524) = kk(80);
ys(526) = kk(81);
ys(528) = kk(82);
ys(574) = kk(83);
ys(576) = kk(84);
ys(578) = kk(85);
ys(580) = kk(86);
ys(582) = kk(87);
ys(584) = kk(88);
ys(586) = kk(89);
ys(588) = kk(90);
ys(590) = kk(91);
ys(592) = kk(92);
ys(638) = kk(93);
ys(640) = kk(94);
ys(642) = kk(95);
ys(644) = kk(96);
ys(646) = kk(97);
ys(648) = kk(98);
ys(650) = kk(99);
ys(652) = kk(100);
ys(654) = kk(101);
ys(656) = kk(102);
ys(718) = kk(103);
ys(720) = kk(104);
ys(722) = kk(105);
ys(724) = kk(106);
ys(726) = kk(107);
ys(728) = kk(108);
ys(730) = kk(109);
ys(732) = kk(110);
ys(734) = kk(111);
ys(736) = kk(112);
ys(782) = kk(113);
ys(784) = kk(114);
ys(786) = kk(115);
ys(788) = kk(116);
ys(790) = kk(117);
ys(792) = kk(118);
ys(794) = kk(119);
ys(796) = kk(120);
ys(798) = kk(121);
ys(800) = kk(122);
ys(846) = kk(123);
ys(848) = kk(124);
ys(850) = kk(125);
ys(852) = kk(126);
ys(854) = kk(127);
ys(856) = kk(128);
ys(858) = kk(129);
ys(860) = kk(130);
ys(862) = kk(131);
ys(864) = kk(132);
ys(910) = kk(133);
ys(912) = kk(134);
ys(914) = kk(135);
ys(916) = kk(136);
ys(918) = kk(137);
ys(920) = kk(138);
ys(922) = kk(139);
ys(924) = kk(140);
ys(926) = kk(141);
ys(928) = kk(142);
ys(974) = kk(143);
ys(976) = kk(144);
ys(978) = kk(145);
ys(980) = kk(146);
ys(982) = kk(147);
ys(984) = kk(148);
ys(986) = kk(149);
ys(988) = kk(150);
ys(990) = kk(151);
ys(992) = kk(152);
ys(1038) = kk(153);
ys(1040) = kk(154);
ys(1042) = kk(155);
ys(1044) = kk(156);
ys(1046) = kk(157);
ys(1048) = kk(158);
ys(1050) = kk(159);
ys(1052) = kk(160);
ys(1054) = kk(161);
ys(1056) = kk(162);
ys(1102) = kk(163);
ys(1104) = kk(164);
ys(1106) = kk(165);
ys(1108) = kk(166);
ys(1110) = kk(167);
ys(1112) = kk(168);
ys(1114) = kk(169);
ys(1116) = kk(170);
ys(1118) = kk(171);
ys(1120) = kk(172);
ys(1166) = kk(173);
ys(1168) = kk(174);
ys(1170) = kk(175);
ys(1172) = kk(176);
ys(1174) = kk(177);
ys(1176) = kk(178);
ys(1178) = kk(179);
ys(1180) = kk(180);
ys(1182) = kk(181);
ys(1184) = kk(182);
ys(1230) = kk(183);
ys(1232) = kk(184);
ys(1234) = kk(185);
ys(1236) = kk(186);
ys(1238) = kk(187);
ys(1240) = kk(188);
ys(1242) = kk(189);
ys(1244) = kk(190);
ys(1246) = kk(191);
ys(1248) = kk(192);
ys(1294) = kk(193);
ys(1296) = kk(194);
ys(1298) = kk(195);
ys(1300) = kk(196);
ys(1302) = kk(197);
ys(1304) = kk(198);
ys(1306) = kk(199);
ys(1308) = kk(200);
ys(1310) = kk(201);
ys(1312) = kk(202);
ys(2) = params(1018)*ys(4);
ys(1) = ys(9) - ys(2);
ys(17) = params(5)*ys(1);
ys(18) = params(6)*ys(2);
ys(21) = (ys(17)+ys(18) + (+ ys(62)+ ys(126)+ ys(190)+ ys(254)+ ys(318)+ ys(382)+ ys(446)+ ys(510)+ ys(574)+ ys(638)));
ys(31) = (1 + exo(3))*params(20)*ys(21);
ys(81) = params(55)*ys(1);
ys(82) = params(56)*ys(2);
ys(85) = (ys(81)+ys(82) + (+ ys(64)+ ys(128)+ ys(192)+ ys(256)+ ys(320)+ ys(384)+ ys(448)+ ys(512)+ ys(576)+ ys(640)));
ys(95) = (1 + exo(3))*params(70)*ys(85);
ys(145) = params(105)*ys(1);
ys(146) = params(106)*ys(2);
ys(149) = (ys(145)+ys(146) + (+ ys(66)+ ys(130)+ ys(194)+ ys(258)+ ys(322)+ ys(386)+ ys(450)+ ys(514)+ ys(578)+ ys(642)));
ys(159) = (1 + exo(3))*params(120)*ys(149);
ys(209) = params(155)*ys(1);
ys(210) = params(156)*ys(2);
ys(213) = (ys(209)+ys(210) + (+ ys(68)+ ys(132)+ ys(196)+ ys(260)+ ys(324)+ ys(388)+ ys(452)+ ys(516)+ ys(580)+ ys(644)));
ys(223) = (1 + exo(3))*params(170)*ys(213);
ys(273) = params(205)*ys(1);
ys(274) = params(206)*ys(2);
ys(277) = (ys(273)+ys(274) + (+ ys(70)+ ys(134)+ ys(198)+ ys(262)+ ys(326)+ ys(390)+ ys(454)+ ys(518)+ ys(582)+ ys(646)));
ys(287) = (1 + exo(3))*params(220)*ys(277);
ys(337) = params(255)*ys(1);
ys(338) = params(256)*ys(2);
ys(341) = (ys(337)+ys(338) + (+ ys(72)+ ys(136)+ ys(200)+ ys(264)+ ys(328)+ ys(392)+ ys(456)+ ys(520)+ ys(584)+ ys(648)));
ys(351) = (1 + exo(3))*params(270)*ys(341);
ys(401) = params(305)*ys(1);
ys(402) = params(306)*ys(2);
ys(405) = (ys(401)+ys(402) + (+ ys(74)+ ys(138)+ ys(202)+ ys(266)+ ys(330)+ ys(394)+ ys(458)+ ys(522)+ ys(586)+ ys(650)));
ys(415) = (1 + exo(3))*params(320)*ys(405);
ys(465) = params(355)*ys(1);
ys(466) = params(356)*ys(2);
ys(469) = (ys(465)+ys(466) + (+ ys(76)+ ys(140)+ ys(204)+ ys(268)+ ys(332)+ ys(396)+ ys(460)+ ys(524)+ ys(588)+ ys(652)));
ys(479) = (1 + exo(3))*params(370)*ys(469);
ys(529) = params(405)*ys(1);
ys(530) = params(406)*ys(2);
ys(533) = (ys(529)+ys(530) + (+ ys(78)+ ys(142)+ ys(206)+ ys(270)+ ys(334)+ ys(398)+ ys(462)+ ys(526)+ ys(590)+ ys(654)));
ys(543) = (1 + exo(3))*params(420)*ys(533);
ys(593) = params(455)*ys(1);
ys(594) = params(456)*ys(2);
ys(597) = (ys(593)+ys(594) + (+ ys(80)+ ys(144)+ ys(208)+ ys(272)+ ys(336)+ ys(400)+ ys(464)+ ys(528)+ ys(592)+ ys(656)));
ys(607) = (1 + exo(3))*params(470)*ys(597);
ys(15) = (+ ys(31)+ ys(95)+ ys(159)+ ys(223)+ ys(287)+ ys(351)+ ys(415)+ ys(479)+ ys(543)+ ys(607));
ys(8) = (+ ys(21)+ ys(85)+ ys(149)+ ys(213)+ ys(277)+ ys(341)+ ys(405)+ ys(469)+ ys(533)+ ys(597));
ys(658) = params(1018)*ys(660);
ys(657) = ys(665) - ys(658);
ys(673) = params(513)*ys(657);
ys(674) = params(514)*ys(658);
ys(677) = (ys(673)+ys(674) + (+ ys(718)+ ys(782)+ ys(846)+ ys(910)+ ys(974)+ ys(1038)+ ys(1102)+ ys(1166)+ ys(1230)+ ys(1294)));
ys(687) = (1 + exo(16))*params(528)*ys(677);
ys(737) = params(563)*ys(657);
ys(738) = params(564)*ys(658);
ys(741) = (ys(737)+ys(738) + (+ ys(720)+ ys(784)+ ys(848)+ ys(912)+ ys(976)+ ys(1040)+ ys(1104)+ ys(1168)+ ys(1232)+ ys(1296)));
ys(751) = (1 + exo(16))*params(578)*ys(741);
ys(801) = params(613)*ys(657);
ys(802) = params(614)*ys(658);
ys(805) = (ys(801)+ys(802) + (+ ys(722)+ ys(786)+ ys(850)+ ys(914)+ ys(978)+ ys(1042)+ ys(1106)+ ys(1170)+ ys(1234)+ ys(1298)));
ys(815) = (1 + exo(16))*params(628)*ys(805);
ys(865) = params(663)*ys(657);
ys(866) = params(664)*ys(658);
ys(869) = (ys(865)+ys(866) + (+ ys(724)+ ys(788)+ ys(852)+ ys(916)+ ys(980)+ ys(1044)+ ys(1108)+ ys(1172)+ ys(1236)+ ys(1300)));
ys(879) = (1 + exo(16))*params(678)*ys(869);
ys(929) = params(713)*ys(657);
ys(930) = params(714)*ys(658);
ys(933) = (ys(929)+ys(930) + (+ ys(726)+ ys(790)+ ys(854)+ ys(918)+ ys(982)+ ys(1046)+ ys(1110)+ ys(1174)+ ys(1238)+ ys(1302)));
ys(943) = (1 + exo(16))*params(728)*ys(933);
ys(993) = params(763)*ys(657);
ys(994) = params(764)*ys(658);
ys(997) = (ys(993)+ys(994) + (+ ys(728)+ ys(792)+ ys(856)+ ys(920)+ ys(984)+ ys(1048)+ ys(1112)+ ys(1176)+ ys(1240)+ ys(1304)));
ys(1007) = (1 + exo(16))*params(778)*ys(997);
ys(1057) = params(813)*ys(657);
ys(1058) = params(814)*ys(658);
ys(1061) = (ys(1057)+ys(1058) + (+ ys(730)+ ys(794)+ ys(858)+ ys(922)+ ys(986)+ ys(1050)+ ys(1114)+ ys(1178)+ ys(1242)+ ys(1306)));
ys(1071) = (1 + exo(16))*params(828)*ys(1061);
ys(1121) = params(863)*ys(657);
ys(1122) = params(864)*ys(658);
ys(1125) = (ys(1121)+ys(1122) + (+ ys(732)+ ys(796)+ ys(860)+ ys(924)+ ys(988)+ ys(1052)+ ys(1116)+ ys(1180)+ ys(1244)+ ys(1308)));
ys(1135) = (1 + exo(16))*params(878)*ys(1125);
ys(1185) = params(913)*ys(657);
ys(1186) = params(914)*ys(658);
ys(1189) = (ys(1185)+ys(1186) + (+ ys(734)+ ys(798)+ ys(862)+ ys(926)+ ys(990)+ ys(1054)+ ys(1118)+ ys(1182)+ ys(1246)+ ys(1310)));
ys(1199) = (1 + exo(16))*params(928)*ys(1189);
ys(1249) = params(963)*ys(657);
ys(1250) = params(964)*ys(658);
ys(1253) = (ys(1249)+ys(1250) + (+ ys(736)+ ys(800)+ ys(864)+ ys(928)+ ys(992)+ ys(1056)+ ys(1120)+ ys(1184)+ ys(1248)+ ys(1312)));
ys(1263) = (1 + exo(16))*params(978)*ys(1253);
ys(671) = (+ ys(687)+ ys(751)+ ys(815)+ ys(879)+ ys(943)+ ys(1007)+ ys(1071)+ ys(1135)+ ys(1199)+ ys(1263));
ys(664) = (+ ys(677)+ ys(741)+ ys(805)+ ys(869)+ ys(933)+ ys(997)+ ys(1061)+ ys(1125)+ ys(1189)+ ys(1253));
ys(1335) = (+ ys(31)*params(4)+ ys(95)*params(4)+ ys(159)*params(4)+ ys(223)*params(4)+ ys(287)*params(4)+ ys(351)*params(4)+ ys(415)*params(4)+ ys(479)*params(4)+ ys(543)*params(4)+ ys(607)*params(4)+ ys(687)*params(512)+ ys(751)*params(512)+ ys(815)*params(512)+ ys(879)*params(512)+ ys(943)*params(512)+ ys(1007)*params(512)+ ys(1071)*params(512)+ ys(1135)*params(512)+ ys(1199)*params(512)+ ys(1263)*params(512))/params(1021);
params(17) =  ys(32) - params(18)*ys(1335) - params(19)*ys(1335)^2;
ys(20) = params(10)*ys(4);
ys(24) = params(13)*(1-params(11))*ys(30)*ys(21)/ys(20);
params(8) = params(10) *(ys(24)/ys(6))^(1/(1-params(507)));
ys(25) = (1-params(13))*ys(30)*ys(21)/ys(26);
ys(62) = params(45)*(ys(26)/ys(37))^(1/(1-params(12)))*ys(25);
ys(64) = params(46)*(ys(26)/ys(101))^(1/(1-params(12)))*ys(25);
ys(66) = params(47)*(ys(26)/ys(165))^(1/(1-params(12)))*ys(25);
ys(68) = params(48)*(ys(26)/ys(229))^(1/(1-params(12)))*ys(25);
ys(70) = params(49)*(ys(26)/ys(293))^(1/(1-params(12)))*ys(25);
ys(72) = params(50)*(ys(26)/ys(357))^(1/(1-params(12)))*ys(25);
ys(74) = params(51)*(ys(26)/ys(421))^(1/(1-params(12)))*ys(25);
ys(76) = params(52)*(ys(26)/ys(485))^(1/(1-params(12)))*ys(25);
ys(78) = params(53)*(ys(26)/ys(549))^(1/(1-params(12)))*ys(25);
ys(80) = params(54)*(ys(26)/ys(613))^(1/(1-params(12)))*ys(25);
params(67) =  ys(96) - params(68)*ys(1335) - params(69)*ys(1335)^2;
ys(84) = params(60)*ys(4);
ys(88) = params(63)*(1-params(61))*ys(94)*ys(85)/ys(84);
params(58) = params(60) *(ys(88)/ys(6))^(1/(1-params(507)));
ys(89) = (1-params(63))*ys(94)*ys(85)/ys(90);
ys(126) = params(95)*(ys(90)/ys(37))^(1/(1-params(62)))*ys(89);
ys(128) = params(96)*(ys(90)/ys(101))^(1/(1-params(62)))*ys(89);
ys(130) = params(97)*(ys(90)/ys(165))^(1/(1-params(62)))*ys(89);
ys(132) = params(98)*(ys(90)/ys(229))^(1/(1-params(62)))*ys(89);
ys(134) = params(99)*(ys(90)/ys(293))^(1/(1-params(62)))*ys(89);
ys(136) = params(100)*(ys(90)/ys(357))^(1/(1-params(62)))*ys(89);
ys(138) = params(101)*(ys(90)/ys(421))^(1/(1-params(62)))*ys(89);
ys(140) = params(102)*(ys(90)/ys(485))^(1/(1-params(62)))*ys(89);
ys(142) = params(103)*(ys(90)/ys(549))^(1/(1-params(62)))*ys(89);
ys(144) = params(104)*(ys(90)/ys(613))^(1/(1-params(62)))*ys(89);
params(117) =  ys(160) - params(118)*ys(1335) - params(119)*ys(1335)^2;
ys(148) = params(110)*ys(4);
ys(152) = params(113)*(1-params(111))*ys(158)*ys(149)/ys(148);
params(108) = params(110) *(ys(152)/ys(6))^(1/(1-params(507)));
ys(153) = (1-params(113))*ys(158)*ys(149)/ys(154);
ys(190) = params(145)*(ys(154)/ys(37))^(1/(1-params(112)))*ys(153);
ys(192) = params(146)*(ys(154)/ys(101))^(1/(1-params(112)))*ys(153);
ys(194) = params(147)*(ys(154)/ys(165))^(1/(1-params(112)))*ys(153);
ys(196) = params(148)*(ys(154)/ys(229))^(1/(1-params(112)))*ys(153);
ys(198) = params(149)*(ys(154)/ys(293))^(1/(1-params(112)))*ys(153);
ys(200) = params(150)*(ys(154)/ys(357))^(1/(1-params(112)))*ys(153);
ys(202) = params(151)*(ys(154)/ys(421))^(1/(1-params(112)))*ys(153);
ys(204) = params(152)*(ys(154)/ys(485))^(1/(1-params(112)))*ys(153);
ys(206) = params(153)*(ys(154)/ys(549))^(1/(1-params(112)))*ys(153);
ys(208) = params(154)*(ys(154)/ys(613))^(1/(1-params(112)))*ys(153);
params(167) =  ys(224) - params(168)*ys(1335) - params(169)*ys(1335)^2;
ys(212) = params(160)*ys(4);
ys(216) = params(163)*(1-params(161))*ys(222)*ys(213)/ys(212);
params(158) = params(160) *(ys(216)/ys(6))^(1/(1-params(507)));
ys(217) = (1-params(163))*ys(222)*ys(213)/ys(218);
ys(254) = params(195)*(ys(218)/ys(37))^(1/(1-params(162)))*ys(217);
ys(256) = params(196)*(ys(218)/ys(101))^(1/(1-params(162)))*ys(217);
ys(258) = params(197)*(ys(218)/ys(165))^(1/(1-params(162)))*ys(217);
ys(260) = params(198)*(ys(218)/ys(229))^(1/(1-params(162)))*ys(217);
ys(262) = params(199)*(ys(218)/ys(293))^(1/(1-params(162)))*ys(217);
ys(264) = params(200)*(ys(218)/ys(357))^(1/(1-params(162)))*ys(217);
ys(266) = params(201)*(ys(218)/ys(421))^(1/(1-params(162)))*ys(217);
ys(268) = params(202)*(ys(218)/ys(485))^(1/(1-params(162)))*ys(217);
ys(270) = params(203)*(ys(218)/ys(549))^(1/(1-params(162)))*ys(217);
ys(272) = params(204)*(ys(218)/ys(613))^(1/(1-params(162)))*ys(217);
params(217) =  ys(288) - params(218)*ys(1335) - params(219)*ys(1335)^2;
ys(276) = params(210)*ys(4);
ys(280) = params(213)*(1-params(211))*ys(286)*ys(277)/ys(276);
params(208) = params(210) *(ys(280)/ys(6))^(1/(1-params(507)));
ys(281) = (1-params(213))*ys(286)*ys(277)/ys(282);
ys(318) = params(245)*(ys(282)/ys(37))^(1/(1-params(212)))*ys(281);
ys(320) = params(246)*(ys(282)/ys(101))^(1/(1-params(212)))*ys(281);
ys(322) = params(247)*(ys(282)/ys(165))^(1/(1-params(212)))*ys(281);
ys(324) = params(248)*(ys(282)/ys(229))^(1/(1-params(212)))*ys(281);
ys(326) = params(249)*(ys(282)/ys(293))^(1/(1-params(212)))*ys(281);
ys(328) = params(250)*(ys(282)/ys(357))^(1/(1-params(212)))*ys(281);
ys(330) = params(251)*(ys(282)/ys(421))^(1/(1-params(212)))*ys(281);
ys(332) = params(252)*(ys(282)/ys(485))^(1/(1-params(212)))*ys(281);
ys(334) = params(253)*(ys(282)/ys(549))^(1/(1-params(212)))*ys(281);
ys(336) = params(254)*(ys(282)/ys(613))^(1/(1-params(212)))*ys(281);
params(267) =  ys(352) - params(268)*ys(1335) - params(269)*ys(1335)^2;
ys(340) = params(260)*ys(4);
ys(344) = params(263)*(1-params(261))*ys(350)*ys(341)/ys(340);
params(258) = params(260) *(ys(344)/ys(6))^(1/(1-params(507)));
ys(345) = (1-params(263))*ys(350)*ys(341)/ys(346);
ys(382) = params(295)*(ys(346)/ys(37))^(1/(1-params(262)))*ys(345);
ys(384) = params(296)*(ys(346)/ys(101))^(1/(1-params(262)))*ys(345);
ys(386) = params(297)*(ys(346)/ys(165))^(1/(1-params(262)))*ys(345);
ys(388) = params(298)*(ys(346)/ys(229))^(1/(1-params(262)))*ys(345);
ys(390) = params(299)*(ys(346)/ys(293))^(1/(1-params(262)))*ys(345);
ys(392) = params(300)*(ys(346)/ys(357))^(1/(1-params(262)))*ys(345);
ys(394) = params(301)*(ys(346)/ys(421))^(1/(1-params(262)))*ys(345);
ys(396) = params(302)*(ys(346)/ys(485))^(1/(1-params(262)))*ys(345);
ys(398) = params(303)*(ys(346)/ys(549))^(1/(1-params(262)))*ys(345);
ys(400) = params(304)*(ys(346)/ys(613))^(1/(1-params(262)))*ys(345);
params(317) =  ys(416) - params(318)*ys(1335) - params(319)*ys(1335)^2;
ys(404) = params(310)*ys(4);
ys(408) = params(313)*(1-params(311))*ys(414)*ys(405)/ys(404);
params(308) = params(310) *(ys(408)/ys(6))^(1/(1-params(507)));
ys(409) = (1-params(313))*ys(414)*ys(405)/ys(410);
ys(446) = params(345)*(ys(410)/ys(37))^(1/(1-params(312)))*ys(409);
ys(448) = params(346)*(ys(410)/ys(101))^(1/(1-params(312)))*ys(409);
ys(450) = params(347)*(ys(410)/ys(165))^(1/(1-params(312)))*ys(409);
ys(452) = params(348)*(ys(410)/ys(229))^(1/(1-params(312)))*ys(409);
ys(454) = params(349)*(ys(410)/ys(293))^(1/(1-params(312)))*ys(409);
ys(456) = params(350)*(ys(410)/ys(357))^(1/(1-params(312)))*ys(409);
ys(458) = params(351)*(ys(410)/ys(421))^(1/(1-params(312)))*ys(409);
ys(460) = params(352)*(ys(410)/ys(485))^(1/(1-params(312)))*ys(409);
ys(462) = params(353)*(ys(410)/ys(549))^(1/(1-params(312)))*ys(409);
ys(464) = params(354)*(ys(410)/ys(613))^(1/(1-params(312)))*ys(409);
params(367) =  ys(480) - params(368)*ys(1335) - params(369)*ys(1335)^2;
ys(468) = params(360)*ys(4);
ys(472) = params(363)*(1-params(361))*ys(478)*ys(469)/ys(468);
params(358) = params(360) *(ys(472)/ys(6))^(1/(1-params(507)));
ys(473) = (1-params(363))*ys(478)*ys(469)/ys(474);
ys(510) = params(395)*(ys(474)/ys(37))^(1/(1-params(362)))*ys(473);
ys(512) = params(396)*(ys(474)/ys(101))^(1/(1-params(362)))*ys(473);
ys(514) = params(397)*(ys(474)/ys(165))^(1/(1-params(362)))*ys(473);
ys(516) = params(398)*(ys(474)/ys(229))^(1/(1-params(362)))*ys(473);
ys(518) = params(399)*(ys(474)/ys(293))^(1/(1-params(362)))*ys(473);
ys(520) = params(400)*(ys(474)/ys(357))^(1/(1-params(362)))*ys(473);
ys(522) = params(401)*(ys(474)/ys(421))^(1/(1-params(362)))*ys(473);
ys(524) = params(402)*(ys(474)/ys(485))^(1/(1-params(362)))*ys(473);
ys(526) = params(403)*(ys(474)/ys(549))^(1/(1-params(362)))*ys(473);
ys(528) = params(404)*(ys(474)/ys(613))^(1/(1-params(362)))*ys(473);
params(417) =  ys(544) - params(418)*ys(1335) - params(419)*ys(1335)^2;
ys(532) = params(410)*ys(4);
ys(536) = params(413)*(1-params(411))*ys(542)*ys(533)/ys(532);
params(408) = params(410) *(ys(536)/ys(6))^(1/(1-params(507)));
ys(537) = (1-params(413))*ys(542)*ys(533)/ys(538);
ys(574) = params(445)*(ys(538)/ys(37))^(1/(1-params(412)))*ys(537);
ys(576) = params(446)*(ys(538)/ys(101))^(1/(1-params(412)))*ys(537);
ys(578) = params(447)*(ys(538)/ys(165))^(1/(1-params(412)))*ys(537);
ys(580) = params(448)*(ys(538)/ys(229))^(1/(1-params(412)))*ys(537);
ys(582) = params(449)*(ys(538)/ys(293))^(1/(1-params(412)))*ys(537);
ys(584) = params(450)*(ys(538)/ys(357))^(1/(1-params(412)))*ys(537);
ys(586) = params(451)*(ys(538)/ys(421))^(1/(1-params(412)))*ys(537);
ys(588) = params(452)*(ys(538)/ys(485))^(1/(1-params(412)))*ys(537);
ys(590) = params(453)*(ys(538)/ys(549))^(1/(1-params(412)))*ys(537);
ys(592) = params(454)*(ys(538)/ys(613))^(1/(1-params(412)))*ys(537);
params(467) =  ys(608) - params(468)*ys(1335) - params(469)*ys(1335)^2;
ys(596) = params(460)*ys(4);
ys(600) = params(463)*(1-params(461))*ys(606)*ys(597)/ys(596);
params(458) = params(460) *(ys(600)/ys(6))^(1/(1-params(507)));
ys(601) = (1-params(463))*ys(606)*ys(597)/ys(602);
ys(638) = params(495)*(ys(602)/ys(37))^(1/(1-params(462)))*ys(601);
ys(640) = params(496)*(ys(602)/ys(101))^(1/(1-params(462)))*ys(601);
ys(642) = params(497)*(ys(602)/ys(165))^(1/(1-params(462)))*ys(601);
ys(644) = params(498)*(ys(602)/ys(229))^(1/(1-params(462)))*ys(601);
ys(646) = params(499)*(ys(602)/ys(293))^(1/(1-params(462)))*ys(601);
ys(648) = params(500)*(ys(602)/ys(357))^(1/(1-params(462)))*ys(601);
ys(650) = params(501)*(ys(602)/ys(421))^(1/(1-params(462)))*ys(601);
ys(652) = params(502)*(ys(602)/ys(485))^(1/(1-params(462)))*ys(601);
ys(654) = params(503)*(ys(602)/ys(549))^(1/(1-params(462)))*ys(601);
ys(656) = params(504)*(ys(602)/ys(613))^(1/(1-params(462)))*ys(601);
ys(5) = (+ params(13)*params(11)*ys(30)*ys(21)/ys(3)+ params(63)*params(61)*ys(94)*ys(85)/ys(3)+ params(113)*params(111)*ys(158)*ys(149)/ys(3)+ params(163)*params(161)*ys(222)*ys(213)/ys(3)+ params(213)*params(211)*ys(286)*ys(277)/ys(3)+ params(263)*params(261)*ys(350)*ys(341)/ys(3)+ params(313)*params(311)*ys(414)*ys(405)/ys(3)+ params(363)*params(361)*ys(478)*ys(469)/ys(3)+ params(413)*params(411)*ys(542)*ys(533)/ys(3)+ params(463)*params(461)*ys(606)*ys(597)/ys(3));
ys(19) = params(9)*ys(3);
ys(22) = params(13)*params(11)*ys(30)*ys(21)/ys(19);
params(7) = params(9) *(ys(22)/ys(5))^(1/(1-params(508)));
ys(23) = ys(21)/( ys(16)*(1-ys(32))* (ys(19)^params(11)*ys(20)^(1-params(11)))^params(13)*ys(25)^(1-params(13)));
ys(83) = params(59)*ys(3);
ys(86) = params(63)*params(61)*ys(94)*ys(85)/ys(83);
params(57) = params(59) *(ys(86)/ys(5))^(1/(1-params(508)));
ys(87) = ys(85)/( ys(16)*(1-ys(96))* (ys(83)^params(61)*ys(84)^(1-params(61)))^params(63)*ys(89)^(1-params(63)));
ys(147) = params(109)*ys(3);
ys(150) = params(113)*params(111)*ys(158)*ys(149)/ys(147);
params(107) = params(109) *(ys(150)/ys(5))^(1/(1-params(508)));
ys(151) = ys(149)/( ys(16)*(1-ys(160))* (ys(147)^params(111)*ys(148)^(1-params(111)))^params(113)*ys(153)^(1-params(113)));
ys(211) = params(159)*ys(3);
ys(214) = params(163)*params(161)*ys(222)*ys(213)/ys(211);
params(157) = params(159) *(ys(214)/ys(5))^(1/(1-params(508)));
ys(215) = ys(213)/( ys(16)*(1-ys(224))* (ys(211)^params(161)*ys(212)^(1-params(161)))^params(163)*ys(217)^(1-params(163)));
ys(275) = params(209)*ys(3);
ys(278) = params(213)*params(211)*ys(286)*ys(277)/ys(275);
params(207) = params(209) *(ys(278)/ys(5))^(1/(1-params(508)));
ys(279) = ys(277)/( ys(16)*(1-ys(288))* (ys(275)^params(211)*ys(276)^(1-params(211)))^params(213)*ys(281)^(1-params(213)));
ys(339) = params(259)*ys(3);
ys(342) = params(263)*params(261)*ys(350)*ys(341)/ys(339);
params(257) = params(259) *(ys(342)/ys(5))^(1/(1-params(508)));
ys(343) = ys(341)/( ys(16)*(1-ys(352))* (ys(339)^params(261)*ys(340)^(1-params(261)))^params(263)*ys(345)^(1-params(263)));
ys(403) = params(309)*ys(3);
ys(406) = params(313)*params(311)*ys(414)*ys(405)/ys(403);
params(307) = params(309) *(ys(406)/ys(5))^(1/(1-params(508)));
ys(407) = ys(405)/( ys(16)*(1-ys(416))* (ys(403)^params(311)*ys(404)^(1-params(311)))^params(313)*ys(409)^(1-params(313)));
ys(467) = params(359)*ys(3);
ys(470) = params(363)*params(361)*ys(478)*ys(469)/ys(467);
params(357) = params(359) *(ys(470)/ys(5))^(1/(1-params(508)));
ys(471) = ys(469)/( ys(16)*(1-ys(480))* (ys(467)^params(361)*ys(468)^(1-params(361)))^params(363)*ys(473)^(1-params(363)));
ys(531) = params(409)*ys(3);
ys(534) = params(413)*params(411)*ys(542)*ys(533)/ys(531);
params(407) = params(409) *(ys(534)/ys(5))^(1/(1-params(508)));
ys(535) = ys(533)/( ys(16)*(1-ys(544))* (ys(531)^params(411)*ys(532)^(1-params(411)))^params(413)*ys(537)^(1-params(413)));
ys(595) = params(459)*ys(3);
ys(598) = params(463)*params(461)*ys(606)*ys(597)/ys(595);
params(457) = params(459) *(ys(598)/ys(5))^(1/(1-params(508)));
ys(599) = ys(597)/( ys(16)*(1-ys(608))* (ys(595)^params(461)*ys(596)^(1-params(461)))^params(463)*ys(601)^(1-params(463)));
ys(7) = ys(1)^(-params(1017));
params(1) = ys(7)*ys(5)/(ys(3)^params(2));
params(525) =  ys(688) - params(526)*ys(1335) - params(527)*ys(1335)^2;
ys(676) = params(518)*ys(660);
ys(680) = params(521)*(1-params(519))*ys(686)*ys(677)/ys(676);
params(516) = params(518) *(ys(680)/ys(662))^(1/(1-params(1015)));
ys(681) = (1-params(521))*ys(686)*ys(677)/ys(682);
ys(718) = params(553)*(ys(682)/ys(706))^(1/(1-params(520)))*ys(681);
ys(720) = params(554)*(ys(682)/ys(770))^(1/(1-params(520)))*ys(681);
ys(722) = params(555)*(ys(682)/ys(834))^(1/(1-params(520)))*ys(681);
ys(724) = params(556)*(ys(682)/ys(898))^(1/(1-params(520)))*ys(681);
ys(726) = params(557)*(ys(682)/ys(962))^(1/(1-params(520)))*ys(681);
ys(728) = params(558)*(ys(682)/ys(1026))^(1/(1-params(520)))*ys(681);
ys(730) = params(559)*(ys(682)/ys(1090))^(1/(1-params(520)))*ys(681);
ys(732) = params(560)*(ys(682)/ys(1154))^(1/(1-params(520)))*ys(681);
ys(734) = params(561)*(ys(682)/ys(1218))^(1/(1-params(520)))*ys(681);
ys(736) = params(562)*(ys(682)/ys(1282))^(1/(1-params(520)))*ys(681);
params(575) =  ys(752) - params(576)*ys(1335) - params(577)*ys(1335)^2;
ys(740) = params(568)*ys(660);
ys(744) = params(571)*(1-params(569))*ys(750)*ys(741)/ys(740);
params(566) = params(568) *(ys(744)/ys(662))^(1/(1-params(1015)));
ys(745) = (1-params(571))*ys(750)*ys(741)/ys(746);
ys(782) = params(603)*(ys(746)/ys(706))^(1/(1-params(570)))*ys(745);
ys(784) = params(604)*(ys(746)/ys(770))^(1/(1-params(570)))*ys(745);
ys(786) = params(605)*(ys(746)/ys(834))^(1/(1-params(570)))*ys(745);
ys(788) = params(606)*(ys(746)/ys(898))^(1/(1-params(570)))*ys(745);
ys(790) = params(607)*(ys(746)/ys(962))^(1/(1-params(570)))*ys(745);
ys(792) = params(608)*(ys(746)/ys(1026))^(1/(1-params(570)))*ys(745);
ys(794) = params(609)*(ys(746)/ys(1090))^(1/(1-params(570)))*ys(745);
ys(796) = params(610)*(ys(746)/ys(1154))^(1/(1-params(570)))*ys(745);
ys(798) = params(611)*(ys(746)/ys(1218))^(1/(1-params(570)))*ys(745);
ys(800) = params(612)*(ys(746)/ys(1282))^(1/(1-params(570)))*ys(745);
params(625) =  ys(816) - params(626)*ys(1335) - params(627)*ys(1335)^2;
ys(804) = params(618)*ys(660);
ys(808) = params(621)*(1-params(619))*ys(814)*ys(805)/ys(804);
params(616) = params(618) *(ys(808)/ys(662))^(1/(1-params(1015)));
ys(809) = (1-params(621))*ys(814)*ys(805)/ys(810);
ys(846) = params(653)*(ys(810)/ys(706))^(1/(1-params(620)))*ys(809);
ys(848) = params(654)*(ys(810)/ys(770))^(1/(1-params(620)))*ys(809);
ys(850) = params(655)*(ys(810)/ys(834))^(1/(1-params(620)))*ys(809);
ys(852) = params(656)*(ys(810)/ys(898))^(1/(1-params(620)))*ys(809);
ys(854) = params(657)*(ys(810)/ys(962))^(1/(1-params(620)))*ys(809);
ys(856) = params(658)*(ys(810)/ys(1026))^(1/(1-params(620)))*ys(809);
ys(858) = params(659)*(ys(810)/ys(1090))^(1/(1-params(620)))*ys(809);
ys(860) = params(660)*(ys(810)/ys(1154))^(1/(1-params(620)))*ys(809);
ys(862) = params(661)*(ys(810)/ys(1218))^(1/(1-params(620)))*ys(809);
ys(864) = params(662)*(ys(810)/ys(1282))^(1/(1-params(620)))*ys(809);
params(675) =  ys(880) - params(676)*ys(1335) - params(677)*ys(1335)^2;
ys(868) = params(668)*ys(660);
ys(872) = params(671)*(1-params(669))*ys(878)*ys(869)/ys(868);
params(666) = params(668) *(ys(872)/ys(662))^(1/(1-params(1015)));
ys(873) = (1-params(671))*ys(878)*ys(869)/ys(874);
ys(910) = params(703)*(ys(874)/ys(706))^(1/(1-params(670)))*ys(873);
ys(912) = params(704)*(ys(874)/ys(770))^(1/(1-params(670)))*ys(873);
ys(914) = params(705)*(ys(874)/ys(834))^(1/(1-params(670)))*ys(873);
ys(916) = params(706)*(ys(874)/ys(898))^(1/(1-params(670)))*ys(873);
ys(918) = params(707)*(ys(874)/ys(962))^(1/(1-params(670)))*ys(873);
ys(920) = params(708)*(ys(874)/ys(1026))^(1/(1-params(670)))*ys(873);
ys(922) = params(709)*(ys(874)/ys(1090))^(1/(1-params(670)))*ys(873);
ys(924) = params(710)*(ys(874)/ys(1154))^(1/(1-params(670)))*ys(873);
ys(926) = params(711)*(ys(874)/ys(1218))^(1/(1-params(670)))*ys(873);
ys(928) = params(712)*(ys(874)/ys(1282))^(1/(1-params(670)))*ys(873);
params(725) =  ys(944) - params(726)*ys(1335) - params(727)*ys(1335)^2;
ys(932) = params(718)*ys(660);
ys(936) = params(721)*(1-params(719))*ys(942)*ys(933)/ys(932);
params(716) = params(718) *(ys(936)/ys(662))^(1/(1-params(1015)));
ys(937) = (1-params(721))*ys(942)*ys(933)/ys(938);
ys(974) = params(753)*(ys(938)/ys(706))^(1/(1-params(720)))*ys(937);
ys(976) = params(754)*(ys(938)/ys(770))^(1/(1-params(720)))*ys(937);
ys(978) = params(755)*(ys(938)/ys(834))^(1/(1-params(720)))*ys(937);
ys(980) = params(756)*(ys(938)/ys(898))^(1/(1-params(720)))*ys(937);
ys(982) = params(757)*(ys(938)/ys(962))^(1/(1-params(720)))*ys(937);
ys(984) = params(758)*(ys(938)/ys(1026))^(1/(1-params(720)))*ys(937);
ys(986) = params(759)*(ys(938)/ys(1090))^(1/(1-params(720)))*ys(937);
ys(988) = params(760)*(ys(938)/ys(1154))^(1/(1-params(720)))*ys(937);
ys(990) = params(761)*(ys(938)/ys(1218))^(1/(1-params(720)))*ys(937);
ys(992) = params(762)*(ys(938)/ys(1282))^(1/(1-params(720)))*ys(937);
params(775) =  ys(1008) - params(776)*ys(1335) - params(777)*ys(1335)^2;
ys(996) = params(768)*ys(660);
ys(1000) = params(771)*(1-params(769))*ys(1006)*ys(997)/ys(996);
params(766) = params(768) *(ys(1000)/ys(662))^(1/(1-params(1015)));
ys(1001) = (1-params(771))*ys(1006)*ys(997)/ys(1002);
ys(1038) = params(803)*(ys(1002)/ys(706))^(1/(1-params(770)))*ys(1001);
ys(1040) = params(804)*(ys(1002)/ys(770))^(1/(1-params(770)))*ys(1001);
ys(1042) = params(805)*(ys(1002)/ys(834))^(1/(1-params(770)))*ys(1001);
ys(1044) = params(806)*(ys(1002)/ys(898))^(1/(1-params(770)))*ys(1001);
ys(1046) = params(807)*(ys(1002)/ys(962))^(1/(1-params(770)))*ys(1001);
ys(1048) = params(808)*(ys(1002)/ys(1026))^(1/(1-params(770)))*ys(1001);
ys(1050) = params(809)*(ys(1002)/ys(1090))^(1/(1-params(770)))*ys(1001);
ys(1052) = params(810)*(ys(1002)/ys(1154))^(1/(1-params(770)))*ys(1001);
ys(1054) = params(811)*(ys(1002)/ys(1218))^(1/(1-params(770)))*ys(1001);
ys(1056) = params(812)*(ys(1002)/ys(1282))^(1/(1-params(770)))*ys(1001);
params(825) =  ys(1072) - params(826)*ys(1335) - params(827)*ys(1335)^2;
ys(1060) = params(818)*ys(660);
ys(1064) = params(821)*(1-params(819))*ys(1070)*ys(1061)/ys(1060);
params(816) = params(818) *(ys(1064)/ys(662))^(1/(1-params(1015)));
ys(1065) = (1-params(821))*ys(1070)*ys(1061)/ys(1066);
ys(1102) = params(853)*(ys(1066)/ys(706))^(1/(1-params(820)))*ys(1065);
ys(1104) = params(854)*(ys(1066)/ys(770))^(1/(1-params(820)))*ys(1065);
ys(1106) = params(855)*(ys(1066)/ys(834))^(1/(1-params(820)))*ys(1065);
ys(1108) = params(856)*(ys(1066)/ys(898))^(1/(1-params(820)))*ys(1065);
ys(1110) = params(857)*(ys(1066)/ys(962))^(1/(1-params(820)))*ys(1065);
ys(1112) = params(858)*(ys(1066)/ys(1026))^(1/(1-params(820)))*ys(1065);
ys(1114) = params(859)*(ys(1066)/ys(1090))^(1/(1-params(820)))*ys(1065);
ys(1116) = params(860)*(ys(1066)/ys(1154))^(1/(1-params(820)))*ys(1065);
ys(1118) = params(861)*(ys(1066)/ys(1218))^(1/(1-params(820)))*ys(1065);
ys(1120) = params(862)*(ys(1066)/ys(1282))^(1/(1-params(820)))*ys(1065);
params(875) =  ys(1136) - params(876)*ys(1335) - params(877)*ys(1335)^2;
ys(1124) = params(868)*ys(660);
ys(1128) = params(871)*(1-params(869))*ys(1134)*ys(1125)/ys(1124);
params(866) = params(868) *(ys(1128)/ys(662))^(1/(1-params(1015)));
ys(1129) = (1-params(871))*ys(1134)*ys(1125)/ys(1130);
ys(1166) = params(903)*(ys(1130)/ys(706))^(1/(1-params(870)))*ys(1129);
ys(1168) = params(904)*(ys(1130)/ys(770))^(1/(1-params(870)))*ys(1129);
ys(1170) = params(905)*(ys(1130)/ys(834))^(1/(1-params(870)))*ys(1129);
ys(1172) = params(906)*(ys(1130)/ys(898))^(1/(1-params(870)))*ys(1129);
ys(1174) = params(907)*(ys(1130)/ys(962))^(1/(1-params(870)))*ys(1129);
ys(1176) = params(908)*(ys(1130)/ys(1026))^(1/(1-params(870)))*ys(1129);
ys(1178) = params(909)*(ys(1130)/ys(1090))^(1/(1-params(870)))*ys(1129);
ys(1180) = params(910)*(ys(1130)/ys(1154))^(1/(1-params(870)))*ys(1129);
ys(1182) = params(911)*(ys(1130)/ys(1218))^(1/(1-params(870)))*ys(1129);
ys(1184) = params(912)*(ys(1130)/ys(1282))^(1/(1-params(870)))*ys(1129);
params(925) =  ys(1200) - params(926)*ys(1335) - params(927)*ys(1335)^2;
ys(1188) = params(918)*ys(660);
ys(1192) = params(921)*(1-params(919))*ys(1198)*ys(1189)/ys(1188);
params(916) = params(918) *(ys(1192)/ys(662))^(1/(1-params(1015)));
ys(1193) = (1-params(921))*ys(1198)*ys(1189)/ys(1194);
ys(1230) = params(953)*(ys(1194)/ys(706))^(1/(1-params(920)))*ys(1193);
ys(1232) = params(954)*(ys(1194)/ys(770))^(1/(1-params(920)))*ys(1193);
ys(1234) = params(955)*(ys(1194)/ys(834))^(1/(1-params(920)))*ys(1193);
ys(1236) = params(956)*(ys(1194)/ys(898))^(1/(1-params(920)))*ys(1193);
ys(1238) = params(957)*(ys(1194)/ys(962))^(1/(1-params(920)))*ys(1193);
ys(1240) = params(958)*(ys(1194)/ys(1026))^(1/(1-params(920)))*ys(1193);
ys(1242) = params(959)*(ys(1194)/ys(1090))^(1/(1-params(920)))*ys(1193);
ys(1244) = params(960)*(ys(1194)/ys(1154))^(1/(1-params(920)))*ys(1193);
ys(1246) = params(961)*(ys(1194)/ys(1218))^(1/(1-params(920)))*ys(1193);
ys(1248) = params(962)*(ys(1194)/ys(1282))^(1/(1-params(920)))*ys(1193);
params(975) =  ys(1264) - params(976)*ys(1335) - params(977)*ys(1335)^2;
ys(1252) = params(968)*ys(660);
ys(1256) = params(971)*(1-params(969))*ys(1262)*ys(1253)/ys(1252);
params(966) = params(968) *(ys(1256)/ys(662))^(1/(1-params(1015)));
ys(1257) = (1-params(971))*ys(1262)*ys(1253)/ys(1258);
ys(1294) = params(1003)*(ys(1258)/ys(706))^(1/(1-params(970)))*ys(1257);
ys(1296) = params(1004)*(ys(1258)/ys(770))^(1/(1-params(970)))*ys(1257);
ys(1298) = params(1005)*(ys(1258)/ys(834))^(1/(1-params(970)))*ys(1257);
ys(1300) = params(1006)*(ys(1258)/ys(898))^(1/(1-params(970)))*ys(1257);
ys(1302) = params(1007)*(ys(1258)/ys(962))^(1/(1-params(970)))*ys(1257);
ys(1304) = params(1008)*(ys(1258)/ys(1026))^(1/(1-params(970)))*ys(1257);
ys(1306) = params(1009)*(ys(1258)/ys(1090))^(1/(1-params(970)))*ys(1257);
ys(1308) = params(1010)*(ys(1258)/ys(1154))^(1/(1-params(970)))*ys(1257);
ys(1310) = params(1011)*(ys(1258)/ys(1218))^(1/(1-params(970)))*ys(1257);
ys(1312) = params(1012)*(ys(1258)/ys(1282))^(1/(1-params(970)))*ys(1257);
ys(661) = (+ params(521)*params(519)*ys(686)*ys(677)/ys(659)+ params(571)*params(569)*ys(750)*ys(741)/ys(659)+ params(621)*params(619)*ys(814)*ys(805)/ys(659)+ params(671)*params(669)*ys(878)*ys(869)/ys(659)+ params(721)*params(719)*ys(942)*ys(933)/ys(659)+ params(771)*params(769)*ys(1006)*ys(997)/ys(659)+ params(821)*params(819)*ys(1070)*ys(1061)/ys(659)+ params(871)*params(869)*ys(1134)*ys(1125)/ys(659)+ params(921)*params(919)*ys(1198)*ys(1189)/ys(659)+ params(971)*params(969)*ys(1262)*ys(1253)/ys(659));
ys(675) = params(517)*ys(659);
ys(678) = params(521)*params(519)*ys(686)*ys(677)/ys(675);
params(515) = params(517) *(ys(678)/ys(661))^(1/(1-params(1016)));
ys(679) = ys(677)/( ys(672)*(1-ys(688))* (ys(675)^params(519)*ys(676)^(1-params(519)))^params(521)*ys(681)^(1-params(521)));
ys(739) = params(567)*ys(659);
ys(742) = params(571)*params(569)*ys(750)*ys(741)/ys(739);
params(565) = params(567) *(ys(742)/ys(661))^(1/(1-params(1016)));
ys(743) = ys(741)/( ys(672)*(1-ys(752))* (ys(739)^params(569)*ys(740)^(1-params(569)))^params(571)*ys(745)^(1-params(571)));
ys(803) = params(617)*ys(659);
ys(806) = params(621)*params(619)*ys(814)*ys(805)/ys(803);
params(615) = params(617) *(ys(806)/ys(661))^(1/(1-params(1016)));
ys(807) = ys(805)/( ys(672)*(1-ys(816))* (ys(803)^params(619)*ys(804)^(1-params(619)))^params(621)*ys(809)^(1-params(621)));
ys(867) = params(667)*ys(659);
ys(870) = params(671)*params(669)*ys(878)*ys(869)/ys(867);
params(665) = params(667) *(ys(870)/ys(661))^(1/(1-params(1016)));
ys(871) = ys(869)/( ys(672)*(1-ys(880))* (ys(867)^params(669)*ys(868)^(1-params(669)))^params(671)*ys(873)^(1-params(671)));
ys(931) = params(717)*ys(659);
ys(934) = params(721)*params(719)*ys(942)*ys(933)/ys(931);
params(715) = params(717) *(ys(934)/ys(661))^(1/(1-params(1016)));
ys(935) = ys(933)/( ys(672)*(1-ys(944))* (ys(931)^params(719)*ys(932)^(1-params(719)))^params(721)*ys(937)^(1-params(721)));
ys(995) = params(767)*ys(659);
ys(998) = params(771)*params(769)*ys(1006)*ys(997)/ys(995);
params(765) = params(767) *(ys(998)/ys(661))^(1/(1-params(1016)));
ys(999) = ys(997)/( ys(672)*(1-ys(1008))* (ys(995)^params(769)*ys(996)^(1-params(769)))^params(771)*ys(1001)^(1-params(771)));
ys(1059) = params(817)*ys(659);
ys(1062) = params(821)*params(819)*ys(1070)*ys(1061)/ys(1059);
params(815) = params(817) *(ys(1062)/ys(661))^(1/(1-params(1016)));
ys(1063) = ys(1061)/( ys(672)*(1-ys(1072))* (ys(1059)^params(819)*ys(1060)^(1-params(819)))^params(821)*ys(1065)^(1-params(821)));
ys(1123) = params(867)*ys(659);
ys(1126) = params(871)*params(869)*ys(1134)*ys(1125)/ys(1123);
params(865) = params(867) *(ys(1126)/ys(661))^(1/(1-params(1016)));
ys(1127) = ys(1125)/( ys(672)*(1-ys(1136))* (ys(1123)^params(869)*ys(1124)^(1-params(869)))^params(871)*ys(1129)^(1-params(871)));
ys(1187) = params(917)*ys(659);
ys(1190) = params(921)*params(919)*ys(1198)*ys(1189)/ys(1187);
params(915) = params(917) *(ys(1190)/ys(661))^(1/(1-params(1016)));
ys(1191) = ys(1189)/( ys(672)*(1-ys(1200))* (ys(1187)^params(919)*ys(1188)^(1-params(919)))^params(921)*ys(1193)^(1-params(921)));
ys(1251) = params(967)*ys(659);
ys(1254) = params(971)*params(969)*ys(1262)*ys(1253)/ys(1251);
params(965) = params(967) *(ys(1254)/ys(661))^(1/(1-params(1016)));
ys(1255) = ys(1253)/( ys(672)*(1-ys(1264))* (ys(1251)^params(969)*ys(1252)^(1-params(969)))^params(971)*ys(1257)^(1-params(971)));
ys(663) = ys(657)^(-params(1017));
params(509) = ys(663)*ys(661)/(ys(659)^params(510));
ys(29) = 0;
ys(27) = 1;
ys(28) = 1;
PHH_1_a_t = 1;
params(14) = 1-1/0.9;
params(15) = 1-1/0.9;
params(16) = 1-1/0.9;
ys(93) = 0;
ys(91) = 1;
ys(92) = 1;
PHH_2_a_t = 1;
params(64) = 1-1/0.9;
params(65) = 1-1/0.9;
params(66) = 1-1/0.9;
ys(157) = 0;
ys(155) = 1;
ys(156) = 1;
PHH_3_a_t = 1;
params(114) = 1-1/0.9;
params(115) = 1-1/0.9;
params(116) = 1-1/0.9;
ys(221) = 0;
ys(219) = 1;
ys(220) = 1;
PHH_4_a_t = 1;
params(164) = 1-1/0.9;
params(165) = 1-1/0.9;
params(166) = 1-1/0.9;
ys(285) = 0;
ys(283) = 1;
ys(284) = 1;
PHH_5_a_t = 1;
params(214) = 1-1/0.9;
params(215) = 1-1/0.9;
params(216) = 1-1/0.9;
ys(349) = 0;
ys(347) = 1;
ys(348) = 1;
PHH_6_a_t = 1;
params(264) = 1-1/0.9;
params(265) = 1-1/0.9;
params(266) = 1-1/0.9;
ys(413) = 0;
ys(411) = 1;
ys(412) = 1;
PHH_7_a_t = 1;
params(314) = 1-1/0.9;
params(315) = 1-1/0.9;
params(316) = 1-1/0.9;
ys(477) = 0;
ys(475) = 1;
ys(476) = 1;
PHH_8_a_t = 1;
params(364) = 1-1/0.9;
params(365) = 1-1/0.9;
params(366) = 1-1/0.9;
ys(541) = 0;
ys(539) = 1;
ys(540) = 1;
PHH_9_a_t = 1;
params(414) = 1-1/0.9;
params(415) = 1-1/0.9;
params(416) = 1-1/0.9;
ys(605) = 0;
ys(603) = 1;
ys(604) = 1;
PHH_10_a_t = 1;
params(464) = 1-1/0.9;
params(465) = 1-1/0.9;
params(466) = 1-1/0.9;
ys(685) = 0;
ys(683) = 1;
ys(684) = 1;
PHH_1_b_t = 1;
params(522) = 1-1/0.9;
params(523) = 1-1/0.9;
params(524) = 1-1/0.9;
ys(749) = 0;
ys(747) = 1;
ys(748) = 1;
PHH_2_b_t = 1;
params(572) = 1-1/0.9;
params(573) = 1-1/0.9;
params(574) = 1-1/0.9;
ys(813) = 0;
ys(811) = 1;
ys(812) = 1;
PHH_3_b_t = 1;
params(622) = 1-1/0.9;
params(623) = 1-1/0.9;
params(624) = 1-1/0.9;
ys(877) = 0;
ys(875) = 1;
ys(876) = 1;
PHH_4_b_t = 1;
params(672) = 1-1/0.9;
params(673) = 1-1/0.9;
params(674) = 1-1/0.9;
ys(941) = 0;
ys(939) = 1;
ys(940) = 1;
PHH_5_b_t = 1;
params(722) = 1-1/0.9;
params(723) = 1-1/0.9;
params(724) = 1-1/0.9;
ys(1005) = 0;
ys(1003) = 1;
ys(1004) = 1;
PHH_6_b_t = 1;
params(772) = 1-1/0.9;
params(773) = 1-1/0.9;
params(774) = 1-1/0.9;
ys(1069) = 0;
ys(1067) = 1;
ys(1068) = 1;
PHH_7_b_t = 1;
params(822) = 1-1/0.9;
params(823) = 1-1/0.9;
params(824) = 1-1/0.9;
ys(1133) = 0;
ys(1131) = 1;
ys(1132) = 1;
PHH_8_b_t = 1;
params(872) = 1-1/0.9;
params(873) = 1-1/0.9;
params(874) = 1-1/0.9;
ys(1197) = 0;
ys(1195) = 1;
ys(1196) = 1;
PHH_9_b_t = 1;
params(922) = 1-1/0.9;
params(923) = 1-1/0.9;
params(924) = 1-1/0.9;
ys(1261) = 0;
ys(1259) = 1;
ys(1260) = 1;
PHH_10_b_t = 1;
params(972) = 1-1/0.9;
params(973) = 1-1/0.9;
params(974) = 1-1/0.9;
ys(12) = (+ ys(29)+ ys(93)+ ys(157)+ ys(221)+ ys(285)+ ys(349)+ ys(413)+ ys(477)+ ys(541)+ ys(605));
ys(13) = ys(12);
ys(668) = (+ ys(685)+ ys(749)+ ys(813)+ ys(877)+ ys(941)+ ys(1005)+ ys(1069)+ ys(1133)+ ys(1197)+ ys(1261));
ys(669) = ys(668);
cid = ismember(DSGE_country, {'a'});
sid = DSGE_sector==1;
sid2 = DSGE_sector==1;
params(23) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(38) = params(23)*ys(62);
sid2 = DSGE_sector==2;
params(24) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(39) = params(24)*ys(64);
sid2 = DSGE_sector==3;
params(25) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(40) = params(25)*ys(66);
sid2 = DSGE_sector==4;
params(26) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(41) = params(26)*ys(68);
sid2 = DSGE_sector==5;
params(27) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(42) = params(27)*ys(70);
sid2 = DSGE_sector==6;
params(28) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(43) = params(28)*ys(72);
sid2 = DSGE_sector==7;
params(29) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(44) = params(29)*ys(74);
sid2 = DSGE_sector==8;
params(30) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(45) = params(30)*ys(76);
sid2 = DSGE_sector==9;
params(31) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(46) = params(31)*ys(78);
sid2 = DSGE_sector==10;
params(32) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(47) = params(32)*ys(80);
sid = DSGE_sector==2;
sid2 = DSGE_sector==1;
params(73) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(102) = params(73)*ys(126);
sid2 = DSGE_sector==2;
params(74) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(103) = params(74)*ys(128);
sid2 = DSGE_sector==3;
params(75) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(104) = params(75)*ys(130);
sid2 = DSGE_sector==4;
params(76) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(105) = params(76)*ys(132);
sid2 = DSGE_sector==5;
params(77) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(106) = params(77)*ys(134);
sid2 = DSGE_sector==6;
params(78) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(107) = params(78)*ys(136);
sid2 = DSGE_sector==7;
params(79) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(108) = params(79)*ys(138);
sid2 = DSGE_sector==8;
params(80) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(109) = params(80)*ys(140);
sid2 = DSGE_sector==9;
params(81) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(110) = params(81)*ys(142);
sid2 = DSGE_sector==10;
params(82) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(111) = params(82)*ys(144);
sid = DSGE_sector==3;
sid2 = DSGE_sector==1;
params(123) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(166) = params(123)*ys(190);
sid2 = DSGE_sector==2;
params(124) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(167) = params(124)*ys(192);
sid2 = DSGE_sector==3;
params(125) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(168) = params(125)*ys(194);
sid2 = DSGE_sector==4;
params(126) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(169) = params(126)*ys(196);
sid2 = DSGE_sector==5;
params(127) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(170) = params(127)*ys(198);
sid2 = DSGE_sector==6;
params(128) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(171) = params(128)*ys(200);
sid2 = DSGE_sector==7;
params(129) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(172) = params(129)*ys(202);
sid2 = DSGE_sector==8;
params(130) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(173) = params(130)*ys(204);
sid2 = DSGE_sector==9;
params(131) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(174) = params(131)*ys(206);
sid2 = DSGE_sector==10;
params(132) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(175) = params(132)*ys(208);
sid = DSGE_sector==4;
sid2 = DSGE_sector==1;
params(173) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(230) = params(173)*ys(254);
sid2 = DSGE_sector==2;
params(174) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(231) = params(174)*ys(256);
sid2 = DSGE_sector==3;
params(175) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(232) = params(175)*ys(258);
sid2 = DSGE_sector==4;
params(176) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(233) = params(176)*ys(260);
sid2 = DSGE_sector==5;
params(177) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(234) = params(177)*ys(262);
sid2 = DSGE_sector==6;
params(178) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(235) = params(178)*ys(264);
sid2 = DSGE_sector==7;
params(179) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(236) = params(179)*ys(266);
sid2 = DSGE_sector==8;
params(180) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(237) = params(180)*ys(268);
sid2 = DSGE_sector==9;
params(181) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(238) = params(181)*ys(270);
sid2 = DSGE_sector==10;
params(182) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(239) = params(182)*ys(272);
sid = DSGE_sector==5;
sid2 = DSGE_sector==1;
params(223) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(294) = params(223)*ys(318);
sid2 = DSGE_sector==2;
params(224) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(295) = params(224)*ys(320);
sid2 = DSGE_sector==3;
params(225) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(296) = params(225)*ys(322);
sid2 = DSGE_sector==4;
params(226) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(297) = params(226)*ys(324);
sid2 = DSGE_sector==5;
params(227) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(298) = params(227)*ys(326);
sid2 = DSGE_sector==6;
params(228) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(299) = params(228)*ys(328);
sid2 = DSGE_sector==7;
params(229) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(300) = params(229)*ys(330);
sid2 = DSGE_sector==8;
params(230) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(301) = params(230)*ys(332);
sid2 = DSGE_sector==9;
params(231) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(302) = params(231)*ys(334);
sid2 = DSGE_sector==10;
params(232) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(303) = params(232)*ys(336);
sid = DSGE_sector==6;
sid2 = DSGE_sector==1;
params(273) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(358) = params(273)*ys(382);
sid2 = DSGE_sector==2;
params(274) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(359) = params(274)*ys(384);
sid2 = DSGE_sector==3;
params(275) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(360) = params(275)*ys(386);
sid2 = DSGE_sector==4;
params(276) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(361) = params(276)*ys(388);
sid2 = DSGE_sector==5;
params(277) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(362) = params(277)*ys(390);
sid2 = DSGE_sector==6;
params(278) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(363) = params(278)*ys(392);
sid2 = DSGE_sector==7;
params(279) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(364) = params(279)*ys(394);
sid2 = DSGE_sector==8;
params(280) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(365) = params(280)*ys(396);
sid2 = DSGE_sector==9;
params(281) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(366) = params(281)*ys(398);
sid2 = DSGE_sector==10;
params(282) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(367) = params(282)*ys(400);
sid = DSGE_sector==7;
sid2 = DSGE_sector==1;
params(323) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(422) = params(323)*ys(446);
sid2 = DSGE_sector==2;
params(324) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(423) = params(324)*ys(448);
sid2 = DSGE_sector==3;
params(325) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(424) = params(325)*ys(450);
sid2 = DSGE_sector==4;
params(326) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(425) = params(326)*ys(452);
sid2 = DSGE_sector==5;
params(327) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(426) = params(327)*ys(454);
sid2 = DSGE_sector==6;
params(328) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(427) = params(328)*ys(456);
sid2 = DSGE_sector==7;
params(329) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(428) = params(329)*ys(458);
sid2 = DSGE_sector==8;
params(330) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(429) = params(330)*ys(460);
sid2 = DSGE_sector==9;
params(331) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(430) = params(331)*ys(462);
sid2 = DSGE_sector==10;
params(332) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(431) = params(332)*ys(464);
sid = DSGE_sector==8;
sid2 = DSGE_sector==1;
params(373) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(486) = params(373)*ys(510);
sid2 = DSGE_sector==2;
params(374) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(487) = params(374)*ys(512);
sid2 = DSGE_sector==3;
params(375) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(488) = params(375)*ys(514);
sid2 = DSGE_sector==4;
params(376) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(489) = params(376)*ys(516);
sid2 = DSGE_sector==5;
params(377) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(490) = params(377)*ys(518);
sid2 = DSGE_sector==6;
params(378) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(491) = params(378)*ys(520);
sid2 = DSGE_sector==7;
params(379) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(492) = params(379)*ys(522);
sid2 = DSGE_sector==8;
params(380) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(493) = params(380)*ys(524);
sid2 = DSGE_sector==9;
params(381) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(494) = params(381)*ys(526);
sid2 = DSGE_sector==10;
params(382) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(495) = params(382)*ys(528);
sid = DSGE_sector==9;
sid2 = DSGE_sector==1;
params(423) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(550) = params(423)*ys(574);
sid2 = DSGE_sector==2;
params(424) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(551) = params(424)*ys(576);
sid2 = DSGE_sector==3;
params(425) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(552) = params(425)*ys(578);
sid2 = DSGE_sector==4;
params(426) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(553) = params(426)*ys(580);
sid2 = DSGE_sector==5;
params(427) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(554) = params(427)*ys(582);
sid2 = DSGE_sector==6;
params(428) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(555) = params(428)*ys(584);
sid2 = DSGE_sector==7;
params(429) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(556) = params(429)*ys(586);
sid2 = DSGE_sector==8;
params(430) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(557) = params(430)*ys(588);
sid2 = DSGE_sector==9;
params(431) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(558) = params(431)*ys(590);
sid2 = DSGE_sector==10;
params(432) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(559) = params(432)*ys(592);
sid = DSGE_sector==10;
sid2 = DSGE_sector==1;
params(473) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(614) = params(473)*ys(638);
sid2 = DSGE_sector==2;
params(474) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(615) = params(474)*ys(640);
sid2 = DSGE_sector==3;
params(475) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(616) = params(475)*ys(642);
sid2 = DSGE_sector==4;
params(476) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(617) = params(476)*ys(644);
sid2 = DSGE_sector==5;
params(477) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(618) = params(477)*ys(646);
sid2 = DSGE_sector==6;
params(478) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(619) = params(478)*ys(648);
sid2 = DSGE_sector==7;
params(479) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(620) = params(479)*ys(650);
sid2 = DSGE_sector==8;
params(480) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(621) = params(480)*ys(652);
sid2 = DSGE_sector==9;
params(481) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(622) = params(481)*ys(654);
sid2 = DSGE_sector==10;
params(482) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(623) = params(482)*ys(656);
cid = ismember(DSGE_country, {'b'});
sid = DSGE_sector==1;
sid2 = DSGE_sector==1;
params(543) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(707) = params(543)*ys(718);
sid2 = DSGE_sector==2;
params(544) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(708) = params(544)*ys(720);
sid2 = DSGE_sector==3;
params(545) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(709) = params(545)*ys(722);
sid2 = DSGE_sector==4;
params(546) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(710) = params(546)*ys(724);
sid2 = DSGE_sector==5;
params(547) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(711) = params(547)*ys(726);
sid2 = DSGE_sector==6;
params(548) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(712) = params(548)*ys(728);
sid2 = DSGE_sector==7;
params(549) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(713) = params(549)*ys(730);
sid2 = DSGE_sector==8;
params(550) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(714) = params(550)*ys(732);
sid2 = DSGE_sector==9;
params(551) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(715) = params(551)*ys(734);
sid2 = DSGE_sector==10;
params(552) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(716) = params(552)*ys(736);
sid = DSGE_sector==2;
sid2 = DSGE_sector==1;
params(593) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(771) = params(593)*ys(782);
sid2 = DSGE_sector==2;
params(594) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(772) = params(594)*ys(784);
sid2 = DSGE_sector==3;
params(595) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(773) = params(595)*ys(786);
sid2 = DSGE_sector==4;
params(596) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(774) = params(596)*ys(788);
sid2 = DSGE_sector==5;
params(597) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(775) = params(597)*ys(790);
sid2 = DSGE_sector==6;
params(598) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(776) = params(598)*ys(792);
sid2 = DSGE_sector==7;
params(599) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(777) = params(599)*ys(794);
sid2 = DSGE_sector==8;
params(600) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(778) = params(600)*ys(796);
sid2 = DSGE_sector==9;
params(601) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(779) = params(601)*ys(798);
sid2 = DSGE_sector==10;
params(602) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(780) = params(602)*ys(800);
sid = DSGE_sector==3;
sid2 = DSGE_sector==1;
params(643) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(835) = params(643)*ys(846);
sid2 = DSGE_sector==2;
params(644) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(836) = params(644)*ys(848);
sid2 = DSGE_sector==3;
params(645) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(837) = params(645)*ys(850);
sid2 = DSGE_sector==4;
params(646) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(838) = params(646)*ys(852);
sid2 = DSGE_sector==5;
params(647) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(839) = params(647)*ys(854);
sid2 = DSGE_sector==6;
params(648) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(840) = params(648)*ys(856);
sid2 = DSGE_sector==7;
params(649) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(841) = params(649)*ys(858);
sid2 = DSGE_sector==8;
params(650) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(842) = params(650)*ys(860);
sid2 = DSGE_sector==9;
params(651) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(843) = params(651)*ys(862);
sid2 = DSGE_sector==10;
params(652) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(844) = params(652)*ys(864);
sid = DSGE_sector==4;
sid2 = DSGE_sector==1;
params(693) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(899) = params(693)*ys(910);
sid2 = DSGE_sector==2;
params(694) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(900) = params(694)*ys(912);
sid2 = DSGE_sector==3;
params(695) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(901) = params(695)*ys(914);
sid2 = DSGE_sector==4;
params(696) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(902) = params(696)*ys(916);
sid2 = DSGE_sector==5;
params(697) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(903) = params(697)*ys(918);
sid2 = DSGE_sector==6;
params(698) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(904) = params(698)*ys(920);
sid2 = DSGE_sector==7;
params(699) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(905) = params(699)*ys(922);
sid2 = DSGE_sector==8;
params(700) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(906) = params(700)*ys(924);
sid2 = DSGE_sector==9;
params(701) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(907) = params(701)*ys(926);
sid2 = DSGE_sector==10;
params(702) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(908) = params(702)*ys(928);
sid = DSGE_sector==5;
sid2 = DSGE_sector==1;
params(743) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(963) = params(743)*ys(974);
sid2 = DSGE_sector==2;
params(744) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(964) = params(744)*ys(976);
sid2 = DSGE_sector==3;
params(745) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(965) = params(745)*ys(978);
sid2 = DSGE_sector==4;
params(746) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(966) = params(746)*ys(980);
sid2 = DSGE_sector==5;
params(747) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(967) = params(747)*ys(982);
sid2 = DSGE_sector==6;
params(748) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(968) = params(748)*ys(984);
sid2 = DSGE_sector==7;
params(749) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(969) = params(749)*ys(986);
sid2 = DSGE_sector==8;
params(750) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(970) = params(750)*ys(988);
sid2 = DSGE_sector==9;
params(751) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(971) = params(751)*ys(990);
sid2 = DSGE_sector==10;
params(752) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(972) = params(752)*ys(992);
sid = DSGE_sector==6;
sid2 = DSGE_sector==1;
params(793) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1027) = params(793)*ys(1038);
sid2 = DSGE_sector==2;
params(794) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1028) = params(794)*ys(1040);
sid2 = DSGE_sector==3;
params(795) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1029) = params(795)*ys(1042);
sid2 = DSGE_sector==4;
params(796) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1030) = params(796)*ys(1044);
sid2 = DSGE_sector==5;
params(797) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1031) = params(797)*ys(1046);
sid2 = DSGE_sector==6;
params(798) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1032) = params(798)*ys(1048);
sid2 = DSGE_sector==7;
params(799) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1033) = params(799)*ys(1050);
sid2 = DSGE_sector==8;
params(800) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1034) = params(800)*ys(1052);
sid2 = DSGE_sector==9;
params(801) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1035) = params(801)*ys(1054);
sid2 = DSGE_sector==10;
params(802) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1036) = params(802)*ys(1056);
sid = DSGE_sector==7;
sid2 = DSGE_sector==1;
params(843) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1091) = params(843)*ys(1102);
sid2 = DSGE_sector==2;
params(844) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1092) = params(844)*ys(1104);
sid2 = DSGE_sector==3;
params(845) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1093) = params(845)*ys(1106);
sid2 = DSGE_sector==4;
params(846) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1094) = params(846)*ys(1108);
sid2 = DSGE_sector==5;
params(847) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1095) = params(847)*ys(1110);
sid2 = DSGE_sector==6;
params(848) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1096) = params(848)*ys(1112);
sid2 = DSGE_sector==7;
params(849) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1097) = params(849)*ys(1114);
sid2 = DSGE_sector==8;
params(850) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1098) = params(850)*ys(1116);
sid2 = DSGE_sector==9;
params(851) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1099) = params(851)*ys(1118);
sid2 = DSGE_sector==10;
params(852) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1100) = params(852)*ys(1120);
sid = DSGE_sector==8;
sid2 = DSGE_sector==1;
params(893) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1155) = params(893)*ys(1166);
sid2 = DSGE_sector==2;
params(894) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1156) = params(894)*ys(1168);
sid2 = DSGE_sector==3;
params(895) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1157) = params(895)*ys(1170);
sid2 = DSGE_sector==4;
params(896) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1158) = params(896)*ys(1172);
sid2 = DSGE_sector==5;
params(897) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1159) = params(897)*ys(1174);
sid2 = DSGE_sector==6;
params(898) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1160) = params(898)*ys(1176);
sid2 = DSGE_sector==7;
params(899) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1161) = params(899)*ys(1178);
sid2 = DSGE_sector==8;
params(900) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1162) = params(900)*ys(1180);
sid2 = DSGE_sector==9;
params(901) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1163) = params(901)*ys(1182);
sid2 = DSGE_sector==10;
params(902) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1164) = params(902)*ys(1184);
sid = DSGE_sector==9;
sid2 = DSGE_sector==1;
params(943) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1219) = params(943)*ys(1230);
sid2 = DSGE_sector==2;
params(944) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1220) = params(944)*ys(1232);
sid2 = DSGE_sector==3;
params(945) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1221) = params(945)*ys(1234);
sid2 = DSGE_sector==4;
params(946) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1222) = params(946)*ys(1236);
sid2 = DSGE_sector==5;
params(947) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1223) = params(947)*ys(1238);
sid2 = DSGE_sector==6;
params(948) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1224) = params(948)*ys(1240);
sid2 = DSGE_sector==7;
params(949) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1225) = params(949)*ys(1242);
sid2 = DSGE_sector==8;
params(950) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1226) = params(950)*ys(1244);
sid2 = DSGE_sector==9;
params(951) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1227) = params(951)*ys(1246);
sid2 = DSGE_sector==10;
params(952) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1228) = params(952)*ys(1248);
sid = DSGE_sector==10;
sid2 = DSGE_sector==1;
params(993) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1283) = params(993)*ys(1294);
sid2 = DSGE_sector==2;
params(994) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1284) = params(994)*ys(1296);
sid2 = DSGE_sector==3;
params(995) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1285) = params(995)*ys(1298);
sid2 = DSGE_sector==4;
params(996) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1286) = params(996)*ys(1300);
sid2 = DSGE_sector==5;
params(997) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1287) = params(997)*ys(1302);
sid2 = DSGE_sector==6;
params(998) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1288) = params(998)*ys(1304);
sid2 = DSGE_sector==7;
params(999) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1289) = params(999)*ys(1306);
sid2 = DSGE_sector==8;
params(1000) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1290) = params(1000)*ys(1308);
sid2 = DSGE_sector==9;
params(1001) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1291) = params(1001)*ys(1310);
sid2 = DSGE_sector==10;
params(1002) = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
ys(1292) = params(1002)*ys(1312);
params(35) = 1-params(23);
params(531) = 1-params(543);
ys(51) = params(35)*ys(62);
ys(694) = params(531)*ys(718);
params(36) = 1-params(24);
params(532) = 1-params(544);
ys(52) = params(36)*ys(64);
ys(695) = params(532)*ys(720);
params(37) = 1-params(25);
params(533) = 1-params(545);
ys(53) = params(37)*ys(66);
ys(696) = params(533)*ys(722);
params(38) = 1-params(26);
params(534) = 1-params(546);
ys(54) = params(38)*ys(68);
ys(697) = params(534)*ys(724);
params(39) = 1-params(27);
params(535) = 1-params(547);
ys(55) = params(39)*ys(70);
ys(698) = params(535)*ys(726);
params(40) = 1-params(28);
params(536) = 1-params(548);
ys(56) = params(40)*ys(72);
ys(699) = params(536)*ys(728);
params(41) = 1-params(29);
params(537) = 1-params(549);
ys(57) = params(41)*ys(74);
ys(700) = params(537)*ys(730);
params(42) = 1-params(30);
params(538) = 1-params(550);
ys(58) = params(42)*ys(76);
ys(701) = params(538)*ys(732);
params(43) = 1-params(31);
params(539) = 1-params(551);
ys(59) = params(43)*ys(78);
ys(702) = params(539)*ys(734);
params(44) = 1-params(32);
params(540) = 1-params(552);
ys(60) = params(44)*ys(80);
ys(703) = params(540)*ys(736);
params(85) = 1-params(73);
params(581) = 1-params(593);
ys(115) = params(85)*ys(126);
ys(758) = params(581)*ys(782);
params(86) = 1-params(74);
params(582) = 1-params(594);
ys(116) = params(86)*ys(128);
ys(759) = params(582)*ys(784);
params(87) = 1-params(75);
params(583) = 1-params(595);
ys(117) = params(87)*ys(130);
ys(760) = params(583)*ys(786);
params(88) = 1-params(76);
params(584) = 1-params(596);
ys(118) = params(88)*ys(132);
ys(761) = params(584)*ys(788);
params(89) = 1-params(77);
params(585) = 1-params(597);
ys(119) = params(89)*ys(134);
ys(762) = params(585)*ys(790);
params(90) = 1-params(78);
params(586) = 1-params(598);
ys(120) = params(90)*ys(136);
ys(763) = params(586)*ys(792);
params(91) = 1-params(79);
params(587) = 1-params(599);
ys(121) = params(91)*ys(138);
ys(764) = params(587)*ys(794);
params(92) = 1-params(80);
params(588) = 1-params(600);
ys(122) = params(92)*ys(140);
ys(765) = params(588)*ys(796);
params(93) = 1-params(81);
params(589) = 1-params(601);
ys(123) = params(93)*ys(142);
ys(766) = params(589)*ys(798);
params(94) = 1-params(82);
params(590) = 1-params(602);
ys(124) = params(94)*ys(144);
ys(767) = params(590)*ys(800);
params(135) = 1-params(123);
params(631) = 1-params(643);
ys(179) = params(135)*ys(190);
ys(822) = params(631)*ys(846);
params(136) = 1-params(124);
params(632) = 1-params(644);
ys(180) = params(136)*ys(192);
ys(823) = params(632)*ys(848);
params(137) = 1-params(125);
params(633) = 1-params(645);
ys(181) = params(137)*ys(194);
ys(824) = params(633)*ys(850);
params(138) = 1-params(126);
params(634) = 1-params(646);
ys(182) = params(138)*ys(196);
ys(825) = params(634)*ys(852);
params(139) = 1-params(127);
params(635) = 1-params(647);
ys(183) = params(139)*ys(198);
ys(826) = params(635)*ys(854);
params(140) = 1-params(128);
params(636) = 1-params(648);
ys(184) = params(140)*ys(200);
ys(827) = params(636)*ys(856);
params(141) = 1-params(129);
params(637) = 1-params(649);
ys(185) = params(141)*ys(202);
ys(828) = params(637)*ys(858);
params(142) = 1-params(130);
params(638) = 1-params(650);
ys(186) = params(142)*ys(204);
ys(829) = params(638)*ys(860);
params(143) = 1-params(131);
params(639) = 1-params(651);
ys(187) = params(143)*ys(206);
ys(830) = params(639)*ys(862);
params(144) = 1-params(132);
params(640) = 1-params(652);
ys(188) = params(144)*ys(208);
ys(831) = params(640)*ys(864);
params(185) = 1-params(173);
params(681) = 1-params(693);
ys(243) = params(185)*ys(254);
ys(886) = params(681)*ys(910);
params(186) = 1-params(174);
params(682) = 1-params(694);
ys(244) = params(186)*ys(256);
ys(887) = params(682)*ys(912);
params(187) = 1-params(175);
params(683) = 1-params(695);
ys(245) = params(187)*ys(258);
ys(888) = params(683)*ys(914);
params(188) = 1-params(176);
params(684) = 1-params(696);
ys(246) = params(188)*ys(260);
ys(889) = params(684)*ys(916);
params(189) = 1-params(177);
params(685) = 1-params(697);
ys(247) = params(189)*ys(262);
ys(890) = params(685)*ys(918);
params(190) = 1-params(178);
params(686) = 1-params(698);
ys(248) = params(190)*ys(264);
ys(891) = params(686)*ys(920);
params(191) = 1-params(179);
params(687) = 1-params(699);
ys(249) = params(191)*ys(266);
ys(892) = params(687)*ys(922);
params(192) = 1-params(180);
params(688) = 1-params(700);
ys(250) = params(192)*ys(268);
ys(893) = params(688)*ys(924);
params(193) = 1-params(181);
params(689) = 1-params(701);
ys(251) = params(193)*ys(270);
ys(894) = params(689)*ys(926);
params(194) = 1-params(182);
params(690) = 1-params(702);
ys(252) = params(194)*ys(272);
ys(895) = params(690)*ys(928);
params(235) = 1-params(223);
params(731) = 1-params(743);
ys(307) = params(235)*ys(318);
ys(950) = params(731)*ys(974);
params(236) = 1-params(224);
params(732) = 1-params(744);
ys(308) = params(236)*ys(320);
ys(951) = params(732)*ys(976);
params(237) = 1-params(225);
params(733) = 1-params(745);
ys(309) = params(237)*ys(322);
ys(952) = params(733)*ys(978);
params(238) = 1-params(226);
params(734) = 1-params(746);
ys(310) = params(238)*ys(324);
ys(953) = params(734)*ys(980);
params(239) = 1-params(227);
params(735) = 1-params(747);
ys(311) = params(239)*ys(326);
ys(954) = params(735)*ys(982);
params(240) = 1-params(228);
params(736) = 1-params(748);
ys(312) = params(240)*ys(328);
ys(955) = params(736)*ys(984);
params(241) = 1-params(229);
params(737) = 1-params(749);
ys(313) = params(241)*ys(330);
ys(956) = params(737)*ys(986);
params(242) = 1-params(230);
params(738) = 1-params(750);
ys(314) = params(242)*ys(332);
ys(957) = params(738)*ys(988);
params(243) = 1-params(231);
params(739) = 1-params(751);
ys(315) = params(243)*ys(334);
ys(958) = params(739)*ys(990);
params(244) = 1-params(232);
params(740) = 1-params(752);
ys(316) = params(244)*ys(336);
ys(959) = params(740)*ys(992);
params(285) = 1-params(273);
params(781) = 1-params(793);
ys(371) = params(285)*ys(382);
ys(1014) = params(781)*ys(1038);
params(286) = 1-params(274);
params(782) = 1-params(794);
ys(372) = params(286)*ys(384);
ys(1015) = params(782)*ys(1040);
params(287) = 1-params(275);
params(783) = 1-params(795);
ys(373) = params(287)*ys(386);
ys(1016) = params(783)*ys(1042);
params(288) = 1-params(276);
params(784) = 1-params(796);
ys(374) = params(288)*ys(388);
ys(1017) = params(784)*ys(1044);
params(289) = 1-params(277);
params(785) = 1-params(797);
ys(375) = params(289)*ys(390);
ys(1018) = params(785)*ys(1046);
params(290) = 1-params(278);
params(786) = 1-params(798);
ys(376) = params(290)*ys(392);
ys(1019) = params(786)*ys(1048);
params(291) = 1-params(279);
params(787) = 1-params(799);
ys(377) = params(291)*ys(394);
ys(1020) = params(787)*ys(1050);
params(292) = 1-params(280);
params(788) = 1-params(800);
ys(378) = params(292)*ys(396);
ys(1021) = params(788)*ys(1052);
params(293) = 1-params(281);
params(789) = 1-params(801);
ys(379) = params(293)*ys(398);
ys(1022) = params(789)*ys(1054);
params(294) = 1-params(282);
params(790) = 1-params(802);
ys(380) = params(294)*ys(400);
ys(1023) = params(790)*ys(1056);
params(335) = 1-params(323);
params(831) = 1-params(843);
ys(435) = params(335)*ys(446);
ys(1078) = params(831)*ys(1102);
params(336) = 1-params(324);
params(832) = 1-params(844);
ys(436) = params(336)*ys(448);
ys(1079) = params(832)*ys(1104);
params(337) = 1-params(325);
params(833) = 1-params(845);
ys(437) = params(337)*ys(450);
ys(1080) = params(833)*ys(1106);
params(338) = 1-params(326);
params(834) = 1-params(846);
ys(438) = params(338)*ys(452);
ys(1081) = params(834)*ys(1108);
params(339) = 1-params(327);
params(835) = 1-params(847);
ys(439) = params(339)*ys(454);
ys(1082) = params(835)*ys(1110);
params(340) = 1-params(328);
params(836) = 1-params(848);
ys(440) = params(340)*ys(456);
ys(1083) = params(836)*ys(1112);
params(341) = 1-params(329);
params(837) = 1-params(849);
ys(441) = params(341)*ys(458);
ys(1084) = params(837)*ys(1114);
params(342) = 1-params(330);
params(838) = 1-params(850);
ys(442) = params(342)*ys(460);
ys(1085) = params(838)*ys(1116);
params(343) = 1-params(331);
params(839) = 1-params(851);
ys(443) = params(343)*ys(462);
ys(1086) = params(839)*ys(1118);
params(344) = 1-params(332);
params(840) = 1-params(852);
ys(444) = params(344)*ys(464);
ys(1087) = params(840)*ys(1120);
params(385) = 1-params(373);
params(881) = 1-params(893);
ys(499) = params(385)*ys(510);
ys(1142) = params(881)*ys(1166);
params(386) = 1-params(374);
params(882) = 1-params(894);
ys(500) = params(386)*ys(512);
ys(1143) = params(882)*ys(1168);
params(387) = 1-params(375);
params(883) = 1-params(895);
ys(501) = params(387)*ys(514);
ys(1144) = params(883)*ys(1170);
params(388) = 1-params(376);
params(884) = 1-params(896);
ys(502) = params(388)*ys(516);
ys(1145) = params(884)*ys(1172);
params(389) = 1-params(377);
params(885) = 1-params(897);
ys(503) = params(389)*ys(518);
ys(1146) = params(885)*ys(1174);
params(390) = 1-params(378);
params(886) = 1-params(898);
ys(504) = params(390)*ys(520);
ys(1147) = params(886)*ys(1176);
params(391) = 1-params(379);
params(887) = 1-params(899);
ys(505) = params(391)*ys(522);
ys(1148) = params(887)*ys(1178);
params(392) = 1-params(380);
params(888) = 1-params(900);
ys(506) = params(392)*ys(524);
ys(1149) = params(888)*ys(1180);
params(393) = 1-params(381);
params(889) = 1-params(901);
ys(507) = params(393)*ys(526);
ys(1150) = params(889)*ys(1182);
params(394) = 1-params(382);
params(890) = 1-params(902);
ys(508) = params(394)*ys(528);
ys(1151) = params(890)*ys(1184);
params(435) = 1-params(423);
params(931) = 1-params(943);
ys(563) = params(435)*ys(574);
ys(1206) = params(931)*ys(1230);
params(436) = 1-params(424);
params(932) = 1-params(944);
ys(564) = params(436)*ys(576);
ys(1207) = params(932)*ys(1232);
params(437) = 1-params(425);
params(933) = 1-params(945);
ys(565) = params(437)*ys(578);
ys(1208) = params(933)*ys(1234);
params(438) = 1-params(426);
params(934) = 1-params(946);
ys(566) = params(438)*ys(580);
ys(1209) = params(934)*ys(1236);
params(439) = 1-params(427);
params(935) = 1-params(947);
ys(567) = params(439)*ys(582);
ys(1210) = params(935)*ys(1238);
params(440) = 1-params(428);
params(936) = 1-params(948);
ys(568) = params(440)*ys(584);
ys(1211) = params(936)*ys(1240);
params(441) = 1-params(429);
params(937) = 1-params(949);
ys(569) = params(441)*ys(586);
ys(1212) = params(937)*ys(1242);
params(442) = 1-params(430);
params(938) = 1-params(950);
ys(570) = params(442)*ys(588);
ys(1213) = params(938)*ys(1244);
params(443) = 1-params(431);
params(939) = 1-params(951);
ys(571) = params(443)*ys(590);
ys(1214) = params(939)*ys(1246);
params(444) = 1-params(432);
params(940) = 1-params(952);
ys(572) = params(444)*ys(592);
ys(1215) = params(940)*ys(1248);
params(485) = 1-params(473);
params(981) = 1-params(993);
ys(627) = params(485)*ys(638);
ys(1270) = params(981)*ys(1294);
params(486) = 1-params(474);
params(982) = 1-params(994);
ys(628) = params(486)*ys(640);
ys(1271) = params(982)*ys(1296);
params(487) = 1-params(475);
params(983) = 1-params(995);
ys(629) = params(487)*ys(642);
ys(1272) = params(983)*ys(1298);
params(488) = 1-params(476);
params(984) = 1-params(996);
ys(630) = params(488)*ys(644);
ys(1273) = params(984)*ys(1300);
params(489) = 1-params(477);
params(985) = 1-params(997);
ys(631) = params(489)*ys(646);
ys(1274) = params(985)*ys(1302);
params(490) = 1-params(478);
params(986) = 1-params(998);
ys(632) = params(490)*ys(648);
ys(1275) = params(986)*ys(1304);
params(491) = 1-params(479);
params(987) = 1-params(999);
ys(633) = params(491)*ys(650);
ys(1276) = params(987)*ys(1306);
params(492) = 1-params(480);
params(988) = 1-params(1000);
ys(634) = params(492)*ys(652);
ys(1277) = params(988)*ys(1308);
params(493) = 1-params(481);
params(989) = 1-params(1001);
ys(635) = params(493)*ys(654);
ys(1278) = params(989)*ys(1310);
params(494) = 1-params(482);
params(990) = 1-params(1002);
ys(636) = params(494)*ys(656);
ys(1279) = params(990)*ys(1312);
cid = ismember(DSGE_country, {'a'});
sid = DSGE_sector==1;
params(21) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(22) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==2;
params(71) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(72) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==3;
params(121) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(122) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==4;
params(171) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(172) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==5;
params(221) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(222) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==6;
params(271) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(272) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==7;
params(321) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(322) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==8;
params(371) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(372) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==9;
params(421) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(422) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==10;
params(471) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(472) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
cid = ismember(DSGE_country, {'b'});
sid = DSGE_sector==1;
params(541) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(542) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==2;
params(591) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(592) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==3;
params(641) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(642) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==4;
params(691) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(692) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==5;
params(741) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(742) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==6;
params(791) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(792) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==7;
params(841) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(842) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==8;
params(891) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(892) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==9;
params(941) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(942) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
sid = DSGE_sector==10;
params(991) = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
params(992) = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
params(33) = 1-params(21);
params(34) = 1-params(22);
params(83) = 1-params(71);
params(84) = 1-params(72);
params(133) = 1-params(121);
params(134) = 1-params(122);
params(183) = 1-params(171);
params(184) = 1-params(172);
params(233) = 1-params(221);
params(234) = 1-params(222);
params(283) = 1-params(271);
params(284) = 1-params(272);
params(333) = 1-params(321);
params(334) = 1-params(322);
params(383) = 1-params(371);
params(384) = 1-params(372);
params(433) = 1-params(421);
params(434) = 1-params(422);
params(483) = 1-params(471);
params(484) = 1-params(472);
ys(35) = params(21)*ys(17);
ys(36) = params(22)*ys(18);
ys(35) = params(21)*ys(17);
ys(36) = params(22)*ys(18);
ys(48) = params(33)*ys(17);
ys(49) = params(34)*ys(18);
ys(99) = params(71)*ys(81);
ys(100) = params(72)*ys(82);
ys(99) = params(71)*ys(81);
ys(100) = params(72)*ys(82);
ys(112) = params(83)*ys(81);
ys(113) = params(84)*ys(82);
ys(163) = params(121)*ys(145);
ys(164) = params(122)*ys(146);
ys(163) = params(121)*ys(145);
ys(164) = params(122)*ys(146);
ys(176) = params(133)*ys(145);
ys(177) = params(134)*ys(146);
ys(227) = params(171)*ys(209);
ys(228) = params(172)*ys(210);
ys(227) = params(171)*ys(209);
ys(228) = params(172)*ys(210);
ys(240) = params(183)*ys(209);
ys(241) = params(184)*ys(210);
ys(291) = params(221)*ys(273);
ys(292) = params(222)*ys(274);
ys(291) = params(221)*ys(273);
ys(292) = params(222)*ys(274);
ys(304) = params(233)*ys(273);
ys(305) = params(234)*ys(274);
ys(355) = params(271)*ys(337);
ys(356) = params(272)*ys(338);
ys(355) = params(271)*ys(337);
ys(356) = params(272)*ys(338);
ys(368) = params(283)*ys(337);
ys(369) = params(284)*ys(338);
ys(419) = params(321)*ys(401);
ys(420) = params(322)*ys(402);
ys(419) = params(321)*ys(401);
ys(420) = params(322)*ys(402);
ys(432) = params(333)*ys(401);
ys(433) = params(334)*ys(402);
ys(483) = params(371)*ys(465);
ys(484) = params(372)*ys(466);
ys(483) = params(371)*ys(465);
ys(484) = params(372)*ys(466);
ys(496) = params(383)*ys(465);
ys(497) = params(384)*ys(466);
ys(547) = params(421)*ys(529);
ys(548) = params(422)*ys(530);
ys(547) = params(421)*ys(529);
ys(548) = params(422)*ys(530);
ys(560) = params(433)*ys(529);
ys(561) = params(434)*ys(530);
ys(611) = params(471)*ys(593);
ys(612) = params(472)*ys(594);
ys(611) = params(471)*ys(593);
ys(612) = params(472)*ys(594);
ys(624) = params(483)*ys(593);
ys(625) = params(484)*ys(594);
ys(704) = params(541)*ys(673);
ys(705) = params(542)*ys(674);
ys(691) = params(529)*ys(673);
ys(692) = params(530)*ys(674);
ys(704) = params(541)*ys(673);
ys(705) = params(542)*ys(674);
ys(768) = params(591)*ys(737);
ys(769) = params(592)*ys(738);
ys(755) = params(579)*ys(737);
ys(756) = params(580)*ys(738);
ys(768) = params(591)*ys(737);
ys(769) = params(592)*ys(738);
ys(832) = params(641)*ys(801);
ys(833) = params(642)*ys(802);
ys(819) = params(629)*ys(801);
ys(820) = params(630)*ys(802);
ys(832) = params(641)*ys(801);
ys(833) = params(642)*ys(802);
ys(896) = params(691)*ys(865);
ys(897) = params(692)*ys(866);
ys(883) = params(679)*ys(865);
ys(884) = params(680)*ys(866);
ys(896) = params(691)*ys(865);
ys(897) = params(692)*ys(866);
ys(960) = params(741)*ys(929);
ys(961) = params(742)*ys(930);
ys(947) = params(729)*ys(929);
ys(948) = params(730)*ys(930);
ys(960) = params(741)*ys(929);
ys(961) = params(742)*ys(930);
ys(1024) = params(791)*ys(993);
ys(1025) = params(792)*ys(994);
ys(1011) = params(779)*ys(993);
ys(1012) = params(780)*ys(994);
ys(1024) = params(791)*ys(993);
ys(1025) = params(792)*ys(994);
ys(1088) = params(841)*ys(1057);
ys(1089) = params(842)*ys(1058);
ys(1075) = params(829)*ys(1057);
ys(1076) = params(830)*ys(1058);
ys(1088) = params(841)*ys(1057);
ys(1089) = params(842)*ys(1058);
ys(1152) = params(891)*ys(1121);
ys(1153) = params(892)*ys(1122);
ys(1139) = params(879)*ys(1121);
ys(1140) = params(880)*ys(1122);
ys(1152) = params(891)*ys(1121);
ys(1153) = params(892)*ys(1122);
ys(1216) = params(941)*ys(1185);
ys(1217) = params(942)*ys(1186);
ys(1203) = params(929)*ys(1185);
ys(1204) = params(930)*ys(1186);
ys(1216) = params(941)*ys(1185);
ys(1217) = params(942)*ys(1186);
ys(1280) = params(991)*ys(1249);
ys(1281) = params(992)*ys(1250);
ys(1267) = params(979)*ys(1249);
ys(1268) = params(980)*ys(1250);
ys(1280) = params(991)*ys(1249);
ys(1281) = params(992)*ys(1250);
Aux_1_b_a_t = params(4)/params(512)*(ys(48)+ys(49)+ ys(51)+ ys(115)+ ys(179)+ ys(243)+ ys(307)+ ys(371)+ ys(435)+ ys(499)+ ys(563)+ ys(627));
Aux_2_b_a_t = params(4)/params(512)*(ys(112)+ys(113)+ ys(52)+ ys(116)+ ys(180)+ ys(244)+ ys(308)+ ys(372)+ ys(436)+ ys(500)+ ys(564)+ ys(628));
Aux_3_b_a_t = params(4)/params(512)*(ys(176)+ys(177)+ ys(53)+ ys(117)+ ys(181)+ ys(245)+ ys(309)+ ys(373)+ ys(437)+ ys(501)+ ys(565)+ ys(629));
Aux_4_b_a_t = params(4)/params(512)*(ys(240)+ys(241)+ ys(54)+ ys(118)+ ys(182)+ ys(246)+ ys(310)+ ys(374)+ ys(438)+ ys(502)+ ys(566)+ ys(630));
Aux_5_b_a_t = params(4)/params(512)*(ys(304)+ys(305)+ ys(55)+ ys(119)+ ys(183)+ ys(247)+ ys(311)+ ys(375)+ ys(439)+ ys(503)+ ys(567)+ ys(631));
Aux_6_b_a_t = params(4)/params(512)*(ys(368)+ys(369)+ ys(56)+ ys(120)+ ys(184)+ ys(248)+ ys(312)+ ys(376)+ ys(440)+ ys(504)+ ys(568)+ ys(632));
Aux_7_b_a_t = params(4)/params(512)*(ys(432)+ys(433)+ ys(57)+ ys(121)+ ys(185)+ ys(249)+ ys(313)+ ys(377)+ ys(441)+ ys(505)+ ys(569)+ ys(633));
Aux_8_b_a_t = params(4)/params(512)*(ys(496)+ys(497)+ ys(58)+ ys(122)+ ys(186)+ ys(250)+ ys(314)+ ys(378)+ ys(442)+ ys(506)+ ys(570)+ ys(634));
Aux_9_b_a_t = params(4)/params(512)*(ys(560)+ys(561)+ ys(59)+ ys(123)+ ys(187)+ ys(251)+ ys(315)+ ys(379)+ ys(443)+ ys(507)+ ys(571)+ ys(635));
Aux_10_b_a_t = params(4)/params(512)*(ys(624)+ys(625)+ ys(60)+ ys(124)+ ys(188)+ ys(252)+ ys(316)+ ys(380)+ ys(444)+ ys(508)+ ys(572)+ ys(636));
params(529) = Aux_1_b_a_t/(ys(673)+ys(674) + (+ ys(718)+ ys(782)+ ys(846)+ ys(910)+ ys(974)+ ys(1038)+ ys(1102)+ ys(1166)+ ys(1230)+ ys(1294)));
params(530) = params(529);
params(531) = params(529);
params(581) = params(529);
params(631) = params(529);
params(681) = params(529);
params(731) = params(529);
params(781) = params(529);
params(831) = params(529);
params(881) = params(529);
params(931) = params(529);
params(981) = params(529);
params(579) = Aux_2_b_a_t/(ys(737)+ys(738) + (+ ys(720)+ ys(784)+ ys(848)+ ys(912)+ ys(976)+ ys(1040)+ ys(1104)+ ys(1168)+ ys(1232)+ ys(1296)));
params(580) = params(579);
params(532) = params(579);
params(582) = params(579);
params(632) = params(579);
params(682) = params(579);
params(732) = params(579);
params(782) = params(579);
params(832) = params(579);
params(882) = params(579);
params(932) = params(579);
params(982) = params(579);
params(629) = Aux_3_b_a_t/(ys(801)+ys(802) + (+ ys(722)+ ys(786)+ ys(850)+ ys(914)+ ys(978)+ ys(1042)+ ys(1106)+ ys(1170)+ ys(1234)+ ys(1298)));
params(630) = params(629);
params(533) = params(629);
params(583) = params(629);
params(633) = params(629);
params(683) = params(629);
params(733) = params(629);
params(783) = params(629);
params(833) = params(629);
params(883) = params(629);
params(933) = params(629);
params(983) = params(629);
params(679) = Aux_4_b_a_t/(ys(865)+ys(866) + (+ ys(724)+ ys(788)+ ys(852)+ ys(916)+ ys(980)+ ys(1044)+ ys(1108)+ ys(1172)+ ys(1236)+ ys(1300)));
params(680) = params(679);
params(534) = params(679);
params(584) = params(679);
params(634) = params(679);
params(684) = params(679);
params(734) = params(679);
params(784) = params(679);
params(834) = params(679);
params(884) = params(679);
params(934) = params(679);
params(984) = params(679);
params(729) = Aux_5_b_a_t/(ys(929)+ys(930) + (+ ys(726)+ ys(790)+ ys(854)+ ys(918)+ ys(982)+ ys(1046)+ ys(1110)+ ys(1174)+ ys(1238)+ ys(1302)));
params(730) = params(729);
params(535) = params(729);
params(585) = params(729);
params(635) = params(729);
params(685) = params(729);
params(735) = params(729);
params(785) = params(729);
params(835) = params(729);
params(885) = params(729);
params(935) = params(729);
params(985) = params(729);
params(779) = Aux_6_b_a_t/(ys(993)+ys(994) + (+ ys(728)+ ys(792)+ ys(856)+ ys(920)+ ys(984)+ ys(1048)+ ys(1112)+ ys(1176)+ ys(1240)+ ys(1304)));
params(780) = params(779);
params(536) = params(779);
params(586) = params(779);
params(636) = params(779);
params(686) = params(779);
params(736) = params(779);
params(786) = params(779);
params(836) = params(779);
params(886) = params(779);
params(936) = params(779);
params(986) = params(779);
params(829) = Aux_7_b_a_t/(ys(1057)+ys(1058) + (+ ys(730)+ ys(794)+ ys(858)+ ys(922)+ ys(986)+ ys(1050)+ ys(1114)+ ys(1178)+ ys(1242)+ ys(1306)));
params(830) = params(829);
params(537) = params(829);
params(587) = params(829);
params(637) = params(829);
params(687) = params(829);
params(737) = params(829);
params(787) = params(829);
params(837) = params(829);
params(887) = params(829);
params(937) = params(829);
params(987) = params(829);
params(879) = Aux_8_b_a_t/(ys(1121)+ys(1122) + (+ ys(732)+ ys(796)+ ys(860)+ ys(924)+ ys(988)+ ys(1052)+ ys(1116)+ ys(1180)+ ys(1244)+ ys(1308)));
params(880) = params(879);
params(538) = params(879);
params(588) = params(879);
params(638) = params(879);
params(688) = params(879);
params(738) = params(879);
params(788) = params(879);
params(838) = params(879);
params(888) = params(879);
params(938) = params(879);
params(988) = params(879);
params(929) = Aux_9_b_a_t/(ys(1185)+ys(1186) + (+ ys(734)+ ys(798)+ ys(862)+ ys(926)+ ys(990)+ ys(1054)+ ys(1118)+ ys(1182)+ ys(1246)+ ys(1310)));
params(930) = params(929);
params(539) = params(929);
params(589) = params(929);
params(639) = params(929);
params(689) = params(929);
params(739) = params(929);
params(789) = params(929);
params(839) = params(929);
params(889) = params(929);
params(939) = params(929);
params(989) = params(929);
params(979) = Aux_10_b_a_t/(ys(1249)+ys(1250) + (+ ys(736)+ ys(800)+ ys(864)+ ys(928)+ ys(992)+ ys(1056)+ ys(1120)+ ys(1184)+ ys(1248)+ ys(1312)));
params(980) = params(979);
params(540) = params(979);
params(590) = params(979);
params(640) = params(979);
params(690) = params(979);
params(740) = params(979);
params(790) = params(979);
params(840) = params(979);
params(890) = params(979);
params(940) = params(979);
params(990) = params(979);
params(541) = 1-params(529);
params(542) = params(541);
params(543) = params(541);
params(593) = params(541);
params(643) = params(541);
params(693) = params(541);
params(743) = params(541);
params(793) = params(541);
params(843) = params(541);
params(893) = params(541);
params(943) = params(541);
params(993) = params(541);
params(591) = 1-params(579);
params(592) = params(591);
params(544) = params(591);
params(594) = params(591);
params(644) = params(591);
params(694) = params(591);
params(744) = params(591);
params(794) = params(591);
params(844) = params(591);
params(894) = params(591);
params(944) = params(591);
params(994) = params(591);
params(641) = 1-params(629);
params(642) = params(641);
params(545) = params(641);
params(595) = params(641);
params(645) = params(641);
params(695) = params(641);
params(745) = params(641);
params(795) = params(641);
params(845) = params(641);
params(895) = params(641);
params(945) = params(641);
params(995) = params(641);
params(691) = 1-params(679);
params(692) = params(691);
params(546) = params(691);
params(596) = params(691);
params(646) = params(691);
params(696) = params(691);
params(746) = params(691);
params(796) = params(691);
params(846) = params(691);
params(896) = params(691);
params(946) = params(691);
params(996) = params(691);
params(741) = 1-params(729);
params(742) = params(741);
params(547) = params(741);
params(597) = params(741);
params(647) = params(741);
params(697) = params(741);
params(747) = params(741);
params(797) = params(741);
params(847) = params(741);
params(897) = params(741);
params(947) = params(741);
params(997) = params(741);
params(791) = 1-params(779);
params(792) = params(791);
params(548) = params(791);
params(598) = params(791);
params(648) = params(791);
params(698) = params(791);
params(748) = params(791);
params(798) = params(791);
params(848) = params(791);
params(898) = params(791);
params(948) = params(791);
params(998) = params(791);
params(841) = 1-params(829);
params(842) = params(841);
params(549) = params(841);
params(599) = params(841);
params(649) = params(841);
params(699) = params(841);
params(749) = params(841);
params(799) = params(841);
params(849) = params(841);
params(899) = params(841);
params(949) = params(841);
params(999) = params(841);
params(891) = 1-params(879);
params(892) = params(891);
params(550) = params(891);
params(600) = params(891);
params(650) = params(891);
params(700) = params(891);
params(750) = params(891);
params(800) = params(891);
params(850) = params(891);
params(900) = params(891);
params(950) = params(891);
params(1000) = params(891);
params(941) = 1-params(929);
params(942) = params(941);
params(551) = params(941);
params(601) = params(941);
params(651) = params(941);
params(701) = params(941);
params(751) = params(941);
params(801) = params(941);
params(851) = params(941);
params(901) = params(941);
params(951) = params(941);
params(1001) = params(941);
params(991) = 1-params(979);
params(992) = params(991);
params(552) = params(991);
params(602) = params(991);
params(652) = params(991);
params(702) = params(991);
params(752) = params(991);
params(802) = params(991);
params(852) = params(991);
params(902) = params(991);
params(952) = params(991);
params(1002) = params(991);
ys(704) = params(541)*ys(673);
ys(705) = params(542)*ys(674);
ys(707) = params(543)*ys(718);
ys(771) = params(593)*ys(782);
ys(835) = params(643)*ys(846);
ys(899) = params(693)*ys(910);
ys(963) = params(743)*ys(974);
ys(1027) = params(793)*ys(1038);
ys(1091) = params(843)*ys(1102);
ys(1155) = params(893)*ys(1166);
ys(1219) = params(943)*ys(1230);
ys(1283) = params(993)*ys(1294);
ys(691) = params(529)*ys(673);
ys(692) = params(530)*ys(674);
ys(694) = params(531)*ys(718);
ys(758) = params(581)*ys(782);
ys(822) = params(631)*ys(846);
ys(886) = params(681)*ys(910);
ys(950) = params(731)*ys(974);
ys(1014) = params(781)*ys(1038);
ys(1078) = params(831)*ys(1102);
ys(1142) = params(881)*ys(1166);
ys(1206) = params(931)*ys(1230);
ys(1270) = params(981)*ys(1294);
ys(768) = params(591)*ys(737);
ys(769) = params(592)*ys(738);
ys(708) = params(544)*ys(720);
ys(772) = params(594)*ys(784);
ys(836) = params(644)*ys(848);
ys(900) = params(694)*ys(912);
ys(964) = params(744)*ys(976);
ys(1028) = params(794)*ys(1040);
ys(1092) = params(844)*ys(1104);
ys(1156) = params(894)*ys(1168);
ys(1220) = params(944)*ys(1232);
ys(1284) = params(994)*ys(1296);
ys(755) = params(579)*ys(737);
ys(756) = params(580)*ys(738);
ys(695) = params(532)*ys(720);
ys(759) = params(582)*ys(784);
ys(823) = params(632)*ys(848);
ys(887) = params(682)*ys(912);
ys(951) = params(732)*ys(976);
ys(1015) = params(782)*ys(1040);
ys(1079) = params(832)*ys(1104);
ys(1143) = params(882)*ys(1168);
ys(1207) = params(932)*ys(1232);
ys(1271) = params(982)*ys(1296);
ys(832) = params(641)*ys(801);
ys(833) = params(642)*ys(802);
ys(709) = params(545)*ys(722);
ys(773) = params(595)*ys(786);
ys(837) = params(645)*ys(850);
ys(901) = params(695)*ys(914);
ys(965) = params(745)*ys(978);
ys(1029) = params(795)*ys(1042);
ys(1093) = params(845)*ys(1106);
ys(1157) = params(895)*ys(1170);
ys(1221) = params(945)*ys(1234);
ys(1285) = params(995)*ys(1298);
ys(819) = params(629)*ys(801);
ys(820) = params(630)*ys(802);
ys(696) = params(533)*ys(722);
ys(760) = params(583)*ys(786);
ys(824) = params(633)*ys(850);
ys(888) = params(683)*ys(914);
ys(952) = params(733)*ys(978);
ys(1016) = params(783)*ys(1042);
ys(1080) = params(833)*ys(1106);
ys(1144) = params(883)*ys(1170);
ys(1208) = params(933)*ys(1234);
ys(1272) = params(983)*ys(1298);
ys(896) = params(691)*ys(865);
ys(897) = params(692)*ys(866);
ys(710) = params(546)*ys(724);
ys(774) = params(596)*ys(788);
ys(838) = params(646)*ys(852);
ys(902) = params(696)*ys(916);
ys(966) = params(746)*ys(980);
ys(1030) = params(796)*ys(1044);
ys(1094) = params(846)*ys(1108);
ys(1158) = params(896)*ys(1172);
ys(1222) = params(946)*ys(1236);
ys(1286) = params(996)*ys(1300);
ys(883) = params(679)*ys(865);
ys(884) = params(680)*ys(866);
ys(697) = params(534)*ys(724);
ys(761) = params(584)*ys(788);
ys(825) = params(634)*ys(852);
ys(889) = params(684)*ys(916);
ys(953) = params(734)*ys(980);
ys(1017) = params(784)*ys(1044);
ys(1081) = params(834)*ys(1108);
ys(1145) = params(884)*ys(1172);
ys(1209) = params(934)*ys(1236);
ys(1273) = params(984)*ys(1300);
ys(960) = params(741)*ys(929);
ys(961) = params(742)*ys(930);
ys(711) = params(547)*ys(726);
ys(775) = params(597)*ys(790);
ys(839) = params(647)*ys(854);
ys(903) = params(697)*ys(918);
ys(967) = params(747)*ys(982);
ys(1031) = params(797)*ys(1046);
ys(1095) = params(847)*ys(1110);
ys(1159) = params(897)*ys(1174);
ys(1223) = params(947)*ys(1238);
ys(1287) = params(997)*ys(1302);
ys(947) = params(729)*ys(929);
ys(948) = params(730)*ys(930);
ys(698) = params(535)*ys(726);
ys(762) = params(585)*ys(790);
ys(826) = params(635)*ys(854);
ys(890) = params(685)*ys(918);
ys(954) = params(735)*ys(982);
ys(1018) = params(785)*ys(1046);
ys(1082) = params(835)*ys(1110);
ys(1146) = params(885)*ys(1174);
ys(1210) = params(935)*ys(1238);
ys(1274) = params(985)*ys(1302);
ys(1024) = params(791)*ys(993);
ys(1025) = params(792)*ys(994);
ys(712) = params(548)*ys(728);
ys(776) = params(598)*ys(792);
ys(840) = params(648)*ys(856);
ys(904) = params(698)*ys(920);
ys(968) = params(748)*ys(984);
ys(1032) = params(798)*ys(1048);
ys(1096) = params(848)*ys(1112);
ys(1160) = params(898)*ys(1176);
ys(1224) = params(948)*ys(1240);
ys(1288) = params(998)*ys(1304);
ys(1011) = params(779)*ys(993);
ys(1012) = params(780)*ys(994);
ys(699) = params(536)*ys(728);
ys(763) = params(586)*ys(792);
ys(827) = params(636)*ys(856);
ys(891) = params(686)*ys(920);
ys(955) = params(736)*ys(984);
ys(1019) = params(786)*ys(1048);
ys(1083) = params(836)*ys(1112);
ys(1147) = params(886)*ys(1176);
ys(1211) = params(936)*ys(1240);
ys(1275) = params(986)*ys(1304);
ys(1088) = params(841)*ys(1057);
ys(1089) = params(842)*ys(1058);
ys(713) = params(549)*ys(730);
ys(777) = params(599)*ys(794);
ys(841) = params(649)*ys(858);
ys(905) = params(699)*ys(922);
ys(969) = params(749)*ys(986);
ys(1033) = params(799)*ys(1050);
ys(1097) = params(849)*ys(1114);
ys(1161) = params(899)*ys(1178);
ys(1225) = params(949)*ys(1242);
ys(1289) = params(999)*ys(1306);
ys(1075) = params(829)*ys(1057);
ys(1076) = params(830)*ys(1058);
ys(700) = params(537)*ys(730);
ys(764) = params(587)*ys(794);
ys(828) = params(637)*ys(858);
ys(892) = params(687)*ys(922);
ys(956) = params(737)*ys(986);
ys(1020) = params(787)*ys(1050);
ys(1084) = params(837)*ys(1114);
ys(1148) = params(887)*ys(1178);
ys(1212) = params(937)*ys(1242);
ys(1276) = params(987)*ys(1306);
ys(1152) = params(891)*ys(1121);
ys(1153) = params(892)*ys(1122);
ys(714) = params(550)*ys(732);
ys(778) = params(600)*ys(796);
ys(842) = params(650)*ys(860);
ys(906) = params(700)*ys(924);
ys(970) = params(750)*ys(988);
ys(1034) = params(800)*ys(1052);
ys(1098) = params(850)*ys(1116);
ys(1162) = params(900)*ys(1180);
ys(1226) = params(950)*ys(1244);
ys(1290) = params(1000)*ys(1308);
ys(1139) = params(879)*ys(1121);
ys(1140) = params(880)*ys(1122);
ys(701) = params(538)*ys(732);
ys(765) = params(588)*ys(796);
ys(829) = params(638)*ys(860);
ys(893) = params(688)*ys(924);
ys(957) = params(738)*ys(988);
ys(1021) = params(788)*ys(1052);
ys(1085) = params(838)*ys(1116);
ys(1149) = params(888)*ys(1180);
ys(1213) = params(938)*ys(1244);
ys(1277) = params(988)*ys(1308);
ys(1216) = params(941)*ys(1185);
ys(1217) = params(942)*ys(1186);
ys(715) = params(551)*ys(734);
ys(779) = params(601)*ys(798);
ys(843) = params(651)*ys(862);
ys(907) = params(701)*ys(926);
ys(971) = params(751)*ys(990);
ys(1035) = params(801)*ys(1054);
ys(1099) = params(851)*ys(1118);
ys(1163) = params(901)*ys(1182);
ys(1227) = params(951)*ys(1246);
ys(1291) = params(1001)*ys(1310);
ys(1203) = params(929)*ys(1185);
ys(1204) = params(930)*ys(1186);
ys(702) = params(539)*ys(734);
ys(766) = params(589)*ys(798);
ys(830) = params(639)*ys(862);
ys(894) = params(689)*ys(926);
ys(958) = params(739)*ys(990);
ys(1022) = params(789)*ys(1054);
ys(1086) = params(839)*ys(1118);
ys(1150) = params(889)*ys(1182);
ys(1214) = params(939)*ys(1246);
ys(1278) = params(989)*ys(1310);
ys(1280) = params(991)*ys(1249);
ys(1281) = params(992)*ys(1250);
ys(716) = params(552)*ys(736);
ys(780) = params(602)*ys(800);
ys(844) = params(652)*ys(864);
ys(908) = params(702)*ys(928);
ys(972) = params(752)*ys(992);
ys(1036) = params(802)*ys(1056);
ys(1100) = params(852)*ys(1120);
ys(1164) = params(902)*ys(1184);
ys(1228) = params(952)*ys(1248);
ys(1292) = params(1002)*ys(1312);
ys(1267) = params(979)*ys(1249);
ys(1268) = params(980)*ys(1250);
ys(703) = params(540)*ys(736);
ys(767) = params(590)*ys(800);
ys(831) = params(640)*ys(864);
ys(895) = params(690)*ys(928);
ys(959) = params(740)*ys(992);
ys(1023) = params(790)*ys(1056);
ys(1087) = params(840)*ys(1120);
ys(1151) = params(890)*ys(1184);
ys(1215) = params(940)*ys(1248);
ys(1279) = params(990)*ys(1312);
ys(1313) = (ys(48)+ys(49)+ ys(51)+ ys(115)+ ys(179)+ ys(243)+ ys(307)+ ys(371)+ ys(435)+ ys(499)+ ys(563)+ ys(627))*params(528);
ys(1315) = (ys(112)+ys(113)+ ys(52)+ ys(116)+ ys(180)+ ys(244)+ ys(308)+ ys(372)+ ys(436)+ ys(500)+ ys(564)+ ys(628))*params(578);
ys(1317) = (ys(176)+ys(177)+ ys(53)+ ys(117)+ ys(181)+ ys(245)+ ys(309)+ ys(373)+ ys(437)+ ys(501)+ ys(565)+ ys(629))*params(628);
ys(1319) = (ys(240)+ys(241)+ ys(54)+ ys(118)+ ys(182)+ ys(246)+ ys(310)+ ys(374)+ ys(438)+ ys(502)+ ys(566)+ ys(630))*params(678);
ys(1321) = (ys(304)+ys(305)+ ys(55)+ ys(119)+ ys(183)+ ys(247)+ ys(311)+ ys(375)+ ys(439)+ ys(503)+ ys(567)+ ys(631))*params(728);
ys(1323) = (ys(368)+ys(369)+ ys(56)+ ys(120)+ ys(184)+ ys(248)+ ys(312)+ ys(376)+ ys(440)+ ys(504)+ ys(568)+ ys(632))*params(778);
ys(1325) = (ys(432)+ys(433)+ ys(57)+ ys(121)+ ys(185)+ ys(249)+ ys(313)+ ys(377)+ ys(441)+ ys(505)+ ys(569)+ ys(633))*params(828);
ys(1327) = (ys(496)+ys(497)+ ys(58)+ ys(122)+ ys(186)+ ys(250)+ ys(314)+ ys(378)+ ys(442)+ ys(506)+ ys(570)+ ys(634))*params(878);
ys(1329) = (ys(560)+ys(561)+ ys(59)+ ys(123)+ ys(187)+ ys(251)+ ys(315)+ ys(379)+ ys(443)+ ys(507)+ ys(571)+ ys(635))*params(928);
ys(1331) = (ys(624)+ys(625)+ ys(60)+ ys(124)+ ys(188)+ ys(252)+ ys(316)+ ys(380)+ ys(444)+ ys(508)+ ys(572)+ ys(636))*params(978);
ys(1314) = params(20) * params(512)/params(4)*(ys(691)+ys(692)+ ys(694)+ ys(758)+ ys(822)+ ys(886)+ ys(950)+ ys(1014)+ ys(1078)+ ys(1142)+ ys(1206)+ ys(1270));
ys(1316) = params(70) * params(512)/params(4)*(ys(755)+ys(756)+ ys(695)+ ys(759)+ ys(823)+ ys(887)+ ys(951)+ ys(1015)+ ys(1079)+ ys(1143)+ ys(1207)+ ys(1271));
ys(1318) = params(120) * params(512)/params(4)*(ys(819)+ys(820)+ ys(696)+ ys(760)+ ys(824)+ ys(888)+ ys(952)+ ys(1016)+ ys(1080)+ ys(1144)+ ys(1208)+ ys(1272));
ys(1320) = params(170) * params(512)/params(4)*(ys(883)+ys(884)+ ys(697)+ ys(761)+ ys(825)+ ys(889)+ ys(953)+ ys(1017)+ ys(1081)+ ys(1145)+ ys(1209)+ ys(1273));
ys(1322) = params(220) * params(512)/params(4)*(ys(947)+ys(948)+ ys(698)+ ys(762)+ ys(826)+ ys(890)+ ys(954)+ ys(1018)+ ys(1082)+ ys(1146)+ ys(1210)+ ys(1274));
ys(1324) = params(270) * params(512)/params(4)*(ys(1011)+ys(1012)+ ys(699)+ ys(763)+ ys(827)+ ys(891)+ ys(955)+ ys(1019)+ ys(1083)+ ys(1147)+ ys(1211)+ ys(1275));
ys(1326) = params(320) * params(512)/params(4)*(ys(1075)+ys(1076)+ ys(700)+ ys(764)+ ys(828)+ ys(892)+ ys(956)+ ys(1020)+ ys(1084)+ ys(1148)+ ys(1212)+ ys(1276));
ys(1328) = params(370) * params(512)/params(4)*(ys(1139)+ys(1140)+ ys(701)+ ys(765)+ ys(829)+ ys(893)+ ys(957)+ ys(1021)+ ys(1085)+ ys(1149)+ ys(1213)+ ys(1277));
ys(1330) = params(420) * params(512)/params(4)*(ys(1203)+ys(1204)+ ys(702)+ ys(766)+ ys(830)+ ys(894)+ ys(958)+ ys(1022)+ ys(1086)+ ys(1150)+ ys(1214)+ ys(1278));
ys(1332) = params(470) * params(512)/params(4)*(ys(1267)+ys(1268)+ ys(703)+ ys(767)+ ys(831)+ ys(895)+ ys(959)+ ys(1023)+ ys(1087)+ ys(1151)+ ys(1215)+ ys(1279));
