@#define country = ["a", "b"]
@#define country2 = ["a"]
@#define countryLast= ["b"]
@#define sector = 10

/*
  Targets and parameters
*/

betta = 0.992^4;                                                             // Discount factor
sig = 2;                                                                     // Intertemporal elasticity of substitution
delta = 0.025*4;                                                             // Depr. rate
Psi2 = 0.5;
Y_VA_a_t = 1;                                                                // Aggregate value added per capita of region A is normalized to 1
Y_VA_b_t = 0.5725;                                                           // Aggregate value added percapita of region B relative to region A
size_a = 0.156;                                                              // "size" governs the population, world population is normalized to unity!
size_b = 1-size_a;
rer_ba_t = 1;                                                                //Real exchange rate between countries a and b
R_w_t = 1/betta;

@#for co in country
  R_@{co}_t = R_w_t;
  rho_eps_@{co} = 0.8^4;                                                     // Persistence TFP shock
  epsi_@{co}_t = exp(shock_epsi_@{co}_t/(1-rho_eps_@{co}));                  // Aggregate TFP shock
  epsi_carb_int_@{co}_ts = 1;                                                // Emissions intensity shock process
  rho_eps_carb_int_@{co} = 0.8^4;                                            // Persistence emission intensity shock
  lab_@{co} = 2;                                                             // Inverse Frisch elasticity of labor supply
  N_@{co}_t = 0.333;                                                         // Steady state hours -> 1/3 of time endowmwnt
  PI_@{co}_t = 1;                                                            // Relative price of investment basket (normalized to 1)
  rk_@{co}_t = PI_@{co}_t/betta-(1-delta)*PI_@{co}_t;                        // Real rental rate of capital
  rho_EM = 1-0.9979^4;                                                       // Rate of decay wrt atmosph. carbon concentration
  P_EM_@{co}_t = shock_P_EM_@{co}_t;                                         // Initial carbon price level
@#endfor

@#for co in country
  cid = ismember(DSGE_country, {'@{co}'});                                   // In order to match DSGE_country names with ISO country names in calibration
    @#for se in (1:sector)
      sid = DSGE_sector==@{se};                                              // In order to match DSGE_sectors with NACE sector names in calibration
      // Constant emission per unit of output (2005 values):
      carb_int_@{se}_@{co} = Calibration.Emissions.Const_frac.(ISO{cid}){NACE(sid),6};
      gama1_@{se}_@{co} = 0;                                                 // Damage function parameter (proportional)
      gama2_@{se}_@{co} = 0;                                                 // Damage function parameter (quadratic)
      Pen_@{se}_@{co}_t = 0;                                                 // Relative sectoral output loss
    @#endfor
@#endfor

@#for co in country
  /*
    Production parameters and elasticities of substitution
  */
  cid = ismember(DSGE_country, {'@{co}'});
  sigc_@{co} = 1-1/0.9091;                                                   // Determines elasticity of substitution between sector-level consumption goods
  sigi_@{co}  = 1-1/0.7511;                                                  // Determines elasticity of substitution between sector-level investment goods
  upsi_K_@{co} = 2;                                                          // Determines the elasticity of substitution of capital across sectors, taken from Bouakez et al. (2023) )
  upsi_N_@{co} = 2;                                                          // Determines the elasticity of substitution of labor across sectors, taken from Bouakez et al. (2023))
  @#for se in (1:sector)
    sid = DSGE_sector==@{se};
    alphaN_@{se}_@{co} = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_N(6,:);                // Elasticity of output wrt labor (calibrated to WIOD 2005 data)
    alphaH_@{se}_@{co} = Calibration.SEA.(ISO{cid}).(NACE(sid)).alpha_H(6,:);                // Elasticity of output wrt intermediate-goods (calibrated to WIOD 2005 data)
    omega_N_tild_@{se}_@{co} = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_N(6,:);          // Weight attached to labor provided to sector se
    omega_K_tild_@{se}_@{co} = Calibration.SEA.(ISO{cid}).(NACE(sid)).omega_K(6,:);          // Weight attached to capital provided to sector se
    Psi_con_@{se}_@{co} = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_C'};  // Sectoral shares in the consumption good bundle
    Psi_inv_@{se}_@{co} = Calibration.WIOD.y05.(ISO{cid}).NA.Psi_C_I_G{NACE(sid), 'Psi_I'};  // Sectoral shares in the investment good bundle
  @#endfor
  @#for se in (1:sector)
    EM_cost_@{se}_@{co}_t = (1 + shock_epsi_carb_int_@{co}_t)*P_EM_@{co}_t*carb_int_@{se}_@{co};
    mc_tild_@{se}_@{co}_t = 1;
    mc_@{se}_@{co}_t = mc_tild_@{se}_@{co}_t - EM_cost_@{se}_@{co}_t;
    @#for co2 in country
      P_@{se}_@{co}_@{co2}_t = 1;
    @#endfor
    PC_@{se}_@{co}_t = 1;
    PI_@{se}_@{co}_t = 1;
    PH_@{se}_@{co}_t = 1;
    @#for se2 in (1:sector)
      PHH_@{se}_@{se2}_@{co}_t = 1;
    @#endfor
  @#endfor
  /*
    Inter-sector trade shares
  */
  @#for se in (1:sector)
    sid = DSGE_sector==@{se};
    @#for se2 in (1:sector)
      sid2 = DSGE_sector==@{se2};
      Psi_@{se}_@{se2}_@{co} = Calibration.WIOD.y05.(ISO{cid}).IO.Psi_H{NACE(sid2), NACE(sid)}; // Weighting parameter for intermediate goods -> share of se2 used in H_se
    @#endfor
  @#endfor
  // Substitution elasticities
  sigh_1_@{co} = 1-1/0.1;
  sigh_2_@{co} = 1-1/0.1;
  sigh_3_@{co} = 1-1/0.1;
  sigh_4_@{co} = 1-1/0.1;
  sigh_5_@{co} = 1-1/0.1;
  sigh_6_@{co} = 1-1/0.1;
  sigh_7_@{co} = 1-1/0.1;
  sigh_8_@{co} = 1-1/0.1;
  sigh_9_@{co} = 1-1/0.1;
  sigh_10_@{co}= 1-1/0.1;
@#endfor

/*
 Solving for the steady state values
*/

getp;

kk = getk(params, ys, DSGE_sector, DSGE_country);

K_a_t = kk(1);
K_b_t = kk(2);

@#define l = 1

@#for c in country
  @#for i in (1:sector)
    @#for j in (1:sector)
      @#define idx = 2 + (l-1)*sector*sector + (i-1)*sector + j
      H_@{i}_@{j}_@{c}_t = kk(@{idx});
    @#endfor
  @#endfor
  @#define l = l + 1
@#endfor

@#for co in country
  I_@{co}_t = delta*K_@{co}_t;
  C_@{co}_t = Y_VA_@{co}_t - I_@{co}_t;
  @#for se in (1:sector)
    C_@{se}_@{co}_t = Psi_con_@{se}_@{co}*C_@{co}_t;
    I_@{se}_@{co}_t = Psi_inv_@{se}_@{co}*I_@{co}_t;
    Y_@{se}_@{co}_t = (C_@{se}_@{co}_t+I_@{se}_@{co}_t + (
    @#for se2 in (1:sector)
      + H_@{se2}_@{se}_@{co}_t
    @#endfor
    ));
    ZZ_@{se}_@{co}_t = (1 + shock_epsi_carb_int_@{co}_t)*carb_int_@{se}_@{co}*Y_@{se}_@{co}_t;
  @#endfor
  ZZ_@{co}_t = (
  @#for se in (1:sector)
    + ZZ_@{se}_@{co}_t
  @#endfor
  );
  Y_@{co}_t = (
  @#for se in (1:sector)
    + Y_@{se}_@{co}_t
  @#endfor
  );
@#endfor

EM_t = (
@#for co in country
  @#for se in (1:sector)
    + ZZ_@{se}_@{co}_t*size_@{co}
  @#endfor
@#endfor
)/rho_EM;

@#for co in country
  @#for se in (1:sector)
    gama0_@{se}_@{co} =  Pen_@{se}_@{co}_t - gama1_@{se}_@{co}*EM_t - gama2_@{se}_@{co}*EM_t^2;
    K_@{se}_@{co}_t = omega_K_tild_@{se}_@{co}*K_@{co}_t;
    rk_@{se}_@{co}_t = alphaH_@{se}_@{co}*(1-alphaN_@{se}_@{co})*mc_@{se}_@{co}_t*Y_@{se}_@{co}_t/K_@{se}_@{co}_t;
    omega_K_@{se}_@{co} = omega_K_tild_@{se}_@{co} *(rk_@{se}_@{co}_t/rk_@{co}_t)^(1/(1-upsi_K_@{co}));
    H_@{se}_@{co}_t = (1-alphaH_@{se}_@{co})*mc_@{se}_@{co}_t*Y_@{se}_@{co}_t/PH_@{se}_@{co}_t;
    @#for se2 in (1:sector)
      H_@{se}_@{se2}_@{co}_t = Psi_@{se}_@{se2}_@{co}*(PH_@{se}_@{co}_t/P_@{se2}_@{co}_@{co}_t)^(1/(1-sigh_@{se}_@{co}))*H_@{se}_@{co}_t;
    @#endfor
  @#endfor
  w_@{co}_t = (
  @#for se in (1:sector)
    + alphaH_@{se}_@{co}*alphaN_@{se}_@{co}*mc_@{se}_@{co}_t*Y_@{se}_@{co}_t/N_@{co}_t
  @#endfor
  );
  @#for se in (1:sector)
    N_@{se}_@{co}_t = omega_N_tild_@{se}_@{co}*N_@{co}_t;
    w_@{se}_@{co}_t = alphaH_@{se}_@{co}*alphaN_@{se}_@{co}*mc_@{se}_@{co}_t*Y_@{se}_@{co}_t/N_@{se}_@{co}_t;
    omega_N_@{se}_@{co} = omega_N_tild_@{se}_@{co} *(w_@{se}_@{co}_t/w_@{co}_t)^(1/(1-upsi_N_@{co}));
    epsi_@{se}_@{co}_t = Y_@{se}_@{co}_t/( epsi_@{co}_t*(1-Pen_@{se}_@{co}_t)* (N_@{se}_@{co}_t^alphaN_@{se}_@{co}*K_@{se}_@{co}_t^(1-alphaN_@{se}_@{co}))^alphaH_@{se}_@{co}*H_@{se}_@{co}_t^(1-alphaH_@{se}_@{co}));
  @#endfor
  lambda_@{co}_t = C_@{co}_t^(-sig);
  kappaN_@{co} = lambda_@{co}_t*w_@{co}_t/(N_@{co}_t^lab_@{co});
@#endfor

/*
  Multi-country part
*/

@#for co in country
  @#for se in (1:sector)
    TB_@{se}_@{co}_t = 0;
    PC_@{se}_@{co}_t = 1;
    PI_@{se}_@{co}_t = 1;
    PHH_@{se}_@{co}_t = 1;
    sigc_@{se}_@{co} = 1-1/0.9;
    sigi_@{se}_@{co} = 1-1/0.9;
    sighh_@{se}_@{co} = 1-1/0.9;
  @#endfor
@#endfor

@#for co in country
  TB_@{co}_t = (
  @#for se in (1:sector)
    + TB_@{se}_@{co}_t
  @#endfor
  );
  NFA_@{co}_t = TB_@{co}_t;
@#endfor

@#for co in country
  cid = ismember(DSGE_country, {'@{co}'});
  @#for se in (1:sector)
    sid = DSGE_sector==@{se};
    @#for se2 in (1:sector)
      sid2 = DSGE_sector==@{se2};
      hb_hhh_@{se}_@{se2}_@{co}_@{co} = Calibration.WIOD.y05.(ISO{cid}).IO.Biases_hhh.(ISO{cid}){NACE(sid2), NACE(sid)};
      H_@{se}_@{se2}_@{co}_@{co}_t = hb_hhh_@{se}_@{se2}_@{co}_@{co}*H_@{se}_@{se2}_@{co}_t;
    @#endfor
  @#endfor
@#endfor

@#for se in (1:sector)
    @#for se2 in (1:sector)
      hb_hhh_@{se}_@{se2}_a_b = 1-hb_hhh_@{se}_@{se2}_a_a;
      hb_hhh_@{se}_@{se2}_b_a = 1-hb_hhh_@{se}_@{se2}_b_b;
      H_@{se}_@{se2}_a_b_t = hb_hhh_@{se}_@{se2}_a_b*H_@{se}_@{se2}_a_t;
      H_@{se}_@{se2}_b_a_t = hb_hhh_@{se}_@{se2}_b_a*H_@{se}_@{se2}_b_t;
    @#endfor
@#endfor

@#for co in country
  cid = ismember(DSGE_country, {'@{co}'});
  @#for se in (1:sector)
    sid = DSGE_sector==@{se};
    hb_con_@{se}_@{co}_@{co} = Calibration.WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_C'};
    hb_inv_@{se}_@{co}_@{co} = Calibration.  WIOD.y05.(ISO{cid}).NA.Biases_C_I.(ISO{cid}){NACE(sid), 'HB_I'};
  @#endfor
@#endfor

@#for se in (1:sector)
  hb_con_@{se}_a_b = 1-hb_con_@{se}_a_a;
  hb_inv_@{se}_a_b = 1-hb_inv_@{se}_a_a;
@#endfor

@#for co in country
  @#for se in (1:sector)
    C_@{se}_@{co}_@{co}_t = hb_con_@{se}_@{co}_@{co}*C_@{se}_@{co}_t;
    I_@{se}_@{co}_@{co}_t = hb_inv_@{se}_@{co}_@{co}*I_@{se}_@{co}_t;
    @#for co2 in country
      C_@{se}_@{co}_@{co2}_t = hb_con_@{se}_@{co}_@{co2}*C_@{se}_@{co}_t;
      I_@{se}_@{co}_@{co2}_t = hb_inv_@{se}_@{co}_@{co2}*I_@{se}_@{co}_t;
    @#endfor
  @#endfor
@#endfor

@#for se in (1:sector)
  Aux_@{se}_b_a_t = size_a/size_b*(C_@{se}_a_b_t+I_@{se}_a_b_t
  @#for se2 in (1:sector)
    + H_@{se2}_@{se}_a_b_t
  @#endfor
  );
@#endfor

@#for co in countryLast
  @#for se in (1:sector)
    @#for co2 in country2
      hb_con_@{se}_@{co}_@{co2} = Aux_@{se}_@{co}_@{co2}_t/(C_@{se}_@{co}_t+I_@{se}_@{co}_t + (
      @#for se2 in (1:sector)
        + H_@{se2}_@{se}_@{co}_t
      @#endfor
      ));
      hb_inv_@{se}_@{co}_@{co2} = hb_con_@{se}_@{co}_@{co2};
      @#for se2 in (1:sector)
        hb_hhh_@{se2}_@{se}_@{co}_@{co2} = hb_con_@{se}_@{co}_@{co2};
      @#endfor
    @#endfor
  @#endfor
@#endfor

@#for se in (1:sector)
  hb_con_@{se}_b_b = 1-hb_con_@{se}_b_a;
  hb_inv_@{se}_b_b = hb_con_@{se}_b_b;
  @#for se2 in (1:sector)
    hb_hhh_@{se2}_@{se}_b_b = hb_con_@{se}_b_b;
  @#endfor
@#endfor

@#for co in countryLast
  @#for se in (1:sector)
    @#for co2 in country2
      C_@{se}_@{co}_@{co}_t = hb_con_@{se}_@{co}_@{co}*C_@{se}_@{co}_t;
      I_@{se}_@{co}_@{co}_t = hb_inv_@{se}_@{co}_@{co}*I_@{se}_@{co}_t;
      @#for se2 in (1:sector)
        H_@{se2}_@{se}_@{co}_@{co}_t = hb_hhh_@{se2}_@{se}_@{co}_@{co}*H_@{se2}_@{se}_b_t;
      @#endfor
      C_@{se}_@{co}_@{co2}_t = hb_con_@{se}_@{co}_@{co2}*C_@{se}_@{co}_t;
      I_@{se}_@{co}_@{co2}_t = hb_inv_@{se}_@{co}_@{co2}*I_@{se}_@{co}_t;
      @#for se2 in (1:sector)
        H_@{se2}_@{se}_@{co}_@{co2}_t = hb_hhh_@{se2}_@{se}_@{co}_@{co2}*H_@{se2}_@{se}_b_t;
      @#endfor
    @#endfor
  @#endfor
@#endfor

@#for se in (1:sector)
  MM_@{se}_a_b_t = (C_@{se}_a_b_t+I_@{se}_a_b_t
  @#for se2 in (1:sector)
    + H_@{se2}_@{se}_a_b_t
  @#endfor
  )*carb_int_@{se}_b;
@#endfor

@#for se in (1:sector)
  XX_@{se}_b_a_t = carb_int_@{se}_a * size_b/size_a*(C_@{se}_b_a_t+I_@{se}_b_a_t
  @#for se2 in (1:sector)
    + H_@{se2}_@{se}_b_a_t
  @#endfor
  );
@#endfor
