@#ifndef USE_FORWARD_DIFF
@#define USE_FORWARD_DIFF=false
@#endif

@#ifndef ISJULIA
@#define ISJULIA=false
@#endif

@#ifndef BLOCKS
@#define BLOCKS=false
@#endif

@#ifndef BYTECODE
@#define BYTECODE=false
@#endif

@#ifndef USE_DLL
@#define USE_DLL=false
@#endif

@#ifndef MFS_VALUE
@#define MFS_VALUE = 0
@#endif

@#ifndef STATIC_MFS_VALUE
@#define STATIC_MFS_VALUE = 0
@#endif

@#ifndef CUTOFF_VALUE
@#define CUTOFF_VALUE = 0
@#endif

@#ifndef PERIODS
@#define PERIODS = 600
@#endif

@#ifndef MARKOWITZ_VALUE
@#define MARKOWITZ_VALUE=0.5
@#endif

@#ifndef STACK_SOLVE_ALGO_VALUE
@#define STACK_SOLVE_ALGO_VALUE=0
@#endif

@#ifndef STEADY_SOLVE_ALGO_VALUE
@#define STEADY_SOLVE_ALGO_VALUE=0
@#endif

@#ifndef PRECONDITIONER
@#define PRECONDITIONER="first_iter_lu"
@#endif

@#define country    = ["a", "b"]
@#define country2   = ["a"]
@#define countryLast= ["b"]
@#define sector     = 10
@#define sector2    = 9


@#include "declarations.mod"

@#include "equations.mod"

@#include "calib-and-steady.mod"


steady(noprint);

options_.noprint = false; // Because I want to keep the perfect foresight solver as verbose as usual.


/*
** Set up of the perfect foresight problem (shock)
*/

shocks;
var shock_P_EM_a_t;
periods 
1
2
3
4
5
6
7
8
9
10
11
12
13
14
15
16
17
18
19
20
21
22
23
24
25
26
27
28
29
30
31
32
33
34
35
36
37
38
39
40
41
42
43
44
45
46
47
48
49
50
51
52
53
54
55
56
57
58
59
60
61
62
63
64
65
66
67
68
69
70
71
72
73
74
75
76
77
78
79
80
81
82
83
84
85
86
87
88
89
90
91
92
93
94
95
96:500
;
values 
0
0.0098834
0.0197669
0.0296504
0.0395339
0.0494174
0.04944338
0.04946936
0.04949534
0.04952132
0.0495473
0.06306842
0.07658954
0.09011066
0.10363178
0.1171529
0.12406388
0.13097486
0.13788584
0.14479682
0.1517078
0.16182176
0.17193572
0.18204968
0.19216364
0.2022776
0.21239264
0.22250768
0.23262272
0.24273776
0.2528528
0.26296556
0.27307832
0.28319108
0.29330384
0.3034166
0.31353014
0.32364368
0.33375722
0.34387076
0.3539843
0.36409814
0.37421198
0.38432582
0.39443966
0.4045535
0.41466566
0.42477782
0.43488998
0.44500214
0.4551143
0.46523012
0.47534594
0.48546176
0.49557758
0.5056934
0.51580757
0.52592174
0.53603591
0.54615008
0.55626425
0.56637842
0.57649259
0.58660676
0.59672093
0.6068351
0.61695047
0.62706584
0.63718121
0.64729658
0.65741195
0.66752732
0.67764269
0.68775806
0.69787343
0.7079888
0.71809991
0.72821102
0.73832213
0.74843324
0.75854435
0.76865546
0.77876657
0.78887768
0.79898879
0.8090999
0.81921911
0.82933832
0.83945753
0.84957674
0.85969595
0.86981516
0.87993437
0.89005358
0.90017279
0.910292; 
end;

for i=1:@{ITERATIONS}

perfect_foresight_setup(periods=@{PERIODS});

// The shock is excessively large, leading to near singularity
// problems that prevent the model from being solved in a single
// attempt. This might be related to the model's calibration. To
// address this, we will reduce the shock size and consider employing
// a divide and conquer strategy (homotopy).
oo_exo_simul = oo_.exo_simul;
oo_.exo_simul = .25*oo_exo_simul;

perfect_foresight_solver(no_homotopy, preconditioner=@{PRECONDITIONER}, markowitz=@{MARKOWITZ_VALUE}, stack_solve_algo = @{STACK_SOLVE_ALGO_VALUE}, solve_algo = @{STEADY_SOLVE_ALGO_VALUE}, maxit=20);

// Uncomment the following block to solve the perfect foresight model with full shock size (two steps homotopy).

/*
oo_.exo_simul = .50*oo_exo_simul;

perfect_foresight_solver(no_homotopy, preconditioner=@{PRECONDITIONER}, markowitz=@{MARKOWITZ_VALUE}, stack_solve_algo = @{STACK_SOLVE_ALGO_VALUE}, solve_algo = @{STEADY_SOLVE_ALGO_VALUE}, maxit=20);

oo_.exo_simul = 1.00*oo_exo_simul;

perfect_foresight_solver(no_homotopy, preconditioner=@{PRECONDITIONER}, markowitz=@{MARKOWITZ_VALUE}, stack_solve_algo = @{STACK_SOLVE_ALGO_VALUE}, solve_algo = @{STEADY_SOLVE_ALGO_VALUE}, maxit=20);
*/

end;
