classdef test_extract_WIOD_sectors < matlab.unittest.TestCase
%TEST_EXTRACT_WIOD_SECTORS Unit tests for extract_WIOD_sectors function
%
%   Run with: runtests('test_extract_WIOD_sectors')
%
%   NOTE: Functional tests with synthetic data are limited because
%   extract_WIOD_sectors is tightly coupled to the full 55-sector WIOD
%   structure. Integration tests with real WIOD data are recommended
%   for comprehensive testing.

    properties
        FuncPath
    end

    methods(TestClassSetup)
        function setupOnce(testCase)
            % Add Functions folder to path
            testCase.FuncPath = fullfile(fileparts(fileparts(mfilename('fullpath'))), ...
                'EMuSe_Calibration_Toolkit', 'Functions');
            addpath(testCase.FuncPath);
        end
    end

    methods(TestClassTeardown)
        function teardownOnce(testCase)
            rmpath(testCase.FuncPath);
        end
    end

    methods(Test)
        %% Input Validation Tests
        function testEmptyWIODDataThrowsError(testCase)
            testCase.verifyError(...
                @() extract_WIOD_sectors([], 'DEU', {'DEU'}, ["A"]), ...
                'extract_WIOD_sectors:InvalidWIOD');
        end

        function testInvalidWIODDataTypeThrowsError(testCase)
            testCase.verifyError(...
                @() extract_WIOD_sectors('not a cell', 'DEU', {'DEU'}, ["A"]), ...
                'extract_WIOD_sectors:InvalidWIOD');
        end

        function testEmptyISO2ThrowsError(testCase)
            WIOD = {'dummy'};  % Minimal cell to pass first check
            testCase.verifyError(...
                @() extract_WIOD_sectors(WIOD, 'DEU', {}, ["A"]), ...
                'extract_WIOD_sectors:InvalidISO2');
        end

        function testEmptyNACEThrowsError(testCase)
            WIOD = {'dummy'};
            testCase.verifyError(...
                @() extract_WIOD_sectors(WIOD, 'DEU', {'DEU'}, []), ...
                'extract_WIOD_sectors:EmptyNACE');
        end

        function testInvalidISO2TypeThrowsError(testCase)
            WIOD = {'dummy'};
            testCase.verifyError(...
                @() extract_WIOD_sectors(WIOD, 'DEU', 'not a cell', ["A"]), ...
                'extract_WIOD_sectors:InvalidISO2');
        end

        function testNumericWIODDataThrowsError(testCase)
            testCase.verifyError(...
                @() extract_WIOD_sectors(123, 'DEU', {'DEU'}, ["A"]), ...
                'extract_WIOD_sectors:InvalidWIOD');
        end

        function testStructWIODDataThrowsError(testCase)
            testCase.verifyError(...
                @() extract_WIOD_sectors(struct(), 'DEU', {'DEU'}, ["A"]), ...
                'extract_WIOD_sectors:InvalidWIOD');
        end
    end
end
