function paths = deflate(paths, info, t)

% Normalize paths with trends.
%
% INPUTS
% - paths  [dseries]   Object containing the time series to be rescaled.
% - info   [cell]      Description of the long run behaviour of the variables.
% - t      [integer]   scalar, time index.
%
% OUTPUTS
% - paths  [dseries]

    for i=1:paths.vobs
        variable = paths.name{i};
        j = find(strcmp(info(:,1), variable));
        if isequal(info{j,2}, 'Trend')
            paths{variable} = paths{variable}/info{j,3}^(t/paths.freq);
        end
    end