ds = dseries('../database/baseline.mat');

@#if MCE_IN_PAC_CONSUMPTION
ds.mce_Z1_pac_consumption_eq0 = dseries(ds.U2_CONS_PAC_PE.data, ds.dates(1), 'U2_CONS_PAC_PE');
@#endif

@#if MCE_IN_PAC_BUSINESS
ds.mce_Z1_pac_business_eq0 = dseries(ds.U2_BUSINESS_PAC_PE.data, ds.dates(1), 'U2_BUSINESS_PAC_PE');
@#endif

@#if MCE_IN_PAC_HOUSEPRICE
ds.mce_Z1_pac_houseprice_eq0 = dseries(ds.U2_HOUSEPRICE_PAC_PE.data, ds.dates(1), 'U2_HOUSEPRICE_PAC_PE');
@#endif

@#if MCE_IN_PAC_PROPERTY_INCOME
ds.mce_Z1_pac_property_income_eq0 = dseries(ds.U2_PROPERTY_PAC_PE.data, ds.dates(1), 'U2_PROPERTY_PAC_PE');
@#endif

@#if MCE_IN_PAC_RESIDENTIAL
ds.mce_Z1_pac_residential_eq0 = dseries(ds.U2_RESIDENTIAL_PAC_PE.data, ds.dates(1), 'U2_RESIDENTIAL_PAC_PE');
@#endif

@#if MCE_IN_PAC_LABOUR
ds.mce_Z1_pac_labour_eq0 = dseries(ds.U2_LABOUR_PAC_PE.data, ds.dates(1), 'U2_LABOUR_PAC_PE');
@#endif

@#if MCE_IN_LONG_TERM_INTEREST_RATE
ds.U2_RFB_E10Y = dseries(ones(ds.nobs, 1), ds.firstdate);
ds.U2_RFB_10Y = dseries(ones(ds.nobs, 1), ds.firstdate)*couponBB/(1+mean(ds.U2_STN)/100)^0.25/(1+mean(ds.U2_TP_10Y)/100)^0.25/(1 - (1-tauBB)/(1+mean(ds.U2_STN)/100)^0.25/(1+mean(ds.U2_TP_10Y)/100)^0.25);
ds.U2_RFCB_10Y = dseries(ones(ds.nobs, 1), ds.firstdate)*couponBB/(1+mean(ds.U2_STN)/100)^0.25/(1+mean(ds.U2_SCB)/100)^0.25/(1 - (1-tauBB)/(1+mean(ds.U2_STN)/100)^0.25/(1+mean(ds.U2_SCB)/100)^0.25);
@#endif

@#if MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP
ds.TPM_GAP = dseries(zeros(ds.nobs, 1), ds.firstdate);
@#endif

@#if MCE_IN_PERMANENT_INCOMES
ds.U2_G_VYERT = dseries(zeros(ds.nobs, 1), ds.firstdate);
ds.U2_G_VYERT_VE = dseries(zeros(ds.nobs, 1), ds.firstdate);
@#endif

ds.save('baseline_updated', 'mat');
