function make(varargin)

ROOT_FOLDER = fileparts(mfilename('fullpath'));
ROOT_FOLDER = ROOT_FOLDER(1:end-7);

if isempty(varargin)
    targets = {'irfs'};
else
    targets = varargin;
end

if ismember('irfs', targets)

    %
    % Compute IRFs
    %

    LIST_OF_IRF_SHOCKS = {'res_U2_STN', 'res_U2_TP_10Y'};
    LIST_OF_IRF_VARIABLES = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y', 'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_LNN', 'U2_EENX'};

    if calldynare('full')
        dynare hybrid -DFULL=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="full"
    end

    if calldynare('without-mce-in-pac')
        dynare hybrid -DMCE_IN_WAPRO=true -DMCE_IN_WAGE=true -DMCE_IN_PERMANENT_INCOMES=true -DMCE_IN_FINANCIAL -DMCE_IN_EXCHANGE_RATE=true -DDEFAULT_TO_MCE=false -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac"
    end

    if calldynare('without-mce-in-exchange-rate')
        dynare hybrid -DMCE_IN_EXCHANGE_RATE=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-exchange-rate"
    end

    if calldynare('without-mce-in-consumption')
        dynare hybrid -DMCE_IN_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-consumption"
    end

    if calldynare('without-mce-in-permanent-incomes')
        dynare hybrid -DMCE_IN_PERMANENT_INCOMES=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-permanent-incomes"
    end

    if calldynare('without-mce-in-pac-consumption')
        dynare hybrid -DMCE_IN_PAC_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-consumption"
    end

    if calldynare('without-mce-in-financial')
        dynare hybrid -DMCE_IN_FINANCIAL=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-financial"
    end

    if calldynare('without-mce-in-long-term-interest-rate')
        dynare hybrid -DMCE_IN_LONG_TERM_INTEREST_RATE=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-long-term-interest-rate"
    end

    if calldynare('without-mce-in-expected-averaged-output-gap')
        dynare hybrid -DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-expected-averaged-output-gap"
    end

    if calldynare('without-mce-in-wapro-and-wage')
        dynare hybrid -DMCE_IN_WAPRO=false -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-wapro-and-wage"
    end

    if calldynare('without-mce-in-wapro')
        dynare hybrid -DMCE_IN_WAPRO=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-wapro"
    end

    if calldynare('without-mce-in-wage')
        dynare hybrid -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-wage"
    end

    if calldynare('without-mce-in-pac-business')
        dynare hybrid -DMCE_IN_PAC_BUSINESS=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-business"
    end

    if calldynare('without-mce-in-pac-houseprice')
        dynare hybrid -DMCE_IN_PAC_HOUSEPRICE=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-houseprice"
    end

    if calldynare('without-mce-in-pac-property-income')
        dynare hybrid -DMCE_IN_PAC_PROPERTY_INCOME=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-property-income"
    end

    if calldynare('without-mce-in-pac-residential')
        dynare hybrid -DMCE_IN_PAC_RESIDENTIAL=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-residential"
    end

    if calldynare('without-mce-in-pac-labour')
        dynare hybrid -DMCE_IN_PAC_LABOUR=false -DDEFAULT_TO_MCE=true -DBUILD_IRFS=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="without-mce-in-pac-labour"
    end

end

if ismember('forwardguidance', targets)

    LIST_OF_IRF_SHOCKS = {};
    LIST_OF_IRF_VARIABLES = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y', 'U2_EENX'};

    if calldynare('forward-guidance/full')
        dynare hybrid -DFULL=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/full"
    end

    if calldynare('forward-guidance/without-mce-in-pac')
        dynare hybrid -DMCE_IN_WAPRO=true -DMCE_IN_WAGE=true -DMCE_IN_PERMANENT_INCOMES=true -DMCE_IN_FINANCIAL -DMCE_IN_EXCHANGE_RATE=true -DDEFAULT_TO_MCE=false -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac"
    end

    if calldynare('forward-guidance/without-mce-in-exchange-rate')
        dynare hybrid -DMCE_IN_EXCHANGE_RATE=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-exchange-rate"
    end

    if calldynare('forward-guidance/without-mce-in-consumption')
        dynare hybrid -DMCE_IN_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-consumption"
    end

    if calldynare('forward-guidance/without-mce-in-permanent-incomes')
        dynare hybrid -DMCE_IN_PERMANENT_INCOMES=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-permanent-incomes"
    end

    if calldynare('forward-guidance/without-mce-in-pac-consumption')
        dynare hybrid -DMCE_IN_PAC_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-consumption"
    end

    if calldynare('forward-guidance/without-mce-in-financial')
        dynare hybrid -DMCE_IN_FINANCIAL=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-financial"
    end

    if calldynare('forward-guidance/without-mce-in-long-term-interest-rate')
        dynare hybrid -DMCE_IN_LONG_TERM_INTEREST_RATE=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-long-term-interest-rate"
    end

    if calldynare('forward-guidance/without-mce-in-expected-averaged-output-gap')
        dynare hybrid -DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-expected-averaged-output-gap"
    end

    if calldynare('forward-guidance/without-mce-in-wapro-and-wage')
        dynare hybrid -DMCE_IN_WAPRO=false -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-wapro-and-wage"
    end

    if calldynare('forward-guidance/without-mce-in-wapro')
        dynare hybrid -DMCE_IN_WAPRO=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-wapro"
    end

    if calldynare('forward-guidance/without-mce-in-wage')
        dynare hybrid -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-wage"
    end

    if calldynare('forward-guidance/without-mce-in-pac-business')
        dynare hybrid -DMCE_IN_PAC_BUSINESS=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-business"
    end

    if calldynare('forward-guidance/without-mce-in-pac-houseprice')
        dynare hybrid -DMCE_IN_PAC_HOUSEPRICE=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-houseprice"
    end

    if calldynare('forward-guidance/without-mce-in-pac-property-income')
        dynare hybrid -DMCE_IN_PAC_PROPERTY_INCOME=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-property-income"
    end

    if calldynare('forward-guidance/without-mce-in-pac-residential')
        dynare hybrid -DMCE_IN_PAC_RESIDENTIAL=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-residential"
    end

    if calldynare('forward-guidance/without-mce-in-pac-labour')
        dynare hybrid -DMCE_IN_PAC_LABOUR=false -DDEFAULT_TO_MCE=true -DFORWARD_GUIDANCE_PUZZLE=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-labour"
    end

end

if ismember('expected-tfp-growth-shock', targets)

    LIST_OF_IRF_SHOCKS = {};
    LIST_OF_IRF_VARIABLES = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y', 'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_LNN', 'U2_EENX'};

    if calldynare('tfp-growth-expected-shock/full')
        dynare hybrid -DFULL=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/full"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac')
        dynare hybrid -DMCE_IN_WAPRO=true -DMCE_IN_WAGE=true -DMCE_IN_PERMANENT_INCOMES=true -DMCE_IN_FINANCIAL -DMCE_IN_EXCHANGE_RATE=true -DDEFAULT_TO_MCE=false -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-exchange-rate')
        dynare hybrid -DMCE_IN_EXCHANGE_RATE=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-exchange-rate"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-consumption')
        dynare hybrid -DMCE_IN_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-consumption"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-permanent-incomes')
        dynare hybrid -DMCE_IN_PERMANENT_INCOMES=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-permanent-incomes"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-consumption')
        dynare hybrid -DMCE_IN_PAC_CONSUMPTION=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-consumption"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-financial')
        dynare hybrid -DMCE_IN_FINANCIAL=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-financial"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-long-term-interest-rate')
        dynare hybrid -DMCE_IN_LONG_TERM_INTEREST_RATE=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-long-term-interest-rate"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-expected-averaged-output-gap')
        dynare hybrid -DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-expected-averaged-output-gap"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-wapro-and-wage')
        dynare hybrid -DMCE_IN_WAPRO=false -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wapro-and-wage"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-wapro')
        dynare hybrid -DMCE_IN_WAPRO=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wapro"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-wage')
        dynare hybrid -DMCE_IN_WAGE=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wage"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-business')
        dynare hybrid -DMCE_IN_PAC_BUSINESS=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-business"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-houseprice')
        dynare hybrid -DMCE_IN_PAC_HOUSEPRICE=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-houseprice"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-property-income')
        dynare hybrid -DMCE_IN_PAC_PROPERTY_INCOME=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-property-income"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-residential')
        dynare hybrid -DMCE_IN_PAC_RESIDENTIAL=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-residential"
    end

    if calldynare('tfp-growth-expected-shock/without-mce-in-pac-labour')
        dynare hybrid -DMCE_IN_PAC_LABOUR=false -DDEFAULT_TO_MCE=true -DEXPECTED_PRODUCTIVITY_SHOCK=true -DBUILD_MATLAB_PLOTS=false -DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-labour"
    end

end


function b = calldynare(subfolder)
    b = false;
    if isempty(LIST_OF_IRF_SHOCKS)
        for j=1:length(LIST_OF_IRF_VARIABLES)
            b = ~isfile(sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/models/hybrid.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/models/update-database.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/database/baseline.mat', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j}));
            if b
                return
            end
        end
    else
        for i=1:length(LIST_OF_IRF_SHOCKS)
            for j=1:length(LIST_OF_IRF_VARIABLES)
                b = ~isfile(sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/models/hybrid.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/models/update-database.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/database/baseline.mat', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j}));
                if b
                    return
                end
            end
        end
    end
end

end