function comparison_plot(modelName, periodsToPlot, genSinglePdf, compWP)


%% PREAMBLE

% Create the list of shocks
listofshocks(1) = {'res_U2_Q_T_PRO'};  % Technology shock
listofshocks(2) = {'res_U2_STN'};      % Policy shock (Interest rate)
listofshocks(3) = {'res_U2_TP_10Y'};   % Term Premium shock
listofshocks(4) = {'res_U2_SLRN'};     % Risk Premium shock
listofshocks(5) = {'res_U2_A_YED'};  % Inflation (Phillips curve)
listofshocks(6) = {'res_U2_G_C_CER'};  % Wage (Wage curve)

%% Perform transformation and set database for plotting IRFs
%% Cell list of variables to be plotted as deviations
dev={'U2_STN' 'U2_ESTN' 'U2_R_LUN' 'U2_TP_10Y' 'U2_OIS_10Y' ...
    'U2_STN_E10Y','U2_HH_SL_CON', 'U2_HH_SL_IHN', 'U2_SLRN', 'U2_SCB', 'U2_SCOE', 'U2_HH_SL_DEP',...
    'U2_HH_L_CON', 'U2_HH_L_IHN', 'U2_LRN', 'U2_CB', 'U2_HH_L_DEP' 'U2_S_GO_COR'  'U2_S_RPPD'};

%% Cell list of variables to be plotted as percentage deviations *100
pdev={'U2_YER' 'U2_HH_COR' 'U2_ITR' 'U2_LNN' 'U2_EENX' 'U2_XXR' 'U2_MXR' 'U2_HH_EDIR' 'U2_MTR', 'U2_MNR',...
    'U2_XTR', 'U2_XNR' 'U2_WDREX' 'U2_REENX' 'U2_T_PRO' 'U2_POU' 'U2_CXEDEX' 'U2_RPPD' 'U2_COE'};

%% Cell list of variables to be plotted as 4th sqrt of log diff
adev={'U2_YED' 'U2_C_CEN' 'U2_XXD' 'U2_MXD' 'U2_MTD'  'U2_XTD' 'U2_HH_COD' 'U2_C_WAN'};

%% Cell list of variables to be plotted as log diff *100
qdev={};
ydev={};

%% Load the MCE model data

% Construct the structure containing all of the simultion from the above model
irfs_mce = struct();
for i=1:length(listofshocks)
    listofshocks{i}
    irfs_mce.(listofshocks{i}) = dseries(sprintf('./mat/%s_%s.mat', modelName, listofshocks{i}));
end

% Load baseline data
baseline_mce = dseries('../database/baseline.mat');

irf_mce_report = struct();

for i = 1:length(listofshocks)
    names_tmp = irfs_mce.(listofshocks{i}).name;
    irfs_mce_report.(listofshocks{i}) = irf_trans_report(baseline_mce{names_tmp{:}},irfs_mce.(listofshocks{i}){names_tmp{:}},'dev',dev,'pdev',pdev,'qdev',qdev,'adev',adev,'ydev',ydev,'start_date',firstobservedperiod(irfs_mce.(listofshocks{i}))-1);
end


%% Load the Backward model results - WP
%baseline_wp = dseries('baseline_WP.mat');
baseline_wp = dseries('../database/baseline_with_foreign.mat');
names_baseline_tmp = baseline_wp.name;

% Load IRFS from WP version of the model
%load('irfs_WP.mat');
load('../database/irfs_with_foreign.mat');
irfs_wp = irfs;
clear irfs;

irfs_wp_redef = struct();
irfs_wp_report = struct();

for i = 1:length(listofshocks)
    names_tmp = irfs_wp.(listofshocks{i}).name;

    irfs_wp_report.(listofshocks{i}) = irf_trans_report(baseline_wp{names_tmp{:}},...
        irfs_wp.(listofshocks{i}){names_tmp{:}},'dev',dev,'pdev',pdev,'qdev',qdev,'adev',adev,'ydev',ydev,'start_date',firstobservedperiod(irfs_wp.(listofshocks{i})));

    irfs_wp_report.(listofshocks{i}) = dseries([zeros(1,size(irfs_wp_report.(listofshocks{i}).data,2)); irfs_wp_report.(listofshocks{i}).data], firstobservedperiod(irfs_mce_report.(listofshocks{i})), irfs_wp_report.(listofshocks{i}).name);
end


%% Plot Settings
% Reporting plot
shock_titles = {'Figure 1: Technology shock (1%)', 'res_U2_Q_T_PRO' ... (0.1% GDP)
    'Figure 2: Short-term interest rate shock (100bp)', 'res_U2_STN' ...
    'Figure 3: Term premium shock (100bp)','res_U2_TP_10Y' ...
    'Figure 4: Risk premium shock (100bp)', 'res_U2_SLRN' ...
    'Figure 5: GDP deflator shock (1)', 'res_U2_A_YED' ...
    'Figure 6: Compensation per employee gap shock (1)', 'res_U2_G_C_CER'...
    ...'Figure 4: Interest rate expectations shock', ...
    ...'Figure 5: Share of SSC paid by households (1pp)',...
    ...'Figure 6: Share of SSC paid by firms (1pp)',...
    ...'Figure 7: Government spending shock (1% GDP)', ...
    ...'Figure 8: World demand shock (1%)',...
    ...'Figure 9: Exchange rate shock (euro depreciation 1%)',...
    ...'Figure 10: Oil price shock (10%)',...
    ...'Figure 11: Competitors prices shock (1%)',...
    };

additional_var = {...'U2_T_PRO',...
    ...'U2_HH_L_CON',...
    ...'U2_TP_10Y',...
    ...'U2_SLRN',...
    ...'U2_STN_E10Y',...
    ...'U2_S_SCNL_HH',...
    ...'U2_S_SCNL_F',...
    ...'U2_GO_COR',...
    ...'U2_WDREX',...
    ...'U2_REENX',...
    ...'U2_POU',...
    ...'U2_CXEDEX',...
    };

additional_var_title = {...'Labour Augmenting Technology',...
    ...'Consumer Lending Rate',...
    ...'Term Premium',...
    ...'Spread on Business Lending Rate',...
    ...'Interest Rate Expectations (10Y)',...
    ...'Share of SSC Paid by Households',...
    ...'Share of SSC Paid by Firms',...
    ...'Total Real Gov. Cons. Expenditure',...
    ...'World Demand',...
    ...'Real Effective Exchange Rate',...
    ...'Oil Price',...
    ...'Competitors Export Prices',...
    };

footnote_text = {'Note: The figure shows impulse responses to a permanent technology shocks of 1%. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    'Note: The figure shows impulse responses to an increase in short-term nominal rate equal to 100 bp. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    'Note: The figure shows impulse responses to an increase in 10-year term-premium equal to 100 bp. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    'Note: The figure shows impulse responses to an increase in the spread on business lending rate equal to 100 bp. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    ...'Note: This figure shows impulse responses to change in expectations of the short term nominal rate over the 10 year horizon. The shock to short-term rate expectations is calibrated based on ex-ante difference between the two expected paths for the short term interest rate. In the baseline the short-term interest rate is assumed to linearly increase from 0\% to 2\% in two years and stay fixed afterwards, while in the alternative scenario the short term is assumed to be zero in the first year and linearly increase from 0\% to 2\% in the second year and stay fixed afterwards.  The impulse responses were obtained under exogenous fiscal and extra area blocks, while the rest of the economy endogenously responds to the shock. This implies ex-post movements of the short term IR are not consistent with ex-ante expectations and therefore the shock should not be interpreted as a credible Odyssian forward-guidance scenario.', ...
    ...'Note: The figure shows impulse responses to permanent 1p.p. increase in share of social security contributions paid by households. The impulse responses were obtained under exogenous fiscal and extra area blocks.',...
    ...'Note: The figure shows impulse responses to permanent 1p.p. increase in share of social security contributions paid by firms. The impulse responses were obtained under exogenous fiscal and extra area blocks.',...
    ...'Note: The figure shows impulse responses to permanent increase in government spending equal to 1% of the baseline GDP. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    ...'Note: The figure shows impulse responses to permanent increase in world demand equal to 1%. The impulse responses were obtained under exogenous fiscal, extra area and exchange rate blocks.', ...
    ...'Note: The figure shows impulse responses to permanent depreciation of nominal exchange rate equal to 1%. The impulse responses were obtained under exogenous fiscal, extra area and exchange rate blocks.', ...
    ...'Note: The figure shows impulse responses to permanent increase in oil prices equal to 10%. The impulse responses were obtained under exogenous fiscal, extra area and exchange rate blocks.', ...
    ...'Note: The figure shows impulse responses to permanent increase in competitors export prices equal to 1%. The impulse responses were obtained under exogenous fiscal, extra area and exchange rate blocks.', ...
    ...'Note: The figure shows impulse responses to permanent increase in residential property prices equal to 1%. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    ...'Note: The figure shows impulse responses to permanent decrease in cost of equity equal to 1%. The impulse responses were obtained under exogenous fiscal and extra area blocks.', ...
    };


irf_1 = {};
irf_2 = {};

for ii = 1:length(shock_titles)/2
    var_list{ii} = {'U2_YER', 'U2_HH_COR', 'U2_ITR',...
        'U2_XXR', 'U2_MXR', 'U2_LNN', ...
        'U2_HH_COD', 'U2_YED', 'U2_C_WAN', ...
        'U2_XXD', 'U2_MXD', 'U2_EENX', ...
        'U2_STN', 'U2_OIS_10Y'};

    title_list{ii} = {'Real Output', 'Real Consumption', 'Real Investment',...
        'Real Exports (extra)','Real Imports (extra)', 'Total Employment', ...
        'Consumption Defl. Infl.', 'GDP Defl. Infl.', 'Nom. Wage Infl.', ...
        'Export Defl. Infl. (extra)', 'Import Defl. Infl. (extra)', 'Nom. Effective Exchange Rate', ...
        'Nom. Short-term Interest Rate', 'Nom. Long-term Bond Rate'};


    var_list_presentation{ii} = {'U2_YER', 'U2_HH_COR', 'U2_ITR',...
        'U2_XXR', 'U2_MXR', 'U2_LNN', ...
        'U2_HH_COD', 'U2_YED', 'U2_C_CEN', ...
        'U2_STN', 'U2_OIS_10Y', 'U2_EENX'};

    title_list_presentation{ii} = {'Real Output', 'Real Consumption', 'Real Investment',...
        'Real Exports (extra)', 'Real Imports (extra)', 'Total Employment', ...
        'Consumption Defl. Infl.', 'GDP Defl. Infl.', 'Nom. Wage Infl.', ...
        'Nom. Short-term Interest Rate', 'Nom. Long-term Bond Rate', 'Nom. Effective Exchange Rate'};


    % Data base with VAR expectations setting
    legend = 'ECB-BASE NEW VAR EXPECTATIONS';
    %irf_1{ii} = irfs_backward_model_report.(shock_titles{(ii-1)*2+2});
    irf_1{ii} = irfs_mce_report.(shock_titles{(ii-1)*2+2});
    if compWP
        % Data base with ECB-BASE v1
        legend_2 = 'ECB-BASE WP VAR';
        irf_2{ii} = irfs_wp_report.(shock_titles{(ii-1)*2+2});
    else
        % Data base with ECB-BASE v1
        legend_2 = 'ECB-BASE NEW MCE';
        irf_2{ii} = irfs_mce_report.(shock_titles{(ii-1)*2+2});
    end
end


% Plot Settings
disp_type = 'Q'; ...'Y';        % If disp_type is switched to 'Y', then disp_range has to be divided by 4
disp_range = 4*5; ...50;
dim_1 = 5;
dim_2 = 3;
save_ = 'no';                  % If yes, the figure will be saved in the specified format (see: format_)
orient_ = 'portrait';
format_ = 'fig'; ...fig ...png ...epsc ...emf
fname = 'irfs_booklet';
fldr = 'chartpack';        % Location to save figures and .ps reports
report = 'yes';                  % If yes, a .ps file will be generated with all the other figures saved under the same fname

if genSinglePdf
    for ii = 1:length(shock_titles)/2
        plot_irf_reporting(irf_1{ii}, var_list{ii}, title_list{ii}, {shock_titles{(ii-1)*2+1}}, 'disp_type', 'Q', 'disp_range', periodsToPlot, 'dim1', dim_1, 'dim2', dim_2,...
            'legend_1', legend, 'folder_to_save', fldr, 'save', save_, 'orient', orient_, 'format', format_, 'fname', sprintf('irfs_%s', modelName),'reporting', report, 'shock_names', {shock_titles{(ii-1)*2+2}},...
            'Series2', irf_2{ii}, 'var_list_2', var_list{ii}, 'legend_2', legend_2 ...
            ...,'Series3', irf_3{ii}, 'var_list_3', var_list{ii}, 'legend_3', legend_3 ...
            );
    end
else
    for ii = 1:length(shock_titles)/2
        plot_irf_reporting(irf_1{ii}, var_list{ii}, title_list{ii}, {shock_titles{(ii-1)*2+1}}, 'disp_type', 'Q', 'disp_range', periodsToPlot, 'dim1', dim_1, 'dim2', dim_2,...
            'legend_1', legend, 'folder_to_save', fldr, 'save', save_, 'orient', orient_, 'format', format_, 'fname', sprintf('irfs_%s', modelName),'reporting', report, 'shock_names', {},...
            'Series2', irf_2{ii}, 'var_list_2', var_list{ii}, 'legend_2', legend_2 ...
            ...,'Series3', irf_3{ii}, 'var_list_3', var_list{ii}, 'legend_3', legend_3 ...
            );
    end
end