function make(varargin)

ROOT_FOLDER = fileparts(mfilename('fullpath'));
ROOT_FOLDER = ROOT_FOLDER(1:end-7);

if isempty(varargin)
    targets = {'irfs-all'};
else
    if nargin==1 && isequal(varargin{1}, 'all')
        varargin = {'irfs-all', 'forwardguidance-all', 'expected-tfp-growth-shock-all'};
    end
    targets = varargin;
end

% dev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y'};

% pdev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS = {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_LNN', 'U2_EENX'};

% qdev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS = {};

% adev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS = {};

% ydev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS = {};

% Set the list of endogenous variables that will be plotted.
LIST_OF_IRF_VARIABLES = [VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS, ...
                    VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS, ...
                    VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS, ...
                    VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS, ...
                    VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS];

if ismember('irfs-all', targets) || ismember('irfs', targets)

    %
    % Compute IRFs
    %

    % Set list of shocks [user defined]
    LIST_OF_IRF_SHOCKS = {'res_U2_STN', 1.0; ...
                        'res_U2_TP_10Y', 1.0; ...
                        'res_U2_A_YED', 0.1; ...
                        'res_U2_G_C_CER', 0.1; ...
                        'res_U2_Q_T_PRO', 0.01; ...
                        'res_U2_SLRN', 0.1; ...
                        'res_U2_WDREX', 0.01};

    % Compute backward model IRFs
    for l = 1:length(LIST_OF_IRF_SHOCKS)
        filename = sprintf('%s/models/mat/irfs_backward_model_%s', ROOT_FOLDER, LIST_OF_IRF_SHOCKS{l,1});
        filewext = sprintf('%s.mat', filename);
        if ~exist(filewext, 'file') || ismorerecent(sprintf('%s/models/hybrid.mod', ROOT_FOLDER), filewext) ...
                || ismorerecent(sprintf('%s/models/computeirf.m', ROOT_FOLDER), filewext) ...
                || ismorerecent(sprintf('%s/database/baseline.mat', ROOT_FOLDER), filewext) ...
                || ismorerecent(sprintf('%s/matlab/make.m', ROOT_FOLDER), filewext)
            ts = computeirf(LIST_OF_IRF_SHOCKS{l,1}, LIST_OF_IRF_SHOCKS{l,2}, LIST_OF_IRF_VARIABLES, 1499);
            ts.save(filename, 'mat');
        end
    end

    % Set macro-variables to be passed to dynare preprocessor.
    IRF_SETUP = {};
    IRF_SETUP{1} = '-DShockNames=[';
    IRF_SETUP{2} = '-DShockValues=[';
    for k=1:rows(LIST_OF_IRF_SHOCKS)-1
        IRF_SETUP{1} = sprintf('%s"%s", ', IRF_SETUP{1}, LIST_OF_IRF_SHOCKS{k,1});
        IRF_SETUP{2} = sprintf('%s%12.6f, ', IRF_SETUP{2}, LIST_OF_IRF_SHOCKS{k,2});
    end
    IRF_SETUP{1} = sprintf('%s"%s"]', IRF_SETUP{1}, LIST_OF_IRF_SHOCKS{end, 1});
    IRF_SETUP{2} = sprintf('%s%12.6f]', IRF_SETUP{2}, LIST_OF_IRF_SHOCKS{end,2});
    IRF_SETUP{3} = '-DVariableNames=[';
    for k=1:length(LIST_OF_IRF_VARIABLES)-1
        IRF_SETUP{3} = sprintf('%s"%s", ', IRF_SETUP{3}, LIST_OF_IRF_VARIABLES{k});
    end
    IRF_SETUP{3} = sprintf('%s"%s"]', IRF_SETUP{3}, LIST_OF_IRF_VARIABLES{end});
    IRF_SETUP_LENGTH = length(IRF_SETUP);
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePpdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePqdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePadev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePydev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DBUILD_IRFS=true';
    IRF_SETUP{IRF_SETUP_LENGTH+2} = '-DBUILD_MATLAB_PLOTS=false';

    if (ismember('irfs-all', targets) || all(ismember({'irfs','full'}, targets))) && calldynare('full')
        dynare('hybrid', '-DFULL=true', '-DSUBFOLDERNAME="full"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','full-without-tp-in-exchange-rate'}, targets))) && calldynare('full-without-tp-in-exchange-rate')
        dynare('hybrid', '-DFULL=true', '-DEXCHANGE_RATE_WITH_TP=false', '-DSUBFOLDERNAME="full-without-tp-in-exchange-rate"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac'}, targets))) && calldynare('without-mce-in-pac')
        dynare('hybrid', '-DDEFAULT_TO_MCE=false', '-DMCE_IN_WAPRO=true', '-DMCE_IN_WAGE=true', '-DMCE_IN_PERMANENT_INCOMES=true', '-DMCE_IN_FINANCIAL=true', '-DMCE_IN_EXCHANGE_RATE=true', '-DSUBFOLDERNAME="without-mce-in-pac"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-exchange-rate'}, targets))) && calldynare('without-mce-in-exchange-rate')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true ', '-DMCE_IN_EXCHANGE_RATE=false', '-DSUBFOLDERNAME="without-mce-in-exchange-rate"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-consumption'}, targets))) && calldynare('without-mce-in-consumption')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_CONSUMPTION=false', '-DSUBFOLDERNAME="without-mce-in-consumption"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-permanent-incomes'}, targets))) && calldynare('without-mce-in-permanent-incomes')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PERMANENT_INCOMES=false', '-DSUBFOLDERNAME="without-mce-in-permanent-incomes"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-consumption'}, targets))) && calldynare('without-mce-in-pac-consumption')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_CONSUMPTION=false', '-DSUBFOLDERNAME="without-mce-in-pac-consumption"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-financial'}, targets))) && calldynare('without-mce-in-financial')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_FINANCIAL=false', '-DSUBFOLDERNAME="without-mce-in-financial"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-long-term-interest-rate'}, targets))) && calldynare('without-mce-in-long-term-interest-rate')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_LONG_TERM_INTEREST_RATE=false', '-DSUBFOLDERNAME="without-mce-in-long-term-interest-rate"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-expected-averaged-output-gap'}, targets))) && calldynare('without-mce-in-expected-averaged-output-gap')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false', '-DSUBFOLDERNAME="without-mce-in-expected-averaged-output-gap"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-wapro-and-wage'}, targets))) && calldynare('without-mce-in-wapro-and-wage')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_WAPRO=false', '-DMCE_IN_WAGE=false', '-DSUBFOLDERNAME="without-mce-in-wapro-and-wage"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-wapro'}, targets))) && calldynare('without-mce-in-wapro')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_WAPRO=false', '-DSUBFOLDERNAME="without-mce-in-wapro"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-wage'}, targets))) && calldynare('without-mce-in-wage')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_WAGE=false', '-DSUBFOLDERNAME="without-mce-in-wage"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-business'}, targets))) && calldynare('without-mce-in-pac-business')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_BUSINESS=false', '-DSUBFOLDERNAME="without-mce-in-pac-business"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-houseprice'}, targets))) && calldynare('without-mce-in-pac-houseprice')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_HOUSEPRICE=false', '-DSUBFOLDERNAME="without-mce-in-pac-houseprice"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-property-income'}, targets))) && calldynare('without-mce-in-pac-property-income')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_PROPERTY_INCOME=false', '-DSUBFOLDERNAME="without-mce-in-pac-property-income"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-residential'}, targets))) && calldynare('without-mce-in-pac-residential')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_RESIDENTIAL=false', '-DSUBFOLDERNAME="without-mce-in-pac-residential"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','without-mce-in-pac-labour'}, targets))) && calldynare('without-mce-in-pac-labour')
        dynare('hybrid', '-DDEFAULT_TO_MCE=true', '-DMCE_IN_PAC_LABOUR=false', '-DSUBFOLDERNAME="without-mce-in-pac-labour"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','backward-with-uip'}, targets))) && calldynare('backward-with-uip')
        dynare('hybrid', '-DBACKWARD_WITH_UIP=true', '-DSUBFOLDERNAME="backward-with-uip"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','backward-with-uip-without-tp'}, targets))) && calldynare('backward-with-uip-without-tp')
        dynare('hybrid', '-DBACKWARD_WITH_UIP=true', '-DEXCHANGE_RATE_WITH_TP=false', '-DSUBFOLDERNAME="backward-with-uip-without-tp"', IRF_SETUP{:})
    end

    if (ismember('irfs-all', targets) || all(ismember({'irfs','hybrid'}, targets))) && calldynare('hybrid')
        dynare('hybrid', '-DHYBRID=true', '-DSUBFOLDERNAME="hybrid"', IRF_SETUP{:})
    end

end

if ismember('forwardguidance-all', targets) || ismember('forwardguidance', targets)

    LIST_OF_IRF_SHOCKS = {};

    % Set macro-variables to be passed to dynare preprocessor.
    IRF_SETUP = {};
    IRF_SETUP{1} = '-DVariableNames=[';
    for k=1:length(LIST_OF_IRF_VARIABLES)-1
        IRF_SETUP{1} = sprintf('%s"%s", ', IRF_SETUP{1}, LIST_OF_IRF_VARIABLES{k});
    end
    IRF_SETUP{1} = sprintf('%s"%s"]', IRF_SETUP{1}, LIST_OF_IRF_VARIABLES{end});
    IRF_SETUP_LENGTH = length(IRF_SETUP);
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePpdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePqdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePadev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePydev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DFORWARD_GUIDANCE_PUZZLE=true';
    IRF_SETUP{IRF_SETUP_LENGTH+2} = '-DBUILD_MATLAB_PLOTS=false';

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'full'}, targets))) && calldynare('forward-guidance/full')
        dynare('hybrid', '-DFULL=true', '-DSUBFOLDERNAME="forward-guidance/full"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac'}, targets))) && calldynare('forward-guidance/without-mce-in-pac')
        dynare('hybrid', '-DMCE_IN_WAPRO=true ', '-DMCE_IN_WAGE=true ', '-DMCE_IN_PERMANENT_INCOMES=true ', '-DMCE_IN_FINANCIAL=true ', '-DMCE_IN_EXCHANGE_RATE=true ', '-DDEFAULT_TO_MCE=false', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-exchange-rate'}, targets))) && calldynare('forward-guidance/without-mce-in-exchange-rate')
        dynare('hybrid', '-DMCE_IN_EXCHANGE_RATE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-exchange-rate"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-consumption'}, targets))) && calldynare('forward-guidance/without-mce-in-consumption')
        dynare('hybrid', '-DMCE_IN_CONSUMPTION=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-consumption"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-permanent-incomes'}, targets))) && calldynare('forward-guidance/without-mce-in-permanent-incomes')
        dynare('hybrid', '-DMCE_IN_PERMANENT_INCOMES=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-permanent-incomes"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-consumption'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-consumption')
        dynare('hybrid', '-DMCE_IN_PAC_CONSUMPTION=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-consumption"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-financial'}, targets))) && calldynare('forward-guidance/without-mce-in-financial')
        dynare('hybrid', '-DMCE_IN_FINANCIAL=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-financial"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-long-term-interest-rate'}, targets))) && calldynare('forward-guidance/without-mce-in-long-term-interest-rate')
        dynare('hybrid', '-DMCE_IN_LONG_TERM_INTEREST_RATE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-long-term-interest-rate"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-expected-averaged-output-gap'}, targets))) && calldynare('forward-guidance/without-mce-in-expected-averaged-output-gap')
        dynare('hybrid', '-DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-expected-averaged-output-gap"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-wapro-and-wage'}, targets))) && calldynare('forward-guidance/without-mce-in-wapro-and-wage')
        dynare('hybrid', '-DMCE_IN_WAPRO=false', '-DMCE_IN_WAGE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-wapro-and-wage"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-wapro'}, targets))) && calldynare('forward-guidance/without-mce-in-wapro')
        dynare('hybrid', '-DMCE_IN_WAPRO=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-wapro"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-wage'}, targets))) && calldynare('forward-guidance/without-mce-in-wage')
        dynare('hybrid', '-DMCE_IN_WAGE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-wage"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-business'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-business')
        dynare('hybrid', '-DMCE_IN_PAC_BUSINESS=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-business"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-houseprice'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-houseprice')
        dynare('hybrid', '-DMCE_IN_PAC_HOUSEPRICE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-houseprice"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-property-income'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-property-income')
        dynare('hybrid', '-DMCE_IN_PAC_PROPERTY_INCOME=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-property-income"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-residential'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-residential')
        dynare('hybrid', '-DMCE_IN_PAC_RESIDENTIAL=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-residential"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'without-mce-in-pac-labour'}, targets))) && calldynare('forward-guidance/without-mce-in-pac-labour')
        dynare('hybrid', '-DMCE_IN_PAC_LABOUR=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="forward-guidance/without-mce-in-pac-labour"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'backward-with-uip'}, targets))) && calldynare('forward-guidance/backward-with-uip')
        dynare('hybrid', '-DBACKWARD_WITH_UIP=true', '-DSUBFOLDERNAME="forward-guidance/backward-with-uip"', IRF_SETUP{:})
    end

    if (ismember('forwardguidance-all', targets) || all(ismember({'forwardguidance', 'hybrid'}, targets))) && calldynare('forward-guidance/hybrid')
        dynare('hybrid', '-DHYBRID=true', '-DSUBFOLDERNAME="forward-guidance/hybrid"', IRF_SETUP{:})
    end

end

if ismember('expected-tfp-growth-shock-all', targets) || ismember('expected-tfp-growth-shock', targets)

    LIST_OF_IRF_SHOCKS = {};

    % Set macro-variables to be passed to dynare preprocessor.
    IRF_SETUP = {};
    IRF_SETUP{1} = '-DVariableNames=[';
    for k=1:length(LIST_OF_IRF_VARIABLES)-1
        IRF_SETUP{1} = sprintf('%s"%s", ', IRF_SETUP{1}, LIST_OF_IRF_VARIABLES{k});
    end
    IRF_SETUP{1} = sprintf('%s"%s"]', IRF_SETUP{1}, LIST_OF_IRF_VARIABLES{end});
    IRF_SETUP_LENGTH = length(IRF_SETUP);
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePpdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePqdev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePadev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    if ~isempty(VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS)
        IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DVariablePydev=[';
        for k=1:length(VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS)-1
            IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s", ', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{k});
        end
        IRF_SETUP{IRF_SETUP_LENGTH+1} = sprintf('%s"%s"]', IRF_SETUP{IRF_SETUP_LENGTH+1}, VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS{end});
        IRF_SETUP_LENGTH = IRF_SETUP_LENGTH+1;
    end
    IRF_SETUP{IRF_SETUP_LENGTH+1} = '-DEXPECTED_PRODUCTIVITY_SHOCK=true';
    IRF_SETUP{IRF_SETUP_LENGTH+2} = '-DBUILD_MATLAB_PLOTS=false';

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'full'}, targets))) && calldynare('tfp-growth-expected-shock/full')
        dynare('hybrid', '-DFULL=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/full"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac')
        dynare('hybrid', '-DDEFAULT_TO_MCE=false', '-DMCE_IN_WAPRO=true', '-DMCE_IN_WAGE=true', '-DMCE_IN_PERMANENT_INCOMES=true', '-DMCE_IN_FINANCIAL=true', '-DMCE_IN_EXCHANGE_RATE=true', ...
               '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-exchange-rate'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-exchange-rate')
        dynare('hybrid', '-DMCE_IN_EXCHANGE_RATE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-exchange-rate"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-consumption'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-consumption')
        dynare('hybrid', '-DMCE_IN_CONSUMPTION=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-consumption"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-permanent-incomes'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-permanent-incomes')
        dynare('hybrid', '-DMCE_IN_PERMANENT_INCOMES=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-permanent-incomes"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac-consumption'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-consumption')
        dynare('hybrid', '-DMCE_IN_PAC_CONSUMPTION=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-consumption"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-financial'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-financial')
        dynare('hybrid', '-DMCE_IN_FINANCIAL=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-financial"', IRF_SETUP{:})
    end

    % This one is not working with the latest calibration provided by Nikola
    %
    % if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-long-term-interest-rate'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-long-term-interest-rate')
    %     dynare('hybrid', '-DMCE_IN_LONG_TERM_INTEREST_RATE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-long-term-interest-rate"', IRF_SETUP{:})
    % end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-expected-averages-output-gap'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-expected-averaged-output-gap')
        dynare('hybrid', '-DMCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-expected-averaged-output-gap"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-wapro-and-wage'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-wapro-and-wage')
        dynare('hybrid', '-DMCE_IN_WAPRO=false', '-DMCE_IN_WAGE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wapro-and-wage"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-wapro'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-wapro')
        dynare('hybrid', '-DMCE_IN_WAPRO=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wapro"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-wage'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-wage')
        dynare('hybrid', '-DMCE_IN_WAGE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-wage"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac-business'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-business')
        dynare('hybrid', '-DMCE_IN_PAC_BUSINESS=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-business"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac-houseprice'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-houseprice')
        dynare('hybrid', '-DMCE_IN_PAC_HOUSEPRICE=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-houseprice"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-property-income'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-property-income')
        dynare('hybrid', '-DMCE_IN_PAC_PROPERTY_INCOME=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-property-income"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac-residential'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-residential')
        dynare('hybrid', '-DMCE_IN_PAC_RESIDENTIAL=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-residential"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'without-mce-in-pac-labour'}, targets))) && calldynare('tfp-growth-expected-shock/without-mce-in-pac-labour')
        dynare('hybrid', '-DMCE_IN_PAC_LABOUR=false', '-DDEFAULT_TO_MCE=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/without-mce-in-pac-labour"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'backward-with-uip'}, targets))) && calldynare('tfp-growth-expected-shock/backward-with-uip')
        dynare('hybrid', '-DBACKWARD_WITH_UIP=true', '-DDEFAULT_TO_MCE=false', '-DSUBFOLDERNAME="tfp-growth-expected-shock/backward-with-uip"', IRF_SETUP{:})
    end

    if (ismember('expected-tfp-growth-shock-all', targets) || all(ismember({'expected-tfp-growth-shock', 'hybrid'}, targets))) && calldynare('tfp-growth-expected-shock/hybrid')
        dynare('hybrid', '-DHYBRID=true', '-DSUBFOLDERNAME="tfp-growth-expected-shock/hybrid"', IRF_SETUP{:})
    end

end


function b = calldynare(subfolder)
    b = false;
    if isempty(LIST_OF_IRF_SHOCKS)
        for j=1:length(LIST_OF_IRF_VARIABLES)
            b = ~isfile(sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/matlab/make.m', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/models/hybrid.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/models/update-database.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j})) || ...
                ismorerecent(sprintf('%s/database/baseline.mat', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_VARIABLES{j}));
            if b
                return
            end
        end
    else
        for i=1:length(LIST_OF_IRF_SHOCKS)
            for j=1:length(LIST_OF_IRF_VARIABLES)
                b = ~isfile(sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/matlab/make.m', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/models/hybrid.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/models/update-database.mod', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j})) || ...
                    ismorerecent(sprintf('%s/database/baseline.mat', ROOT_FOLDER), sprintf('%s/irfs-data/hybrid/%s/%s/%s.dat', ROOT_FOLDER, subfolder, LIST_OF_IRF_SHOCKS{i}, LIST_OF_IRF_VARIABLES{j}));
                if b
                    return
                end
            end
        end
    end
end

end