function db = computeresiduals()

% INPUTS
% - periods            [integer]    scalar, number of periods for the long run simulation.
% - deflateobsindex    [integer]    scalar, index period for the observation used to normalize the simulated data.
%
% OUTPUTS
% none

global M_

% Load database (generated by the ecb-mc package).
db = dseries('../database/data-for-ecb-base.mat');

% Write the backward version of the model
dynare('hybrid', '-DBACKWARD=true', '-DEXOGENIZE_FOREIGN=false', 'savemacro=backward.mod', 'onlymacro', 'notime');

% Preprocess backward model
dynare('backward', 'stochastic', 'fast', 'nopreprocessoroutput', 'notime');

% Set options
options.solve_algo = 14;
options.maxiter = 500;
options.tolx = 1e-8;
options.tolf = 1e-8;
options.simulations_along_bgp = 4;

% Cleanup database (remove unnecessary variables from database).
listofvariables = getlistofvariables();
db = db{listofvariables{:}};

% Compute residuals.
listofvariables = getlistofvariables(M_);

db.U2_STN_ZLB = db.U2_STN;
db.U2_TP_10YEXO = dseries(zeros(db.nobs,1), db.dates(1));
db.U2_TP_10YENDO = db.U2_TP_10Y;
db.U2_GO_COR_EXO = db.U2_GO_COR;
db.U2_A_COD = 100*((db.U2_HH_COD/db.U2_HH_COD(-1))^4-1);
db.U2_FC = dseries(zeros(db.nobs,1), db.dates(1));
db.U2_AUX_GO_COR = dseries(zeros(db.nobs,1), db.dates(1));
db.U2_AUX_WDREX = dseries(zeros(db.nobs,1), db.dates(1));
db.U2_T_PRO_STATIONARY_SHOCK = dseries(ones(db.nobs,1), db.dates(1));

db = solvemodelforresiduals('backward.mod', db{listofvariables{:}}, true);
