// --+ options: json=compute +--

@#define getresiduals = false
@#define plotresiduals = false

/*
** DEFINITION OF THE MODEL TO BE SIMULATED (user input).
*/

@#define BACKWARD = false
@#define EXOGENIZE_FOREIGN = true
//@#define OUTPUT_GAP_AS_DEVIATION_TO_BASELINE = true
//@#define OUTPUT_GAP_AS_DEVIATION_TO_BASELINE_IN_SPREADS = true

@#if !BACKWARD
//@#define DEFAULT_TO_MCE = false
//@#define MCE_IN_EXCHANGE_RATE = true
//@#define EXOGENOUS_EXCHANGE_RATE = true
//@#define EXACT_EXPECTATIONS_10Y = false
//@#define BACKWARD_WITH_UIP = false
//@#define FULL = false
@#define HYBRID = true
//@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
//@#define MCE_IN_FINANCIAL = true
//@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
//@#define MCE_IN_PAC_BUSINESS = false
//@#define MCE_IN_PAC_CONSUMPTION = false
//@#define MCE_IN_PAC_HOUSEPRICE = false
//@#define MCE_IN_PAC_LABOUR = false
//@#define MCE_IN_PAC_PROPERTY_INCOME = false
//@#define MCE_IN_PAC_RESIDENTIAL = false
//@#define MCE_IN_PERMANENT_INCOMES = false
//@#define MCE_IN_WAGE = false
//@#define MCE_IN_WAPRO = false
@#endif

// Set the number of periods for the perfect foresigt solver (should be very large for the model to converge to the BGP)
@#define SimulationPeriods  = 1500


/*
** DO NOT MODIFY THE FOLLOWING LINES...
*/

@#define BUILD_MATLAB_PLOTS = true

@#include "core.mod"

@#include "update-database.mod"

// Check that the baseline is correct
initval_file(series=baseline, first_obs=3);
perfect_foresight_setup(periods=@{SimulationPeriods});
@#if BACKWARD
    perfect_foresight_solver(solve_algo=14);
@#else
    perfect_foresight_solver(stack_solve_algo=0, no_homotopy);
@#endif
Baseline = dseries([transpose(oo_.endo_simul), oo_.exo_simul], 5000Q1, [M_.endo_names; M_.exo_names]);
info = data.projectionsetup_mce({'U2'}, Baseline, 'trial-macroexp.mod');


@#if getresiduals
  // Compute in sample residuals (from the backward model)
  residuals = computeresiduals();

  @#if plotresiduals
    figure()
    subplot(2,4,1), plot(residuals.res_U2_A_YED), title('res_U2_A_YED', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,2), plot(residuals.res_U2_GO_COR), title('res_U2_GO_COR', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,3), plot(residuals.res_U2_SLRN), title('res_U2_SLRN', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,4), plot(residuals.res_U2_STN), title('res_U2_STN', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,5), plot(residuals.res_U2_T_PRO_STATIONARY_SHOCK), title('res_U2_T_PRO_STATIONARY_SHOCK', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,6), plot(residuals.res_U2_US_10Y), title('res_U2_US_10Y', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,7), plot(residuals.res_U2_US_EHIC), title('res_U2_US_EHIC', 'Interpreter', 'none'), box on, axis tight
    subplot(2,4,6), plot(residuals.res_U2_WDREX), title('res_U2_WDREX', 'Interpreter', 'none'), box on, axis tight
    return
  @#endif

  v_res_U2_A_YED = nanmean(residuals.res_U2_A_YED)^2;
  v_res_U2_SLRN = nanmean(residuals.res_U2_SLRN)^2;
  v_res_U2_STN = nanmean(residuals.res_U2_STN)^2;
  v_res_U2_US_10Y = nanmean(residuals.res_U2_US_10Y)^2;
  v_res_U2_US_EHIC = nanmean(residuals.res_U2_US_EHIC)^2;
  v_res_U2_WDREX = nanmean(residuals.res_U2_WDREX)^2;

@#endif


@#if getresiduals
  shocks;
    var res_U2_A_YED = v_res_U2_A_YED;
    // var res_U2_GO_COR = 0.0001;
    var res_U2_SLRN = v_res_U2_SLRN;
    var res_U2_STN = v_res_U2_STN;
    var res_U2_T_PRO_STATIONARY_SHOCK = 0.001;
    var res_U2_US_10Y = v_res_U2_US_10Y;
    var res_U2_US_EHIC = v_res_U2_US_EHIC;
    var res_U2_WDREX = v_res_U2_WDREX;
  end;
@#else
  shocks;
    var res_U2_A_YED = 0.001;
    // var res_U2_GO_COR = 0.0001;
    var res_U2_SLRN = 0.001;
    var res_U2_STN = 0.01;
    var res_U2_T_PRO_STATIONARY_SHOCK = 0.001;
    var res_U2_US_10Y = 0.001;
    var res_U2_US_EHIC = 0.01;
    var res_U2_WDREX = 0.001;
  end;
@#endif

// Baseline defines the BGP along which the simulation is done, info provides
// information about the BGP (how to extend the BGP if need be). Output is a
// dseries object.

[ts, DynareResults] = extended_path([], 100, [], options_, M_, oo_, Baseline, info);

verbatim;
  figure()
  subplot(2,2,1), plot(ts.U2_G_YER.data), title('U2_G_YER', 'Interpreter', 'none'), box on, axis tight
  subplot(2,2,2), plot(ts.U2_A_YED.data), title('U2_A_YED', 'Interpreter', 'none'), box on, axis tight
  subplot(2,2,3), plot(ts.U2_STN.data), title('U2_STN', 'Interpreter', 'none'), box on, axis tight
  subplot(2,2,4), plot(ts.U2_YER.log.data), title('log(U2_YER)', 'Interpreter', 'none'), box on, axis tight
end;
