// --+ options: json=compute +--

@#ifndef BACKWARD
@#define BACKWARD = false
@#endif

@#ifndef FULL
@#define FULL = false
@#endif

@#ifndef HYBRID
@#define HYBRID = false
@#endif

@#ifndef BACKWARD_WITH_UIP
@#define BACKWARD_WITH_UIP = false
@#endif

@#if FULL && BACKWARD
@#error "It makes no sense to use options FULL and BACKWARD simultaneously."
@#endif

@#if FULL && HYBRID
@#error "It makes no sense to use options FULL and HYBRID simultaneously."
@#endif

@#if BACKWARD && HYBRID
@#error "It makes no sense to use options BACkWARD and HYBRID simultaneously."
@#endif

@#if BACKWARD && BACKWARD_WITH_UIP
@#error "It makes no sense to use options BACkWARD and BACKWARD_WITH_UIP simultaneously."
@#endif

@#if HYBRID && BACKWARD_WITH_UIP
@#error "It makes no sense to use options HYBRID and BACKWARD_WITH_UIP simultaneously."
@#endif

@#if FULL && BACKWARD_WITH_UIP
@#error "It makes no sense to use options FULL and BACKWARD_WITH_UIP simultaneously."
@#endif

@#ifndef DEFAULT_TO_MCE
@#if BACKWARD
@#define DEFAULT_TO_MCE = false
@#elseif FULL
@#define DEFAULT_TO_MCE = true
@#elseif HYBRID
@#define DEFAULT_TO_MCE = false
@#elseif BACKWARD_WITH_UIP
@#define DEFAULT_TO_MCE = false
@#else
@#define DEFAULT_TO_MCE = true
@#endif
@#endif

@#echomacrovars BACKWARD
@#echomacrovars BACKWARD_WITH_UIP
@#echomacrovars HYBRID
@#echomacrovars FULL
@#echomacrovars DEFAULT_TO_MCE

@#if HYBRID
@#define MCE_IN_WAPRO = true
@#define MCE_IN_WAGE = true
@#define MCE_IN_FINANCIAL = true
@#define MCE_IN_EXCHANGE_RATE = true
@#endif

@#if BACKWARD_WITH_UIP
@#define MCE_IN_EXCHANGE_RATE = true
@#endif

@#if !BACKWARD

@#if FULL
@#define MCE_IN_WAPRO = true
@#else
@#ifndef MCE_IN_WAPRO
@#if DEFAULT_TO_MCE
@#define MCE_IN_WAPRO = true
@#else
@#define MCE_IN_WAPRO = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_WAGE = true
@#else
@#ifndef MCE_IN_WAGE
@#if DEFAULT_TO_MCE
@#define MCE_IN_WAGE = true
@#else
@#define MCE_IN_WAGE = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PERMANENT_INCOMES = true
@#else
@#ifndef MCE_IN_PERMANENT_INCOMES
@#if DEFAULT_TO_MCE
@#define MCE_IN_PERMANENT_INCOMES = true
@#else
@#define MCE_IN_PERMANENT_INCOMES = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_CONSUMPTION = true
@#else
@#ifndef MCE_IN_PAC_CONSUMPTION
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_CONSUMPTION = true
@#else
@#define MCE_IN_PAC_CONSUMPTION = false
@#endif
@#endif
@#endif

@#if !FULL
@#ifdef MCE_IN_CONSUMPTION
@#if MCE_IN_CONSUMPTION
@#define MCE_IN_PAC_CONSUMPTION = true
@#define MCE_IN_PEMANENT_INCOMES = true
@#else
@#define MCE_IN_PAC_CONSUMPTION = false
@#define MCE_IN_PEMANENT_INCOMES = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_LONG_TERM_INTEREST_RATE = true
@#else
@#ifndef MCE_IN_LONG_TERM_INTEREST_RATE
@#if DEFAULT_TO_MCE
@#define MCE_IN_LONG_TERM_INTEREST_RATE = true
@#else
@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = true
@#else
@#ifndef MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP
@#if DEFAULT_TO_MCE
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = true
@#else
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
@#endif
@#endif
@#endif

@#if !FULL
@#ifdef MCE_IN_FINANCIAL
@#if MCE_IN_FINANCIAL
@#define MCE_IN_LONG_TERM_INTEREST_RATE = true
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = true
@#else
@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_EXCHANGE_RATE = true
@#else
@#ifndef MCE_IN_EXCHANGE_RATE
@#if DEFAULT_TO_MCE
@#define MCE_IN_EXCHANGE_RATE = true
@#else
@#define MCE_IN_EXCHANGE_RATE = false
@#endif
@#endif
@#endif

@#if MCE_IN_EXCHANGE_RATE
@#ifndef EXCHANGE_RATE_WITH_TP
@#define EXCHANGE_RATE_WITH_TP = true
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_BUSINESS = true
@#else
@#ifndef MCE_IN_PAC_BUSINESS
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_BUSINESS = true
@#else
@#define MCE_IN_PAC_BUSINESS = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_HOUSEPRICE = true
@#else
@#ifndef MCE_IN_PAC_HOUSEPRICE
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_HOUSEPRICE = true
@#else
@#define MCE_IN_PAC_HOUSEPRICE = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_PROPERTY_INCOME = true
@#else
@#ifndef MCE_IN_PAC_PROPERTY_INCOME
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_PROPERTY_INCOME = true
@#else
@#define MCE_IN_PAC_PROPERTY_INCOME = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_RESIDENTIAL = true
@#else
@#ifndef MCE_IN_PAC_RESIDENTIAL
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_RESIDENTIAL = true
@#else
@#define MCE_IN_PAC_RESIDENTIAL = false
@#endif
@#endif
@#endif

@#if FULL
@#define MCE_IN_PAC_LABOUR = true
@#else
@#ifndef MCE_IN_PAC_LABOUR
@#if DEFAULT_TO_MCE
@#define MCE_IN_PAC_LABOUR = true
@#else
@#define MCE_IN_PAC_LABOUR = false
@#endif
@#endif
@#endif

@#else

@#define MCE_IN_WAPRO = false
@#define MCE_IN_WAGE = false
@#define MCE_IN_PERMANENT_INCOMES = false
@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
@#define MCE_IN_EXCHANGE_RATE = false
@#define MCE_IN_PAC_CONSUMPTION = false
@#define MCE_IN_PAC_BUSINESS = false
@#define MCE_IN_PAC_HOUSEPRICE = false
@#define MCE_IN_PAC_PROPERTY_INCOME = false
@#define MCE_IN_PAC_RESIDENTIAL = false
@#define MCE_IN_PAC_LABOUR = false

@#endif

@#define U2_T_Y_SIVR_FIX = true

@#ifndef EXACT_EXPECTATIONS_10Y
@#define EXACT_EXPECTATIONS_10Y = false
@#endif

@#ifndef BUILD_IRFS
@#define BUILD_IRFS = false
@#endif

@#ifndef FORWARD_GUIDANCE_PUZZLE
@#define FORWARD_GUIDANCE_PUZZLE = false
@#endif

@#ifndef EXPECTED_PRODUCTIVITY_SHOCK
@#define EXPECTED_PRODUCTIVITY_SHOCK = false
@#endif

@#ifndef BUILD_MATLAB_PLOTS
@#define BUILD_MATLAB_PLOTS = false
@#endif

@#if !BUILD_MATLAB_PLOTS && !BACKWARD
@#ifndef SUBFOLDERNAME
@#error "Definition of SUBFOLDERNAME is missing (required for saving simulation results for PGF plots)."
@#endif
@#endif

var
	U2_A4_YED
	U2_A_C_CEN
	U2_A_C_CER
	U2_A_C_CER_TAR
	U2_A_C_WAN
	U2_A_YED
	U2_A_YED_TAR
	U2_A_YED_VE
	U2_BUSINESS_AUX
	U2_BUSINESS_PAC_PE
	U2_BU_ITD
	U2_BU_ITN
	U2_BU_ITR
	U2_BU_L_ITN
	U2_BU_L_ITR
	U2_BU_OITD
	U2_BU_OITR
	U2_BU_OITR_T
	U2_BU_U_ITR
	U2_BU_Y_ITR
	U2_CB
	U2_CEN
	U2_CMDEX
	U2_CMEDEX
	U2_CMEDEX_AUX
	U2_COE
	U2_CONS_PAC_PE
	U2_CXDEX
	U2_CXEDEX
	U2_CXEDEX_AUX
	U2_C_CEN
	U2_C_CER
	U2_C_CER_TAR
	U2_C_GO_BU_SCN
	U2_C_LNH
	U2_C_WAN
	U2_C_WAR
	U2_DLYHLT
	U2_DL_HH_L_CON
	U2_EENM
	U2_EENX
	U2_EENX_tmp
	U2_EEN_RES
	U2_EEN_RES_C
	U2_EHIC
	U2_EPS_L_U2_T_YER
	U2_ESTN
	U2_ES_RPPD_IHD
	U2_EXR
	U2_GOSMIN
	U2_GO_BU_SCN
	U2_G_A_YED
	U2_G_C_CER
	U2_G_C_CER_VE
	U2_G_HH_S_DIRL
	U2_G_HH_S_DIRP
	U2_G_HH_S_DIRT
	U2_G_HH_S_EDIRL
	U2_G_HH_S_EDIRP
	U2_G_HH_S_EDIRT
	U2_G_HH_S_VDIRL
	U2_G_HH_S_VDIRL_VE
	U2_G_HH_S_VDIRP
	U2_G_HH_S_VDIRP_VE
	U2_G_HH_S_VDIRT
	U2_G_HH_S_VDIRT_VE
	U2_G_HH_Y_DIR
	U2_G_HH_Y_EDIR
	U2_G_HH_Y_VDIR
	U2_G_HH_Y_VDIR_VE
	U2_G_LNN
	U2_G_R_LUN
	U2_G_VYER
	U2_G_VYER_VE
	U2_G_YER
	U2_G_YER_E10Y
    U2_G_YER_E10Y_VE
    @#if MCE_IN_LONG_TERM_INTEREST_RATE
        U2_RFB_E10Y
        U2_RFB_10Y
        U2_RFCB_10Y
    @#endif
    @#if MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP
        TPM_GAP
    @#endif
    U2_HEF
	U2_HEG
	U2_HEX
	U2_HGPDR
	U2_HH_B9N
	U2_HH_B_APN
	U2_HH_B_IRN
	U2_HH_B_KTN
	U2_HH_B_OPPN
	U2_HH_B_SBN
	U2_HH_B_SCN
	U2_HH_CFKN
	U2_HH_COD
	U2_HH_CON
	U2_HH_COR
	U2_HH_C_DDN
	U2_HH_C_DDR
	U2_HH_C_ODDR
	U2_HH_DIN
	U2_HH_DINL
	U2_HH_DINP
	U2_HH_DINT
	U2_HH_DIR
	U2_HH_DIRL
	U2_HH_DIRP
	U2_HH_DIRT
	U2_HH_DTN
	U2_HH_D_IHN
	U2_HH_EDIR
	U2_HH_EDIRL
	U2_HH_EDIRP
	U2_HH_EDIRT
	U2_HH_FWN
	U2_HH_GOS
	U2_HH_GOSMIN
	U2_HH_GSN
	U2_HH_IHD
	U2_HH_IHN
	U2_HH_IHR
	U2_HH_ITN
	U2_HH_IVN
	U2_HH_KFN
	U2_HH_KFNPN
	U2_HH_L_CON
	U2_HH_L_DEP
	U2_HH_L_IHN
	U2_HH_NPN
	U2_HH_OCOD
	U2_HH_OCOR
	U2_HH_OIHD
	U2_HH_OIHR
	U2_HH_SL_CON
	U2_HH_SL_DEP
	U2_HH_SL_IHN
	U2_HH_S_IHD
	U2_HH_TWN
	U2_HH_TWR
	U2_HH_U_IHR
	U2_HH_U_IHR2
	U2_HICP
	U2_HIF
	U2_HOUSEPRICE_PAC_PE
	U2_HWN
	U2_H_HH_S_DIRL
	U2_H_HH_S_DIRP
	U2_H_HH_S_DIRT
	U2_H_HH_Y_DIR
	U2_H_Q_YER
	U2_H_Q_YER400
	U2_IR_TAN
	U2_IR_TLN
	U2_ITD
	U2_ITN
	U2_ITR
	U2_IVR
	U2_LABOUR_PAC_PE
	U2_LEN
	U2_LFN
	U2_LNN
	U2_LRN
	U2_LSN
	U2_MED
	U2_MEED
	U2_MIN
	U2_MND
	U2_MNN
	U2_MNR
	U2_MST
	U2_MTD
	U2_MTN
	U2_MTR
	U2_MXD
	U2_MXDNO
	U2_MXN
	U2_MXR
	U2_MXST
	U2_NFANRV_S
	U2_OHEF
	U2_OHEG
	U2_OHEX
	U2_OIS_10Y
	U2_OLNN
	U2_OLSN
	U2_OS_RPPD
	U2_PCU
	U2_PCU_AUX
	U2_PMNST
	U2_PMXST
	U2_POU
	U2_POU_AUX
	U2_PROPERTY_PAC_PE
	U2_PXXST
	U2_Q16_S_RPPD
	U2_Q_S_RPPD_IHD
	U2_Q_TAU
	U2_Q_T_PRO
	U2_REENX
	U2_RESIDENTIAL_PAC_AUX
	U2_RESIDENTIAL_PAC_PE
	U2_RPPD
	U2_R_LFP
	U2_R_LUN
	U2_SCB
	U2_SCOE
	U2_SIVR
	U2_SKFR
	U2_SKHR
	U2_SLRN
    U2_STN
    U2_STN_ZLB
	U2_STN_E10Y
    U2_STN_E10Y_VE
	U2_S_DTNL
	U2_S_DTNT
	U2_S_GO_COR
	U2_S_RPPD
	U2_S_RPPD_IHD
	U2_TAU
	U2_TIN
    U2_TP_10Y
    U2_TP_10YEXO
    U2_TP_10YENDO
	U2_TREND_MND_AUX
	U2_TREND_MTR_AUX
	U2_TREND_XXD_AUX
	U2_TREND_XXR_AUX
	U2_T_A_C_CEN
	U2_T_BU_Y_Q_ITR
	U2_T_BU_Y_Q_ITR_100
	U2_T_C_LNH
	U2_T_LNN
	U2_T_PRO
	U2_T_Q_YER
	U2_T_Q_YER_100
	U2_T_R_LFP
	U2_T_R_LUN
	U2_T_YER
	U2_T_Y_SIVR
	U2_USTP_10Y
	U2_US_10Y
	U2_US_EHIC
	U2_W0_CEN
	U2_WAN
	U2_WAP
	U2_WAP_ANNUAL_GROWTH
	U2_WDREX
	U2_WER
	U2_WEREX
	U2_XND
	U2_XNN
	U2_XNR
	U2_XTD
	U2_XTN
	U2_XTR
	U2_XXD
	U2_XXN
	U2_XXR
	U2_XXST
	U2_YED
	U2_YEN
	U2_YER
	U2_Y_ITD
	U2_Y_SIVR
	U2_ZHICP
	U2_ZHIF
    U2_dUSTP_10Y
    @#if MCE_IN_PERMANENT_INCOMES
         U2_G_VYERT
         U2_G_VYERT_VE
    @#endif


;

parameters
	ONE
	coeff_one
	ecm_bu_itd
	ecm_hh_cod
	ecm_hh_ihd
	h1_pac_business_eq0_var_AUX_DIFF_206_lag_1
	h1_pac_business_eq0_var_AUX_DIFF_206_lag_2
	h1_pac_business_eq0_var_U2_A_YED_lag_1
	h1_pac_business_eq0_var_U2_A_YED_lag_2
	h1_pac_business_eq0_var_U2_EHIC_lag_1
	h1_pac_business_eq0_var_U2_EHIC_lag_2
	h1_pac_business_eq0_var_U2_ESTN_lag_1
	h1_pac_business_eq0_var_U2_ESTN_lag_2
	h1_pac_business_eq0_var_U2_G_EYER_lag_1
	h1_pac_business_eq0_var_U2_G_EYER_lag_2
	h1_pac_business_eq0_var_U2_G_YER_lag_1
	h1_pac_business_eq0_var_U2_G_YER_lag_2
	h1_pac_business_eq0_var_U2_STN_lag_1
	h1_pac_business_eq0_var_U2_STN_lag_2
	h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_1
	h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_2
	h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_1
	h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_2
	h1_pac_consumption_eq0_var_U2_A_YED_lag_1
	h1_pac_consumption_eq0_var_U2_A_YED_lag_2
	h1_pac_consumption_eq0_var_U2_EHIC_lag_1
	h1_pac_consumption_eq0_var_U2_EHIC_lag_2
	h1_pac_consumption_eq0_var_U2_ESTN_lag_1
	h1_pac_consumption_eq0_var_U2_ESTN_lag_2
	h1_pac_consumption_eq0_var_U2_G_EYER_lag_1
	h1_pac_consumption_eq0_var_U2_G_EYER_lag_2
	h1_pac_consumption_eq0_var_U2_G_YER_lag_1
	h1_pac_consumption_eq0_var_U2_G_YER_lag_2
	h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_1
	h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_2
	h1_pac_consumption_eq0_var_U2_STN_lag_1
	h1_pac_consumption_eq0_var_U2_STN_lag_2
	h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_1
	h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_2
	h1_pac_houseprice_eq0_var_U2_A_YED_lag_1
	h1_pac_houseprice_eq0_var_U2_A_YED_lag_2
	h1_pac_houseprice_eq0_var_U2_EHIC_lag_1
	h1_pac_houseprice_eq0_var_U2_EHIC_lag_2
	h1_pac_houseprice_eq0_var_U2_ESTN_lag_1
	h1_pac_houseprice_eq0_var_U2_ESTN_lag_2
	h1_pac_houseprice_eq0_var_U2_G_EYER_lag_1
	h1_pac_houseprice_eq0_var_U2_G_EYER_lag_2
	h1_pac_houseprice_eq0_var_U2_G_YER_lag_1
	h1_pac_houseprice_eq0_var_U2_G_YER_lag_2
	h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_1
	h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_2
	h1_pac_houseprice_eq0_var_U2_STN_lag_1
	h1_pac_houseprice_eq0_var_U2_STN_lag_2
	h1_pac_labor_eq0_var_AUX_DIFF_258_lag_1
	h1_pac_labor_eq0_var_AUX_DIFF_258_lag_2
	h1_pac_labor_eq0_var_U2_A_YED_lag_1
	h1_pac_labor_eq0_var_U2_A_YED_lag_2
	h1_pac_labor_eq0_var_U2_EHIC_lag_1
	h1_pac_labor_eq0_var_U2_EHIC_lag_2
	h1_pac_labor_eq0_var_U2_ESTN_lag_1
	h1_pac_labor_eq0_var_U2_ESTN_lag_2
	h1_pac_labor_eq0_var_U2_G_EYER_lag_1
	h1_pac_labor_eq0_var_U2_G_EYER_lag_2
	h1_pac_labor_eq0_var_U2_G_YER_lag_1
	h1_pac_labor_eq0_var_U2_G_YER_lag_2
	h1_pac_labor_eq0_var_U2_Q_TAU_lag_1
	h1_pac_labor_eq0_var_U2_Q_TAU_lag_2
	h1_pac_labor_eq0_var_U2_STN_lag_1
	h1_pac_labor_eq0_var_U2_STN_lag_2
	h1_pac_property_eq0_var_AUX_DIFF_295_lag_1
	h1_pac_property_eq0_var_AUX_DIFF_295_lag_2
	h1_pac_property_eq0_var_U2_A_YED_lag_1
	h1_pac_property_eq0_var_U2_A_YED_lag_2
	h1_pac_property_eq0_var_U2_EHIC_lag_1
	h1_pac_property_eq0_var_U2_EHIC_lag_2
	h1_pac_property_eq0_var_U2_ESTN_lag_1
	h1_pac_property_eq0_var_U2_ESTN_lag_2
	h1_pac_property_eq0_var_U2_G_EYER_lag_1
	h1_pac_property_eq0_var_U2_G_EYER_lag_2
	h1_pac_property_eq0_var_U2_G_YER_lag_1
	h1_pac_property_eq0_var_U2_G_YER_lag_2
	h1_pac_property_eq0_var_U2_H_Q_YER400_lag_1
	h1_pac_property_eq0_var_U2_H_Q_YER400_lag_2
	h1_pac_property_eq0_var_U2_STN_lag_1
	h1_pac_property_eq0_var_U2_STN_lag_2
	h1_pac_residential_eq0_var_AUX_DIFF_225_lag_1
	h1_pac_residential_eq0_var_AUX_DIFF_225_lag_2
	h1_pac_residential_eq0_var_U2_A_YED_lag_1
	h1_pac_residential_eq0_var_U2_A_YED_lag_2
	h1_pac_residential_eq0_var_U2_EHIC_lag_1
	h1_pac_residential_eq0_var_U2_EHIC_lag_2
	h1_pac_residential_eq0_var_U2_ESTN_lag_1
	h1_pac_residential_eq0_var_U2_ESTN_lag_2
	h1_pac_residential_eq0_var_U2_G_EYER_lag_1
	h1_pac_residential_eq0_var_U2_G_EYER_lag_2
	h1_pac_residential_eq0_var_U2_G_YER_lag_1
	h1_pac_residential_eq0_var_U2_G_YER_lag_2
	h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_1
	h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_2
	h1_pac_residential_eq0_var_U2_STN_lag_1
	h1_pac_residential_eq0_var_U2_STN_lag_2
	maturity_val
	pac_business_pac_growth_neutrality_correction
	pac_consumption_pac_growth_neutrality_correction
	pac_houseprice_pac_growth_neutrality_correction
	pac_labor_pac_growth_neutrality_correction
	pac_property_pac_growth_neutrality_correction
	pac_residential_pac_growth_neutrality_correction
	u2_alpha
	u2_annual_inflation_rate
	u2_annual_pop_growth_rate
	u2_annual_tfp_growth_rate
	u2_beta_cons_l
	u2_beta_cons_p
	u2_beta_cons_t
	u2_beta_cons_trend
	u2_beta_discount_cons
	u2_beta_hh_c_ddr_trend
	u2_beta_hh_gos_trend
	u2_beta_hh_gos_u2_s_rppd_u2_yen
	u2_beta_hh_gos_u2_skhr_u2_hh_ihd
	u2_beta_houseprice_hh_dir
	u2_beta_houseprice_hh_u_ihr
	u2_beta_residential_trend
	u2_beta_residential_u2_hh_u_ihr2
	u2_beta_residential_u2_s_rppd_ihd
	u2_beta_residential_u2_yer
	u2_bu_itr_pac_u2_bu_itr_L1
	u2_bu_l_itn_u2_cb
	u2_bu_l_itn_u2_coe
	u2_bu_l_itn_u2_lrn
	u2_bu_q_itd_u2_q_yed
	u2_business_aux
	u2_c_houseprice_tar
	u2_c_lnh_a1
	u2_cb_u2_ois_10y
	u2_coe_u2_ois_10y
	u2_coeff_fix
	u2_coeff_one
	u2_con_fix
	u2_cons_tar_const
	u2_dlyhlt
	u2_dummy_trend
	u2_dyn_trade
	u2_ecm_lnh
	u2_ecm_pac_business
	u2_ecm_pac_cons
	u2_ecm_pac_houseprice
	u2_ecm_pac_labor
	u2_ecm_pac_property
	u2_ecm_pac_residential
	u2_ecm_r_lfp
	u2_ecm_sivr
	u2_een_res_L1
	u2_een_res_c
	u2_een_res_c_L1
	u2_eenx_const
	u2_eenx_u2_us_ir
	u2_eenx_u2_yed_cxedex
	u2_gamma_business
	u2_gamma_cons
	u2_hef_ar
	u2_hef_ecm
	u2_hef_u2_yed
	u2_heg_ecm
	u2_heg_med
	u2_heg_med_lag
	u2_hex_ecm
	u2_hex_u2_yed
	u2_hex_u2_yed_lag
	u2_hh_b_irn_u2_L1_u2_yen
	u2_hh_b_irn_u2_hh_l_ihn_u2_hh_l_dep_u2_yen
	u2_hh_b_irn_u2_s_rw_nfan_u2_yen
	u2_hh_b_irn_u2_stn_u2_yen
	u2_hh_b_irn_u2_yen
	u2_hh_c_ddr_const
	u2_hh_c_ddr_u2_hh_c_ddr_L1
	u2_hh_c_ddr_u2_hh_c_ddr_L2
	u2_hh_c_ddr_u2_hh_c_ddr_L3
	u2_hh_cod_u2_mxd
	u2_hh_cod_u2_q_yed
	u2_hh_cor_pac_u2_hh_cor_L1
	u2_hh_cor_pac_u2_hh_dsl_con_lt_10y
	u2_hh_d_ihn_l1
	u2_hh_d_ihn_lr
	u2_hh_ihr_pac_u2_ihr_L1
	u2_hh_ihr_pac_u2_ihr_L2
	u2_hh_ihr_pac_u2_yer_h_q_yer
	u2_hh_l_con_u2_ois_10y
	u2_hh_l_dep_u2_ois_10y
	u2_hh_l_ihn_u2_ois_10y
	u2_hh_ocod_u2_mxd
	u2_hh_q_ihd_u2_q_hh_ihd
	u2_hh_q_ocod_w
	u2_hh_sl_con_L1
	u2_hh_sl_con_constant
	u2_hh_sl_con_u2_g_yer_e10y
	u2_hh_sl_dep_L1
	u2_hh_sl_dep_constant
	u2_hh_sl_dep_u2_g_yer_e10y
	u2_hh_sl_ihn_L1
	u2_hh_sl_ihn_constant
	u2_hh_sl_ihn_u2_g_yer_e10y
	u2_hicp_we
	u2_hicp_wf
	u2_ir_tan_us_10y
	u2_ir_tln_tmp_ir_const
	u2_ir_tln_u2_ois_10y
	u2_lnn_pac_u2_lnn_L1
	u2_lnn_u2_g_yer
	u2_lrn_u2_ois_10y
	u2_lsn_L1
	u2_mnd_cmd
	u2_mnd_ecm
	u2_mnd_lag1
	u2_mnd_med
	u2_mst_c
	u2_mst_param_1
	u2_mst_trend
	u2_mtr_ecm
	u2_mtr_eenx
	u2_mtr_wer
	u2_mx_we
	u2_mxd_cmd
	u2_mxd_ecm
	u2_mxd_mpcom_1
	u2_mxd_mpcom_2
	u2_mxr_c
	u2_mxr_ecm
	u2_mxr_eenx
	u2_mxr_wer
	u2_mxst_c
	u2_mxst_param_1
	u2_mxst_trend
	u2_nfanrv_s_constant
	u2_nfanrv_s_u2_eenx
	u2_nfanrv_s_u2_ir
	u2_nfanrv_s_u2_yed
	u2_nfanrv_s_u2_ywd
	u2_ohef_constant
	u2_oheg_constant
	u2_oheg_trend
	u2_ohex_coeff_1
	u2_ohex_coeff_2
	u2_ohex_constant
	u2_ohex_trend
	u2_oihd_mxd
	u2_oitd_u2_mxd
	u2_olsn_constant
	u2_pmnst_c
	u2_pmnst_param1
	u2_pmnst_trend
	u2_pmxst_c
	u2_pmxst_trend
	u2_pxxst_c
	u2_pxxst_param_1
	u2_pxxst_trend
	u2_r_lfp_a1
	u2_residential_tar_const
	u2_s_c_wer
	u2_s_dtnl_l1
	u2_s_dtnl_lr
	u2_s_dtnt_l1
	u2_s_dtnt_lr
	u2_s_g_wer
	u2_s_i_wer
	u2_s_rppd_pac_u2_s_rppd_L1
	u2_s_x_wer
	u2_scb_L1
	u2_scb_constant
	u2_scb_u2_g_yer_e10y
	u2_scoe_L1
	u2_scoe_constant
	u2_scoe_u2_g_yer_e10y
	u2_sivr_L1
	u2_slrn_L1
	u2_slrn_constant
	u2_slrn_u2_g_yer_e10y
	u2_t_c_lnh_l1
	u2_t_c_lnh_lr
	u2_t_r_lfp_l1
	u2_t_r_lfp_lr
	u2_t_r_lun_l1
	u2_t_r_lun_lr
	u2_tp_10y_L1
	u2_tp_10y_L1_u2_dustp_10y
	u2_tp_10y_constant
	u2_tp_10y_u2_g_yer_e10y
	u2_ustp_10y_constant
	u2_wdrex_u2_yer
	u2_xnn_c
	u2_xnr_c
	u2_xxd_cxd
	u2_xxd_ecm
	u2_xxd_mxd
	u2_xxr_c
	u2_xxr_ecm
	u2_xxr_eenx
	u2_xxr_wdrex
	u2_xxst_c
	u2_xxst_param_1
	u2_xxst_trend
	u2_y_sivr_L1
	u2_y_sivr_u2_t_y_sivr
	u2_yer_u2_bu_itr
	u2_yer_u2_go_cor
	u2_yer_u2_go_itr
	u2_yer_u2_hh_cor
	u2_yer_u2_hh_ihr
	u2_yer_u2_mtr
	u2_yer_u2_sivr_l1
	u2_yer_u2_sivr_l2
	u2_yer_u2_xtr
	var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_1
	var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_1
	var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_1
	var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_1
	var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_1
	var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_0
	var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_1
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_0
	var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_1
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_0
	var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_1
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_0
	var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_1
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_0
	var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_1
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_0
	var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_1
	var_expectation_model_U2_G_YER_CONS_U2_A_YED_0
	var_expectation_model_U2_G_YER_CONS_U2_A_YED_1
	var_expectation_model_U2_G_YER_CONS_U2_EHIC_0
	var_expectation_model_U2_G_YER_CONS_U2_EHIC_1
	var_expectation_model_U2_G_YER_CONS_U2_ESTN_0
	var_expectation_model_U2_G_YER_CONS_U2_ESTN_1
	var_expectation_model_U2_G_YER_CONS_U2_G_EYER_0
	var_expectation_model_U2_G_YER_CONS_U2_G_EYER_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_1
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_0
	var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_1
	var_expectation_model_U2_G_YER_CONS_U2_G_YER_0
	var_expectation_model_U2_G_YER_CONS_U2_G_YER_1
	var_expectation_model_U2_G_YER_CONS_U2_STN_0
	var_expectation_model_U2_G_YER_CONS_U2_STN_1
	var_expectation_model_U2_G_YER_FIN_U2_A_YED_0
	var_expectation_model_U2_G_YER_FIN_U2_A_YED_1
	var_expectation_model_U2_G_YER_FIN_U2_EHIC_0
	var_expectation_model_U2_G_YER_FIN_U2_EHIC_1
	var_expectation_model_U2_G_YER_FIN_U2_ESTN_0
	var_expectation_model_U2_G_YER_FIN_U2_ESTN_1
	var_expectation_model_U2_G_YER_FIN_U2_G_EYER_0
	var_expectation_model_U2_G_YER_FIN_U2_G_EYER_1
	var_expectation_model_U2_G_YER_FIN_U2_G_YER_0
	var_expectation_model_U2_G_YER_FIN_U2_G_YER_1
	var_expectation_model_U2_G_YER_FIN_U2_STN_0
	var_expectation_model_U2_G_YER_FIN_U2_STN_1
	var_expectation_model_U2_STN_FIN_U2_A_YED_0
	var_expectation_model_U2_STN_FIN_U2_A_YED_1
	var_expectation_model_U2_STN_FIN_U2_EHIC_0
	var_expectation_model_U2_STN_FIN_U2_EHIC_1
	var_expectation_model_U2_STN_FIN_U2_ESTN_0
	var_expectation_model_U2_STN_FIN_U2_ESTN_1
	var_expectation_model_U2_STN_FIN_U2_G_EYER_0
	var_expectation_model_U2_STN_FIN_U2_G_EYER_1
	var_expectation_model_U2_STN_FIN_U2_G_YER_0
	var_expectation_model_U2_STN_FIN_U2_G_YER_1
	var_expectation_model_U2_STN_FIN_U2_STN_0
    var_expectation_model_U2_STN_FIN_U2_STN_1
    @#if MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP || MCE_IN_LONG_TERM_INTEREST_RATE
        tauBB
        couponBB
    @#endif
    @#if MCE_IN_PAC_BUSINESS
        u2_beta_discount_business
    @#endif
    @#if MCE_IN_PAC_HOUSEPRICE
        u2_beta_discount_houseprice
    @#endif
    @#if MCE_IN_PAC_PROPERTY_INCOME
        u2_beta_discount_property
    @#endif
    @#if MCE_IN_PAC_RESIDENTIAL
        u2_beta_discount_residential
    @#endif
    @#if MCE_IN_PAC_LABOUR
        u2_beta_discount_labour
    @#endif
;

//+ CALIBRATION +
h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_1 = 0.1626544491047876;
h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_2 = 0.1411406102889175;
h1_pac_consumption_eq0_var_U2_A_YED_lag_1 = -0.0009767161856845347;
h1_pac_consumption_eq0_var_U2_A_YED_lag_2 = 0.001035253972160412;
h1_pac_consumption_eq0_var_U2_EHIC_lag_1 = -5.853778647587727e-05;
h1_pac_consumption_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_consumption_eq0_var_U2_ESTN_lag_1 = 0.0007560045818219346;
h1_pac_consumption_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_consumption_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_consumption_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_consumption_eq0_var_U2_G_YER_lag_1 = 0.003111608700783614;
h1_pac_consumption_eq0_var_U2_G_YER_lag_2 = -0.002292007628334399;
h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_1 = -0.0506446184048179;
h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_2 = 0;
h1_pac_consumption_eq0_var_U2_STN_lag_1 = -0.001433750299287091;
h1_pac_consumption_eq0_var_U2_STN_lag_2 = 0.0006777457174651564;
pac_consumption_pac_growth_neutrality_correction = -0.04320074593116019;
u2_beta_cons_l = 0.6991451882083289;
u2_beta_cons_p = 0.2009052592813653;
u2_beta_cons_t = 0.05932990110065055;
u2_beta_cons_trend = 0.0001349901172762192;
u2_beta_discount_cons = 0.9306048591021;
u2_con_fix = 1;
u2_cons_tar_const = 0.4105308376308755;
u2_dlyhlt = 1;
u2_ecm_pac_cons = 0.5022770381375605;
u2_gamma_cons = 0.3366398228996337;
u2_hh_cor_pac_u2_hh_cor_L1 = 0.875178838533221;
u2_hh_cor_pac_u2_hh_dsl_con_lt_10y = -0.002;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_0 = -0.105391383441344;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_1 = -0.1056755895009623;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_0 = 0.2110669729423061;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_1 = -1.387778780781446e-17;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_0 = -0.1465446413349779;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_1 = 1.040834085586084e-17;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_0 = 3.379919953386898;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_1 = 0.3666759280698042;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_0 = -1.110223024625157e-16;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_1 = -3.669217271798764e-17;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_0 = -0.6563684635995903;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_1 = -0.1635579332958289;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_0 = 0.201374105931605;
var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_1 = -0.05482946459662655;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_0 = 1.727655222780228;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_1 = 1.024174349595429;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_0 = -2.751829572375656;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_0 = 3.853676938352221;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_0 = 4.009525851898427;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_1 = 0.2505531453596666;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_0 = 0.6833914509675744;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_1 = -2.073160019585531;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_0 = -3.628593448676582;
var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_1 = -0.2250834896756469;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_0 = -1.022150656798502;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_1 = -0.3678179028440636;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_0 = 1.389968559642564;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_0 = -1.040657229799257;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_1 = 8.326672684688674e-17;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_0 = 2.220446049250313e-16;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_1 = 7.338434543597527e-17;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_0 = 4.634891942902629;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_1 = -0.06426477645486095;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_0 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_1 = 0;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_0 = 1.78372484283864;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_1 = 2.458452166827488;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_0 = 1.232853982153528;
var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_1 = -0.1921967523542665;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_0 = -0.4662981083953578;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_1 = -0.1148020123374076;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_0 = 0.5811001207327648;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_1 = -2.081668171172169e-17;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_0 = 0.4069684552840799;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_1 = -3.469446951953614e-18;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_0 = 2.220446049250313e-16;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_1 = 7.338434543597527e-17;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_0 = 3.577880960493497;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_1 = 0.5368810911845403;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_0 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_1 = 0;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_0 = 1.241050684017676;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_1 = 1.746624871260591;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_0 = 0.2726470497081928;
var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_1 = -0.6796155049922714;
var_expectation_model_U2_G_YER_CONS_U2_A_YED_0 = 0.1257466558601055;
var_expectation_model_U2_G_YER_CONS_U2_A_YED_1 = -0.2052896502071984;
var_expectation_model_U2_G_YER_CONS_U2_EHIC_0 = 0.07954299434709156;
var_expectation_model_U2_G_YER_CONS_U2_EHIC_1 = -7.806255641895632e-17;
var_expectation_model_U2_G_YER_CONS_U2_ESTN_0 = 2.537773185360116;
var_expectation_model_U2_G_YER_CONS_U2_ESTN_1 = 3.885780586188048e-16;
var_expectation_model_U2_G_YER_CONS_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_0 = -4.440892098500626e-16;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_1 = -1.467686908719505e-16;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_0 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_1 = 0;
var_expectation_model_U2_G_YER_CONS_U2_G_YER_0 = 9.149337513104561;
var_expectation_model_U2_G_YER_CONS_U2_G_YER_1 = -2.563650530763917;
var_expectation_model_U2_G_YER_CONS_U2_STN_0 = -3.432559183573049;
var_expectation_model_U2_G_YER_CONS_U2_STN_1 = 0.8947859982129225;
u2_s_dtnl_l1 = 0.9;
u2_s_dtnl_lr = 0.6106553196567571;
u2_s_dtnt_l1 = 0.9;
u2_s_dtnt_lr = 0.1189275517835356;
h1_pac_business_eq0_var_AUX_DIFF_206_lag_1 = -0.003397777745781906;
h1_pac_business_eq0_var_AUX_DIFF_206_lag_2 = -0.01752977122304158;
h1_pac_business_eq0_var_U2_A_YED_lag_1 = 0.001117177261335133;
h1_pac_business_eq0_var_U2_A_YED_lag_2 = 0.0005217144350858528;
h1_pac_business_eq0_var_U2_EHIC_lag_1 = -0.001638891696420984;
h1_pac_business_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_business_eq0_var_U2_ESTN_lag_1 = -0.001973448938017126;
h1_pac_business_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_business_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_business_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_business_eq0_var_U2_G_YER_lag_1 = -0.0057637479892332;
h1_pac_business_eq0_var_U2_G_YER_lag_2 = 0.002441394944903822;
h1_pac_business_eq0_var_U2_STN_lag_1 = -0.00105158596793514;
h1_pac_business_eq0_var_U2_STN_lag_2 = 0.003025034905952263;
h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_1 = 0.9423900018532613;
h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_2 = 0;
pac_business_pac_growth_neutrality_correction = 0.04356093764881985;
u2_bu_itr_pac_u2_bu_itr_L1 = -0.008584328182077584;
u2_business_aux = 1;
u2_ecm_pac_business = 0.1766379471202974;
u2_gamma_business = 0.5;
u2_yer_u2_bu_itr = 0.11299;
u2_yer_u2_go_cor = 0.22614;
u2_yer_u2_go_itr = 0.02846;
u2_yer_u2_hh_cor = 0.5311499999999998;
u2_yer_u2_hh_ihr = 0.05411;
u2_yer_u2_mtr = -0.36522;
u2_yer_u2_sivr_l1 = 0.40051;
u2_yer_u2_sivr_l2 = -0.40207;
u2_yer_u2_xtr = 0.41393;
u2_alpha = 0.33;
u2_annual_tfp_growth_rate = 1.2;
u2_een_res_L1 = 0.9479043059244708;
u2_een_res_c = -0.01215218728994713;
u2_een_res_c_L1 = 0.9;
u2_eenx_const = -0.1742532620287895;
u2_eenx_u2_us_ir = 0.09308879286069492;
u2_eenx_u2_yed_cxedex = 1;
coeff_one = 1;
h1_pac_property_eq0_var_AUX_DIFF_295_lag_1 = -0.02416745312969909;
h1_pac_property_eq0_var_AUX_DIFF_295_lag_2 = -0.01489260896639229;
h1_pac_property_eq0_var_U2_A_YED_lag_1 = 0.001513532590376892;
h1_pac_property_eq0_var_U2_A_YED_lag_2 = 0.0004047792890013905;
h1_pac_property_eq0_var_U2_EHIC_lag_1 = -0.001918311879378281;
h1_pac_property_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_property_eq0_var_U2_ESTN_lag_1 = 0.001888138658475421;
h1_pac_property_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_property_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_property_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_property_eq0_var_U2_G_YER_lag_1 = 0.0006428199013192434;
h1_pac_property_eq0_var_U2_G_YER_lag_2 = -0.0006320319531211064;
h1_pac_property_eq0_var_U2_H_Q_YER400_lag_1 = 0.9136958750383219;
h1_pac_property_eq0_var_U2_H_Q_YER400_lag_2 = 0;
h1_pac_property_eq0_var_U2_STN_lag_1 = -0.001920579288707786;
h1_pac_property_eq0_var_U2_STN_lag_2 = 3.244063023236392e-05;
pac_property_pac_growth_neutrality_correction = 0.2938886162633311;
u2_annual_inflation_rate = 1.9;
u2_annual_pop_growth_rate = 0.790513833992;
u2_annual_tfp_growth_rate = 1.2;
u2_beta_hh_c_ddr_trend = -0.001248571245100189;
u2_beta_hh_gos_trend = -1.853885679438964e-05;
u2_beta_hh_gos_u2_s_rppd_u2_yen = 0.008557886895862845;
u2_beta_hh_gos_u2_skhr_u2_hh_ihd = 0.006774986647929528;
u2_ecm_pac_property = 0.2107756897967211;
u2_hh_b_irn_u2_L1_u2_yen = 0.9706682041339405;
u2_hh_b_irn_u2_hh_l_ihn_u2_hh_l_dep_u2_yen = 0.0003888538394079958;
u2_hh_b_irn_u2_s_rw_nfan_u2_yen = -0.01976522819998291;
u2_hh_b_irn_u2_stn_u2_yen = 0.0001059080778398501;
u2_hh_b_irn_u2_yen = 0.0006105411536135125;
u2_hh_c_ddr_const = -1.05734503371137;
u2_hh_c_ddr_u2_hh_c_ddr_L1 = -0.1763706266428059;
u2_hh_c_ddr_u2_hh_c_ddr_L2 = 0.004303479961518106;
u2_hh_c_ddr_u2_hh_c_ddr_L3 = 0.003542717475725999;
u2_wdrex_u2_yer = 0.0399981884057971;
ecm_bu_itd = -0.1161968689987536;
ecm_hh_cod = -0.015531;
ecm_hh_ihd = -0.07941298456456367;
u2_bu_q_itd_u2_q_yed = 0.7040730340091352;
u2_hh_cod_u2_mxd = 0.11257;
u2_hh_cod_u2_q_yed = 0.54525;
u2_hh_ocod_u2_mxd = 0.018739;
u2_hh_q_ihd_u2_q_hh_ihd = 0.4427584951825363;
u2_oihd_mxd = 0.1306810952985882;
u2_oitd_u2_mxd = 0.06055475007398857;
u2_annual_inflation_rate = 1.9;
u2_annual_pop_growth_rate = 0.790513833992;
u2_annual_tfp_growth_rate = 1.2;
u2_hh_d_ihn_l1 = 0.9;
u2_hh_d_ihn_lr = 0.0042133803233958;
h1_pac_residential_eq0_var_AUX_DIFF_225_lag_1 = 0.1315823416826039;
h1_pac_residential_eq0_var_AUX_DIFF_225_lag_2 = 0.03751298067543845;
h1_pac_residential_eq0_var_U2_A_YED_lag_1 = 0.0005725457659237382;
h1_pac_residential_eq0_var_U2_A_YED_lag_2 = 0.0001549419761844304;
h1_pac_residential_eq0_var_U2_EHIC_lag_1 = -0.0007274877421081661;
h1_pac_residential_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_residential_eq0_var_U2_ESTN_lag_1 = -0.0002653736851006692;
h1_pac_residential_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_residential_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_residential_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_residential_eq0_var_U2_G_YER_lag_1 = -0.001613144048596592;
h1_pac_residential_eq0_var_U2_G_YER_lag_2 = 0.001070630939302435;
h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_1 = 0.2895342239120594;
h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_2 = 0;
h1_pac_residential_eq0_var_U2_STN_lag_1 = 0.0004522555771897842;
h1_pac_residential_eq0_var_U2_STN_lag_2 = -0.0001868818920891144;
pac_residential_pac_growth_neutrality_correction = 0.1426802194038418;
u2_beta_residential_trend = -0.006076734642393596;
u2_beta_residential_u2_hh_u_ihr2 = -0.1555292519409732;
u2_beta_residential_u2_s_rppd_ihd = -1.003572290626816;
u2_beta_residential_u2_yer = 0.9999999996840084;
u2_ecm_pac_residential = 0.03169488674412724;
u2_hh_ihr_pac_u2_ihr_L1 = 0.1333731134561249;
u2_hh_ihr_pac_u2_ihr_L2 = 0.2653171208699308;
u2_hh_ihr_pac_u2_yer_h_q_yer = 1.161073139499928;
u2_residential_tar_const = -1.979555136658838;
coeff_one = 1;
h1_pac_labor_eq0_var_AUX_DIFF_258_lag_1 = 0.03283627373211083;
h1_pac_labor_eq0_var_AUX_DIFF_258_lag_2 = 0.01485707250170619;
h1_pac_labor_eq0_var_U2_A_YED_lag_1 = -8.903812361071903e-06;
h1_pac_labor_eq0_var_U2_A_YED_lag_2 = -4.038081056465092e-06;
h1_pac_labor_eq0_var_U2_EHIC_lag_1 = 1.294189341753701e-05;
h1_pac_labor_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_labor_eq0_var_U2_ESTN_lag_1 = 4.578227387171288e-05;
h1_pac_labor_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_labor_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_labor_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_labor_eq0_var_U2_G_YER_lag_1 = 1.134173150895247e-05;
h1_pac_labor_eq0_var_U2_G_YER_lag_2 = 1.042666411185786e-05;
h1_pac_labor_eq0_var_U2_Q_TAU_lag_1 = 0.1065581267337813;
h1_pac_labor_eq0_var_U2_Q_TAU_lag_2 = 0;
h1_pac_labor_eq0_var_U2_STN_lag_1 = -5.930199051189519e-05;
h1_pac_labor_eq0_var_U2_STN_lag_2 = 1.351971664018193e-05;
pac_labor_pac_growth_neutrality_correction = 0.1341382779656271;
u2_c_lnh_a1 = 0.002828999313911175;
u2_ecm_lnh = 0.09070621710425592;
u2_ecm_pac_labor = 0.01505375154351507;
u2_ecm_r_lfp = 0.0709203032156341;
u2_lnn_pac_u2_lnn_L1 = 0.7116102490667757;
u2_lnn_u2_g_yer = 0.001589881433272481;
u2_lsn_L1 = -0.0192821714301598;
u2_olsn_constant = -1.878849506783135;
u2_r_lfp_a1 = 0.2274761297457347;
u2_annual_pop_growth_rate = 0.790513833992;
u2_t_c_lnh_l1 = 0.9;
u2_t_c_lnh_lr = 405.8383625643807;
u2_t_r_lfp_l1 = 0.9;
u2_t_r_lfp_lr = 49.34514860853642;
u2_t_r_lun_l1 = 0.9;
u2_t_r_lun_lr = 8.703655132214706;
u2_coeff_fix = 0.2;
u2_coeff_one = 1;
u2_dummy_trend = -0.01368253441099765;
u2_dyn_trade = 1;
u2_mnd_cmd = 0.07744431351051941;
u2_mnd_ecm = -0.1127302747917438;
u2_mnd_lag1 = -0.1045193628155758;
u2_mnd_med = 0.03455767055041391;
u2_mst_c = 0.2459747662968283;
u2_mst_param_1 = -1;
u2_mst_trend = 0.001369009726305442;
u2_mtr_ecm = -0.08419721338723545;
u2_mtr_eenx = -0.1186941191281308;
u2_mtr_wer = 1.693869911749506;
u2_mxd_cmd = 0.317228967719528;
u2_mxd_ecm = -0.0435407813947217;
u2_mxd_mpcom_1 = 0.0961358099745328;
u2_mxd_mpcom_2 = 0.03796859805500564;
u2_mxr_c = 0;
u2_mxr_ecm = -0.07018588940491166;
u2_mxr_eenx = -0.1039204248821929;
u2_mxr_wer = 1.552076190886355;
u2_mxst_c = -0.3831397398945449;
u2_mxst_param_1 = -1;
u2_mxst_trend = 0.001928189419940012;
u2_pmnst_c = 0.1083323885029303;
u2_pmnst_param1 = 0.7345218627158596;
u2_pmnst_trend = -0.001552564566334625;
u2_pmxst_c = 0.3629125154173661;
u2_pmxst_trend = -0.001694526204804665;
u2_pxxst_c = 0.1831796741578246;
u2_pxxst_param_1 = 0.7166252095682315;
u2_pxxst_trend = -0.0007733547969392856;
u2_s_x_wer = 0.3106814933;
u2_xnn_c = 0;
u2_xnr_c = 0;
u2_xxd_cxd = 0.1186081227093066;
u2_xxd_ecm = -0.08137464832117147;
u2_xxd_mxd = 0.2252620083769389;
u2_xxr_c = 0;
u2_xxr_ecm = -0.07201394038261259;
u2_xxr_eenx = 0.1972608096434295;
u2_xxr_wdrex = 0.8921649406599937;
u2_xxst_c = 1.862386409102766;
u2_xxst_param_1 = -0.4307417140438313;
u2_xxst_trend = -0.001293208085651054;
u2_s_c_wer = 0.1637755003;
u2_s_g_wer = 0.076468481;
u2_s_i_wer = 0.2397857757;
u2_s_x_wer = 0.3106814933;
ONE = 1;
u2_hef_ar = 0.7151746843996657;
u2_hef_ecm = -0.02726160985237678;
u2_hef_u2_yed = 0.1561704391744786;
u2_heg_ecm = -0.02725918225645978;
u2_heg_med = 0.1979686438836532;
u2_heg_med_lag = 0.03666490567878262;
u2_hex_ecm = -0.11139941731822;
u2_hex_u2_yed = 0.4481662954263854;
u2_hex_u2_yed_lag = 0.2331215293968017;
u2_hh_q_ocod_w = 0.16378;
u2_ohef_constant = -0.01551437229906661;
u2_oheg_constant = 0.5552066313984161;
u2_oheg_trend = -0.004070166814548576;
u2_ohex_coeff_1 = 0.779919053766634;
u2_ohex_coeff_2 = 0.220080946233366;
u2_ohex_constant = -0.1734573778823593;
u2_ohex_trend = 0.0003976843504373667;
u2_hicp_we = 0.094682273;
u2_hicp_wf = 0.199243182;
u2_mx_we = 0.094573;
u2_annual_inflation_rate = 1.9;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_0 = 0.01282461053511436;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_1 = 0.02041981707255808;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_0 = -0.03324442760767245;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_1 = 0;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_0 = 0.1176475520718259;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_1 = 0;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_0 = 1.057101679219504;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_1 = -0.1657944384396904;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_0 = -0.002742053485758693;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_1 = 0.01272390531073551;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_0 = -0.1340426607830048;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_1 = 0.01639510871117892;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_0 = 0;
var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_1 = 0;
u2_alpha = 0.33;
var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_0 = 0.4902010913914016;
var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_1 = 0.1175269195313936;
var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_0 = 0.3922719890772049;
var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_1 = 0;
var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_0 = 0.1097362638917046;
var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_1 = 0;
var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_0 = 0;
var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_1 = 0;
var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_0 = 0.1546661615871122;
var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_1 = 0.05067247123083027;
var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_0 = -0.1342919751688975;
var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_1 = 0.02455571127719285;
u2_annual_inflation_rate = 1.9;
u2_ecm_sivr = 0.1322740474728449;
u2_sivr_L1 = 0.8706719941089264;
u2_y_sivr_L1 = 1;
u2_y_sivr_u2_t_y_sivr = 0.005;
h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_1 = 0.01433645075000456;
h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_2 = 0.0007969539425469557;
h1_pac_houseprice_eq0_var_U2_A_YED_lag_1 = -2.438969670947952e-05;
h1_pac_houseprice_eq0_var_U2_A_YED_lag_2 = -5.38614937591595e-05;
h1_pac_houseprice_eq0_var_U2_EHIC_lag_1 = 7.825119046863916e-05;
h1_pac_houseprice_eq0_var_U2_EHIC_lag_2 = 0;
h1_pac_houseprice_eq0_var_U2_ESTN_lag_1 = 0.0004888665679276965;
h1_pac_houseprice_eq0_var_U2_ESTN_lag_2 = 0;
h1_pac_houseprice_eq0_var_U2_G_EYER_lag_1 = 0;
h1_pac_houseprice_eq0_var_U2_G_EYER_lag_2 = 0;
h1_pac_houseprice_eq0_var_U2_G_YER_lag_1 = -0.0005867883372765559;
h1_pac_houseprice_eq0_var_U2_G_YER_lag_2 = 0.0006554454529916083;
h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_1 = 0;
h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_2 = 0;
h1_pac_houseprice_eq0_var_U2_STN_lag_1 = -0.0004526860363022037;
h1_pac_houseprice_eq0_var_U2_STN_lag_2 = -3.618053162549428e-05;
pac_houseprice_pac_growth_neutrality_correction = 0.02599671358693034;
u2_beta_houseprice_hh_dir = 0.9965621269554436;
u2_beta_houseprice_hh_u_ihr = -1.001013285509037;
u2_c_houseprice_tar = 5.298598372253582;
u2_ecm_pac_houseprice = 0.02390527963023737;
u2_s_rppd_pac_u2_s_rppd_L1 = 0.7263407939190563;
coeff_one = 1;
maturity_val = 39;
u2_annual_inflation_rate = 1.9;
u2_cb_u2_ois_10y = 0.5743008970220413;
u2_coe_u2_ois_10y = 0.7727131832320768;
u2_hh_l_con_u2_ois_10y = 0.6057062933702294;
u2_hh_l_dep_u2_ois_10y = 0.264956180770732;
u2_hh_l_ihn_u2_ois_10y = 0.5474576013731445;
u2_hh_sl_con_L1 = 0.8404123777893794;
u2_hh_sl_con_constant = 0.8018401470053671;
u2_hh_sl_con_u2_g_yer_e10y = -0.3915440477903044;
u2_hh_sl_dep_L1 = 0.95647839527672;
u2_hh_sl_dep_constant = 0.01778988450589232;
u2_hh_sl_dep_u2_g_yer_e10y = -0.06701668841075537;
u2_hh_sl_ihn_L1 = 0.8586394235581211;
u2_hh_sl_ihn_constant = 0.1998754288339481;
u2_hh_sl_ihn_u2_g_yer_e10y = -0.2046018491061455;
u2_ir_tan_us_10y = 0.2068263006494447;
u2_ir_tln_tmp_ir_const = 3.2;
u2_ir_tln_u2_ois_10y = 0.11706673652786;
u2_lrn_u2_ois_10y = 0.2142127946530265;
u2_nfanrv_s_constant = -0.03184857916612642;
u2_nfanrv_s_u2_eenx = 0.1781241687520116;
u2_nfanrv_s_u2_ir = 0.2298162025755681;
u2_nfanrv_s_u2_yed = 0.2583163896756261;
u2_nfanrv_s_u2_ywd = -1.029936236912812;
u2_scb_L1 = 0.8817520180090289;
u2_scb_constant = 0.1095622907831893;
u2_scb_u2_g_yer_e10y = -0.03431704523407826;
u2_scoe_L1 = 0.894745774953364;
u2_scoe_constant = 0.6725185933806731;
u2_scoe_u2_g_yer_e10y = -0.3634010914056551;
u2_slrn_L1 = 0.9409064774472824;
u2_slrn_constant = 0.08137631039689046;
u2_slrn_u2_g_yer_e10y = -0.1171763854256536;
u2_tp_10y_L1 = 0.8850337214827472;
u2_tp_10y_L1_u2_dustp_10y = 0.1063613587503521;
u2_tp_10y_constant = 0.06481094073768887;
u2_tp_10y_u2_g_yer_e10y = -0.1865669809254386;
u2_ustp_10y_constant = 0.07934333333333328;
var_expectation_model_U2_G_YER_FIN_U2_A_YED_0 = -0.07993927441249926;
var_expectation_model_U2_G_YER_FIN_U2_A_YED_1 = -0.3962603073466723;
var_expectation_model_U2_G_YER_FIN_U2_EHIC_0 = 0.4761995817591726;
var_expectation_model_U2_G_YER_FIN_U2_EHIC_1 = 0;
var_expectation_model_U2_G_YER_FIN_U2_ESTN_0 = 5.864222285915325;
var_expectation_model_U2_G_YER_FIN_U2_ESTN_1 = 0;
var_expectation_model_U2_G_YER_FIN_U2_G_EYER_0 = 0;
var_expectation_model_U2_G_YER_FIN_U2_G_EYER_1 = 0;
var_expectation_model_U2_G_YER_FIN_U2_G_YER_0 = 12.76014248173341;
var_expectation_model_U2_G_YER_FIN_U2_G_YER_1 = -3.097162173413724;
var_expectation_model_U2_G_YER_FIN_U2_STN_0 = -7.516915873021729;
var_expectation_model_U2_G_YER_FIN_U2_STN_1 = 1.652693587106389;
var_expectation_model_U2_STN_FIN_U2_A_YED_0 = 0.8710641564650008;
var_expectation_model_U2_STN_FIN_U2_A_YED_1 = 0.03663901974383173;
var_expectation_model_U2_STN_FIN_U2_EHIC_0 = -0.9077031762088323;
var_expectation_model_U2_STN_FIN_U2_EHIC_1 = 0;
var_expectation_model_U2_STN_FIN_U2_ESTN_0 = 35.071033331672;
var_expectation_model_U2_STN_FIN_U2_ESTN_1 = 0;
var_expectation_model_U2_STN_FIN_U2_G_EYER_0 = 0;
var_expectation_model_U2_STN_FIN_U2_G_EYER_1 = 0;
var_expectation_model_U2_STN_FIN_U2_G_YER_0 = 9.651894074282737;
var_expectation_model_U2_STN_FIN_U2_G_YER_1 = -5.275279337032956;
var_expectation_model_U2_STN_FIN_U2_STN_0 = 4.883243052530442;
var_expectation_model_U2_STN_FIN_U2_STN_1 = 0.04572361579757486;
u2_bu_l_itn_u2_cb = 0.073313141;
u2_bu_l_itn_u2_coe = 0.346519836;
u2_bu_l_itn_u2_lrn = 0.580167022;
@#if MCE_IN_LONG_TERM_INTEREST_RATE || MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP
    gov_consol_duration=1+maturity_val;
    betta= (1+3.2/100)^0.25;
    tauBB = 1 - 1/betta*(1-1/gov_consol_duration);
    couponBB = (1+3.2/100)^0.25 + tauBB-1; //which normally implies that U2_RFB_E10Y = 1
@#endif
@#if MCE_IN_PAC_BUSINESS
    u2_beta_discount_business = 0.98;
@#endif
@#if MCE_IN_PAC_HOUSEPRICE
    u2_beta_discount_houseprice = 0.98;
@#endif
@#if MCE_IN_PAC_PROPERTY_INCOME
    u2_beta_discount_property = 0.9306048591021;
@#endif
@#if MCE_IN_PAC_RESIDENTIAL
    u2_beta_discount_residential = 0.98;
@#endif
@#if MCE_IN_PAC_LABOUR
    u2_beta_discount_labour = 0.9306048591021;
@#endif
//- CALIBRATION -

varexo
	DYN_H_HICP
	DYN_H_TRADE
	U2_BU_D_ITR
	U2_BU_S_DTN
	U2_BU_Y_MIBR
	U2_DUMMY_TREND
	U2_D_IHR
	U2_D_ITR
	U2_GO_BU_R_SCN
	U2_GO_CON
	U2_GO_COR
	U2_GO_HH_DTN
	U2_GO_ITN
	U2_GO_ITR
	U2_GO_SBCN
	U2_GO_SCN
	U2_GO_TIN
	U2_G_EYER
	U2_IR_TAN_RV
	U2_IR_TLN_RV
	U2_OS_RPPD_T
	U2_S_RW_NFAN
	U2_S_SCNL
	U2_S_SCNT
	U2_S_TIH
	U2_TREND_OHEG
	U2_TREND_OHEX
	U2_TTREND
	U2_T_G_C_CER
	U2_YWD
	dummy_long_run
	dummy_long_run_EENX
	res_U2_A_YED
	res_U2_BU_ITD_tmp
	res_U2_BU_ITR
	res_U2_BU_Q_ITD
	res_U2_CB
	res_U2_CMDEX
	res_U2_CMEDEX
	res_U2_COE
	res_U2_CXEDEX
	res_U2_C_LNH
	res_U2_EENM
	res_U2_EENX
	res_U2_EENX_tmp
	res_U2_EEN_RES
	res_U2_EEN_RES_C
	res_U2_EHIC
	res_U2_ESTN
	res_U2_EXR
	res_U2_GOSMIN
	res_U2_G_C_CER
	res_U2_HEF
	res_U2_HEG
	res_U2_HEX
	res_U2_HGPDR
	res_U2_HH_B_APN
	res_U2_HH_B_IRN
	res_U2_HH_B_KTN
	res_U2_HH_B_OPPN
	res_U2_HH_B_SBN
	res_U2_HH_B_SCN
	res_U2_HH_COD_tmp
	res_U2_HH_COR
	res_U2_HH_COR_tmp
	res_U2_HH_C_DDR
	res_U2_HH_C_DDR_tmp
	res_U2_HH_DTN
	res_U2_HH_D_IHN
	res_U2_HH_FWN
	res_U2_HH_GOS
	res_U2_HH_IHD_tmp
	res_U2_HH_IHR
	res_U2_HH_ITN
	res_U2_HH_IVN
	res_U2_HH_L_CON
	res_U2_HH_L_DEP
	res_U2_HH_L_IHN
	res_U2_HH_NPN
	res_U2_HH_OIHR
	res_U2_HH_Q_COD
	res_U2_HH_Q_IHD
	res_U2_HH_SL_CON
	res_U2_HH_SL_DEP
	res_U2_HH_SL_IHN
	res_U2_HWN
	res_U2_H_HH_S_DIRL
	res_U2_H_HH_S_DIRP
	res_U2_H_HH_S_DIRT
	res_U2_H_HH_Y_DIR
	res_U2_H_Q_YER
	res_U2_LNN
	res_U2_LRN
	res_U2_LSN
	res_U2_MIN
	res_U2_MND
	res_U2_MTR
	res_U2_MXD
	res_U2_MXR
	res_U2_NFANRV_S
	res_U2_PCU
	res_U2_POU
	res_U2_Q_T_PRO
	res_U2_R_LFP
	res_U2_SCB
	res_U2_SCOE
	res_U2_SIVR
	res_U2_SLRN
	res_U2_STN
	res_U2_S_DTNL
	res_U2_S_DTNT
	res_U2_S_ORPPD
	res_U2_S_RPPD
	res_U2_TAU
	res_U2_TIN
    res_U2_TP_10Y
    res_U2_TP_10YENDO
	res_U2_TREND_MND_AUX
	res_U2_TREND_MTR_AUX
	res_U2_TREND_XXD_AUX
	res_U2_TREND_XXR_AUX
	res_U2_T_BU_Y_Q_ITR
	res_U2_T_C_LNH
	res_U2_T_R_LFP
	res_U2_T_R_LUN
	res_U2_T_Y_SIVR
	res_U2_USTP_10Y
	res_U2_US_10Y
	res_U2_US_EHIC
	res_U2_W0_CEN
	res_U2_WAP_ANNUAL_GROWTH
	res_U2_WDREX
	res_U2_XNN
	res_U2_XNR
	res_U2_XXD
	res_U2_XXR
	res_U2_YER
	res_U2_ZHICP
	res_U2_ZHIF
;

@#if MCE_IN_PAC_CONSUMPTION
    pac_model(discount=u2_beta_discount_cons, model_name=pac_consumption, growth = U2_H_Q_YER400(-1), steady_state_growth=0.00496293157320360);
@#endif

@#if MCE_IN_PAC_BUSINESS
    pac_model(discount=u2_beta_discount_business, model_name=pac_business, growth = U2_BU_OITR_T(-1), steady_state_growth=0.00496293157320360);
@#endif

@#if MCE_IN_PAC_HOUSEPRICE
    pac_model(discount=u2_beta_discount_houseprice, model_name=pac_houseprice, growth = U2_OS_RPPD_T, steady_state_growth=0.00496293157320360);
@#endif

@#if MCE_IN_PAC_PROPERTY_INCOME
    pac_model(discount=u2_beta_discount_property, model_name=pac_property_income, growth = U2_H_Q_YER400(-1), steady_state_growth=0.00496293157320360);
@#endif

@#if MCE_IN_PAC_RESIDENTIAL
    pac_model(discount=u2_beta_discount_residential, model_name=pac_residential, growth = U2_H_Q_YER400(-1), steady_state_growth=0.00496293157320360);
@#endif

@#if MCE_IN_PAC_LABOUR
    pac_model(discount=u2_beta_discount_labour, model_name=pac_labour, growth = U2_Q_TAU(-1), steady_state_growth=0.00496293157320360);
@#endif

model(use_dll);

    @#if MCE_IN_PERMANENT_INCOMES

        [blockname='consumption',name='U2_G_VYERT']
        U2_G_VYERT = U2_G_VYERT(-1) + (U2_T_Q_YER - 0.49629);

        [blockname='consumption',name='U2_G_VYERT_VE']
        U2_G_VYERT_VE = (1-u2_beta_discount_cons)*U2_G_VYERT + u2_beta_discount_cons*U2_G_VYERT_VE(1);

    @#endif

    [blockname='consumption',name='U2_G_VYER_VE']
	U2_G_VYER_VE =  var_expectation_model_U2_G_YER_CONS_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_YER_CONS_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_YER_CONS_U2_STN_0*U2_STN + var_expectation_model_U2_G_YER_CONS_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_YER_CONS_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_YER_CONS_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_0*U2_G_HH_Y_DIR + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_0*U2_G_HH_S_DIRL + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_0*U2_G_HH_S_DIRT + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_0*U2_G_HH_S_DIRP + var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_0*U2_G_HH_Y_EDIR + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_0*U2_G_HH_S_EDIRL + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_0*U2_G_HH_S_EDIRT + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_0*U2_G_HH_S_EDIRP + var_expectation_model_U2_G_YER_CONS_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_YER_CONS_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_YER_CONS_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_YER_CONS_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_DIR_1*U2_G_HH_Y_DIR(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRL_1*U2_G_HH_S_DIRL(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRT_1*U2_G_HH_S_DIRT(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_DIRP_1*U2_G_HH_S_DIRP(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_Y_EDIR_1*U2_G_HH_Y_EDIR(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRL_1*U2_G_HH_S_EDIRL(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRT_1*U2_G_HH_S_EDIRT(-1) + var_expectation_model_U2_G_YER_CONS_U2_G_HH_S_EDIRP_1*U2_G_HH_S_EDIRP(-1);

	[blockname='consumption',name='U2_G_VYER']
    @#if MCE_IN_PERMANENT_INCOMES
        U2_G_VYER = (1-u2_beta_discount_cons)*U2_G_YER + u2_beta_discount_cons*U2_G_VYER(1);
    @#else
        U2_G_VYER = (1-u2_beta_discount_cons)*U2_G_VYER_VE;
    @#endif

	[blockname='consumption',name='U2_G_HH_Y_VDIR_VE']
	U2_G_HH_Y_VDIR_VE =  var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_0*U2_STN + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_0*U2_G_HH_Y_DIR + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_0*U2_G_HH_S_DIRL + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_0*U2_G_HH_S_DIRT + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_0*U2_G_HH_S_DIRP + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_0*U2_G_HH_Y_EDIR + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_0*U2_G_HH_S_EDIRL + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_0*U2_G_HH_S_EDIRT + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_0*U2_G_HH_S_EDIRP + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_DIR_1*U2_G_HH_Y_DIR(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRL_1*U2_G_HH_S_DIRL(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRT_1*U2_G_HH_S_DIRT(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_DIRP_1*U2_G_HH_S_DIRP(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_Y_EDIR_1*U2_G_HH_Y_EDIR(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRL_1*U2_G_HH_S_EDIRL(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRT_1*U2_G_HH_S_EDIRT(-1) + var_expectation_model_U2_G_HH_Y_DIR_CONS_U2_G_HH_S_EDIRP_1*U2_G_HH_S_EDIRP(-1);

	[blockname='consumption',name='U2_G_HH_Y_VDIR']
    @#if MCE_IN_PERMANENT_INCOMES
        U2_G_HH_Y_VDIR = (1-u2_beta_discount_cons)*U2_G_HH_Y_DIR + u2_beta_discount_cons*U2_G_HH_Y_VDIR(1);
    @#else
        U2_G_HH_Y_VDIR = (1-u2_beta_discount_cons)*U2_G_HH_Y_VDIR_VE;
    @#endif

    [blockname='consumption',name='U2_G_HH_S_VDIRL_VE']
	U2_G_HH_S_VDIRL_VE =  var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_0*U2_STN + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_0*U2_G_HH_Y_DIR + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_0*U2_G_HH_S_DIRL + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_0*U2_G_HH_S_DIRT + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_0*U2_G_HH_S_DIRP + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_0*U2_G_HH_Y_EDIR + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_0*U2_G_HH_S_EDIRL + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_0*U2_G_HH_S_EDIRT + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_0*U2_G_HH_S_EDIRP + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_DIR_1*U2_G_HH_Y_DIR(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRL_1*U2_G_HH_S_DIRL(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRT_1*U2_G_HH_S_DIRT(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_DIRP_1*U2_G_HH_S_DIRP(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_Y_EDIR_1*U2_G_HH_Y_EDIR(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRL_1*U2_G_HH_S_EDIRL(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRT_1*U2_G_HH_S_EDIRT(-1) + var_expectation_model_U2_G_HH_S_DIRL_CONS_U2_G_HH_S_EDIRP_1*U2_G_HH_S_EDIRP(-1);

    [blockname='consumption',name='U2_G_HH_S_VDIRL']
    @#if MCE_IN_PERMANENT_INCOMES
        U2_G_HH_S_VDIRL = (1-u2_beta_discount_cons)*U2_G_HH_S_DIRL + u2_beta_discount_cons*U2_G_HH_S_VDIRL(1);
    @#else
        U2_G_HH_S_VDIRL =  (1-u2_beta_discount_cons)*U2_G_HH_S_VDIRL_VE;
    @#endif

	[blockname='consumption',name='U2_G_HH_S_VDIRT_VE']
	U2_G_HH_S_VDIRT_VE =  var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_0*U2_STN + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_0*U2_G_HH_Y_DIR + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_0*U2_G_HH_S_DIRL + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_0*U2_G_HH_S_DIRT + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_0*U2_G_HH_S_DIRP + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_0*U2_G_HH_Y_EDIR + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_0*U2_G_HH_S_EDIRL + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_0*U2_G_HH_S_EDIRT + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_0*U2_G_HH_S_EDIRP + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_DIR_1*U2_G_HH_Y_DIR(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRL_1*U2_G_HH_S_DIRL(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRT_1*U2_G_HH_S_DIRT(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_DIRP_1*U2_G_HH_S_DIRP(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_Y_EDIR_1*U2_G_HH_Y_EDIR(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRL_1*U2_G_HH_S_EDIRL(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRT_1*U2_G_HH_S_EDIRT(-1) + var_expectation_model_U2_G_HH_S_DIRT_CONS_U2_G_HH_S_EDIRP_1*U2_G_HH_S_EDIRP(-1);

	[blockname='consumption',name='U2_G_HH_S_VDIRT']
    @#if MCE_IN_PERMANENT_INCOMES
        U2_G_HH_S_VDIRT = (1-u2_beta_discount_cons)*U2_G_HH_S_DIRT + u2_beta_discount_cons*U2_G_HH_S_VDIRT(1);
    @#else
        U2_G_HH_S_VDIRT = (1-u2_beta_discount_cons)*U2_G_HH_S_VDIRT_VE;
    @#endif

	[blockname='consumption',name='U2_G_HH_S_VDIRP_VE']
	U2_G_HH_S_VDIRP_VE =  var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_0*U2_STN + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_0*U2_G_HH_Y_DIR + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_0*U2_G_HH_S_DIRL + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_0*U2_G_HH_S_DIRT + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_0*U2_G_HH_S_DIRP + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_0*U2_G_HH_Y_EDIR + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_0*U2_G_HH_S_EDIRL + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_0*U2_G_HH_S_EDIRT + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_0*U2_G_HH_S_EDIRP + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_DIR_1*U2_G_HH_Y_DIR(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRL_1*U2_G_HH_S_DIRL(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRT_1*U2_G_HH_S_DIRT(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_DIRP_1*U2_G_HH_S_DIRP(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_Y_EDIR_1*U2_G_HH_Y_EDIR(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRL_1*U2_G_HH_S_EDIRL(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRT_1*U2_G_HH_S_EDIRT(-1) + var_expectation_model_U2_G_HH_S_DIRP_CONS_U2_G_HH_S_EDIRP_1*U2_G_HH_S_EDIRP(-1);

	[blockname='consumption',name='U2_G_HH_S_VDIRP']
    @#if MCE_IN_PERMANENT_INCOMES
        U2_G_HH_S_VDIRP = (1-u2_beta_discount_cons)*U2_G_HH_S_DIRP + u2_beta_discount_cons*U2_G_HH_S_VDIRP(1);
    @#else
        U2_G_HH_S_VDIRP = (1-u2_beta_discount_cons)*U2_G_HH_S_VDIRP_VE;
    @#endif

	[blockname='consumption',name='U2_HH_EDIR', type='longrun']
    @#if MCE_IN_PERMANENT_INCOMES
        log(U2_HH_EDIR) =  log(U2_H_HH_Y_DIR) + log(U2_T_YER) - U2_G_VYERT/100 + U2_G_HH_Y_VDIR/100 + U2_G_VYER/100 + U2_G_VYERT_VE/100;
    @#else
        U2_HH_EDIR =  U2_H_HH_Y_DIR*U2_T_YER*exp(U2_G_HH_Y_VDIR/100+U2_G_VYER/100);
    @#endif

	[blockname='consumption',name='U2_HH_EDIRL', type='longrun']
    @#if MCE_IN_PERMANENT_INCOMES
        log(U2_HH_EDIRL) =  log(U2_H_HH_S_DIRL)+log(U2_H_HH_Y_DIR)+log(U2_T_YER) - U2_G_VYERT/100 + U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRL/100+ U2_G_VYERT_VE/100;
    @#else
        log(U2_HH_EDIRL) =  log(U2_H_HH_S_DIRL)+log(U2_H_HH_Y_DIR)+log(U2_T_YER)+U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRL/100;
    @#endif

    [blockname='consumption',name='U2_HH_EDIRT', type='longrun']
    @#if MCE_IN_PERMANENT_INCOMES
        log(U2_HH_EDIRT) =  log(U2_T_YER) - U2_G_VYERT/100 +log(U2_H_HH_Y_DIR)+log(U2_H_HH_S_DIRT)+U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRT/100+ U2_G_VYERT_VE/100;
    @#else
	    log(U2_HH_EDIRT) =  log(U2_T_YER)+log(U2_H_HH_Y_DIR)+log(U2_H_HH_S_DIRT)+U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRT/100;
    @#endif

	[blockname='consumption',name='U2_HH_EDIRP', type='longrun']
    @#if MCE_IN_PERMANENT_INCOMES
        log(U2_HH_EDIRP) =  log(U2_T_YER) - U2_G_VYERT/100 +log(U2_H_HH_Y_DIR)+log(U2_H_HH_S_DIRP)+U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRP/100+ U2_G_VYERT_VE/100;
    @#else
        log(U2_HH_EDIRP) =  log(U2_T_YER)+log(U2_H_HH_Y_DIR)+log(U2_H_HH_S_DIRP)+U2_G_VYER/100+U2_G_HH_Y_VDIR/100+U2_G_HH_S_VDIRP/100;
@#endif

	[blockname='consumption',name='U2_CONS_PAC_PE']
	U2_CONS_PAC_PE =  h1_pac_consumption_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_consumption_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_consumption_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_consumption_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_consumption_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_consumption_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_1*diff(log(U2_HH_OCOR(-1))) + h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_1*U2_H_Q_YER400(-1) + h1_pac_consumption_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_consumption_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_consumption_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_consumption_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_consumption_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_consumption_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_consumption_eq0_var_AUX_DIFF_470_lag_2*diff(log(U2_HH_OCOR(-2))) + h1_pac_consumption_eq0_var_U2_H_Q_YER400_lag_2*U2_H_Q_YER400(-2);

	[blockname='consumption',name='U2_HH_COR']
    @#if MCE_IN_PAC_CONSUMPTION
        diff(log(U2_HH_COR)) =  u2_gamma_cons*(u2_ecm_pac_cons*(log(U2_HH_OCOR(-1))-log(U2_HH_COR(-1)))+u2_hh_cor_pac_u2_hh_cor_L1*diff(log(U2_HH_COR(-1)))+pac_expectation(pac_consumption))+(1-u2_gamma_cons)*(u2_dlyhlt*U2_DLYHLT) + pac_consumption_pac_growth_neutrality_correction*U2_H_Q_YER400(-1) + u2_hh_cor_pac_u2_hh_dsl_con_lt_10y*U2_DL_HH_L_CON + res_U2_HH_COR;
    @#else
        diff(log(U2_HH_COR)) =  u2_gamma_cons*(u2_ecm_pac_cons*(log(U2_HH_OCOR(-1))-log(U2_HH_COR(-1)))+u2_hh_cor_pac_u2_hh_cor_L1*diff(log(U2_HH_COR(-1)))+U2_CONS_PAC_PE)+u2_hh_cor_pac_u2_hh_dsl_con_lt_10y*U2_DL_HH_L_CON+(1-u2_gamma_cons)*u2_dlyhlt*U2_DLYHLT+res_U2_HH_COR + pac_consumption_pac_growth_neutrality_correction*U2_H_Q_YER400(-1);
    @#endif

    [blockname='consumption',name='U2_HH_OCOR', rename='U2_HH_COR_tmp->U2_HH_OCOR']
	log(U2_HH_OCOR) =  u2_cons_tar_const+u2_beta_cons_l*(log(U2_HH_EDIRL)-log(U2_HH_TWR))+u2_beta_cons_t*(log(U2_HH_EDIRT)-log(U2_HH_TWR))+u2_beta_cons_p*(log(U2_HH_EDIRP)-log(U2_HH_TWR))+log(U2_HH_TWR)*u2_con_fix+u2_beta_cons_trend*U2_TTREND+res_U2_HH_COR_tmp;

	[blockname='consumption',name='U2_G_HH_Y_EDIR']
	U2_G_HH_Y_EDIR =  0;

	[blockname='consumption',name='U2_G_HH_S_EDIRL']
	U2_G_HH_S_EDIRL =  0;

	[blockname='consumption',name='U2_G_HH_S_EDIRT']
	U2_G_HH_S_EDIRT =  0;

	[blockname='consumption',name='U2_G_HH_S_EDIRP']
	U2_G_HH_S_EDIRP =  0;

	[blockname='consumption',name='U2_DL_HH_L_CON']
	U2_DL_HH_L_CON =  diff(U2_HH_L_CON);

	[blockname='consumption',name='U2_DLYHLT']
	U2_DLYHLT =  (U2_HH_DIRL+U2_HH_DIRT)/(U2_HH_DIRL(-1)+U2_HH_DIRT(-1))-1;

	[blockname='consumption',name='U2_T_Q_YER']
	U2_T_Q_YER =  100*(U2_T_YER/U2_T_YER(-1)-1.0);

	[blockname='consumption',name='U2_H_Q_YER']
	U2_H_Q_YER =  U2_H_Q_YER(-1)+0.05*(U2_T_Q_YER(-1)-U2_H_Q_YER(-1))+res_U2_H_Q_YER;

	[blockname='consumption',name='U2_H_HH_Y_DIR']
	U2_H_HH_Y_DIR =  U2_H_HH_Y_DIR(-1)+0.05*(U2_HH_DIR/U2_YER-U2_H_HH_Y_DIR(-1))+res_U2_H_HH_Y_DIR;

	[blockname='consumption',name='U2_H_HH_S_DIRL']
	U2_H_HH_S_DIRL =  U2_H_HH_S_DIRL(-1)+0.05*(U2_HH_DIRL/U2_HH_DIR-U2_H_HH_S_DIRL(-1))+res_U2_H_HH_S_DIRL;

	[blockname='consumption',name='U2_H_HH_S_DIRT']
	U2_H_HH_S_DIRT =  U2_H_HH_S_DIRT(-1)+0.05*(U2_HH_DIRT/U2_HH_DIR-U2_H_HH_S_DIRT(-1))+res_U2_H_HH_S_DIRT;

	[blockname='consumption',name='U2_W0_CEN']
	log(U2_W0_CEN) =  log(U2_W0_CEN(-1))+diff(log(U2_CEN))+res_U2_W0_CEN;

	[blockname='consumption',name='U2_MIN']
	log(U2_MIN) =  log(U2_MIN(-1))+diff(log(U2_W0_CEN))+res_U2_MIN;

	[blockname='consumption',name='U2_HH_B_SCN']
	log(U2_HH_B_SCN) =  log(U2_HH_B_SCN(-1))+diff(log(U2_GO_SCN))+res_U2_HH_B_SCN;

	[blockname='consumption',name='U2_HH_DTN']
	log(U2_HH_DTN) =  log(U2_HH_DTN(-1))+diff(log(U2_GO_HH_DTN))+res_U2_HH_DTN;

	[blockname='consumption',name='U2_HH_B_SBN']
	log(U2_HH_B_SBN) =  log(U2_HH_B_SBN(-1))+diff(log(U2_GO_SBCN))+res_U2_HH_B_SBN;

	[blockname='consumption',name='U2_HH_DINL', type='longrun']
	log(U2_HH_DINL) =  log(U2_W0_CEN+U2_MIN)+log(1-(U2_GO_BU_SCN+U2_HH_DTN*U2_S_DTNL)/(U2_W0_CEN+U2_MIN));

	[blockname='consumption',name='U2_HH_DINT', type='longrun']
	log(U2_HH_DINT) =  log(U2_HH_B_SBN)+log(1-(U2_S_SCNT*U2_HH_B_SCN+U2_HH_DTN*U2_S_DTNT)/U2_HH_B_SBN);

	[blockname='consumption',name='U2_HH_DIN', type='longrun']
	log(U2_HH_DIN) =  log(U2_HH_DINP)+log(1+(U2_HH_DINL+U2_HH_DINT)/U2_HH_DINP);

	[blockname='consumption',name='U2_HH_DIRL', type='longrun']
	log(U2_HH_DIRL) =  log(U2_HH_DINL)-log(U2_HH_COD);

	[blockname='consumption',name='U2_HH_DIRT', type='longrun']
	log(U2_HH_DIRT) =  log(U2_HH_DINT)-log(U2_HH_COD);

	[blockname='consumption',name='U2_HH_DIR', type='longrun']
	log(U2_HH_DIR) =  log(U2_HH_DIN)-log(U2_HH_COD);

	[blockname='consumption',name='U2_G_HH_Y_DIR']
	U2_G_HH_Y_DIR =  100*(U2_HH_DIR/U2_YER/U2_H_HH_Y_DIR-1);

	[blockname='consumption',name='U2_G_HH_S_DIRL']
	U2_G_HH_S_DIRL =  100*(U2_HH_DIRL/U2_HH_DIR/U2_H_HH_S_DIRL-1);

	[blockname='consumption',name='U2_G_HH_S_DIRT']
	U2_G_HH_S_DIRT =  100*(U2_HH_DIRT/U2_HH_DIR/U2_H_HH_S_DIRT-1);

	[blockname='consumption',name='U2_S_DTNL']
	U2_S_DTNL =  (1-u2_s_dtnl_l1)*u2_s_dtnl_lr+u2_s_dtnl_l1*U2_S_DTNL(-1)+res_U2_S_DTNL;

	[blockname='consumption',name='U2_S_DTNT']
	U2_S_DTNT =  (1-u2_s_dtnt_l1)*u2_s_dtnt_lr+u2_s_dtnt_l1*U2_S_DTNT(-1)+res_U2_S_DTNT;

	[blockname='consumption',name='U2_H_Q_YER400']
	U2_H_Q_YER400 =  U2_H_Q_YER/100;

	[blockname='business',name='U2_BUSINESS_PAC_PE']
	U2_BUSINESS_PAC_PE =  h1_pac_business_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_business_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_business_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_business_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_business_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_business_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_business_eq0_var_AUX_DIFF_206_lag_1*diff(log(U2_BU_OITR(-1))) + h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_1*U2_T_Q_YER_100(-1) + h1_pac_business_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_business_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_business_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_business_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_business_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_business_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_business_eq0_var_AUX_DIFF_206_lag_2*diff(log(U2_BU_OITR(-2))) + h1_pac_business_eq0_var_U2_T_Q_YER_100_lag_2*U2_T_Q_YER_100(-2);

	[blockname='business',name='U2_BU_ITR']
    @#if MCE_IN_PAC_BUSINESS
        diff(log(U2_BU_ITR)) =  u2_gamma_business*(u2_ecm_pac_business*(log(U2_BU_OITR(-1))-log(U2_BU_ITR(-1)))+u2_bu_itr_pac_u2_bu_itr_L1*diff(log(U2_BU_ITR(-1)))+pac_expectation(pac_business))+(1-u2_gamma_business)*(u2_business_aux*U2_BUSINESS_AUX)+res_U2_BU_ITR + pac_business_pac_growth_neutrality_correction*U2_BU_OITR_T(-1);
    @#else
        diff(log(U2_BU_ITR)) =  u2_gamma_business*(u2_ecm_pac_business*(log(U2_BU_OITR(-1))-log(U2_BU_ITR(-1)))+u2_bu_itr_pac_u2_bu_itr_L1*diff(log(U2_BU_ITR(-1)))+U2_BUSINESS_PAC_PE)+(1-u2_gamma_business)*u2_business_aux*U2_BUSINESS_AUX+res_U2_BU_ITR + pac_business_pac_growth_neutrality_correction*U2_BU_OITR_T(-1);
    @#endif

	[blockname='business',name='U2_BUSINESS_AUX']
	U2_BUSINESS_AUX =  U2_T_BU_Y_Q_ITR_100+diff(log(U2_YER));

	[blockname='business',name='U2_BU_OITR_T']
	U2_BU_OITR_T =  U2_T_Q_YER_100+U2_T_BU_Y_Q_ITR_100;

	[blockname='business',name='U2_T_BU_Y_Q_ITR']
	U2_T_BU_Y_Q_ITR =  0.95*U2_T_BU_Y_Q_ITR(-1)+0.05*log(U2_BU_Y_ITR/U2_BU_Y_ITR(-1))+res_U2_T_BU_Y_Q_ITR;

	[blockname='business',long_run_name='U2_BU_OITR', name='U2_BU_OITR', type='longrun']
	U2_BU_OITR =  U2_BU_Y_ITR*U2_YER*(U2_H_Q_YER/100+U2_BU_D_ITR/100);

	[blockname='business',name='U2_BU_Y_ITR', type='longrun']
	U2_BU_Y_ITR =  U2_BU_Y_MIBR/(U2_BU_U_ITR/400);

	[blockname='business',name='U2_BU_U_ITR', type='longrun']
	U2_BU_U_ITR =  400*U2_Y_ITD*(U2_BU_D_ITR/100+U2_BU_L_ITR/400-(1-U2_BU_D_ITR/100)*U2_HGPDR/400)*1/(1-U2_BU_S_DTN);

	[blockname='business',name='U2_Y_ITD', type='longrun']
	U2_Y_ITD =  U2_ITD/U2_YED;

	[blockname='business',name='U2_HGPDR', type='longrun']
	U2_HGPDR =  0.975*U2_HGPDR(-1)+2.5*(log(U2_Y_ITD)-log(U2_Y_ITD(-1)))+res_U2_HGPDR;

	[blockname='business',name='U2_BU_L_ITR', type='longrun']
	U2_BU_L_ITR =  U2_BU_L_ITN-U2_EHIC;

	[blockname='business',name='U2_T_Q_YER_100', type='longrun']
	U2_T_Q_YER_100 =  U2_T_Q_YER/100;

	[blockname='business',name='U2_T_BU_Y_Q_ITR_100', type='longrun']
	U2_T_BU_Y_Q_ITR_100 =  U2_T_BU_Y_Q_ITR/100;

	[blockname='closure',name='U2_HH_CON']
	log(U2_HH_CON) =  log(U2_HH_COR)+log(U2_HH_COD);

	[blockname='closure',name='U2_BU_ITN']
	log(U2_BU_ITN) =  log(U2_BU_ITR)+log(U2_BU_ITD);

	[blockname='closure',name='U2_YEN', type='longrun']
	log(U2_YEN) =  log(U2_YED)+log(U2_YER);

	[blockname='closure',name='U2_YER', type='longrun']
	diff(log(U2_YER)) =  u2_yer_u2_hh_cor*log(U2_HH_COR/U2_HH_COR(-1))+u2_yer_u2_go_cor*log(U2_GO_COR/U2_GO_COR(-1))+u2_yer_u2_bu_itr*log(U2_BU_ITR/U2_BU_ITR(-1))+u2_yer_u2_hh_ihr*log(U2_HH_IHR/U2_HH_IHR(-1))+u2_yer_u2_go_itr*log(U2_GO_ITR/U2_GO_ITR(-1))+u2_yer_u2_xtr*log(U2_XTR/U2_XTR(-1))+u2_yer_u2_mtr*log(U2_MTR/U2_MTR(-1))+u2_yer_u2_sivr_l1*log(U2_SIVR/U2_SIVR(-1))+u2_yer_u2_sivr_l2*log(U2_SIVR(-1)/U2_SIVR(-2))+res_U2_YER;

	[blockname='closure',name='U2_GOSMIN']
	U2_GOSMIN =  U2_YEN-U2_CEN-U2_TIN+res_U2_GOSMIN;

	[blockname='closure',name='U2_TIN']
	log(U2_TIN) =  log(U2_TIN(-1))+diff(log(U2_GO_TIN))+res_U2_TIN;

	[blockname='closure',name='U2_G_YER']
	U2_G_YER =  100*(log(U2_YER)-log(U2_T_YER));

	[blockname='closure',name='U2_ITN']
	log(U2_ITN) =  log(U2_BU_ITN)+log(1+U2_HH_IHN/U2_BU_ITN+U2_GO_ITN/U2_BU_ITN);

	[blockname='closure',name='U2_ITR']
	U2_ITR =  U2_GO_ITR+U2_BU_ITR+U2_HH_IHR;

	[blockname='closure',name='U2_ITD']
	log(U2_ITD) =  log(U2_ITN)-log(U2_ITR);

	[blockname='closure',name='U2_CEN']
	log(U2_CEN) =  log(U2_C_CEN)+log(U2_LEN);

	[blockname='closure',name='U2_S_GO_COR']
	U2_S_GO_COR =  U2_GO_COR*100/U2_YER;

	[blockname='closure',name='U2_GO_BU_SCN']
	log(U2_GO_BU_SCN) =  log(U2_CEN)+log(U2_GO_BU_R_SCN);

	[blockname='production',name='U2_T_YER']
	log(U2_T_YER) =  u2_alpha*log(U2_SKFR)+(1-u2_alpha)*log(U2_T_PRO)+(1-u2_alpha)*(log(U2_T_R_LFP/100)+log(U2_WAP)+log(1-U2_T_R_LUN/100))+U2_EPS_L_U2_T_YER;

	[blockname='production',name='U2_T_PRO']
	U2_T_PRO =  U2_Q_T_PRO*U2_T_PRO(-1);

	[blockname='production',name='U2_SKFR']
	U2_SKFR =  U2_SKFR(-1)*(1-U2_D_ITR/100)+U2_ITR;

	[blockname='production',name='U2_Q_T_PRO']
	U2_Q_T_PRO =  (1+u2_annual_tfp_growth_rate/100)^0.25+res_U2_Q_T_PRO;

	[blockname='production',name='U2_EPS_L_U2_T_YER']
	U2_EPS_L_U2_T_YER =  0.9782*U2_EPS_L_U2_T_YER(-1);

	[blockname='exchange-rate',name='U2_EENX_tmp']
	log(U2_EENX_tmp) =  u2_eenx_const*(1-dummy_long_run_EENX)+u2_eenx_u2_yed_cxedex*(log(U2_YED)-log(U2_CXEDEX))+u2_eenx_u2_us_ir*(U2_US_10Y-U2_US_EHIC-(U2_OIS_10Y-U2_EHIC))+res_U2_EENX_tmp;

    [blockname='exchange-rate',name='U2_EENX']
    @#if MCE_IN_EXCHANGE_RATE
        @#if EXCHANGE_RATE_WITH_TP
            diff(log(U2_EENX(1))) = ((-((U2_US_10Y - 3.763738678548371)-(U2_STN - 3.2)-4*(U2_TP_10YEXO)))/100 +0.0001*U2_EEN_RES+0.0001*res_U2_EENX)/4 ; //-0.563738719114321 to be added to U2_TP_10Y
        @#else
            diff(log(U2_EENX(1))) = ((-((U2_US_10Y - 3.763738678548371)-(U2_STN - 3.2)))/100 +0.0001*U2_EEN_RES+0.0001*res_U2_EENX)/4 ;
        @#endif
    @#else
	    log(U2_EENX) =  u2_eenx_u2_yed_cxedex*(log(U2_YED)-log(U2_CXEDEX))+u2_eenx_u2_us_ir*(U2_US_10Y-U2_US_EHIC-(U2_OIS_10Y-U2_EHIC))+U2_EEN_RES+res_U2_EENX;
    @#endif

	[blockname='exchange-rate',name='U2_EEN_RES']
	U2_EEN_RES =  u2_een_res_L1*U2_EEN_RES(-1)+(1-dummy_long_run_EENX)*U2_EEN_RES_C+res_U2_EEN_RES;

	[blockname='exchange-rate',name='U2_EEN_RES_C']
	U2_EEN_RES_C =  (1-dummy_long_run_EENX)*u2_een_res_c+dummy_long_run_EENX*u2_een_res_c_L1*U2_EEN_RES_C(-1)+res_U2_EEN_RES_C;

	[blockname='exchange-rate',name='U2_EXR']
	U2_EXR =  1/U2_EENX+res_U2_EXR;

	[blockname='exchange-rate',name='U2_EENM']
	U2_EENM =  U2_EENX+res_U2_EENM;

	[blockname='exchange-rate',name='U2_REENX']
	U2_REENX =  U2_CXEDEX*U2_EENX/U2_YED;

	[blockname='property-income',name='U2_HH_GOS']
	U2_HH_GOS =  u2_beta_hh_gos_u2_skhr_u2_hh_ihd*U2_SKHR*U2_HH_IHD+u2_beta_hh_gos_u2_s_rppd_u2_yen*(U2_S_RPPD-1)*U2_YEN+u2_beta_hh_gos_trend*U2_YEN*U2_TTREND+res_U2_HH_GOS;

	[blockname='property-income',name='U2_HH_GOSMIN']
	log(U2_HH_GOSMIN) =  log(U2_HH_GOS)+log(1+U2_MIN/U2_HH_GOS);

	[blockname='property-income',name='U2_HH_B_IRN']
	U2_HH_B_IRN =  U2_YEN*u2_hh_b_irn_u2_yen+u2_hh_b_irn_u2_L1_u2_yen*U2_YEN*U2_HH_B_IRN(-1)/U2_YEN(-1)+u2_hh_b_irn_u2_s_rw_nfan_u2_yen*0.01*U2_YEN*U2_S_RW_NFAN(-1)+u2_hh_b_irn_u2_stn_u2_yen*U2_STN*U2_YEN-u2_hh_b_irn_u2_hh_l_ihn_u2_hh_l_dep_u2_yen*U2_YEN*(U2_HH_L_IHN-U2_HH_L_DEP)+res_U2_HH_B_IRN;

	[blockname='property-income',name='U2_PROPERTY_PAC_PE']
	U2_PROPERTY_PAC_PE =  h1_pac_property_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_property_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_property_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_property_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_property_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_property_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_property_eq0_var_AUX_DIFF_295_lag_1*diff(log(U2_HH_C_ODDR(-1))) + h1_pac_property_eq0_var_U2_H_Q_YER400_lag_1*U2_H_Q_YER400(-1) + h1_pac_property_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_property_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_property_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_property_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_property_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_property_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_property_eq0_var_AUX_DIFF_295_lag_2*diff(log(U2_HH_C_ODDR(-2))) + h1_pac_property_eq0_var_U2_H_Q_YER400_lag_2*U2_H_Q_YER400(-2);

	[blockname='property-income',name='U2_HH_C_DDR']
    @#if MCE_IN_PAC_PROPERTY_INCOME
        diff(log(U2_HH_C_DDR)) =  u2_ecm_pac_property*(log(U2_HH_C_ODDR(-1))-log(U2_HH_C_DDR(-1)))+u2_hh_c_ddr_u2_hh_c_ddr_L1*diff(log(U2_HH_C_DDR(-1)))+u2_hh_c_ddr_u2_hh_c_ddr_L2*diff(log(U2_HH_C_DDR(-2)))+u2_hh_c_ddr_u2_hh_c_ddr_L3*diff(log(U2_HH_C_DDR(-3)))+pac_expectation(pac_property_income)+res_U2_HH_C_DDR + pac_property_pac_growth_neutrality_correction*U2_H_Q_YER400(-1);
    @#else
        diff(log(U2_HH_C_DDR)) =  u2_ecm_pac_property*(log(U2_HH_C_ODDR(-1))-log(U2_HH_C_DDR(-1)))+u2_hh_c_ddr_u2_hh_c_ddr_L1*diff(log(U2_HH_C_DDR(-1)))+u2_hh_c_ddr_u2_hh_c_ddr_L2*diff(log(U2_HH_C_DDR(-2)))+u2_hh_c_ddr_u2_hh_c_ddr_L3*diff(log(U2_HH_C_DDR(-3)))+U2_PROPERTY_PAC_PE+res_U2_HH_C_DDR + pac_property_pac_growth_neutrality_correction*U2_H_Q_YER400(-1);
    @#endif

	[blockname='property-income',name='U2_HH_B_OPPN']
	U2_HH_B_OPPN =  U2_HH_B_OPPN(-1)*((1+u2_annual_inflation_rate/100)*(1+u2_annual_pop_growth_rate/100)*(1+u2_annual_tfp_growth_rate/100))^0.25+res_U2_HH_B_OPPN;

	[blockname='property-income',name='U2_HH_C_ODDR', rename='U2_HH_C_DDR_tmp->U2_HH_C_ODDR']
	log(U2_HH_C_ODDR) =  u2_hh_c_ddr_const+log(U2_HH_GOSMIN)*coeff_one-coeff_one*log(U2_HH_COD)+U2_TTREND*u2_beta_hh_c_ddr_trend+res_U2_HH_C_DDR_tmp;

	[blockname='property-income',name='U2_H_HH_S_DIRP']
	U2_H_HH_S_DIRP =  U2_H_HH_S_DIRP(-1)+0.05*(U2_HH_DIRP/U2_HH_DIR-U2_H_HH_S_DIRP(-1))+res_U2_H_HH_S_DIRP;

	[blockname='property-income',name='U2_HH_DIRP']
	log(U2_HH_DIRP) =  log(U2_HH_DINP)-log(U2_HH_COD);

	[blockname='property-income',name='U2_G_HH_S_DIRP']
	U2_G_HH_S_DIRP =  100*(U2_HH_DIRP/U2_HH_DIR/U2_H_HH_S_DIRP-1);

	[blockname='property-income',name='U2_HH_C_DDN']
	log(U2_HH_C_DDN) =  log(U2_HH_C_DDR)+log(U2_HH_COD);

	[blockname='property-income',name='U2_HH_DINP']
	log(U2_HH_DINP) =  log(U2_HH_C_DDN+U2_HH_GOS+U2_HH_B_IRN+U2_HH_B_OPPN)+log(1-((1-U2_S_SCNL-U2_S_SCNT)*U2_HH_B_SCN+(1-U2_S_DTNL-U2_S_DTNT)*U2_HH_DTN)/(U2_HH_C_DDN+U2_HH_GOS+U2_HH_B_IRN+U2_HH_B_OPPN));

	[blockname='foreign',name='U2_US_10Y']
	U2_US_10Y =  0.9*U2_US_10Y(-1)+0.1*U2_OIS_10Y+res_U2_US_10Y;

	[blockname='foreign',name='U2_CMEDEX']
	U2_CMEDEX =  U2_YED*U2_CMEDEX_AUX;

	[blockname='foreign',name='U2_CXEDEX']
	U2_CXEDEX =  U2_CXEDEX_AUX*U2_YED;

	[blockname='foreign',name='U2_PCU']
	U2_PCU =  U2_YED*U2_PCU_AUX;

	[blockname='foreign',name='U2_POU']
	U2_POU =  U2_YED*U2_POU_AUX;

	[blockname='foreign',name='U2_CMEDEX_AUX']
	U2_CMEDEX_AUX =  0.5+0.5*U2_CMEDEX_AUX(-1)+res_U2_CMEDEX;

	[blockname='foreign',name='U2_CXEDEX_AUX']
	U2_CXEDEX_AUX =  0.5+0.5*U2_CXEDEX_AUX(-1)+res_U2_CXEDEX;

	[blockname='foreign',name='U2_PCU_AUX']
	U2_PCU_AUX =  0.5+0.5*U2_PCU_AUX(-1)+res_U2_PCU;

	[blockname='foreign',name='U2_POU_AUX']
	U2_POU_AUX =  0.5+0.5*U2_POU_AUX(-1)+res_U2_POU;

	[blockname='foreign',name='U2_WDREX']
	U2_WDREX =  u2_wdrex_u2_yer*U2_YER+res_U2_WDREX;

	[blockname='foreign',name='U2_US_EHIC']
	U2_US_EHIC =  0.98*U2_US_EHIC(-1)+0.02*U2_EHIC+res_U2_US_EHIC;

	[blockname='policy-rule',name='U2_STN', type='longrun']
    U2_STN =  max(U2_STN_ZLB, 0);

    [blockname='policy-rule',name='U2_STN_ZLB', type='longrun']
    U2_STN_ZLB = 0.899*U2_STN_ZLB(-1)+0.3232+0.101*1.827*U2_G_A_YED+0.166*(U2_A_YED-U2_A_YED(-1))+0.077*(U2_G_YER-U2_G_YER(-1))+res_U2_STN;

	[blockname='policy-rule',name='U2_ESTN', type='longrun']
	U2_ESTN =  U2_ESTN(-1)+0.05*(U2_STN-U2_ESTN(-1))+res_U2_ESTN;

	[blockname='price',name='U2_HH_COD']
	diff(log(U2_HH_COD)) =  u2_hh_cod_u2_mxd*diff(log(U2_MXD))+ecm_hh_cod*(log(U2_HH_COD(-1))-log(U2_HH_OCOD(-1)))+u2_hh_cod_u2_q_yed*diff(log(U2_YED))+(1-u2_hh_cod_u2_q_yed-u2_hh_cod_u2_mxd)*diff(log(U2_YED(-1)))+res_U2_HH_Q_COD;

	[blockname='price',name='U2_BU_ITD']
	diff(log(U2_BU_ITD)) =  ecm_bu_itd*(log(U2_BU_ITD(-1))-log(U2_BU_OITD(-1)))+diff(log(U2_YED))*u2_bu_q_itd_u2_q_yed+diff(log(U2_YED(-1)))*(1-u2_bu_q_itd_u2_q_yed)+res_U2_BU_Q_ITD;

	[blockname='price',name='U2_HH_IHD']
	diff(log(U2_HH_IHD)) =  ecm_hh_ihd*(log(U2_HH_IHD(-1))-log(U2_HH_OIHD(-1)))+u2_hh_q_ihd_u2_q_hh_ihd*diff(log(U2_HH_IHD(-1)))+diff(log(U2_YED))*(1-u2_hh_q_ihd_u2_q_hh_ihd)+res_U2_HH_Q_IHD;

	[blockname='price',name='U2_HH_OCOD', rename='U2_HH_COD_tmp->U2_HH_OCOD']
	log(U2_HH_OCOD) =  (1-u2_hh_ocod_u2_mxd)*log(U2_YED)+u2_hh_ocod_u2_mxd*log(U2_MXD)+res_U2_HH_COD_tmp;

	[blockname='price',name='U2_BU_OITD', rename='U2_BU_ITD_tmp->U2_BU_OITD']
	log(U2_BU_OITD) =  log(U2_YED)*(1-u2_oitd_u2_mxd)+log(U2_MXD)*u2_oitd_u2_mxd+res_U2_BU_ITD_tmp;

	[blockname='price',name='U2_HH_OIHD', rename='U2_HH_IHD_tmp->U2_HH_OIHD']
	log(U2_HH_OIHD) =  log(U2_YED)*(1-u2_oihd_mxd)+log(U2_MXD)*u2_oihd_mxd+res_U2_HH_IHD_tmp;

	[blockname='wealth',name='U2_HH_B_APN']
	U2_HH_B_APN =  ((1+u2_annual_inflation_rate/100)*(1+u2_annual_pop_growth_rate/100)*(1+u2_annual_tfp_growth_rate/100))^0.25*U2_HH_B_APN(-1)+res_U2_HH_B_APN;

	[blockname='wealth',name='U2_HH_GSN']
	log(U2_HH_GSN) =  log(U2_HH_DIN)+log(1-(U2_HH_CON-U2_HH_B_APN)/U2_HH_DIN);

	[blockname='wealth',name='U2_HH_B_KTN']
	U2_HH_B_KTN =  U2_HH_B_KTN(-1)*((1+u2_annual_inflation_rate/100)*(1+u2_annual_pop_growth_rate/100)*(1+u2_annual_tfp_growth_rate/100))^0.25+res_U2_HH_B_KTN;

	[blockname='wealth',name='U2_HH_IVN']
	U2_HH_IVN =  U2_HH_IVN(-1)*(U2_YEN+U2_MTN-U2_HH_CON-U2_GO_CON-U2_ITN-U2_XTN)/(U2_YEN(-1)+U2_MTN(-1)-U2_HH_CON(-1)-U2_GO_CON(-1)-U2_ITN(-1)-U2_XTN(-1))+res_U2_HH_IVN;

	[blockname='wealth',name='U2_HH_ITN']
	log(U2_HH_ITN) =  log(U2_HH_ITN(-1))+diff(log(U2_HH_IHN))+res_U2_HH_ITN;

	[blockname='wealth',name='U2_HH_KFN']
	log(U2_HH_KFN) =  log(U2_HH_ITN)+log(1+U2_HH_IVN/U2_HH_ITN);

	[blockname='wealth',name='U2_HH_NPN']
	U2_HH_NPN =  ((1+u2_annual_inflation_rate/100)*(1+u2_annual_pop_growth_rate/100)*(1+u2_annual_tfp_growth_rate/100))^0.25*U2_HH_NPN(-1)+res_U2_HH_NPN;

	[blockname='wealth',name='U2_HH_KFNPN']
	log(U2_HH_KFNPN) =  log(U2_HH_KFN)+log(1+U2_HH_NPN/U2_HH_KFN);

	[blockname='wealth',name='U2_HH_CFKN']
	log(U2_HH_CFKN) =  log(U2_HWN(-1))+log(U2_HH_D_IHN);

	[blockname='wealth',name='U2_HH_D_IHN']
	U2_HH_D_IHN =  (1-u2_hh_d_ihn_l1)*u2_hh_d_ihn_lr+u2_hh_d_ihn_l1*U2_HH_D_IHN(-1)+res_U2_HH_D_IHN;

	[blockname='wealth',name='U2_HH_B9N']
	log(U2_HH_B9N) =  log(U2_HH_GSN)+log(1-(U2_HH_KFNPN-U2_HH_B_KTN)/U2_HH_GSN);

	[blockname='wealth',name='U2_HH_TWN']
	log(U2_HH_TWN) =  log(U2_HH_FWN)+log(1+U2_HWN/U2_HH_FWN);

	[blockname='wealth',name='U2_HH_TWR']
	log(U2_HH_TWR) =  log(U2_HH_TWN)-log(U2_HH_COD);

	[blockname='wealth',name='U2_HWN']
	U2_HWN =  U2_HWN(-1)*U2_RPPD/U2_RPPD(-1)+U2_HH_IHN-U2_HH_CFKN+res_U2_HWN;

    [blockname='wealth',name='U2_HH_FWN']
    @#if MCE_IN_LONG_TERM_INTEREST_RATE
        U2_HH_FWN =  U2_HH_FWN(-1)*(0.5 + 0.25*(U2_RFB_10Y)/U2_RFB_10Y(-1) + 0.25*(U2_RFCB_10Y)/U2_RFCB_10Y(-1))+U2_HH_B9N+res_U2_HH_FWN;
    @#else
        U2_HH_FWN =  U2_HH_FWN(-1)*(0.5930+0.0666*(1+U2_OIS_10Y(-1)/100)/(1+U2_OIS_10Y/100)+0.1622*(1+U2_CB(-1)/100)/(1+U2_CB/100)+0.1782*(1+U2_COE(-1)/100)/(1+U2_COE/100))+U2_HH_B9N+res_U2_HH_FWN;
    @#endif

    [blockname='residential',name='U2_RESIDENTIAL_PAC_PE']
	U2_RESIDENTIAL_PAC_PE =  h1_pac_residential_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_residential_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_residential_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_residential_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_residential_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_residential_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_residential_eq0_var_AUX_DIFF_225_lag_1*diff(log(U2_HH_OIHR(-1))) + h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_1*U2_H_Q_YER400(-1) + h1_pac_residential_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_residential_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_residential_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_residential_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_residential_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_residential_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_residential_eq0_var_AUX_DIFF_225_lag_2*diff(log(U2_HH_OIHR(-2))) + h1_pac_residential_eq0_var_U2_H_Q_YER400_lag_2*U2_H_Q_YER400(-2);

	[blockname='residential',name='U2_HH_IHR']
    @#if MCE_IN_PAC_RESIDENTIAL
        diff(log(U2_HH_IHR)) = u2_ecm_pac_residential*(log(U2_HH_OIHR(-1))-log(U2_HH_IHR(-1)))+u2_hh_ihr_pac_u2_ihr_L1*diff(log(U2_HH_IHR(-1)))+u2_hh_ihr_pac_u2_ihr_L2*diff(log(U2_HH_IHR(-2)))+pac_expectation(pac_residential) + (u2_hh_ihr_pac_u2_yer_h_q_yer*U2_RESIDENTIAL_PAC_AUX) + res_U2_HH_IHR + pac_residential_pac_growth_neutrality_correction*U2_H_Q_YER400(-1) ;
    @#else
        diff(log(U2_HH_IHR)) =  u2_ecm_pac_residential*(log(U2_HH_OIHR(-1))-log(U2_HH_IHR(-1)))+u2_hh_ihr_pac_u2_ihr_L1*diff(log(U2_HH_IHR(-1)))+u2_hh_ihr_pac_u2_ihr_L2*diff(log(U2_HH_IHR(-2)))+U2_RESIDENTIAL_PAC_PE+u2_hh_ihr_pac_u2_yer_h_q_yer*U2_RESIDENTIAL_PAC_AUX+res_U2_HH_IHR + pac_residential_pac_growth_neutrality_correction*U2_H_Q_YER400(-1);
    @#endif

	[blockname='residential',name='U2_HH_OIHR', rename='U2_HH_IHR_tmp->U2_HH_OIHR']
	log(U2_HH_OIHR) =  res_U2_HH_OIHR+u2_residential_tar_const+u2_beta_residential_trend*U2_TTREND+u2_beta_residential_u2_yer*log(U2_YER)+u2_beta_residential_u2_hh_u_ihr2*log(U2_HH_U_IHR2)+u2_beta_residential_u2_s_rppd_ihd*log(U2_S_RPPD_IHD);

	[blockname='residential',name='U2_RESIDENTIAL_PAC_AUX']
    U2_RESIDENTIAL_PAC_AUX =  U2_YER/U2_YER(-1)-1.0-U2_H_Q_YER400;

	[blockname='residential',name='U2_S_RPPD_IHD', type='longrun']
	U2_S_RPPD_IHD =  U2_HH_IHD/U2_RPPD;

	[blockname='residential',name='U2_Q_S_RPPD_IHD']
	U2_Q_S_RPPD_IHD =  diff(log(U2_S_RPPD_IHD))*100;

	[blockname='residential',name='U2_ES_RPPD_IHD']
	U2_ES_RPPD_IHD =  0.875*U2_ES_RPPD_IHD(-1)+U2_Q_S_RPPD_IHD*0.125;

	[blockname='residential',name='U2_HH_U_IHR2', type='longrun']
	U2_HH_U_IHR2 =  400*(0.034+U2_LRN/400-U2_EHIC/400-U2_ES_RPPD_IHD/100);

	[blockname='residential',name='U2_HH_S_IHD', type='longrun']
	U2_HH_S_IHD =  U2_HH_IHN/U2_HH_IHR/U2_HH_COD;

	[blockname='residential',name='U2_HH_IHN', type='longrun']
	log(U2_HH_IHN) =  log(U2_HH_IHR)+log(U2_HH_IHD);

	[blockname='labour',name='U2_LABOUR_PAC_PE']
	U2_LABOUR_PAC_PE =  h1_pac_labor_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_labor_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_labor_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_labor_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_labor_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_labor_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_labor_eq0_var_AUX_DIFF_258_lag_1*diff(log(U2_OLNN(-1))) + h1_pac_labor_eq0_var_U2_Q_TAU_lag_1*U2_Q_TAU(-1) + h1_pac_labor_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_labor_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_labor_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_labor_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_labor_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_labor_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_labor_eq0_var_AUX_DIFF_258_lag_2*diff(log(U2_OLNN(-2))) + h1_pac_labor_eq0_var_U2_Q_TAU_lag_2*U2_Q_TAU(-2);

	[blockname='labour',name='U2_LNN']
    @#if MCE_IN_PAC_LABOUR
        diff(log(U2_LNN)) =  u2_ecm_pac_labor*(log(U2_OLNN(-1))-log(U2_LNN(-1)))+u2_lnn_pac_u2_lnn_L1*diff(log(U2_LNN(-1)))+diff(U2_G_YER)*u2_lnn_u2_g_yer+pac_expectation(pac_labour)+res_U2_LNN + pac_labor_pac_growth_neutrality_correction*U2_Q_TAU(-1);
    @#else
        diff(log(U2_LNN)) =  u2_ecm_pac_labor*(log(U2_OLNN(-1))-log(U2_LNN(-1)))+u2_lnn_pac_u2_lnn_L1*diff(log(U2_LNN(-1)))+diff(U2_G_YER)*u2_lnn_u2_g_yer+U2_LABOUR_PAC_PE+res_U2_LNN + pac_labor_pac_growth_neutrality_correction*U2_Q_TAU(-1);
    @#endif

	[blockname='labour',name='U2_C_LNH']
	diff(log(U2_C_LNH)) =  u2_ecm_lnh*(log(U2_T_C_LNH(-1))-log(U2_C_LNH(-1)))+u2_c_lnh_a1*(diff(U2_G_YER)-diff(U2_G_LNN))+coeff_one*diff(log(U2_T_C_LNH))+res_U2_C_LNH;

	[blockname='labour',name='U2_OLSN', rename='U2_LSN_tmp->U2_OLSN']
	log(U2_OLSN) =  u2_olsn_constant+log(U2_OLNN)*coeff_one;

	[blockname='labour',name='U2_LSN']
	diff(log(U2_LSN)) =  diff(log(U2_LNN(-1)))*coeff_one+u2_lsn_L1*(log(U2_LSN(-1))-log(U2_OLSN(-1)))+res_U2_LSN;

	[blockname='labour',name='U2_R_LFP']
	diff(U2_R_LFP) =  u2_ecm_r_lfp*(U2_T_R_LFP(-1)-U2_R_LFP(-1))+u2_r_lfp_a1*(U2_R_LUN(-1)/100-U2_T_R_LUN(-1)/100)+coeff_one*diff(U2_T_R_LFP)+res_U2_R_LFP;

	[blockname='labour',name='U2_OLNN']
	log(U2_OLNN) =  (-0.1)*(log(U2_C_CER)-log(U2_C_CER_TAR))+log(U2_T_LNN);

	[blockname='labour',name='U2_TAU']
	diff(log(U2_TAU)) =  diff(log(U2_TAU(-1)))*dummy_long_run+log(1+u2_annual_pop_growth_rate/100)/4*(1-dummy_long_run)+res_U2_TAU;

	[blockname='labour',name='U2_Q_TAU']
	U2_Q_TAU =  log(U2_TAU)-log(U2_TAU(-1));

	[blockname='labour',name='U2_T_LNN']
	U2_T_LNN =  U2_T_R_LFP/100*U2_WAP*(1-U2_T_R_LUN/100);

	[blockname='labour',name='U2_G_LNN']
	U2_G_LNN =  100*(log(U2_LNN)-log(U2_T_LNN));

	[blockname='labour',name='U2_LEN', type='longrun']
	U2_LEN =  U2_LNN-U2_LSN;

	[blockname='labour',name='U2_LFN', type='longrun']
	U2_LFN =  U2_WAP*U2_R_LFP/100;

	[blockname='labour',name='U2_T_R_LUN']
	U2_T_R_LUN =  (1-u2_t_r_lun_l1)*u2_t_r_lun_lr+u2_t_r_lun_l1*U2_T_R_LUN(-1)+res_U2_T_R_LUN;

	[blockname='labour',name='U2_R_LUN', type='longrun']
	U2_R_LUN =  100*(1-U2_LNN/U2_LFN);

	[blockname='labour',name='U2_G_R_LUN']
	U2_G_R_LUN =  U2_R_LUN-U2_T_R_LUN;

	[blockname='labour',name='U2_T_R_LFP']
	U2_T_R_LFP =  (1-u2_t_r_lfp_l1)*u2_t_r_lfp_lr+u2_t_r_lfp_l1*U2_T_R_LFP(-1)+res_U2_T_R_LFP;

	[blockname='labour',name='U2_T_C_LNH']
	U2_T_C_LNH =  (1-u2_t_c_lnh_l1)*u2_t_c_lnh_lr+u2_t_c_lnh_l1*U2_T_C_LNH(-1)+res_U2_T_C_LNH;

	[blockname='labour',name='U2_WAP_ANNUAL_GROWTH']
	U2_WAP_ANNUAL_GROWTH =  u2_annual_pop_growth_rate/100+res_U2_WAP_ANNUAL_GROWTH;

	[blockname='labour',name='U2_WAP']
	U2_WAP =  U2_WAP(-1)*(1+U2_WAP_ANNUAL_GROWTH)^0.25;

	[blockname='trade',name='U2_MTR']
	diff(log(U2_MTR)) =  u2_coeff_one*(U2_H_Q_YER/100+U2_TREND_MTR_AUX)+u2_xxr_c*(1-DYN_H_TRADE)+u2_mtr_ecm*(log(U2_MTR(-1))-log(U2_MST(-1)))+u2_mtr_wer*(diff(log(U2_WER))-U2_H_Q_YER/100)+u2_mtr_eenx*diff(log(U2_EENX))+res_U2_MTR;

	[blockname='trade',name='U2_MND']
	diff(log(U2_MND)) =  u2_mnd_ecm*(log(U2_MND(-1))-log(U2_PMNST(-1)))+u2_mnd_lag1*(diff(log(U2_MND(-1)))-(diff(log(U2_YED(-1)))+U2_TREND_MND_AUX(-1)))+u2_mnd_cmd*(diff(log(U2_CMDEX))-diff(log(U2_YED)))+u2_mnd_med*(diff(log(U2_MED(-1)))-diff(log(U2_YED(-1))))+u2_dyn_trade*(diff(log(U2_YED))+U2_TREND_MND_AUX)+res_U2_MND;

	[blockname='trade',name='U2_XNR']
	diff(log(U2_XNR)) =  (1-DYN_H_TRADE)*u2_xnr_c+u2_coeff_one*(log(U2_MNR)-log(U2_MNR(-1)))+u2_coeff_fix*DYN_H_TRADE*(log(U2_MNR(-1))-log(U2_XNR(-1)))+res_U2_XNR;

	[blockname='trade',name='U2_XNN']
	diff(log(U2_XNN)) =  (1-DYN_H_TRADE)*u2_xnn_c+u2_coeff_one*(log(U2_MNN)-log(U2_MNN(-1)))+u2_coeff_fix*DYN_H_TRADE*(log(U2_MNN(-1))-log(U2_XNN(-1)))+res_U2_XNN;

	[blockname='trade',name='U2_XXR']
	diff(log(U2_XXR)) =  u2_xxr_c*(1-DYN_H_TRADE)+u2_coeff_one*(U2_H_Q_YER/100+U2_TREND_XXR_AUX)+u2_xxr_ecm*(log(U2_XXR(-1))-log(U2_XXST(-1)))+u2_xxr_wdrex*(diff(log(U2_WDREX))-(U2_H_Q_YER/100+U2_TREND_XXR_AUX))+diff(log(U2_EENX))*u2_xxr_eenx+res_U2_XXR;

	[blockname='trade',name='U2_XXD']
	diff(log(U2_XXD)) =  u2_xxd_ecm*(log(U2_XXD(-1))-log(U2_PXXST(-1)))+u2_xxd_cxd*(diff(log(U2_CXDEX))-diff(log(U2_YED)))+u2_dyn_trade*(diff(log(U2_YED))+U2_TREND_XXD_AUX)+u2_xxd_mxd*(diff(log(U2_MXD))-diff(log(U2_YED)))+res_U2_XXD;

	[blockname='trade',name='U2_MXR']
	log(U2_MXR) =  u2_coeff_one*log(U2_MXR(-1))+u2_coeff_one*U2_H_Q_YER/100+(1-DYN_H_TRADE)*u2_mxr_c+u2_mxr_ecm*(log(U2_MXR(-1))-log(U2_MXST(-1)))+(diff(log(U2_WER))-U2_H_Q_YER/100)*u2_mxr_wer+diff(log(U2_EENX))*u2_mxr_eenx+res_U2_MXR;

	[blockname='trade',name='U2_MXD']
	log(U2_MXD) =  log(U2_MXD(-1))+u2_coeff_one*diff(log(U2_YED))+u2_mxd_mpcom_1*(diff(log(U2_MED))-diff(log(U2_EXR))-diff(log(U2_YED)))+u2_mxd_ecm*(log(U2_MXD(-1))-log(U2_PMXST(-1)))+(diff(log(U2_CMDEX))-diff(log(U2_YED)))*u2_mxd_cmd+u2_mxd_mpcom_2*(diff(log(U2_MED(-1)))-diff(log(U2_EXR(-1)))-diff(log(U2_YED(-1))))+res_U2_MXD;

	[blockname='trade',name='U2_MST', rename='U2_MST_tmp->U2_MST']
	log(U2_MST) =  u2_mst_c+u2_coeff_one*log(U2_WER)+u2_mst_param_1*((log(U2_MTD)-0.094573*(log(U2_MED)-log(U2_EXR)))/0.905427-log(U2_YED))+u2_mst_trend*U2_TTREND;

	[blockname='trade',name='U2_PMNST', rename='U2_PMNST_tmp->U2_PMNST']
	log(U2_PMNST) =  u2_pmnst_c+u2_coeff_one*log(U2_MXD)+u2_pmnst_param1*(log(U2_YED)-log(U2_MXD))+U2_TTREND*u2_pmnst_trend;

	[blockname='trade',name='U2_XXST', rename='U2_XXST_tmp->U2_XXST']
	log(U2_XXST) =  u2_xxst_c+u2_coeff_one*log(U2_WDREX)+u2_xxst_param_1*(log(U2_XXD)-log(U2_CXDEX))+U2_TTREND*u2_xxst_trend;

	[blockname='trade',name='U2_PXXST', rename='U2_PXXST_tmp->U2_PXXST']
	log(U2_PXXST) =  u2_pxxst_c+u2_coeff_one*log(U2_CXDEX)+u2_pxxst_param_1*(log(U2_MXD)*u2_s_x_wer+log(U2_YED)*(1-u2_s_x_wer)-log(U2_CXDEX))+U2_TTREND*u2_pxxst_trend+u2_dummy_trend*U2_DUMMY_TREND;

	[blockname='trade',name='U2_MXST', rename='U2_MXST_tmp->U2_MXST']
	log(U2_MXST) =  u2_coeff_one*log(U2_WER)+u2_mxst_c+u2_mxst_param_1*((log(U2_MXD)-(log(U2_MED)-log(U2_EXR))*0.1165)/0.8835-log(U2_YED))+U2_TTREND*u2_mxst_trend;

	[blockname='trade',name='U2_PMXST', rename='U2_PMXST_tmp->U2_PMXST']
	log(U2_PMXST) =  u2_pmxst_c+u2_coeff_one*log(U2_CMDEX)+0.1165*(log(U2_MED)-log(U2_EXR)-log(U2_CMDEX))+0.30*(log(U2_YED)-log(U2_CMDEX))+U2_TTREND*u2_pmxst_trend;

	[blockname='trade',name='U2_XTD']
	U2_XTD =  (U2_XXR*U2_XXD+U2_XNR*U2_XND)/(U2_XXR+U2_XNR);

	[blockname='trade',name='U2_MTD']
	U2_MTD =  (U2_MXR*U2_MXD+U2_MNR*U2_MND)/(U2_MNR+U2_MXR);

	[blockname='trade',name='U2_WER']
	U2_WER =  u2_s_c_wer*U2_HH_COR+u2_s_g_wer*U2_GO_COR+u2_s_i_wer*U2_ITR+u2_s_x_wer*U2_XTR;

	[blockname='trade',name='U2_WEREX']
	U2_WEREX =  u2_s_c_wer*U2_HH_COR+u2_s_g_wer*U2_GO_COR+u2_s_i_wer*U2_ITR+u2_s_x_wer*U2_XXR;

	[blockname='trade',name='U2_CXDEX']
	log(U2_CXDEX) =  log(U2_CXEDEX)+log(U2_EENX);

	[blockname='trade',name='U2_CMDEX']
	log(U2_CMDEX) =  log(U2_CXEDEX)+log(U2_EENX)+res_U2_CMDEX;

	[blockname='trade',name='U2_MED']
	log(U2_MED) =  0.8*log(U2_POU)+0.2*log(U2_PCU);

	[blockname='trade',name='U2_MEED']
	log(U2_MEED) =  (log(U2_MTD)-0.094573*(log(U2_MED)-log(U2_EXR)))/0.905427;

	[blockname='trade',name='U2_XTR']
	U2_XTR =  U2_XXR+U2_XNR;

	[blockname='trade',name='U2_MNR']
	U2_MNR =  U2_MTR-U2_MXR;

	[blockname='trade',name='U2_XTN']
	log(U2_XTN) =  log(U2_XXN)+log(1+U2_XNN/U2_XXN);

	[blockname='trade',name='U2_MTN']
	log(U2_MTN) =  log(U2_MNN)+log(1+U2_MXN/U2_MNN);

	[blockname='trade',name='U2_XXN']
	log(U2_XXN) =  log(U2_XXR)+log(U2_XXD);

	[blockname='trade',name='U2_MXN']
	log(U2_MXN) =  log(U2_MXR)+log(U2_MXD);

	[blockname='trade',name='U2_MNN']
	log(U2_MNN) =  log(U2_MNR)+log(U2_MND);

	[blockname='trade',name='U2_XND']
	U2_XND =  U2_XNN/U2_XNR;

	[blockname='trade',name='U2_TREND_MTR_AUX']
	U2_TREND_MTR_AUX =  0.5*U2_TREND_MTR_AUX(-1)+res_U2_TREND_MTR_AUX;

	[blockname='trade',name='U2_TREND_MND_AUX']
	U2_TREND_MND_AUX =  0.5*U2_TREND_MND_AUX(-1)+res_U2_TREND_MND_AUX;

	[blockname='trade',name='U2_TREND_XXR_AUX']
	U2_TREND_XXR_AUX =  0.5*U2_TREND_XXR_AUX(-1)+res_U2_TREND_XXR_AUX;

	[blockname='trade',name='U2_TREND_XXD_AUX']
	U2_TREND_XXD_AUX =  0.5*U2_TREND_XXD_AUX(-1)+res_U2_TREND_XXD_AUX;

	[blockname='hicp',name='U2_HEG']
	diff(log(U2_HEG)) =  ONE*U2_EHIC/400+u2_heg_ecm*(log(U2_HEG(-1))-log(U2_OHEG(-1)))+u2_heg_med*(diff(log(U2_MED)-log(U2_EXR))-U2_EHIC/400)+u2_heg_med_lag*(diff(log(U2_MED(-1))-log(U2_EXR(-1)))-U2_EHIC(-1)/400)+res_U2_HEG;

	[blockname='hicp',name='U2_HEF']
	diff(log(U2_HEF)) =  ONE*U2_EHIC/400+u2_hef_ecm*(log(U2_HEF(-1))-log(U2_OHEF(-1)))+u2_hef_u2_yed*(diff((1-u2_hh_q_ocod_w)*log(U2_YED)+u2_hh_q_ocod_w*log(U2_MXDNO))-U2_EHIC/400)+u2_hef_ar*(diff(log(U2_HEF(-1)))-U2_EHIC(-1)/400)+res_U2_HEF;

	[blockname='hicp',name='U2_HEX']
	diff(log(U2_HEX)) =  ONE*U2_EHIC/400+u2_hex_ecm*(log(U2_HEX(-1))-log(U2_OHEX(-1)))+u2_hex_u2_yed*(diff(log(U2_YED))-U2_EHIC/400)+u2_hex_u2_yed_lag*(diff(log(U2_YED(-1)))-U2_EHIC(-1)/400)+res_U2_HEX;

	[blockname='hicp',name='U2_OHEG', rename='U2_OHEG_tmp->U2_OHEG']
	log(U2_OHEG) =  u2_oheg_constant+ONE*log(U2_MED)-ONE*log(U2_EXR)+u2_oheg_trend*U2_TREND_OHEG;

	[blockname='hicp',name='U2_OHEF', rename='U2_OHEF_tmp->U2_OHEF']
	log(U2_OHEF) =  u2_ohef_constant+(1-u2_hh_q_ocod_w)*log(U2_YED)+u2_hh_q_ocod_w*log(U2_MXDNO);

	[blockname='hicp',name='U2_OHEX', rename='U2_OHEX_tmp->U2_OHEX']
	log(U2_OHEX) =  u2_ohex_constant+u2_ohex_coeff_1*log(U2_OHEF)+u2_ohex_coeff_2*(log(U2_C_CEN)-log(U2_T_PRO))+u2_ohex_trend*U2_TREND_OHEX;

	[blockname='hicp',name='U2_HIF', type='longrun']
	log(U2_HIF) =  U2_ZHIF+((1-u2_hicp_we)*log(U2_HEX)-(1-u2_hicp_we-u2_hicp_wf)*log(U2_HEF))/u2_hicp_wf;

	[blockname='hicp',name='U2_HICP', type='longrun']
	log(U2_HICP) =  U2_ZHICP+(1-u2_hicp_we)*log(U2_HEX)+u2_hicp_we*log(U2_HEG);

	[blockname='hicp',name='U2_MXDNO', type='longrun']
	log(U2_MXDNO) =  (log(U2_MXD)-u2_mx_we*(log(U2_MED)-log(U2_EXR)))/(1-u2_mx_we);

	[blockname='hicp',name='U2_ZHICP']
	U2_ZHICP =  U2_ZHICP(-1)*DYN_H_HICP+res_U2_ZHICP;

	[blockname='hicp',name='U2_ZHIF']
	U2_ZHIF =  DYN_H_HICP*U2_ZHIF(-1)+res_U2_ZHIF;

	[blockname='wage',name='U2_G_C_CER_VE']
	U2_G_C_CER_VE =  var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_0*U2_STN + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_0*U2_G_C_CER + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_0*U2_T_G_C_CER + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_G_C_CER_1*U2_G_C_CER(-1) + var_expectation_model_U2_G_C_CER_OP_FCAST_U2_T_G_C_CER_1*U2_T_G_C_CER(-1);

    [blockname='wage',name='U2_G_C_CER']
    @#if MCE_IN_WAGE
        U2_G_C_CER =  (0.511193176387121*U2_G_C_CER(1)+0.3*U2_G_C_CER(-1)+0.200049137480719*(U2_EHIC-u2_annual_inflation_rate)-0.5913867897056069*U2_G_A_YED+0.391337652224888*U2_G_A_YED(-1))/1.153357952916136-0.092082630991800*U2_G_R_LUN(-1)+res_U2_G_C_CER;
    @#else
        U2_G_C_CER =  (0.511193176387121*U2_G_C_CER_VE+0.3*U2_G_C_CER(-1)+0.200049137480719*(U2_EHIC-u2_annual_inflation_rate)-0.5913867897056069*U2_G_A_YED+0.391337652224888*U2_G_A_YED(-1))/1.153357952916136-0.092082630991800*U2_G_R_LUN(-1)+res_U2_G_C_CER;
    @#endif

    [blockname='wage',name='U2_C_CER_TAR']
	log(U2_C_CER_TAR) =  log(1-u2_alpha)-0.173953307123438+log(U2_T_YER)-log(U2_T_LNN)+log(U2_YED)-log(U2_HH_COD);

	[blockname='wage',name='U2_C_CER']
	log(U2_C_CER) =  log(U2_C_CER_TAR)+U2_G_C_CER/100;

	[blockname='wage',name='U2_WAN']
	log(U2_WAN) =  log(U2_C_WAN)+log(U2_LEN);

	[blockname='wage',name='U2_C_CEN']
	log(U2_C_CEN) =  log(U2_HH_COD)+log(U2_C_CER);

	[blockname='wage',name='U2_A_C_CEN']
	U2_A_C_CEN =  100*((U2_HH_COD*U2_C_CER/(U2_C_CER(-1)*U2_HH_COD(-1)))^4-1);

	[blockname='wage',name='U2_A_C_CER']
	U2_A_C_CER =  100*((U2_C_CER/U2_C_CER(-1))^4-1);

	[blockname='wage',name='U2_C_WAR']
	U2_C_WAR =  U2_C_CER-U2_C_GO_BU_SCN/U2_HH_COD;

	[blockname='wage',name='U2_C_WAN']
	log(U2_C_WAN) =  log(U2_HH_COD)+log(U2_C_WAR);

	[blockname='wage',name='U2_A_C_WAN']
	U2_A_C_WAN =  100*((U2_HH_COD*U2_C_WAR/(U2_HH_COD(-1)*U2_C_WAR(-1)))^4-1);

	[blockname='wage',name='U2_A_C_CER_TAR']
	U2_A_C_CER_TAR =  100*((U2_C_CER_TAR/U2_C_CER_TAR(-1))^4-1);

	[blockname='wage',name='U2_T_A_C_CEN']
	U2_T_A_C_CEN =  4*U2_H_Q_YER-400*diff(log(U2_TAU))+U2_EHIC;

	[blockname='wage',name='U2_C_GO_BU_SCN']
	U2_C_GO_BU_SCN =  U2_GO_BU_R_SCN*U2_C_CEN;

	[blockname='wapro',name='U2_YED']
	log(U2_YED) =  log(U2_YED(-1))+log((1+U2_A_YED/100)^0.25);

	[blockname='wapro',name='U2_A_YED_VE']
	U2_A_YED_VE =  var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_0*U2_STN + var_expectation_model_U2_A_YED_OP_FCAST_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_A_YED_OP_FCAST_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_A_YED_OP_FCAST_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_A_YED_OP_FCAST_U2_EHIC_1*U2_EHIC(-1) + var_expectation_model_U2_A_YED_OP_FCAST_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_A_YED_OP_FCAST_U2_STN_1*U2_STN(-1);

    [blockname='wapro',name='U2_A_YED']
    @#if MCE_IN_WAPRO
        U2_A_YED =  (0.387271924091236*U2_A_YED(-1)+0.629532709573858*U2_A_YED(1)+0.2269957100499433*U2_EHIC+0.421357609729608*(U2_G_C_CER+0.4285714285714286*U2_G_YER))/1.243800343715037+res_U2_A_YED;
    @#else
	    U2_A_YED =  (0.387271924091236*U2_A_YED(-1)+0.629532709573858*U2_A_YED_VE+0.2269957100499433*U2_EHIC+0.421357609729608*(U2_G_C_CER+0.4285714285714286*U2_G_YER))/1.243800343715037+res_U2_A_YED;
    @#endif

    [blockname='wapro',name='U2_EHIC', type='longrun']
	U2_EHIC =  0.75*U2_EHIC(-1)+0.25*(U2_A_YED(-1)*0.1+0.9*U2_A_YED_TAR(-1))+res_U2_EHIC;

	[blockname='wapro',name='U2_A4_YED']
	U2_A4_YED =  100*(U2_YED/U2_YED(-4)-1);

	[blockname='wapro',name='U2_G_A_YED']
	U2_G_A_YED =  U2_A_YED-U2_A_YED_TAR;

	[blockname='wapro',name='U2_A_YED_TAR']
	U2_A_YED_TAR =  0.9596*U2_A_YED_TAR(-1)+0.04039999999999999*u2_annual_inflation_rate;

	[blockname='inventories',name='U2_SIVR']
	diff(log(U2_SIVR)) =  u2_ecm_sivr*(log(U2_T_Y_SIVR(-1))-log(U2_Y_SIVR(-1)))+u2_sivr_L1*(log(U2_SIVR(-1))-log(U2_SIVR(-2)))+(1-u2_sivr_L1)*(log(U2_YER(-1))-log(U2_YER(-2)))+res_U2_SIVR;

	[blockname='inventories',name='U2_Y_SIVR']
	U2_Y_SIVR =  U2_SIVR/U2_YER;

    [blockname='inventories',name='U2_T_Y_SIVR']
    @#if U2_T_Y_SIVR_FIX
        U2_T_Y_SIVR =  U2_Y_SIVR+res_U2_T_Y_SIVR;
    @#else
	    U2_T_Y_SIVR =  U2_T_Y_SIVR(-1)*u2_y_sivr_L1+u2_y_sivr_u2_t_y_sivr*(U2_Y_SIVR-U2_T_Y_SIVR(-1))+res_U2_T_Y_SIVR;
    @#endif

	[blockname='inventories',name='U2_IVR']
	U2_IVR =  U2_SIVR-U2_SIVR(-1);

	[blockname='houseprice',name='U2_HOUSEPRICE_PAC_PE']
	U2_HOUSEPRICE_PAC_PE =  h1_pac_houseprice_eq0_var_U2_A_YED_lag_1*U2_A_YED(-1) + h1_pac_houseprice_eq0_var_U2_G_YER_lag_1*U2_G_YER(-1) + h1_pac_houseprice_eq0_var_U2_STN_lag_1*U2_STN(-1) + h1_pac_houseprice_eq0_var_U2_G_EYER_lag_1*U2_G_EYER(-1) + h1_pac_houseprice_eq0_var_U2_ESTN_lag_1*U2_ESTN(-1) + h1_pac_houseprice_eq0_var_U2_EHIC_lag_1*U2_EHIC(-1) + h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_1*diff(log(U2_OS_RPPD(-1))) + h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_1*U2_OS_RPPD_T(-1) + h1_pac_houseprice_eq0_var_U2_A_YED_lag_2*U2_A_YED(-2) + h1_pac_houseprice_eq0_var_U2_G_YER_lag_2*U2_G_YER(-2) + h1_pac_houseprice_eq0_var_U2_STN_lag_2*U2_STN(-2) + h1_pac_houseprice_eq0_var_U2_G_EYER_lag_2*U2_G_EYER(-2) + h1_pac_houseprice_eq0_var_U2_ESTN_lag_2*U2_ESTN(-2) + h1_pac_houseprice_eq0_var_U2_EHIC_lag_2*U2_EHIC(-2) + h1_pac_houseprice_eq0_var_AUX_DIFF_202_lag_2*diff(log(U2_OS_RPPD(-2))) + h1_pac_houseprice_eq0_var_U2_OS_RPPD_T_lag_2*U2_OS_RPPD_T(-2);

	[blockname='houseprice',name='U2_S_RPPD']
    @#if MCE_IN_PAC_HOUSEPRICE
        diff(log(U2_S_RPPD)) =  u2_ecm_pac_houseprice*(log(U2_OS_RPPD(-1))-log(U2_S_RPPD(-1)))+u2_s_rppd_pac_u2_s_rppd_L1*diff(log(U2_S_RPPD(-1)))+pac_expectation(pac_houseprice)+res_U2_S_RPPD + pac_houseprice_pac_growth_neutrality_correction*U2_OS_RPPD_T;
    @#else
        diff(log(U2_S_RPPD)) =  u2_ecm_pac_houseprice*(log(U2_OS_RPPD(-1))-log(U2_S_RPPD(-1)))+u2_s_rppd_pac_u2_s_rppd_L1*diff(log(U2_S_RPPD(-1)))+U2_HOUSEPRICE_PAC_PE+res_U2_S_RPPD + pac_houseprice_pac_growth_neutrality_correction*U2_OS_RPPD_T;
    @#endif

	[blockname='houseprice',name='U2_OS_RPPD', rename='U2_S_RPPD_tmp->U2_OS_RPPD']
	log(U2_OS_RPPD) =  u2_c_houseprice_tar+u2_beta_houseprice_hh_dir*(log(U2_HH_DIR)-log(U2_SKHR))+u2_beta_houseprice_hh_u_ihr*log(U2_HH_U_IHR)+res_U2_S_ORPPD;

	[blockname='houseprice',name='U2_RPPD', type='longrun']
	U2_RPPD =  U2_S_RPPD*U2_HH_COD;

	[blockname='houseprice',name='U2_Q16_S_RPPD']
	U2_Q16_S_RPPD =  (log(U2_S_RPPD)-log(U2_S_RPPD(-1)))*100/16+0.9375*U2_Q16_S_RPPD(-1);

	[blockname='houseprice',name='U2_HH_U_IHR', type='longrun']
	U2_HH_U_IHR =  400*(0.034+U2_HH_L_IHN/400-U2_EHIC/400+U2_S_TIH/4-U2_Q16_S_RPPD*0.4/100);

	[blockname='houseprice',name='U2_SKHR', type='longrun']
	U2_SKHR =  U2_SKHR(-1)*(1-U2_D_IHR/100)+U2_HH_IHR;

	[blockname='financial-nfa',name='U2_dUSTP_10Y', type='longrun']
	U2_dUSTP_10Y =  U2_USTP_10Y-u2_ustp_10y_constant/0.09999999999999998;

	[blockname='financial-nfa',name='U2_USTP_10Y', type='longrun']
	U2_USTP_10Y =  u2_ustp_10y_constant+0.9*U2_USTP_10Y(-1)+res_U2_USTP_10Y;

	[blockname='financial-nfa',name='U2_TP_10YEXO']
	U2_TP_10YEXO =  u2_tp_10y_L1*U2_TP_10YEXO(-1)+res_U2_TP_10Y;

    [blockname='financial-nfa',name='U2_TP_10YENDO']
	U2_TP_10YENDO =  u2_tp_10y_constant+u2_tp_10y_L1*U2_TP_10YENDO(-1)+U2_G_YER_E10Y*u2_tp_10y_u2_g_yer_e10y+u2_tp_10y_L1_u2_dustp_10y*U2_dUSTP_10Y+res_U2_TP_10YENDO;

	[blockname='financial-nfa',name='U2_TP_10Y']
    U2_TP_10Y = U2_TP_10YENDO + U2_TP_10YEXO;

    @#if MCE_IN_LONG_TERM_INTEREST_RATE

        [blockname='financial-nfa',name='U2_RFB_E10Y']
        U2_RFB_E10Y = couponBB/(1+U2_STN/100)^0.25+(1-tauBB)*U2_RFB_E10Y(1)/(1+U2_STN/100)^0.25;

        [blockname='financial-nfa',name='U2_RFB_10Y']
        U2_RFB_10Y = couponBB/(1+U2_STN/100)^0.25/(1+U2_TP_10Y(1)/100)^0.25+(1-tauBB)*U2_RFB_10Y(1)/(1+U2_STN/100)^0.25/(1+U2_TP_10Y(1)/100)^0.25;

        [blockname='financial-nfa',name='U2_RFCB_10Y']
        U2_RFCB_10Y = couponBB/(1+U2_STN/100)^0.25/(1+U2_SCB(1)/100)^0.25+(1-tauBB)*U2_RFCB_10Y(1)/(1+U2_STN/100)^0.25/(1+U2_SCB(1)/100)^0.25;

        [blockname='financial-nfa',name='U2_STN_E10Y']
        @#if EXACT_EXPECTATIONS_10Y
            U2_STN_E10Y = (1/40)*(U2_STN
            @#for i in 1:39
                + U2_STN(@{i})
            @#endfor
            );
        @#else
            U2_STN_E10Y = 100*((((1-tauBB)*U2_RFB_E10Y+couponBB)/(U2_RFB_E10Y))^4-1);
        @#endif
    @#else

        [blockname='financial-nfa',name='U2_STN_E10Y']
	    U2_STN_E10Y =  1/(1+maturity_val)*U2_STN_E10Y_VE;

    @#endif

	[blockname='financial-nfa',name='U2_STN_E10Y_VE']
	U2_STN_E10Y_VE =  var_expectation_model_U2_STN_FIN_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_STN_FIN_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_STN_FIN_U2_STN_0*U2_STN + var_expectation_model_U2_STN_FIN_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_STN_FIN_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_STN_FIN_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_STN_FIN_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_STN_FIN_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_STN_FIN_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_STN_FIN_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_STN_FIN_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_STN_FIN_U2_EHIC_1*U2_EHIC(-1);

	[blockname='financial-nfa',name='U2_HH_SL_CON']
	U2_HH_SL_CON =  u2_hh_sl_con_L1*U2_HH_SL_CON(-1)+U2_G_YER_E10Y*u2_hh_sl_con_u2_g_yer_e10y+u2_hh_sl_con_constant+res_U2_HH_SL_CON;

	[blockname='financial-nfa',name='U2_HH_SL_IHN', type='longrun']
	U2_HH_SL_IHN =  u2_hh_sl_ihn_L1*U2_HH_SL_IHN(-1)+U2_G_YER_E10Y*u2_hh_sl_ihn_u2_g_yer_e10y+u2_hh_sl_ihn_constant+res_U2_HH_SL_IHN;

	[blockname='financial-nfa',name='U2_SLRN', type='longrun']
	U2_SLRN =  u2_slrn_L1*U2_SLRN(-1)+U2_G_YER_E10Y*u2_slrn_u2_g_yer_e10y+u2_slrn_constant+res_U2_SLRN;

	[blockname='financial-nfa',name='U2_SCB', type='longrun']
	U2_SCB =  u2_scb_L1*U2_SCB(-1)+U2_G_YER_E10Y*u2_scb_u2_g_yer_e10y+u2_scb_constant+res_U2_SCB;

	[blockname='financial-nfa',name='U2_SCOE', type='longrun']
	U2_SCOE =  u2_scoe_L1*U2_SCOE(-1)+U2_G_YER_E10Y*u2_scoe_u2_g_yer_e10y+u2_scoe_constant+res_U2_SCOE;

	[blockname='financial-nfa',name='U2_HH_SL_DEP', type='longrun']
	U2_HH_SL_DEP =  u2_hh_sl_dep_L1*U2_HH_SL_DEP(-1)+U2_G_YER_E10Y*u2_hh_sl_dep_u2_g_yer_e10y+u2_hh_sl_dep_constant+res_U2_HH_SL_DEP;

	[blockname='financial-nfa',name='U2_HH_L_CON', type='longrun']
	U2_HH_L_CON =  U2_STN*(1-u2_hh_l_con_u2_ois_10y)+u2_hh_l_con_u2_ois_10y*U2_OIS_10Y+U2_HH_SL_CON+res_U2_HH_L_CON;

	[blockname='financial-nfa',name='U2_HH_L_IHN', type='longrun']
	U2_HH_L_IHN =  U2_STN*(1-u2_hh_l_ihn_u2_ois_10y)+U2_OIS_10Y*u2_hh_l_ihn_u2_ois_10y+U2_HH_SL_IHN+res_U2_HH_L_IHN;

	[blockname='financial-nfa',name='U2_LRN', type='longrun']
	U2_LRN =  U2_STN*(1-u2_lrn_u2_ois_10y)+U2_OIS_10Y*u2_lrn_u2_ois_10y+U2_SLRN+res_U2_LRN;

	[blockname='financial-nfa',name='U2_HH_L_DEP', type='longrun']
	U2_HH_L_DEP =  U2_STN*(1-u2_hh_l_dep_u2_ois_10y)+U2_OIS_10Y*u2_hh_l_dep_u2_ois_10y+U2_HH_SL_DEP+res_U2_HH_L_DEP;

	[blockname='financial-nfa',name='U2_CB', type='longrun']
	U2_CB =  U2_STN*(1-u2_cb_u2_ois_10y)+U2_OIS_10Y*u2_cb_u2_ois_10y+U2_SCB+res_U2_CB;

	[blockname='financial-nfa',name='U2_COE', type='longrun']
	U2_COE =  U2_STN*(1-u2_coe_u2_ois_10y)+U2_OIS_10Y*u2_coe_u2_ois_10y+U2_SCOE+res_U2_COE;

	[blockname='financial-nfa',name='U2_OIS_10Y', type='longrun']
	U2_OIS_10Y =  U2_STN_E10Y+U2_TP_10Y;

	[blockname='financial-nfa',name='U2_G_YER_E10Y_VE']
	U2_G_YER_E10Y_VE =  var_expectation_model_U2_G_YER_FIN_U2_A_YED_0*U2_A_YED + var_expectation_model_U2_G_YER_FIN_U2_G_YER_0*U2_G_YER + var_expectation_model_U2_G_YER_FIN_U2_STN_0*U2_STN + var_expectation_model_U2_G_YER_FIN_U2_G_EYER_0*U2_G_EYER + var_expectation_model_U2_G_YER_FIN_U2_ESTN_0*U2_ESTN + var_expectation_model_U2_G_YER_FIN_U2_EHIC_0*U2_EHIC + var_expectation_model_U2_G_YER_FIN_U2_A_YED_1*U2_A_YED(-1) + var_expectation_model_U2_G_YER_FIN_U2_G_YER_1*U2_G_YER(-1) + var_expectation_model_U2_G_YER_FIN_U2_STN_1*U2_STN(-1) + var_expectation_model_U2_G_YER_FIN_U2_G_EYER_1*U2_G_EYER(-1) + var_expectation_model_U2_G_YER_FIN_U2_ESTN_1*U2_ESTN(-1) + var_expectation_model_U2_G_YER_FIN_U2_EHIC_1*U2_EHIC(-1);

    @#if MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP

        [blockname='financial-nfa',name='U2_G_YER_E10Y']
        @#if EXACT_EXPECTATIONS_10Y
            U2_G_YER_E10Y = (1/40)*(U2_G_YER
            @#for i in 1:39
                + U2_G_YER(@{i})
            @#endfor
            );
        @#else
            U2_G_YER_E10Y = TPM_GAP;
        @#endif

        [blockname='financial-nfa',name='TPM_GAP']
        TPM_GAP = tauBB*U2_G_YER/(1+U2_STN/100)^0.25+(1-tauBB)*TPM_GAP(1)/(1+U2_STN/100)^0.25;

    @#else

	    [blockname='financial-nfa',name='U2_G_YER_E10Y']
	    U2_G_YER_E10Y =  1/(1+maturity_val)*U2_G_YER_E10Y_VE;

    @#endif

	[blockname='financial-nfa',name='U2_NFANRV_S']
	U2_NFANRV_S =  u2_nfanrv_s_u2_ywd*(log(U2_YWD)-log(U2_YWD(-1))-0.25*log(1+u2_annual_inflation_rate/100))+u2_nfanrv_s_u2_yed*(log(U2_YED)-log(U2_YED(-1))-0.25*log(1+u2_annual_inflation_rate/100))+u2_nfanrv_s_u2_eenx*diff(log(U2_EENX))+u2_nfanrv_s_constant*dummy_long_run+u2_nfanrv_s_u2_ir*(U2_IR_TLN-U2_IR_TLN(-1)-(U2_IR_TAN-U2_IR_TAN(-1)))+res_U2_NFANRV_S;

	[blockname='financial-nfa',name='U2_IR_TAN']
	U2_IR_TAN =  u2_ir_tln_tmp_ir_const+u2_tp_10y_constant/(1-u2_tp_10y_L1)+coeff_one*U2_IR_TAN_RV+u2_ir_tan_us_10y*(U2_US_10Y-3.2-u2_tp_10y_constant/(1-u2_tp_10y_L1));

	[blockname='financial-nfa',name='U2_IR_TLN']
	U2_IR_TLN =  u2_ir_tln_tmp_ir_const+u2_tp_10y_constant/(1-u2_tp_10y_L1)+coeff_one*U2_IR_TLN_RV+u2_ir_tln_u2_ois_10y*(U2_OIS_10Y-3.2-u2_tp_10y_constant/(1-u2_tp_10y_L1));

	[blockname='financial-nfa',name='U2_BU_L_ITN', type='longrun']
	U2_BU_L_ITN =  u2_bu_l_itn_u2_cb*U2_CB+u2_bu_l_itn_u2_lrn*U2_LRN+u2_bu_l_itn_u2_coe*U2_COE;

end;


@#if MCE_IN_PAC_CONSUMPTION
    pac.initialize('pac_consumption');
    pac.mce.parameters('pac_consumption');
@#endif

@#if MCE_IN_PAC_BUSINESS
    pac.initialize('pac_business');
    pac.mce.parameters('pac_business');
@#endif

@#if MCE_IN_PAC_HOUSEPRICE
    pac.initialize('pac_houseprice');
    pac.mce.parameters('pac_houseprice');
@#endif

@#if MCE_IN_PAC_PROPERTY_INCOME
    pac.initialize('pac_property_income');
    pac.mce.parameters('pac_property_income');
@#endif

@#if MCE_IN_PAC_RESIDENTIAL
    pac.initialize('pac_residential');
    pac.mce.parameters('pac_residential');
@#endif

@#if MCE_IN_PAC_LABOUR
    pac.initialize('pac_labour');
    pac.mce.parameters('pac_labour');
@#endif

@#if !BACKWARD
    @#if BUILD_IRFS

        @#define SimulationPeriods  = 1500
        @#define IrfPeriods = 120

        @#define ShockName = "res_U2_STN"
        @#define ShockValue = 1
        @#include "./templates/build-irfs.mod"

        @#define ShockName = "res_U2_TP_10Y"
        @#define ShockValue = 1
        @#include "./templates/build-irfs.mod"

        @#define ShockName = "res_U2_A_YED"
        @#define ShockValue = 0.1
        @#include "./templates/build-irfs.mod"

        @#define ShockName = "res_U2_G_C_CER"
        @#define ShockValue = 0.1
        @#include "./templates/build-irfs.mod"

        @#define ShockName = "res_U2_Q_T_PRO"
        @#define ShockValue = 0.01
        @#include "./templates/build-irfs.mod"

        @#define ShockName = "res_U2_SLRN"
        @#define ShockValue = 0.1
        @#include "./templates/build-irfs.mod"

    @#elseif FORWARD_GUIDANCE_PUZZLE

        @#include "update-database.mod"

        initval_file(series=baseline, first_obs=3);
        perfect_foresight_setup(periods=1500);
        perfect_foresight_solver(stack_solve_algo=0);

        Baseline = dseries([transpose(oo_.endo_simul), oo_.exo_simul], 5000Q1, [M_.endo_names; M_.exo_names]);

        nperiods = options_.periods;

        irfs = cell(20,1);

        @#for i in [i for i in 1:20]

            shocks;
                var res_U2_STN;
                periods @{i};
                values 1;
            end;

            initval_file(series=baseline, first_obs=3);
            perfect_foresight_setup(periods=1500);
            perfect_foresight_solver(stack_solve_algo=0, no_homotopy);

            irfs{@{i}} = dseries(Simulated_time_series.data, Baseline.dates(5), Simulated_time_series.name);

            shocks(overwrite);
            end;

            initval_file(series=baseline, first_obs=3);
            perfect_foresight_setup(periods=1500);
            perfect_foresight_solver(stack_solve_algo=0);

        @#endfor

        save(sprintf('irfs_data_fgp_%s', M_.fname), 'irfs');

        dev = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y'};
        pdev = {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_LNN', 'U2_EENX'};
        adev = {};
        qdev = {};
        ydev = {};
        variables = [dev, pdev, adev, qdev, ydev];
        variables = setdiff(variables, {'U2_HH_COR', 'U2_LNN', 'U2_YER', 'U2_BU_ITR'}); % Remove trended variables.

        @#if BUILD_MATLAB_PLOTS

            if ~isfolder('./eps')
                mkdir('./eps')
            end

            ColourMatrix = [0 0 1;
                1 0 0];

            figure;

            % U2_STN
            s1 = subplot(2, 2, 1);
            hold on
            for i=1:20
                lambda = 1-i/20;
                plot(irfs{i}.U2_STN.data(1:60), 'linewidth', 1.5, 'color', lambda*ColourMatrix(1,:) + (1-lambda)*ColourMatrix(2,:))
            end
            hold off
            grid on
            box on
            title('U2_STN','Interpreter','none')
            set(s1,'FontName','cmr12');

            % U2_G_YER
            s2 = subplot(2, 2, 2);
            hold on
            for i=1:20
                lambda = 1-i/20;
                plot(irfs{i}.U2_G_YER.data(1:60), 'linewidth', 1.5, 'color', lambda*ColourMatrix(1,:) + (1-lambda)*ColourMatrix(2,:))
            end
            hold off
            grid on
            box on
            title('U2_G_YER','Interpreter','none')
            set(s2,'FontName','cmr12');

            % U2_A_YED
            s3 = subplot(2, 2, 3);
            hold on
            for i=1:20
                lambda = 1-i/20;
                plot(irfs{i}.U2_A_YED.data(1:60), 'linewidth', 1.5, 'color', lambda*ColourMatrix(1,:) + (1-lambda)*ColourMatrix(2,:))
            end
            hold off
            grid on
            box on
            title('U2_A_YED','Interpreter','none')
            set(s3,'FontName','cmr12');

        @#endif

        @#ifdef SUBFOLDERNAME
            % Save data for PGF plots
            for i=1:length(variables)
                if ~exist(sprintf('../irfs-data/hybrid/%s', '@{SUBFOLDERNAME}'))
                    mkdir(sprintf('../irfs-data/hybrid/%s', '@{SUBFOLDERNAME}'));
                end
                fid = fopen(sprintf('../irfs-data/hybrid/%s/%s.dat', '@{SUBFOLDERNAME}', variables{i}), 'w');
                fprintf(fid, '%d \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f \t %12.6f\n', [1:60; transpose(irfs{1}.(variables{i}).data(1:60)); transpose(irfs{2}.(variables{i}).data(1:60)); transpose(irfs{3}.(variables{i}).data(1:60)); transpose(irfs{4}.(variables{i}).data(1:60)); transpose(irfs{5}.(variables{i}).data(1:60)); transpose(irfs{6}.(variables{i}).data(1:60)); transpose(irfs{7}.(variables{i}).data(1:60)); transpose(irfs{8}.(variables{i}).data(1:60)); transpose(irfs{9}.(variables{i}).data(1:60)); transpose(irfs{10}.(variables{i}).data(1:60)); transpose(irfs{11}.(variables{i}).data(1:60)); transpose(irfs{12}.(variables{i}).data(1:60)); transpose(irfs{13}.(variables{i}).data(1:60)); transpose(irfs{14}.(variables{i}).data(1:60)); transpose(irfs{15}.(variables{i}).data(1:60)); transpose(irfs{16}.(variables{i}).data(1:60)); transpose(irfs{17}.(variables{i}).data(1:60)); transpose(irfs{18}.(variables{i}).data(1:60)); transpose(irfs{19}.(variables{i}).data(1:60)); transpose(irfs{20}.(variables{i}).data(1:60))]);
                fclose(fid);
            end
       @#endif

       @#if BUILD_MATLAB_PLOTS
           lgd = legend('t=1', 't=2', 't=3', 't=4', 't=5', 't=6', 't=7', 't=8', 't=9', 't=10', ...
                         't=11', 't=12', 't=13', 't=14', 't=15', 't=16', 't=17', 't=18', 't=19', 't=20');

            % Programatically move the Legend
            set(lgd, ...
                'Position', [0.634934617934261 0.0803022281216621 0.202486960333143 0.380774024125193], ...
                'NumColumns', 2, ...
                'LineWidth', 1, ...
                'FontSize', 18, ...
                'FontName', 'cmr12', ...
                'Box', 'off');

            print(sprintf('./eps/fgp_%s', M_.fname), '-depsc2');

       @#endif

    @#elseif EXPECTED_PRODUCTIVITY_SHOCK

        @#include "update-database.mod"

        initval_file(series=baseline, first_obs=3);
        perfect_foresight_setup(periods=1500);
        perfect_foresight_solver(stack_solve_algo=0);

        Baseline = dseries([transpose(oo_.endo_simul), oo_.exo_simul], 5000Q1, [M_.endo_names; M_.exo_names]);

        nperiods = options_.periods;

        // List of variables to be plotted as deviations
        dev = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y'};

        // List of variables to be plotted as percentage deviations *100
        pdev = {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_LNN', 'U2_EENX'};

        // List of variables to be plotted as 4th sqrt of log diff
        adev = {};

        // List of variables to be plotted as log diff *100
        qdev = {};
        ydev = {};

        variables = [dev, pdev, adev, qdev, ydev];

        // Subplots parameters
        nvar = length(variables); // Number of subplots is the number of endogenous variables
        nrow = ceil(sqrt(nvar));  // Number of rows
        ncol = ceil(nvar/nrow);   // Number of columns

        // Set the number of periods.
        speriods = 120;

        shockvalues = [0.01 0.01 0.01 0.01];// 0.01 0.01 0.01 0.01];

        shocks;
            var res_U2_Q_T_PRO;
            periods 44:47;
            values (shockvalues);
        end;

        initval_file(series=baseline, first_obs=3);
        perfect_foresight_setup(periods=1500);
        perfect_foresight_solver(stack_solve_algo=0, no_homotopy);

        irfs = dseries('mat/irfs_backward_model_res_U2_Q_T_PRO.mat');

        Simulated_time_series = dseries(Simulated_time_series.data, Baseline.dates(1), Simulated_time_series.name);
        Simulated_time_series = irf_trans_report(Baseline, Simulated_time_series, 'dev', dev, 'pdev', pdev, 'qdev', qdev, 'adev', adev, 'ydev', ydev, 'start_date', Baseline.dates(2));
        irfs = irf_trans_report(baseline, irfs, 'dev', dev, 'pdev', pdev, 'qdev', qdev, 'adev', adev, 'ydev', ydev, 'start_date', irfs.dates(1));

        @#if BUILD_MATLAB_PLOTS

            if ~isfolder('./pdf')
                mkdir('./pdf')
            end

            figure('Name', 'Shock to res_U2_Q_T_PRO (.01)', 'visible', 'off');
            for i=1:nvar
                subplot(nrow, ncol, i)
                plot(Simulated_time_series{variables{i}}.data(2:(2+speriods)), '-', 'linewidth', 2)
                axis tight
                title(variables{i}, 'Interpreter', 'none')
            end
            set(findall(gcf,'-property','FontSize'),'FontSize',5)
            set(findall(gcf, 'Type', 'Text'),'FontWeight', 'Normal')
            print(sprintf('./pdf/irf_%s.pdf', 'res_U2_Q_T_PRO'),'-dpdf', '-bestfit');

        @#endif

        @#ifdef SUBFOLDERNAME
            % Save data for PGF plots
            for i=1:length(variables)
                if ~exist(sprintf('../irfs-data/hybrid/%s', '@{SUBFOLDERNAME}'))
                    mkdir(sprintf('../irfs-data/hybrid/%s', '@{SUBFOLDERNAME}'));
                end
                fid = fopen(sprintf('../irfs-data/hybrid/%s/%s.dat', '@{SUBFOLDERNAME}', variables{i}), 'w');
                fprintf(fid, '%d \t %12.6f\n', [0:120; transpose(Simulated_time_series{variables{i}}.data(1:(1+speriods)))]);
                fclose(fid);
            end
        @#endif

    @#endif

@#endif

if isfile('./baseline_updated.mat')
    delete baseline_updated.mat
end

if isfile('./baseline_updated.old.mat')
    delete baseline_updated.old.mat
end

if isfile('./hybrid.log')
    delete hybrid.log
end

if isfile('./hybrid_results.mat')
    delete hybrid_results.mat
end

if isfolder('./+hybrid')
    rmdir('+hybrid', 's');
    rmdir('hybrid', 's');
end
