function haschanged = isnew(thisfile)

% Returns true if and only if a file has changed.
%
% INPUTS
% - thisfile       [char]        1×n array, full name of a file (with path and extension)
%
% OUTPUTS
% - haschanged     [logical]     scalar, true iff and the file has changed.
%
% REMARKS
% To detect any modifications on `thisfile` we use a checksum
% (stored in .checksums subfolder in the same directory than
% `thisfile`). Returns true if the checksum is not available.

haschanged = true;

[nash, p, f] = compute_checksum_of_a_file(thisfile);

fidh = fopen(sprintf('%s/.checksums/%s.sum', p, f), 'r');

if isequal(fidh, -1)
    return
else
    cash = fgetl(fidh);
    fclose(fidh);
    if isequal(cash, nash)
        haschanged = false;
    end
end