// --+ options: json=compute +--

/*
** DEFINITION OF THE MODEL TO BE SIMULATED (user input).
*/

@#define BACKWARD = false
@#define EXOGENIZE_FOREIGN = true
//@#define OUTPUT_GAP_AS_DEVIATION_TO_BASELINE = true
//@#define OUTPUT_GAP_AS_DEVIATION_TO_BASELINE_IN_SPREADS = true

@#if !BACKWARD
//@#define DEFAULT_TO_MCE = false
//@#define MCE_IN_EXCHANGE_RATE = true
//@#define EXOGENOUS_EXCHANGE_RATE = true
//@#define EXACT_EXPECTATIONS_10Y = false
//@#define BACKWARD_WITH_UIP = false
//@#define FULL = false
@#define HYBRID = true
//@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
//@#define MCE_IN_FINANCIAL = true
//@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
//@#define MCE_IN_PAC_BUSINESS = false
//@#define MCE_IN_PAC_CONSUMPTION = false
//@#define MCE_IN_PAC_HOUSEPRICE = false
//@#define MCE_IN_PAC_LABOUR = false
//@#define MCE_IN_PAC_PROPERTY_INCOME = false
//@#define MCE_IN_PAC_RESIDENTIAL = false
//@#define MCE_IN_PERMANENT_INCOMES = false
//@#define MCE_IN_WAGE = false
//@#define MCE_IN_WAPRO = false
@#endif

// Set the number of periods for the perfect foresigt solver (should be very large for the model to converge to the BGP)
@#define SimulationPeriods  = 1500


/*
** DO NOT MODIFY THE FOLLOWING LINES...
*/

@#define BUILD_MATLAB_PLOTS = true

@#include "core.mod"

@#include "update-database.mod"

// Number of lags in the model.
// FIXME: Not robust with respect to the number of lags on the exogenous variables.
nylags = M_.orig_maximum_endo_lag;
nxlags = M_.orig_maximum_exo_lag;


// Check that the baseline is correct
initval_file(series=baseline, first_obs=3);
perfect_foresight_setup(periods=@{SimulationPeriods});
@#if BACKWARD
    perfect_foresight_solver(solve_algo=14);
@#else
    perfect_foresight_solver(stack_solve_algo=0, no_homotopy);
@#endif
Baseline = dseries([transpose(oo_.endo_simul), oo_.exo_simul], 5000Q1, [M_.endo_names; M_.exo_names]);


/*
** SPECIFY THE SHOCK(S) AND RUN THE SIMULATION.
*/

shocks;
  var res_U2_GO_COR; // Public spending shock...
  periods 1;
  values (0.01*baseline.U2_YER.data(nxlags+nylags+1)); // ... Calibrated to be 1% of baseline GDP.
end;

// Load the baseline.
initval_file(series=baseline, first_obs=3); // (nxlags+1)==3

// Setup of the simulation.
perfect_foresight_setup(periods=@{SimulationPeriods});

// Solve...
@#if BACKWARD
    perfect_foresight_solver(solve_algo=14);
@#else
    perfect_foresight_solver(stack_solve_algo=0, no_homotopy);
@#endif

Simulated_time_series = dseries(transpose(oo_.endo_simul), Baseline.dates(1), M_.endo_names);

/*
** PLOTTING PART
*/

// Choose the variables and define the normalization of the variables.

% dev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS = {'U2_STN', 'U2_TP_10Y', 'U2_A_YED', 'U2_A_COD', 'U2_G_YER', 'U2_SLRN', 'U2_OIS_10Y'};

% pdev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS = {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_EENX', 'U2_MXR', 'U2_XXR'};

% qdev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS = {};

% adev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS = {};

% ydev (see irf_trans_report) [user defined]
VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS = {};

// Normalize IRFs

irfs = irf_trans_report(Baseline, Simulated_time_series, 'dev', VARIABLES_TO_BE_PLOTTED_AS_DEVIATIONS, ...
    'pdev', VARIABLES_TO_BE_PLOTTED_AS_PERCENTAGE_DEVIATIONS, ...
    'qdev', VARIABLES_TO_BE_PLOTTED_AS_LOG_DIFF_DEVIATIONS, ...
    'adev', VARIABLES_TO_BE_PLOTTED_AS_ANNUALIZED_LOG_DIFF_DEVIATIONS, ...
    'ydev', VARIABLES_TO_BE_PLOTTED_AS_ANNUAL_LOG_DIFF_DEVIATIONS, ...
    'start_date', Simulated_time_series.dates(1));

// Order variables for plotting and set long names
vcodes = {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_STN', 'U2_G_YER', 'U2_A_YED', 'U2_EENX', 'U2_MXR', 'U2_XXR'};
vnames = {'Real GDP', 'Real consumption', 'Real intsevment', 'Nominal interest rate', 'Output gap', 'Inflation', 'Nomninal exchange rate', 'Real extra imports', 'Real extra export'};


// Set figure options
nrows = 3;
ncols = 3;
T = 40;

// Build figure with subplots

for i = 1:length(vcodes)
    subplot(nrows, ncols, i)
    plot(0:T, irfs{vcodes{i}}.data(1:T+1), '-k', 'linewidth', 2)
    ax = gca;
    ax.YAxis.Exponent = 0;
    axis tight
    box on
    set(gca, 'TickLabelInterpreter', 'latex', 'FontSize', 10);
    title(vnames{i})
end
