// --+ options: json=compute +--

@#define BACKWARD = false
@#define EXOGENIZE_FOREIGN = true

@#if !BACKWARD
@#define EXOGENOUS_EXCHANGE_RATE = true
@#define DEFAULT_TO_MCE = true
//@#define EXACT_EXPECTATIONS_10Y = false
//@#define BACKWARD_WITH_UIP = false
//@#define FULL = false
//@#define HYBRID = false
@#define MCE_IN_EXCHANGE_RATE = false
//@#define MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP = false
//@#define MCE_IN_FINANCIAL = true
//@#define MCE_IN_LONG_TERM_INTEREST_RATE = false
//@#define MCE_IN_PAC_BUSINESS = false
//@#define MCE_IN_PAC_CONSUMPTION = false
//@#define MCE_IN_PAC_HOUSEPRICE = false
//@#define MCE_IN_PAC_LABOUR = false
//@#define MCE_IN_PAC_PROPERTY_INCOME = false
//@#define MCE_IN_PAC_RESIDENTIAL = false
//@#define MCE_IN_PERMANENT_INCOMES = false
//@#define MCE_IN_WAGE = false
//@#define MCE_IN_WAPRO = false
@#endif

@#define BUILD_MATLAB_PLOTS = true

@#define SimulationPeriods  = 1500

@#include "core.mod"

@#include "update-database.mod"

// Number of lags in the model.
// FIXME: Not robust with respect to the number of lags on the exogenous variables.
nylags = M_.orig_maximum_endo_lag;
nxlags = M_.orig_maximum_exo_lag;

shocks;
  var res_U2_GO_COR; // Public spending shock...
  periods 1;
  values (0.01*baseline.U2_YER.data(nxlags+nylags+1)); // ... Calibrated to be 1% of baseline GDP.
end;

initval_file(series=baseline, first_obs=3); // (nxlags+1)==3

perfect_foresight_setup(periods=@{SimulationPeriods});

@#if BACKWARD
    perfect_foresight_solver(solve_algo=14);
@#else
    perfect_foresight_solver(stack_solve_algo=0, no_homotopy);
@#endif
