compile2pdf = true;

list_of_shocks = {'res_U2_STN', 'Short-term interest rate shock (100bp)' ; ...
                  'res_U2_TP_10Y', 'Term premium shock (100bp)' ;  ...
                  'res_U2_Q_T_PRO', 'TFP growth shock (1\%)' ;...
                  'res_U2_FC', 'Financial condition (100bp)' ; ...
                  'res_U2_WDREX', 'World demand shock (10\%)' ; ...
                  'res_U2_GO_COR', 'Public spending shock (1\% of GDP)' };

scenarii = struct('scenariocodes', {}, ...
                  'scenarionames', {}, ...
                  'scenariostyles', {}, ...
                  'scenariocolours', {}, ...
                  'comments', '', ...
                  'part', '');

scenarii = repmat(scenarii, 3, 1);

scenarii(1).scenariocodes = {'hybrid/full', 'hybrid/hybrid', 'hybrid/backward-with-uip'};
scenarii(1).scenarionames = {'Full MCE', 'Hybrid', 'Backward with UIP'};
scenarii(1).scenariostyles = {'solid', 'solid', 'solid'};
scenarii(1).scenariocolours = {'red', 'black','green'};
scenarii(1).part = 'Simulations of the standard model';

scenarii(2).scenariocodes = {'hybrid/full-with-exogenous-exchange-rate', 'hybrid/hybrid-with-exogenous-exchange-rate', 'backward-with-exogenous-exchange-rate'};
scenarii(2).scenarionames = {'Full MCE', 'Hybrid', 'Backward'};
scenarii(2).scenariostyles = scenarii(1).scenariostyles;
scenarii(2).scenariocolours = scenarii(1).scenariocolours;
scenarii(2).part = 'Simulations of the model with exogenous exchange rate';

scenarii(3).scenariocodes = {'hybrid/full-without-output-gap-effects-on-spreads', 'hybrid/hybrid-without-output-gap-effects-on-spreads', 'backward-no-output-gap-effects-on-spreads'};
scenarii(3).scenarionames = {'Full MCE', 'Hybrid', 'Backward with UIP'};
scenarii(3).scenariostyles = scenarii(1).scenariostyles;
scenarii(3).scenariocolours = scenarii(1).scenariocolours;
scenarii(3).part = 'Simulations of the model without output gap expectation in spreads';


for j=1:length(scenarii)
    for i=1:rows(list_of_shocks)
        makeplots(sprintf('irf_%s_%u', list_of_shocks{i,1}, j), list_of_shocks{i,1}, '', ...
                  {'U2_YER', 'U2_HH_COR', 'U2_BU_ITR', 'U2_G_YER', 'U2_A_YED', 'U2_A_COD', 'U2_STN', 'U2_OIS_10Y', 'U2_SLRN', 'U2_EENX', 'U2_MXR', 'U2_XXR'}, ...
                  {'Real GDP', 'Real Consumption', 'Real Investment', 'Output gap', 'GDP price inflation', 'Consumption price inflation', 'Nominal interest rate', 'Overnight index swap (10 years)', 'Spread on business lending rate', 'Nominal exhange rate', 'Real extra imports', 'Real extra exports'}, ...
                  scenarii(j).scenariocodes, scenarii(j).scenariostyles, scenarii(j).scenarionames, scenarii(j).scenariocolours, false, true)
    end
end

delete *.log *.aux *.tex

fid = fopen('irfs.tex', 'w');
if fid ~= -1
    fprintf(fid, '\\documentclass[oneside]{memoir}\n');
    fprintf(fid, '\\usepackage{graphicx}\n');
    fprintf(fid, '\\usepackage{chngcntr}\n');
    fprintf(fid, '\\mainmatter\n');
    fprintf(fid, '\\counterwithout{figure}{chapter}\n');
    fprintf(fid, '\n');
    fprintf(fid, '\\begin{document}\n');
    for j=1:length(scenarii)
        fprintf(fid, '\\part{%s}\n', scenarii(j).part);
        for i=1:rows(list_of_shocks)
            fprintf(fid, '\\begin{figure}\n');
            fprintf(fid, '\\centering\n');
            fprintf(fid, '\\includegraphics[scale=1.2]{irf_%s_%u.pdf}\n', list_of_shocks{i,1}, j);
            fprintf(fid, '\\caption{\\textbf{%s.} %s}\n', list_of_shocks{i,2}, scenarii(j).comments);
            fprintf(fid, '\\end{figure}\n');
            fprintf(fid, '\\newpage\n');
        end
    end
    fprintf(fid, '\\end{document}\n');
    fclose(fid);
else
    warning('Cannot open file irfs.tex');
end

if compile2pdf
    system('pdflatex irfs')
end