function paths = inflate(paths, info, t)

% unnormalize paths (reciprocal of deflate routine, paths==inflate(deflate(paths, info, t), info, t)).
%
% INPUTS
% - paths  [dseries]   Object containing the time series to be unscaled.
% - info   [cell]      Description of the long run behaviour of the variables.
% - t      [integer]   scalar, time index.
%
% OUTPUTS
% - paths  [dseries]

    for i=1:paths.vobs
        variable = paths.name{i};
        j = find(strcmp(info(:,1), variable));
        if isequal(info{j,2}, 'Trend')
            paths{variable} = paths{variable}*info{j,3}^(t/paths.freq);
        end
    end