baseline = dseries('../database/baseline.mat');

@#if MCE_IN_PAC_CONSUMPTION
baseline.mce_Z1_pac_consumption_eq0 = dseries(baseline.U2_CONS_PAC_PE.data, baseline.dates(1), 'U2_CONS_PAC_PE');
@#endif

@#if MCE_IN_PAC_BUSINESS
baseline.mce_Z1_pac_business_eq0 = dseries(baseline.U2_BUSINESS_PAC_PE.data, baseline.dates(1), 'U2_BUSINESS_PAC_PE');
@#endif

@#if MCE_IN_PAC_HOUSEPRICE
baseline.mce_Z1_pac_houseprice_eq0 = dseries(baseline.U2_HOUSEPRICE_PAC_PE.data, baseline.dates(1), 'U2_HOUSEPRICE_PAC_PE');
@#endif

@#if MCE_IN_PAC_PROPERTY_INCOME
baseline.mce_Z1_pac_property_income_eq0 = dseries(baseline.U2_PROPERTY_PAC_PE.data, baseline.dates(1), 'U2_PROPERTY_PAC_PE');
@#endif

@#if MCE_IN_PAC_RESIDENTIAL
baseline.mce_Z1_pac_residential_eq0 = dseries(baseline.U2_RESIDENTIAL_PAC_PE.data, baseline.dates(1), 'U2_RESIDENTIAL_PAC_PE');
@#endif

@#if MCE_IN_PAC_LABOUR
baseline.mce_Z1_pac_labour_eq0 = dseries(baseline.U2_LABOUR_PAC_PE.data, baseline.dates(1), 'U2_LABOUR_PAC_PE');
@#endif

@#if MCE_IN_LONG_TERM_INTEREST_RATE
baseline.U2_RFB_E10Y = dseries(ones(baseline.nobs, 1), baseline.firstdate);
baseline.U2_RFB_10Y = dseries(ones(baseline.nobs, 1), baseline.firstdate)*couponBB/(1+mean(baseline.U2_STN)/100)^0.25/(1+mean(baseline.U2_TP_10Y)/100)^0.25/(1 - (1-tauBB)/(1+mean(baseline.U2_STN)/100)^0.25/(1+mean(baseline.U2_TP_10Y)/100)^0.25);
baseline.U2_RFCB_10Y = dseries(ones(baseline.nobs, 1), baseline.firstdate)*couponBB/(1+mean(baseline.U2_STN)/100)^0.25/(1+mean(baseline.U2_SCB)/100)^0.25/(1 - (1-tauBB)/(1+mean(baseline.U2_STN)/100)^0.25/(1+mean(baseline.U2_SCB)/100)^0.25);
@#endif

@#if MCE_IN_EXPECTED_AVERAGED_OUTPUT_GAP
baseline.TPM_GAP = dseries(zeros(baseline.nobs, 1), baseline.firstdate);
@#endif

@#if MCE_IN_PERMANENT_INCOMES
baseline.U2_G_VYERT = dseries(zeros(baseline.nobs, 1), baseline.firstdate);
baseline.U2_G_VYERT_VE = dseries(zeros(baseline.nobs, 1), baseline.firstdate);
@#endif

@#if NOMINAL_INTEREST_RATE_ZLB
baseline.U2_STN_ZLB = baseline.U2_STN;
@#endif
