function save_checksum_of_a_file(thisfile)

% Returns the sha checksum of a file has given by git.
%
% INPUTS
% - thisfile      [char]     1×n array, full name of a file (with path and extension).
%
% OUTPUTS
% - hash          [char]     1×40 array, sha checksum of the file.

[hash, p, f] = compute_checksum_of_a_file(thisfile);

directory = sprintf('%s/.checksums', p);

if ~isfolder(directory)
    mkdir(directory);
end

fid = fopen(sprintf('%s/%s.sum', directory, f), 'w');
fprintf(fid, '%s', hash);
fclose(fid);