function buildplots(shockcode, shockname, scenariocodes, scenarionames, scenariocurves, scenariocolours, type, variablecodes, variablenames)

n = 40;

%
% Check inputs
%

if nargin<7
    error('Missing arguments.')
end

assert(ischar(shockcode), ...
       'First input argument has to be a row char array (shock code)');

assert(ischar(shockname), ...
       'Second input argument has to be a row char array (shock name)');

assert(isvector(scenariocodes) & iscell(scenariocodes) & all(cellfun(@(x) ischar(x), scenariocodes)), ...
       'Third input argument has to be a cell of row char arrays (scenario codes)');

assert(isvector(scenarionames) & iscell(scenarionames) & all(cellfun(@(x) ischar(x), scenarionames)), ...
       'Fourth input argument has to be a cell of row char arrays (scenario names)');

assert(isvector(scenariocurves) & length(scenariocurves)==length(scenarionames) & iscell(scenariocurves) & all(cellfun(@(x) ischar(x), scenariocurves)), ...
       'Fifth input argument has to be a cell of row char arrays (scenario curves properties)');

assert(isvector(scenariocolours) & length(scenariocolours)==length(scenarionames) & iscell(scenariocolours) & (all(cellfun(@(x) ischar(x), scenariocolours)) || all(cellfun(@(x) isrgbtriplet(x), scenariocolours))), ...
       'Sixth input argument has to be a cell of row char arrays (scenario curves properties)');

assert(ischar(type) & ismember(type, {'article', 'slides'}), ...
       'Seventh input argument has to be a row char array (shock name)');

%
% Set default list of endogenous variables
%

if nargin<8
    variablecodes = {'U2_STN', ...
                     'U2_A_YED', ...
                     'U2_G_YER', ...
                     'U2_EENX', ...
                     'U2_LNN', ...
                     'U2_SLRN', ...
                     'U2_TP_10Y', ...
                     'U2_OIS_10Y', ...
                     'U2_BU_ITR', ...
                     'U2_HH_COR', ...
                     'U2_YER'};
    variablenames = {'Nominal interest rate', ...
                    'Annual inflation', ...
                    'Output gap', ...
                    'Exchange rate', ...
                    'Total employment', ...
                    'Spread on business lending rate', ...
                    'Ten years ter premium', ...
                    'Euro Overnight Index Swap (10-year)', ...
                    'Business investment', ...
                    'Real consumption', ...
                    'Real GDP'};
end

if nargin<9 && ~exist('variablenames', 'var')
    variablenames = variablecodes;
end

%
% Set various parameters for the figure
%


switch length(variablecodes)
  case {2,3}
    if isequal(type, 'article')
        ncols = 1;
        nrows = length(variablecodes);
    else
        ncols = length(variablecodes);
        nrows = 1;
    end
  case 4
    ncols = 2;
    nrows = 2;
  case {5,6}
    if isequal(type, 'article')
        ncols = 2;
        nrows = 3;
    else
        ncols = 3;
        nrows = 2;
    end
  case {7,8,9}
    ncols = 3;
    nrows = 3;
  case {10,11,12}
    if isequal(type, 'article')
        ncols = 3;
        nrows = 4;
    else
        ncols = 4;
        nrows = 3;
    end
  case {13, 14, 15, 16}
        ncols = 4;
        nrows = 4;
  otherwise
    error('Cannot plot more than sixteen variables.')
end

%
% Set figure options
%

set(groot,'DefaultTextInterpreter','latex');
set(groot,'defaultLineLineWidth',2)

%
% Build figure
%

for i = 1:length(variablecodes)
    subplot(nrows, ncols, i)
    data = readmatrix(sprintf('/home/stepan/works/ecb/ecb-base-mce/irfs-data/%s/%s/%s.dat', scenariocodes{1}, shockcode, variablecodes{i}));
    plot(data(1:n+1,1), data(1:n+1,2), 'LineStyle', scenariocurves{1}, 'Color', scenariocolours{1})
    %set(gca,'YTickLabel', sprintf('%.4f|',get(gca,'YTick')))
    hold on
    for j = 2:length(scenariocodes)
        data = readmatrix(sprintf('/home/stepan/works/ecb/ecb-base-mce/irfs-data/%s/%s/%s.dat', scenariocodes{j}, shockcode, variablecodes{i}));
        plot(data(1:n+1,1), data(1:n+1,2), 'LineStyle', scenariocurves{j}, 'Color', scenariocolours{j})
        %set(gca,'YTickLabel', sprintf('%.4f|', get(gca,'YTick')))
    end
    hold off
    ax = gca;
    ax.YAxis.Exponent = 0;
    axis tight
    box on
    set(gca, 'TickLabelInterpreter', 'latex', 'FontSize', 10);
    title(variablenames{i})
end

l = legend(scenarionames{:});
legend boxoff

lp = get(l, 'Position');

set(l,'Position',[0.5*(1-lp(3)) 0 lp(3) lp(4)]);

print -dpng -r300 toto;



function b = isrgbtriplet(v)
b = isrow(v) & length(v)==3 & isnumeric(v);