compile2pdf = true;

list_of_shocks = {'res_U2_STN', 'Short-term interest rate shock (100bp)' ; ...
                  'res_U2_TP_10Y', 'Term premium shock (100bp)' ;  ...
                  'res_U2_Q_T_PRO', 'TFP growth shock (1\%)' ;...
                  'res_U2_SLRN', 'Risk premium shock (100bp)' ; ...
                  'res_U2_WDREX', 'World demand shock (1\%)' ; ...
                  'res_U2_GO_COR', 'Public spending shock (1\%)' };

scenarii = struct('scenariocodes', {}, ...
                  'scenarionames', {}, ...
                  'scenariostyles', {}, ...
                  'scenariocolours', {}, ...
                  'comments', '');

scenarii = repmat(scenarii, 3, 1);

scenarii(1).scenariocodes = {'hybrid/full', 'hybrid/hybrid', 'hybrid/backward-with-uip'};
scenarii(1).scenarionames = {'Full MCE', 'Hybrid', 'Backward with UIP'};
scenarii(1).scenariostyles = {'solid', 'solid', 'solid'};
scenarii(1).scenariocolours = {'red', 'black','green'};

scenarii(2).scenariocodes = {'hybrid/full', 'hybrid/hybrid', 'hybrid/backward-with-uip'};
scenarii(2).scenarionames = {'Full MCE', 'Hybrid', 'Backward with UIP'};
scenarii(2).scenariostyles = scenarii(1).scenariostyles;
scenarii(2).scenariocolours = scenarii(1).scenariocolours;

scenarii(3).scenariocodes = {'hybrid/full', 'hybrid/hybrid', 'hybrid/backward-with-uip'};
scenarii(3).scenarionames = {'Full MCE', 'Hybrid', 'Backward with UIP'};
scenarii(3).scenariostyles = scenarii(1).scenariostyles;
scenarii(3).scenariocolours = scenarii(1).scenariocolours;


for j=1:length(scenarii)
    for i=1:rows(list_of_shocks)
        makeplots(sprintf('irf_%s_%u', list_of_shocks{i,1}, j), list_of_shocks{i,1}, '', ...
                  {'U2_STN', 'U2_A_YED', 'U2_BU_ITR', 'U2_EENX', 'U2_REENX', 'U2_G_YER', 'U2_HH_COR', 'U2_LNN', 'U2_OIS_10Y', 'U2_SLRN', 'U2_TP_10Y', 'U2_YER'}, ...
                  {'U2\_STN', 'U2\_A\_YED', 'U2\_BU\_ITR', 'U2\_EENX', 'U2\_REENX', 'U2\_G\_YER', 'U2\_HH\_COR', 'U2\_LNN', 'U2\_OIS\_10Y', 'U2\_SLRN', 'U2\_TP\_10Y', 'U2\_YER'}, ...
                  scenarii(j).scenariocodes, scenarii(j).scenariostyles, scenarii(j).scenarionames, scenarii(j).scenariocolours, false, true)
    end
end

delete *.log *.aux *.tex

fid = fopen('irfs.tex', 'w');
if fid ~= -1
    fprintf(fid, '\\documentclass{article}\n');
    fprintf(fid, '\\usepackage{graphicx}\n');
    fprintf(fid, '\n');
    fprintf(fid, '\\begin{document}\n');
    for j=1:length(scenarii)
        for i=1:rows(list_of_shocks)
            fprintf(fid, '\\begin{figure}\n');
            fprintf(fid, '\\centering\n');
            fprintf(fid, '\\includegraphics[scale=1.2]{irf_%s_%u.pdf}\n', list_of_shocks{i,1}, j);
            fprintf(fid, '\\caption{\\textbf{%s.} %s}\n', list_of_shocks{i,2}, scenarii(j).comments);
            fprintf(fid, '\\end{figure}\n');
            fprintf(fid, '\\newpage\n');
        end
    end
    fprintf(fid, '\\end{document}\n');
    fclose(fid);
else
    warning('Cannot open file irfs.tex');
end

if compile2pdf
    system(sprintf('pdflatex irfs%u', comparison))
end