function [hash, p, f]  = compute_checksum_of_a_file(thisfile)

% Returns the sha checksum of a file has given by git.
%
% INPUTS
% - thisfile      [char]     1×n array, full name of a file (with path and extension).
%
% OUTPUTS
% - hash          [char]     1×40 array, checksum of the file.
% - p             [char]     1×m array, path to the file.
% - f             [char]     1×q array, name of the file (without path or extension).

[p, f] = fileparts(thisfile);

hash = git('hash-object', thisfile);