function vnames = getlistofvariables(Model)

% Returns the name of the endogenous and exogenous variables in a model.
% 
% INPUTS
% - Model     [struct]   Description of the model, aka M_.
%
% OUTPUTS
% - vnames    [cell]     List of variables.

if nargin
    vnames = [Model.endo_names(1:Model.orig_endo_nbr); Model.exo_names(cellfun(@(x) isempty(x), regexp(Model.exo_names, '\<res_(\w*)\>')))];
else
    names = load(sprintf('%s/../database/vars', fileparts(mfilename('fullpath'))));
    vnames = [names.endogenousvariables; names.exogenousvariables(cellfun(@(x) isempty(x), regexp(names.exogenousvariables, '\<res_(\w*)\>')))];
end
