compile2pdf = true;
comparison = 1;     

list_of_shocks = {'res_U2_STN', 'Short-term interest rate shock (100bp)' ; ...
                  'res_U2_TP_10Y', 'Term premium shock (100bp)' ;  ...
                  'res_U2_A_YED', 'GDP deflator shock (10\%) ';...
                  'res_U2_G_C_CER', 'Compensation per employee gap shock (1\%)'; ...
                  'res_U2_Q_T_PRO', 'TFP growth shock (1\%)' ;...
                  'res_U2_SLRN', 'Risk premium shock (100bp)' ; ...
                  'res_U2_WDREX', 'World demand shock (1\%)' ; ...
                  'res_U2_GO_COR', 'Public spending shock (1\%)' ;...
                  'res_U2_CXEDEX', 'Competitors'' prices on import markets shock (1\%)'; ...
                  'res_U2_PCU', 'Commodity price shock (1\%)' ; ...
                  'res_U2_POU', 'Oil price shock (1\%)' ; ...
                  'res_U2_US_EHIC', 'U.S. inflation expectation shock (1\%)';...
                  'res_U2_US_10Y', 'U.S. long term interest rate shock (1\%)';};

switch comparison
  case 0
    %
    %  Compare full and backwards
    %
    scenariocodes = {'hybrid/full', 'hybrid/full-endo-foreign', 'backward', 'backward-endo-foreign', 'hybrid/backward-with-uip', 'hybrid/backward-with-uip-endo-foreign'};
    scenarionames = {'Full MCE (exogenous foreign)', 'Full MCE (endogenous foreign)', 'Backward (exogenous foreign)', 'Backward (endogenous foreign)', 'Backward with UIP (exogenous foreign)', 'Backward with UIP (endogenous foreign)'};
    scenariostyles = {'solid', 'dashed', 'solid', 'dashed', 'solid', 'dashed'};
    scenariocolours = {'red', 'red', 'black', 'black','green','green'};
  case 1
    %
    % Compare full, hybrid and backward with UIP
    %
    scenariocodes = {'hybrid/full', 'hybrid/full-endo-foreign', 'hybrid/hybrid', 'hybrid/hybrid-endo-foreign', 'hybrid/backward-with-uip', 'hybrid/backward-with-uip-endo-foreign'};
    scenarionames = {'Full MCE (exogenous foreign)', 'Full MCE (endogenous foreign)', 'Hybrid (exogenous foreign)', 'Hybrid (endogenous foreign)', 'Backward with UIP (exogenous foreign)', 'Backward with UIP (endogenous foreign)'};
    scenariostyles = {'solid', 'dashed', 'solid', 'dashed', 'solid', 'dashed'};
    scenariocolours = {'red', 'red', 'black', 'black','green','green'};
  otherwise
    error('Not implemented.')
end

for i=1:rows(list_of_shocks)
    makeplots(sprintf('irf_%s', list_of_shocks{i,1}), list_of_shocks{i,1}, '', ...
              {'U2_STN', 'U2_A_YED', 'U2_BU_ITR', 'U2_EENX', 'U2_REENX', 'U2_G_YER', 'U2_HH_COR', 'U2_LNN', 'U2_OIS_10Y', 'U2_SLRN', 'U2_TP_10Y', 'U2_YER'}, ...
              {'U2\_STN', 'U2\_A\_YED', 'U2\_BU\_ITR', 'U2\_EENX', 'U2\_REENX', 'U2\_G\_YER', 'U2\_HH\_COR', 'U2\_LNN', 'U2\_OIS\_10Y', 'U2\_SLRN', 'U2\_TP\_10Y', 'U2\_YER'}, ...
              scenariocodes, scenariostyles, scenarionames, scenariocolours, false, true)
end

delete *.log *.aux *.tex

fid = fopen(sprintf('irfs%u.tex', comparison), 'w');
if fid ~= -1
    fprintf(fid, '\\documentclass{article}\n');
    fprintf(fid, '\\usepackage{graphicx}\n');
    fprintf(fid, '\n');
    fprintf(fid, '\\begin{document}\n');
    for i=1:rows(list_of_shocks)
        fprintf(fid, '\\begin{figure}\n');
        fprintf(fid, '\\centering\n');
        fprintf(fid, '\\includegraphics[scale=1.2]{irf_%s.pdf}\n', list_of_shocks{i,1});
        fprintf(fid, '\\caption{\\textbf{%s.}}\n', list_of_shocks{i,2});
        fprintf(fid, '\\end{figure}\n');
        fprintf(fid, '\\newpage\n');
    end
    fprintf(fid, '\\end{document}\n');
    fclose(fid);
else
    warning('Cannot open file irfs.tex');
end

if compile2pdf
    system(sprintf('pdflatex irfs%u', comparison))
end