function plot_identification(params, idemoments, idehess, idemodel, idelre, advanced, tittxt, name, IdentifDirectoryName, tit_TeX, name_tex)
% function plot_identification(params,idemoments,idehess,idemodel, idelre, advanced, tittxt, name, IdentifDirectoryName)
%
% INPUTS
%    o params               [array] parameter values for identification checks
%    o idemoments           [structure] identification results for the moments
%    o idehess              [structure] identification results for the Hessian
%    o idemodel             [structure] identification results for the reduced form solution
%    o idelre               [structure] identification results for the LRE model
%    o advanced             [integer] flag for advanced identification checks
%    o tittxt               [char] name of the results to plot
%    o name                 [char] list of names
%    o IdentifDirectoryName [char] directory name
%    o tittxt               [char] TeX-name of the results to plot
%    o name_tex             [char] TeX-names of the parameters
% OUTPUTS
%    None
%
% SPECIAL REQUIREMENTS
%    None

% Copyright (C) 2008-2017 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

global M_ options_

if nargin <10 || isempty(tit_TeX)
    tit_TeX=tittxt;
end

if nargin <11
    name_TeX=name;
end

[SampleSize, nparam]=size(params);
si_Jnorm = idemoments.si_Jnorm;
si_dTAUnorm = idemodel.si_dTAUnorm;
si_dLREnorm = idelre.si_dLREnorm;

tittxt1=regexprep(tittxt, ' ', '_');
tittxt1=strrep(tittxt1, '.', '');
if SampleSize == 1
    si_J = idemoments.si_J;
    hh = dyn_figure(options_.nodisplay,'Name',[tittxt, ' - Identification using info from observables']);
    subplot(211)
    mmm = (idehess.ide_strength_J);
    [ss, is] = sort(mmm);
    if ~all(isnan(idehess.ide_strength_J_prior))
        bar(log([idehess.ide_strength_J(:,is)' idehess.ide_strength_J_prior(:,is)']))
    else
        bar(log([idehess.ide_strength_J(:,is)' ]))
    end
    hold on
    plot((1:length(idehess.ide_strength_J(:,is)))-0.15,log([idehess.ide_strength_J(:,is)']),'o','MarkerSize',7,'MarkerFaceColor',[0 0 0],'MarkerEdgeColor','none')
    plot((1:length(idehess.ide_strength_J_prior(:,is)))+0.15,log([idehess.ide_strength_J_prior(:,is)']),'o','MarkerSize',7,'MarkerFaceColor',[0 0 0],'MarkerEdgeColor','none')
    if any(isinf(log(idehess.ide_strength_J(idehess.identified_parameter_indices))))
        %-Inf, i.e. 0 strength
        inf_indices=find(isinf(log(idehess.ide_strength_J(idehess.identified_parameter_indices))) & log(idehess.ide_strength_J(idehess.identified_parameter_indices))<0);
        inf_pos=ismember(is,idehess.identified_parameter_indices(inf_indices));
        plot(find(inf_pos)-0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[0 0 0])
        %+Inf, i.e. Inf strength
        inf_indices=find(isinf(log(idehess.ide_strength_J(idehess.identified_parameter_indices))) & log(idehess.ide_strength_J(idehess.identified_parameter_indices))>0);
        inf_pos=ismember(is,idehess.identified_parameter_indices(inf_indices));
        plot(find(inf_pos)-0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 1 1],'MarkerEdgeColor',[0 0 0])
    end
    if any(isinf(log(idehess.ide_strength_J_prior(idehess.identified_parameter_indices))))
        %-Inf, i.e. 0 strength
        inf_indices=find(isinf(log(idehess.ide_strength_J_prior(idehess.identified_parameter_indices))) & log(idehess.ide_strength_J_prior(idehess.identified_parameter_indices))<0);
        inf_pos=ismember(is,idehess.identified_parameter_indices(inf_indices));
        plot(find(inf_pos)+0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[0 0 0])
        %+Inf, i.e. 0 strength
        inf_indices=find(isinf(log(idehess.ide_strength_J_prior(idehess.identified_parameter_indices))) & log(idehess.ide_strength_J_prior(idehess.identified_parameter_indices))>0);
        inf_pos=ismember(is,idehess.identified_parameter_indices(inf_indices));
        plot(find(inf_pos)+0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 1 1],'MarkerEdgeColor',[0 0 0])
    end
    set(gca,'xlim',[0 nparam+1])
    set(gca,'xticklabel','')
    dy = get(gca,'ylim');
    for ip=1:nparam
        text(ip,dy(1),name{is(ip)},'rotation',90,'HorizontalAlignment','right','interpreter','none')
    end
    if ~all(isnan(idehess.ide_strength_J_prior))
        legend('relative to param value','relative to prior std','Location','Best')
    else
        legend('relative to param value','Location','Best')
    end
    if  idehess.flag_score
        title('Identification strength with asymptotic Information matrix (log-scale)')
    else
        title('Identification strength with moments Information matrix (log-scale)')
    end

    subplot(212)
    if ~all(isnan(idehess.deltaM_prior))
        bar(log([idehess.deltaM(is) idehess.deltaM_prior(is)]))
    else
        bar(log([idehess.deltaM(is)]))
    end
    hold on
    plot((1:length(idehess.deltaM(is)))-0.15,log([idehess.deltaM(is)']),'o','MarkerSize',7,'MarkerFaceColor',[0 0 0],'MarkerEdgeColor','none')
    plot((1:length(idehess.deltaM_prior(is)))+0.15,log([idehess.deltaM_prior(is)']),'o','MarkerSize',7,'MarkerFaceColor',[0 0 0],'MarkerEdgeColor','none')
    inf_pos=find(isinf(log(idehess.deltaM)));
    if ~isempty(inf_pos)
        inf_indices=~ismember(inf_pos,idehess.sensitivity_zero_pos);
        inf_pos=ismember(is,inf_pos(inf_indices));
        plot(find(inf_pos)-0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 1 1],'MarkerEdgeColor',[0 0 0])
    end
    inf_pos=find(isinf(log(idehess.deltaM_prior)));
    if ~isempty(inf_pos)
        inf_indices=~ismember(inf_pos,idehess.sensitivity_zero_pos);
        inf_pos=ismember(is,inf_pos(inf_indices));
        plot(find(inf_pos)+0.15,zeros(sum(inf_pos),1),'o','MarkerSize',7,'MarkerFaceColor',[1 1 1],'MarkerEdgeColor',[0 0 0])
    end
    set(gca,'xlim',[0 nparam+1])
    set(gca,'xticklabel','')
    dy = get(gca,'ylim');
    for ip=1:nparam
        text(ip,dy(1),name{is(ip)},'rotation',90,'HorizontalAlignment','right','interpreter','none')
    end
    if ~all(isnan(idehess.deltaM_prior))
        legend('relative to param value','relative to prior std','Location','Best')
    else
        legend('relative to param value','Location','Best')
    end
    if  idehess.flag_score
        title('Sensitivity component with asymptotic Information matrix (log-scale)')
    else
        title('Sensitivity component with moments Information matrix (log-scale)')
    end
    if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
        fidTeX = fopen([IdentifDirectoryName '/' M_.fname '_ident_strength_' tittxt1,'.tex'],'w');
        fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
        fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_ident_strength_%s}\n',[IdentifDirectoryName '/' M_.fname],tittxt1);
        fprintf(fidTeX,'\\caption{%s  - Identification using info from observables.}',tit_TeX);
        fprintf(fidTeX,'\\label{Fig:ident:%s}\n',deblank(tittxt));
        fprintf(fidTeX,'\\end{figure}\n\n');
        fprintf(fidTeX,'%% End Of TeX file. \n');
        fclose(fidTeX);
    end
    dyn_saveas(hh,[IdentifDirectoryName '/' M_.fname '_ident_strength_' tittxt1],options_.nodisplay,options_.graph_format);

    if advanced
        if ~options_.nodisplay
            skipline()
            disp('Plotting advanced diagnostics')
        end
        if all(isnan([si_Jnorm';si_dTAUnorm';si_dLREnorm']))
            fprintf('\nIDENTIFICATION: Skipping sensitivity plot, because standard deviation of parameters is NaN, possibly due to the use of ML.\n')
        else
            hh = dyn_figure(options_.nodisplay,'Name',[tittxt, ' - Sensitivity plot']);
            subplot(211)
            mmm = (si_Jnorm)'./max(si_Jnorm);
            mmm1 = (si_dTAUnorm)'./max(si_dTAUnorm);
            mmm=[mmm mmm1];
            mmm1 = (si_dLREnorm)'./max(si_dLREnorm);
            offset=length(si_dTAUnorm)-length(si_dLREnorm);
            mmm1 = [NaN(offset,1); mmm1];
            mmm=[mmm mmm1];

            bar(log(mmm(is,:).*100))
            set(gca,'xlim',[0 nparam+1])
            set(gca,'xticklabel','')
            dy = get(gca,'ylim');
            for ip=1:nparam
                text(ip,dy(1),name{is(ip)},'rotation',90,'HorizontalAlignment','right','interpreter','none')
            end
            legend('Moments','Model','LRE model','Location','Best')
            title('Sensitivity bars using derivatives (log-scale)')
            dyn_saveas(hh,[IdentifDirectoryName '/' M_.fname '_sensitivity_' tittxt1 ],options_.nodisplay,options_.graph_format);
            if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
                fidTeX = fopen([IdentifDirectoryName '/' M_.fname '_sensitivity_' tittxt1,'.tex'],'w');
                fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
                fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
                fprintf(fidTeX,'\\begin{figure}[H]\n');
                fprintf(fidTeX,'\\centering \n');
                fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_sensitivity_%s}\n',[IdentifDirectoryName '/' M_.fname],tittxt1);
                fprintf(fidTeX,'\\caption{%s  - Sensitivity plot.}',tit_TeX);
                fprintf(fidTeX,'\\label{Fig:sensitivity:%s}\n',deblank(tittxt));
                fprintf(fidTeX,'\\end{figure}\n\n');
                fprintf(fidTeX,'%% End Of TeX file. \n');
                fclose(fidTeX);
            end
        end
        % identificaton patterns
        for  j=1:size(idemoments.cosnJ,2)
            pax=NaN(nparam,nparam);
            %             fprintf('\n')
            %             disp(['Collinearity patterns with ', int2str(j) ,' parameter(s)'])
            %             fprintf('%-15s [%-*s] %10s\n','Parameter',(15+1)*j,' Expl. params ','cosn')
            for i=1:nparam
                namx='';
                for in=1:j
                    dumpindx = idemoments.pars{i,j}(in);
                    if isnan(dumpindx)
                        namx=[namx ' ' sprintf('%-15s','--')];
                    else
                        namx=[namx ' ' sprintf('%-15s',name{dumpindx})];
                        pax(i,dumpindx)=idemoments.cosnJ(i,j);
                    end
                end
                %                 fprintf('%-15s [%s] %10.3f\n',name{i},namx,idemoments.cosnJ(i,j))
            end
            hh = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Collinearity patterns with ', int2str(j) ,' parameter(s)']);
            imagesc(pax,[0 1]);
            set(gca,'xticklabel','')
            set(gca,'yticklabel','')
            for ip=1:nparam
                text(ip,(0.5),name{ip},'rotation',90,'HorizontalAlignment','left','interpreter','none')
                text(0.5,ip,name{ip},'rotation',0,'HorizontalAlignment','right','interpreter','none')
            end
            colorbar;
            colormap('jet');
            ax=colormap;
            ax(1,:)=[0.9 0.9 0.9];
            colormap(ax);
            if nparam>10
                set(gca,'xtick',(5:5:nparam))
                set(gca,'ytick',(5:5:nparam))
            end
            set(gca,'xgrid','on')
            set(gca,'ygrid','on')
            xlabel([tittxt,' - Collinearity patterns with ', int2str(j) ,' parameter(s)'],'interpreter','none')
            dyn_saveas(hh,[ IdentifDirectoryName '/' M_.fname '_ident_collinearity_' tittxt1 '_' int2str(j) ],options_.nodisplay,options_.graph_format);
            if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
                fidTeX = fopen([ IdentifDirectoryName '/' M_.fname '_ident_collinearity_' tittxt1 '_' int2str(j),'.tex'],'w');
                fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
                fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
                fprintf(fidTeX,'\\begin{figure}[H]\n');
                fprintf(fidTeX,'\\centering \n');
                fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_ident_collinearity_%s_%u}\n',[IdentifDirectoryName '/' M_.fname],tittxt1,j);
                fprintf(fidTeX,'\\caption{%s  - Collinearity patterns with %u parameter(s).}',tit_TeX,j);
                fprintf(fidTeX,'\\label{Fig:collinearity:%s:%u_pars}\n',deblank(tittxt),j);
                fprintf(fidTeX,'\\end{figure}\n\n');
                fprintf(fidTeX,'%% End Of TeX file. \n');
                fclose(fidTeX);
            end
        end
        skipline()
        [U,S,V]=svd(idehess.AHess,0);
        S=diag(S);
        if idehess.flag_score
            if nparam<5
                f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (Information matrix)']);
                tex_tit_1=[tittxt,' - Identification patterns (Information matrix)'];
            else
                f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (Information matrix): SMALLEST SV']);
                tex_tit_1=[tittxt,' - Identification patterns (Information matrix): SMALLEST SV'];
                f2 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (Information matrix): HIGHEST SV']);
                tex_tit_2=[tittxt,' - Identification patterns (Information matrix): HIGHEST SV'];
            end
        else
            %             S = idemoments.S;
            %             V = idemoments.V;
            if nparam<5
                f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (moments Information matrix)']);
                tex_tit_1=[tittxt,' - Identification patterns (moments Information matrix)'];
            else
                f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (moments Information matrix): SMALLEST SV']);
                tex_tit_1=[tittxt,' - Identification patterns (moments Information matrix): SMALLEST SV'];
                f2 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - Identification patterns (moments Information matrix): HIGHEST SV']);
                tex_tit_2=[tittxt,' - Identification patterns (moments Information matrix): HIGHEST SV'];
            end
        end
        for j=1:min(nparam,8)
            if j<5
                set(0,'CurrentFigure',f1),
                jj=j;
            else
                set(0,'CurrentFigure',f2),
                jj=j-4;
            end
            subplot(4,1,jj)
            if j<5
                bar(abs(V(:,end-j+1)))
                Stit = S(end-j+1);
            else
                bar(abs(V(:,jj))),
                Stit = S(jj);
            end
            set(gca,'xticklabel','')
            if j==4 || j==nparam || j==8
                for ip=1:nparam
                    text(ip,-0.02,name{ip},'rotation',90,'HorizontalAlignment','right','interpreter','none')
                end
            end
            title(['Singular value ',num2str(Stit)])
        end
        dyn_saveas(f1,[  IdentifDirectoryName '/' M_.fname '_ident_pattern_' tittxt1 '_1' ],options_.nodisplay,options_.graph_format);
        if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
            fidTeX = fopen([  IdentifDirectoryName '/' M_.fname '_ident_pattern_' tittxt1 '_1','.tex'],'w');
            fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
            fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_ident_pattern_%s_1}\n',[IdentifDirectoryName '/' M_.fname],tittxt1);
            fprintf(fidTeX,'\\caption{%s.}',tex_tit_1);
            fprintf(fidTeX,'\\label{Fig:ident_pattern:%s:1}\n',tittxt1);
            fprintf(fidTeX,'\\end{figure}\n\n');
            fprintf(fidTeX,'%% End Of TeX file. \n');
            fclose(fidTeX);
        end
        if nparam>4
            dyn_saveas(f2,[  IdentifDirectoryName '/' M_.fname '_ident_pattern_' tittxt1 '_2' ],options_.nodisplay,options_.graph_format);
            if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
                fidTeX = fopen([  IdentifDirectoryName '/' M_.fname '_ident_pattern_' tittxt1 '_2.tex'],'w');
                fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
                fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
                fprintf(fidTeX,'\\begin{figure}[H]\n');
                fprintf(fidTeX,'\\centering \n');
                fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_ident_pattern_%s_2}\n',[IdentifDirectoryName '/' M_.fname],tittxt1);
                fprintf(fidTeX,'\\caption{%s.}',tex_tit_2);
                fprintf(fidTeX,'\\label{Fig:ident_pattern:%s:2}\n',tittxt1);
                fprintf(fidTeX,'\\end{figure}\n\n');
                fprintf(fidTeX,'%% End Of TeX file. \n');
                fclose(fidTeX);
            end
        end
    end

else
    hh = dyn_figure(options_.nodisplay,'Name',['MC sensitivities']);
    subplot(211)
    mmm = (idehess.ide_strength_J);
    [ss, is] = sort(mmm);
    mmm = mean(si_Jnorm)';
    mmm = mmm./max(mmm);
    if advanced
        mmm1 = mean(si_dTAUnorm)';
        mmm=[mmm mmm1./max(mmm1)];
        mmm1 = mean(si_dLREnorm)';
        offset=size(si_dTAUnorm,2)-size(si_dLREnorm,2);
        mmm1 = [NaN(offset,1); mmm1./max(mmm1)];
        mmm=[mmm mmm1];
    end

    bar(mmm(is,:))
    set(gca,'xlim',[0 nparam+1])
    set(gca,'xticklabel','')
    dy = get(gca,'ylim');
    for ip=1:nparam
        text(ip,dy(1),name{is(ip)},'rotation',90,'HorizontalAlignment','right','interpreter','none')
    end
    if advanced
        legend('Moments','Model','LRE model','Location','Best')
    end
    title('MC mean of sensitivity measures')
    dyn_saveas(hh,[ IdentifDirectoryName '/' M_.fname '_MC_sensitivity' ],options_.nodisplay,options_.graph_format);
    if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
        fidTeX = fopen([ IdentifDirectoryName '/' M_.fname '_MC_sensitivity.tex'],'w');
        fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
        fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_MC_sensitivity}\n',[IdentifDirectoryName '/' M_.fname]);
        fprintf(fidTeX,'\\caption{MC mean of sensitivity measures}');
        fprintf(fidTeX,'\\label{Fig:_MC_sensitivity}\n');
        fprintf(fidTeX,'\\end{figure}\n\n');
        fprintf(fidTeX,'%% End Of TeX file. \n');
        fclose(fidTeX);
    end

    if advanced
        if ~options_.nodisplay,
            skipline()
            disp('Displaying advanced diagnostics')
        end
        %         options_.nograph=1;
        hh = dyn_figure(options_.nodisplay,'Name','MC Condition Number');
        subplot(221)
        hist(log10(idemodel.cond))
        title('log10 of Condition number in the model')
        subplot(222)
        hist(log10(idemoments.cond))
        title('log10 of Condition number in the moments')
        subplot(223)
        hist(log10(idelre.cond))
        title('log10 of Condition number in the LRE model')
        dyn_saveas(hh,[IdentifDirectoryName '/' M_.fname '_ident_COND' ],options_.nodisplay,options_.graph_format);
        options_mcf.pvalue_ks = 0.1;
        options_mcf.pvalue_corr = 0.001;
        options_mcf.alpha2 = 0;
        options_mcf.param_names = name;
        options_mcf.param_names_tex = name_tex;
        options_mcf.fname_ = M_.fname;
        options_mcf.OutputDirectoryName = IdentifDirectoryName;
        options_mcf.beha_title = 'LOW condition nbr';
        options_mcf.nobeha_title = 'HIGH condition nbr';
        options_mcf.amcf_name = 'MC_HighestCondNumberLRE';
        options_mcf.amcf_title = 'MC Highest Condition Number LRE Model';
        options_mcf.title = 'MC Highest Condition Number LRE Model';
        ncut=floor(SampleSize/10*9);
        [dum,is]=sort(idelre.cond);
        mcf_analysis(params, is(1:ncut), is(ncut+1:end), options_mcf, options_);
        options_mcf.amcf_name = 'MC_HighestCondNumberModel';
        options_mcf.amcf_title = 'MC Highest Condition Number Model Solution';
        options_mcf.title = 'MC Highest Condition Number Model Solution';
        [dum,is]=sort(idemodel.cond);
        mcf_analysis(params, is(1:ncut), is(ncut+1:end), options_mcf, options_);
        options_mcf.amcf_name = 'MC_HighestCondNumberMoments';
        options_mcf.amcf_title = 'MC Highest Condition Number Model Moments';
        options_mcf.title = 'MC Highest Condition Number Model Moments';
        [dum,is]=sort(idemoments.cond);
        mcf_analysis(params, is(1:ncut), is(ncut+1:end), options_mcf, options_);
        %         [proba, dproba] = stab_map_1(idemoments.Mco', is(1:ncut), is(ncut+1:end), 'HighestCondNumberMoments_vs_Mco', 1, [], IdentifDirectoryName);
        %         for j=1:nparam,
        % %             ibeh=find(idemoments.Mco(j,:)<0.9);
        % %             inonbeh=find(idemoments.Mco(j,:)>=0.9);
        % %             if ~isempty(ibeh) && ~isempty(inonbeh)
        % %                 [proba, dproba] = stab_map_1(params, ibeh, inonbeh, ['HighestMultiCollinearity_',name{j}], 1, [], IdentifDirectoryName);
        % %             end
        %             [~,is]=sort(idemoments.Mco(:,j));
        %             [proba, dproba] = stab_map_1(params, is(1:ncut), is(ncut+1:end), ['MC_HighestMultiCollinearity_',name{j}], 1, [], IdentifDirectoryName, 0.15);
        %         end

        if nparam<5
            f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - MC Identification patterns (moments): HIGHEST SV']);
            tex_tit_1=[tittxt,' - MC Identification patterns (moments): HIGHEST SV'];
        else
            f1 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - MC Identification patterns (moments): SMALLEST SV']);
            tex_tit_1=[tittxt,' - MC Identification patterns (moments): SMALLEST SV'];
            f2 = dyn_figure(options_.nodisplay,'Name',[tittxt,' - MC Identification patterns (moments): HIGHEST SV']);
            tex_tit_2=[tittxt,' - MC Identification patterns (moments): HIGHEST SV'];
        end
        nplots=min(nparam,8);
        if nplots>4
            nsubplo=ceil(nplots/2);
        else
            nsubplo=nplots;
        end
        for j=1:nplots
            if (nparam>4 && j<=ceil(nplots/2)) || nparam<5
                set(0,'CurrentFigure',f1),
                jj=j;
                VVV=squeeze(abs(idemoments.V(:,:,end-j+1)));
                SSS = idemoments.S(:,end-j+1);
            else
                set(0,'CurrentFigure',f2),
                jj=j-ceil(nplots/2);
                VVV=squeeze(abs(idemoments.V(:,:,jj)));
                SSS = idemoments.S(:,jj);
            end
            subplot(nsubplo,1,jj)
            for i=1:nparam
                [post_mean, post_median(:,i), post_var, hpd_interval(i,:), post_deciles] = posterior_moments(VVV(:,i),0,0.9);
            end
            bar(post_median)
            hold on, plot(hpd_interval,'--*r'),
            Stit=mean(SSS);

            set(gca,'xticklabel','')
            if j==4 || j==nparam || j==8
                for ip=1:nparam
                    text(ip,-0.02,name{ip},'rotation',90,'HorizontalAlignment','right','interpreter','none')
                end
            end
            title(['MEAN Singular value ',num2str(Stit)])
        end
        dyn_saveas(f1,[IdentifDirectoryName '/' M_.fname '_MC_ident_pattern_1' ],options_.nodisplay,options_.graph_format);
        if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
            fidTeX = fopen([IdentifDirectoryName '/' M_.fname '_MC_ident_pattern_1.tex'],'w');
            fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
            fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_MC_ident_pattern_1}\n',[IdentifDirectoryName '/' M_.fname]);
            fprintf(fidTeX,'\\caption{%s.}',tex_tit_1);
            fprintf(fidTeX,'\\label{Fig:MC_ident_pattern:1}\n');
            fprintf(fidTeX,'\\end{figure}\n\n');
            fprintf(fidTeX,'%% End Of TeX file. \n');
            fclose(fidTeX);
        end
        if nparam>4
            dyn_saveas(f2,[  IdentifDirectoryName '/' M_.fname '_MC_ident_pattern_2' ],options_.nodisplay,options_.graph_format);
            if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
                fidTeX = fopen([  IdentifDirectoryName '/' M_.fname '_MC_ident_pattern_2.tex'],'w');
                fprintf(fidTeX,'%% TeX eps-loader file generated by plot_identification.m (Dynare).\n');
                fprintf(fidTeX,['%% ' datestr(now,0) '\n\n']);
                fprintf(fidTeX,'\\begin{figure}[H]\n');
                fprintf(fidTeX,'\\centering \n');
                fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s_MC_ident_pattern_2}\n',[IdentifDirectoryName '/' M_.fname]);
                fprintf(fidTeX,'\\caption{%s.}',tex_tit_2);
                fprintf(fidTeX,'\\label{Fig:MC_ident_pattern:2}\n');
                fprintf(fidTeX,'\\end{figure}\n\n');
                fprintf(fidTeX,'%% End Of TeX file. \n');
                fclose(fidTeX);
            end
        end
    end
end
