/*
 *  /MathJax/extensions/a11y/collapsible.js
 *
 *  Copyright (c) 2009-2018 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

(function(d){var a;var e=d.config.menuSettings;var b={};var g=10000000;var f="data-semantic-complexity";var c=MathJax.Ajax.config.path;if(!c.a11y){c.a11y=d.config.root+"/extensions/a11y"}var h=MathJax.Extension.collapsible={version:"1.4.0",config:d.CombineConfig("collapsible",{disabled:false}),dependents:[],COMPLEXATTR:f,COMPLEXITY:{TEXT:0.5,TOKEN:0.5,CHILD:1,SCRIPT:0.8,SQRT:2,SUBSUP:2,UNDEROVER:2,FRACTION:2,ACTION:2,PHANTOM:0,XML:2,GLYPH:2},COLLAPSE:{identifier:3,number:3,text:10,infixop:15,relseq:15,multirel:15,fenced:18,bigop:20,integral:20,fraction:12,sqrt:9,root:12,vector:15,matrix:15,cases:15,superscript:9,subscript:9,subsup:9,punctuated:{endpunct:g,startpunct:g,value:12}},MARKER:{identifier:"x",number:"#",text:"...",appl:{"limit function":"lim",value:"f()"},fraction:"/",sqrt:"\u221A",root:"\u221A",superscript:"\u25FD\u02D9",subscript:"\u25FD.",subsup:"\u25FD:",vector:{binomial:"(:)",determinant:"|:|",value:"\u27E8:\u27E9"},matrix:{squarematrix:"[::]",rowvector:"\u27E8\u22EF\u27E9",columnvector:"\u27E8\u22EE\u27E9",determinant:"|::|",value:"(::)"},cases:"{:",infixop:{addition:"+",subtraction:"\u2212",multiplication:"\u22C5",implicit:"\u22C5",value:"+"},punctuated:{text:"...",value:","}},Enable:function(j,i){e.collapsible=true;if(i){b.collapsible=true}this.config.disabled=false;MathJax.Extension["semantic-enrich"].Enable(false,i);if(j){d.Queue(["Reprocess",d])}},Disable:function(m,l){e.collapsible=false;if(l){b.collapsible=false}this.config.disabled=true;for(var j=this.dependents.length-1;j>=0;j--){var k=this.dependents[j];if(k.Disable){k.Disable(false,l)}}if(m){d.Queue(["Reprocess",d])}},Dependent:function(i){this.dependents.push(i)},Startup:function(){a=MathJax.ElementJax.mml;var i=MathJax.Extension["semantic-enrich"];if(i){i.Dependent(this)}d.postInputHooks.Add(["Filter",h],100)},Filter:function(i,k,j){if(!i.enriched||this.config.disabled){return}i.root=i.root.Collapse();i.root.inputID=j.id},Marker:function(i){return a.mtext("\u25C2"+i+"\u25B8").With({mathcolor:"blue",attr:{},attrNames:[]})},MakeAction:function(o,l){var n=a.maction(o).With({id:this.getActionID(),actiontype:"toggle",complexity:o.getComplexity(),collapsible:true,attrNames:["id","actiontype","selection",f],attr:{},selection:2});n.attr[f]=n.complexity;if(l.type==="math"){var j=a.mrow().With({complexity:l.complexity,attrNames:[],attr:{}});j.Append.apply(j,l.data);for(var m=l.attrNames.length-1,k;k=l.attrNames[m];m--){if(k.substr(0,14)==="data-semantic-"){j.attr[k]=l.attr[k];j.attrNames.push(k);delete l.attr[k];l.attrNames.splice(m,1)}}j.complexity=l.complexity;n.Append(j);l.data=[];l.Append(n);l.complexity=n.complexity;n=l}else{n.Append(l)}return n},actionID:1,getActionID:function(){return"MJX-Collapse-"+this.actionID++},Collapse:function(k){k.getComplexity();var l=(k.attr||{})["data-semantic-type"];if(l){if(this["Collapse_"+l]){k=(this["Collapse_"+l])(k)}else{if(this.COLLAPSE[l]&&this.MARKER[l]){var m=k.attr["data-semantic-role"];var i=this.COLLAPSE[l];if(typeof(i)!=="number"){i=i[m]||i.value}if(k.complexity>i){var j=this.MARKER[l];if(typeof(j)!=="string"){j=j[m]||j.value}k=this.MakeAction(this.Marker(j),k)}}}}return k},UncollapseChild:function(j,l,i){if(i==null){i=1}if(this.SplitAttribute(j,"children").length===i){var k=(j.data.length===1&&j.data[0].inferred?j.data[0]:j);if(k&&k.data[l]&&k.data[l].collapsible){k.SetData(l,k.data[l].data[1]);j.complexity=k.complexity=null;j.getComplexity();return 1}}return 0},FindChildText:function(i,k){var j=this.FindChild(i,k);return(j?(j.CoreMO()||j).data.join(""):"?")},FindChild:function(k,o){if(k){if(k.attr&&k.attr["data-semantic-id"]===o){return k}if(!k.isToken){for(var l=0,j=k.data.length;l<j;l++){var n=this.FindChild(k.data[l],o);if(n){return n}}}}return null},SplitAttribute:function(i,j){return(i.attr["data-semantic-"+j]||"").split(/,/)},Collapse_fenced:function(j){this.UncollapseChild(j,1);if(j.complexity>this.COLLAPSE.fenced){if(j.attr["data-semantic-role"]==="leftright"){var i=j.data[0].data.join("")+j.data[j.data.length-1].data.join("");j=this.MakeAction(this.Marker(i),j)}}return j},Collapse_appl:function(j){if(this.UncollapseChild(j,2,2)){var i=this.MARKER.appl;i=i[j.attr["data-semantic-role"]]||i.value;j=this.MakeAction(this.Marker(i),j)}return j},Collapse_sqrt:function(i){this.UncollapseChild(i,0);if(i.complexity>this.COLLAPSE.sqrt){i=this.MakeAction(this.Marker(this.MARKER.sqrt),i)}return i},Collapse_root:function(i){this.UncollapseChild(i,0);if(i.complexity>this.COLLAPSE.sqrt){i=this.MakeAction(this.Marker(this.MARKER.sqrt),i)}return i},Collapse_enclose:function(i){if(this.SplitAttribute(i,"children").length===1){var k=(i.data.length===1&&i.data[0].inferred?i.data[0]:i);if(k.data[0]&&k.data[0].collapsible){var j=k.data[0];k.SetData(0,j.data[1]);j.SetData(1,i);i=j}}return i},Collapse_bigop:function(i){if(i.complexity>this.COLLAPSE.bigop||i.data[0].type!=="mo"){var k=this.SplitAttribute(i,"content").pop();var j=h.FindChildText(i,k);i=this.MakeAction(this.Marker(j),i)}return i},Collapse_integral:function(i){if(i.complexity>this.COLLAPSE.integral||i.data[0].type!=="mo"){var k=this.SplitAttribute(i,"content")[0];var j=h.FindChildText(i,k);i=this.MakeAction(this.Marker(j),i)}return i},Collapse_relseq:function(j){if(j.complexity>this.COLLAPSE.relseq){var k=this.SplitAttribute(j,"content");var i=h.FindChildText(j,k[0]);if(k.length>1){i+="\u22EF"}j=this.MakeAction(this.Marker(i),j)}return j},Collapse_multirel:function(j){if(j.complexity>this.COLLAPSE.multirel){var k=this.SplitAttribute(j,"content");var i=h.FindChildText(j,k[0])+"\u22EF";j=this.MakeAction(this.Marker(i),j)}return j},Collapse_superscript:function(i){this.UncollapseChild(i,0,2);if(i.complexity>this.COLLAPSE.superscript){i=this.MakeAction(this.Marker(this.MARKER.superscript),i)}return i},Collapse_subscript:function(i){this.UncollapseChild(i,0,2);if(i.complexity>this.COLLAPSE.subscript){i=this.MakeAction(this.Marker(this.MARKER.subscript),i)}return i},Collapse_subsup:function(i){this.UncollapseChild(i,0,3);if(i.complexity>this.COLLAPSE.subsup){i=this.MakeAction(this.Marker(this.MARKER.subsup),i)}return i}};d.Register.StartupHook("End Extensions",function(){if(e.collapsible==null){e.collapsible=!h.config.disabled}else{h.config.disabled=!e.collapsible}d.Register.StartupHook("MathMenu Ready",function(){b=MathJax.Menu.cookie;var j=function(o){h[e.collapsible?"Enable":"Disable"](true,true);MathJax.Menu.saveCookie()};var i=MathJax.Menu.ITEM,l=MathJax.Menu.menu;var n=i.CHECKBOX(["CollapsibleMath","Collapsible Math"],"collapsible",{action:j});var m=(l.FindId("Accessibility")||{}).submenu,k;if(m){k=m.IndexOfId("CollapsibleMath");if(k!==null){m.items[k]=n}else{m.items.push(i.RULE(),n)}}else{k=l.IndexOfId("About");l.items.splice(k,0,n,i.RULE())}},15)},15)})(MathJax.Hub);MathJax.Ajax.Require("[a11y]/semantic-enrich.js");MathJax.Hub.Register.StartupHook("Semantic Enrich Ready",function(){var a=MathJax.ElementJax.mml,d=MathJax.Extension.collapsible,b=d.COMPLEXITY,c=d.COMPLEXATTR;d.Startup();a.mbase.Augment({Collapse:function(){return d.Collapse(this)},getComplexity:function(){if(this.complexity==null){var f=0;if(this.isToken){f=b.TEXT*this.data.join("").length+b.TOKEN}else{for(var g=0,e=this.data.length;g<e;g++){if(this.data[g]){this.SetData(g,this.data[g].Collapse());f+=this.data[g].complexity}}if(e>1){f+=e*b.CHILD}}if(this.attrNames&&!("complexity" in this)){this.attrNames.push(c)}if(this.attr){this.attr[c]=f}this.complexity=f}return this.complexity},reportComplexity:function(){if(this.attr&&this.attrNames&&!(c in this.attr)){this.attrNames.push(c);this.attr[c]=this.complexity}}});a.mfrac.Augment({getComplexity:function(){if(this.complexity==null){this.SUPER(arguments).getComplexity.call(this);this.complexity*=b.SCRIPT;this.complexity+=b.FRACTION;this.attr[c]=this.complexity}return this.complexity}});a.msqrt.Augment({getComplexity:function(){if(this.complexity==null){this.SUPER(arguments).getComplexity.call(this);this.complexity+=b.SQRT;this.attr[c]=this.complexity}return this.complexity}});a.mroot.Augment({getComplexity:function(){if(this.complexity==null){this.SUPER(arguments).getComplexity.call(this);this.complexity-=(1-b.SCRIPT)*this.data[1].getComplexity();this.complexity+=b.SQRT;this.attr[c]=this.complexity}return this.complexity}});a.msubsup.Augment({getComplexity:function(){if(this.complexity==null){var e=0;if(this.data[this.sub]){e=this.data[this.sub].getComplexity()+b.CHILD}if(this.data[this.sup]){e=Math.max(this.data[this.sup].getComplexity(),e)}e*=b.SCRIPT;if(this.data[this.sub]){e+=b.CHILD}if(this.data[this.sup]){e+=b.CHILD}if(this.data[this.base]){e+=this.data[this.base].getComplexity()+b.CHILD}this.complexity=e+b.SUBSUP;this.reportComplexity()}return this.complexity}});a.munderover.Augment({getComplexity:function(){if(this.complexity==null){var e=0;if(this.data[this.sub]){e=this.data[this.sub].getComplexity()+b.CHILD}if(this.data[this.sup]){e=Math.max(this.data[this.sup].getComplexity(),e)}e*=b.SCRIPT;if(this.data[this.base]){e=Math.max(this.data[this.base].getComplexity(),e)}if(this.data[this.sub]){e+=b.CHILD}if(this.data[this.sup]){e+=b.CHILD}if(this.data[this.base]){e+=b.CHILD}this.complexity=e+b.UNDEROVER;this.reportComplexity()}return this.complexity}});a.mphantom.Augment({getComplexity:function(){this.complexity=b.PHANTOM;this.reportComplexity();return this.complexity}});a.ms.Augment({getComplexity:function(){this.SUPER(arguments).getComplexity.call(this);this.complexity+=this.Get("lquote").length*b.TEXT;this.complexity+=this.Get("rquote").length*b.TEXT;this.attr[c]=this.complexity;return this.complexity}});a.menclose.Augment({getComplexity:function(){if(this.complexity==null){this.SUPER(arguments).getComplexity.call(this);this.complexity+=b.ACTION;this.attr[c]=this.complexity}return this.complexity}});a.maction.Augment({getComplexity:function(){this.complexity=(this.collapsible?this.data[0]:this.selected()).getComplexity();this.reportComplexity();return this.complexity}});a.semantics.Augment({getComplexity:function(){if(this.complexity==null){this.complexity=(this.data[0]?this.data[0].getComplexity():0);this.reportComplexity()}return this.complexity}});a["annotation-xml"].Augment({getComplexity:function(){this.complexity=b.XML;this.reportComplexity();return this.complexity}});a.annotation.Augment({getComplexity:function(){this.complexity=b.XML;this.reportComplexity();return this.complexity}});a.mglyph.Augment({getComplexity:function(){this.complexity=b.GLYPH;this.reportComplexity();return this.complexity}});MathJax.Hub.Startup.signal.Post("Collapsible Ready");MathJax.Ajax.loadComplete("[a11y]/collapsible.js")});
