/*
 *  /MathJax/extensions/a11y/explorer.js
 *
 *  Copyright (c) 2009-2018 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

MathJax.Hub.Register.StartupHook("Sre Ready",function(){var e,b;var d=MathJax.Hub.config.menuSettings;var a={};MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Event.KEY});var c=MathJax.Extension.explorer={version:"1.4.0",dependents:[],defaults:{walker:"table",highlight:"none",background:"blue",foreground:"black",speech:true,generation:"lazy",subtitle:false,ruleset:"mathspeak-default"},eagerComplexity:80,prefix:"Assistive-",hook:null,locHook:null,oldrules:null,addMenuOption:function(i,j){d[c.prefix+i]=j},addDefaults:function(){var m=MathJax.Hub.CombineConfig("explorer",c.defaults);var l=Object.keys(m);for(var k=0,j;j=l[k];k++){if(typeof(d[c.prefix+j])==="undefined"){c.addMenuOption(j,m[j])}}c.setSpeechOption();f.Reset()},setOption:function(i,j){if(d[c.prefix+i]===j){return}c.addMenuOption(i,j);f.Reset()},getOption:function(i){return d[c.prefix+i]},speechOption:function(i){if(c.oldrules===i.value){return}c.setSpeechOption();f.Regenerate()},setSpeechOption:function(){var i=d[c.prefix+"ruleset"];var j=i.split("-");sre.System.getInstance().setupEngine({locale:MathJax.Localization.locale,domain:c.Domain(j[0]),style:j[1],rules:c.RuleSet(j[0])});c.oldrules=i},Domain:function(i){switch(i){case"chromevox":return"default";case"mathspeak":default:return"mathspeak"}},RuleSet:function(i){switch(i){case"chromevox":return["AbstractionRules","SemanticTreeRules"];case"mathspeak":default:return["AbstractionRules","AbstractionSpanish","MathspeakRules","MathspeakSpanish"]}},hook:null,locHook:null,Enable:function(j,i){d.explorer=true;if(i){a.explorer=true}MathJax.Extension.collapsible.Enable(false,i);if(MathJax.Extension.AssistiveMML){MathJax.Extension.AssistiveMML.config.disabled=true;d.assistiveMML=false;if(i){a.assistiveMML=false}}this.DisableMenus(false);if(!this.hook){this.hook=MathJax.Hub.Register.MessageHook("New Math",["Register",this.Explorer])}if(!this.locHook){this.locHook=MathJax.Hub.Register.MessageHook("Locale Reset",["RemoveSpeech",this.Explorer])}if(j){MathJax.Hub.Queue(["Reprocess",MathJax.Hub])}},Disable:function(m,l){d.explorer=false;if(l){a.explorer=false}this.DisableMenus(true);if(this.hook){MathJax.Hub.UnRegister.MessageHook(this.hook);this.hook=null}for(var j=this.dependents.length-1;j>=0;j--){var k=this.dependents[j];if(k.Disable){k.Disable(false,l)}}},DisableMenus:function(m){if(MathJax.Menu){var n=MathJax.Menu.menu.FindId("Accessibility","Explorer");if(n){n=n.submenu;var j=n.items;for(var k=2,l;l=j[k];k++){l.disabled=m}if(!m&&n.FindId("SpeechOutput")&&!d[c.prefix+"speech"]){n.FindId("Subtitles").disabled=true}}}},Dependent:function(i){this.dependents.push(i)}};var g=MathJax.Object.Subclass({div:null,inner:null,Init:function(){this.div=g.Create("assertive");this.inner=MathJax.HTML.addElement(this.div,"div")},Add:function(){if(g.added){return}document.body.appendChild(this.div);g.added=true},Show:function(l,j){this.div.classList.add("MJX_LiveRegion_Show");var k=l.getBoundingClientRect();var n=k.bottom+10+window.pageYOffset;var m=k.left+window.pageXOffset;this.div.style.top=n+"px";this.div.style.left=m+"px";var i=j.colorString();this.inner.style.backgroundColor=i.background;this.inner.style.color=i.foreground},Hide:function(i){this.div.classList.remove("MJX_LiveRegion_Show")},Clear:function(){this.Update("");this.inner.style.top="";this.inner.style.backgroundColor=""},Update:function(i){if(c.getOption("speech")){g.Update(this.inner,i)}}},{ANNOUNCE:"Navigatable Math in page. Explore with shift space and arrow keys. Expand or collapse elements hitting enter.",announced:false,added:false,styles:{".MJX_LiveRegion":{position:"absolute",top:"0",height:"1px",width:"1px",padding:"1px",overflow:"hidden"},".MJX_LiveRegion_Show":{top:"0",position:"absolute",width:"auto",height:"auto",padding:"0px 0px",opacity:1,"z-index":"202",left:0,right:0,margin:"0 auto","background-color":"white","box-shadow":"0px 10px 20px #888",border:"2px solid #CCCCCC"}},Create:function(j){var i=MathJax.HTML.Element("div",{className:"MJX_LiveRegion"});i.setAttribute("aria-live",j);return i},Update:MathJax.Hub.Browser.isPC?function(j,i){j.textContent="";setTimeout(function(){j.textContent=i},100)}:function(j,i){j.textContent="";j.textContent=i},Announce:function(){if(!c.getOption("speech")){return}g.announced=true;MathJax.Ajax.Styles(g.styles);var i=g.Create("polite");document.body.appendChild(i);g.Update(i,g.ANNOUNCE);setTimeout(function(){document.body.removeChild(i)},1000)}});MathJax.Extension.explorer.LiveRegion=g;var h=MathJax.Ajax.fileURL(MathJax.Ajax.config.path.a11y);var f=MathJax.Extension.explorer.Explorer={liveRegion:g(),walker:null,highlighter:null,hoverer:null,flamer:null,speechDiv:null,earconFile:h+"/invalid_keypress"+(["Firefox","Chrome","Opera"].indexOf(MathJax.Hub.Browser.name)!==-1?".ogg":".mp3"),expanded:false,focusoutEvent:MathJax.Hub.Browser.isFirefox?"blur":"focusout",focusinEvent:"focus",ignoreFocusOut:false,jaxCache:{},messageID:null,Reset:function(){f.FlameEnriched()},Register:function(k){if(!c.hook){return}var j=document.getElementById(k[1]);if(j&&j.id){var i=MathJax.Hub.getJaxFor(j.id);if(i&&i.enriched){f.StateChange(j.id,i);f.liveRegion.Add();f.AddEvent(j)}}},StateChange:function(k,i){f.GetHighlighter(0.2);var j=f.jaxCache[k];if(j&&j===i.root){return}if(j){f.highlighter.resetState(k+"-Frame")}f.jaxCache[k]=i.root},AddAria:function(i){i.setAttribute("role","application");i.setAttribute("aria-label","Math")},AddHook:function(i){f.RemoveHook();f.hook=MathJax.Hub.Register.MessageHook("End Math",function(l){var j=l[1].id+"-Frame";var k=document.getElementById(j);if(i&&j===f.expanded){f.ActivateWalker(k,i);k.focus();f.expanded=false}})},RemoveHook:function(){if(f.hook){MathJax.Hub.UnRegister.MessageHook(f.hook);f.hook=null}},AddMessage:function(){return MathJax.Message.Set("Generating Speech Output")},RemoveMessage:function(i){if(i){MathJax.Message.Clear(i)}},AddEvent:function(i){var l=i.id+"-Frame";var j=i.previousSibling;if(!j){return}var k=j.id!==l?j.firstElementChild:j;f.AddAria(k);f.AddMouseEvents(k);if(k.className==="MathJax_MathML"){k=k.firstElementChild}if(!k){return}k.onkeydown=f.Keydown;f.Flame(k);k.addEventListener(f.focusinEvent,function(m){if(!c.hook){return}if(!g.announced){g.Announce()}});k.addEventListener(f.focusoutEvent,function(m){if(!c.hook){return}if(f.ignoreFocusOut){f.ignoreFocusOut=false;if(f.walker.moved==="enter"){m.target.focus();return}}if(f.walker){f.DeactivateWalker()}});if(c.getOption("speech")){f.AddSpeech(k)}},AddSpeech:function(k){var m=k.id;var j=MathJax.Hub.getJaxFor(m);var l=j.root.toMathML();if(!k.getAttribute("haslabel")){f.AddMathLabel(l,m)}if(k.getAttribute("hasspeech")){return}switch(MathJax.Hub.config.explorer.generation){case"eager":f.AddSpeechEager(l,m);break;case"mixed":var i=k.querySelectorAll("[data-semantic-complexity]");if(i.length>=c.eagerComplexity){f.AddSpeechEager(l,m)}break;case"lazy":default:break}},AddSpeechLazy:function(i){var j=new sre.TreeSpeechGenerator();j.setRebuilt(f.walker.rebuilt);j.getSpeech(f.walker.rootNode,f.walker.xml);i.setAttribute("hasspeech","true")},AddSpeechEager:function(i,j){f.MakeSpeechTask(i,j,sre.TreeSpeechGenerator,function(l,k){l.setAttribute("hasspeech","true")},5)},AddMathLabel:function(i,j){f.MakeSpeechTask(i,j,sre.SummarySpeechGenerator,function(l,k){l.setAttribute("haslabel","true");l.setAttribute("aria-label",k)},5)},MakeSpeechTask:function(l,n,k,j,m){var i=f.AddMessage();setTimeout(function(){var q=new k();var p=document.getElementById(n);var r=new sre.DummyWalker(p,q,f.highlighter,l);var o=r.speech();if(o){j(p,o)}f.RemoveMessage(i)},m)},Keydown:function(l){if(l.keyCode===b.ESCAPE){if(!f.walker){return}f.RemoveHook();f.DeactivateWalker();e(l);return}if(f.walker&&f.walker.isActive()){if(typeof(f.walker.modifier)!=="undefined"){f.walker.modifier=l.shiftKey}var j=f.walker.move(l.keyCode);if(j===null){return}if(j){if(f.walker.moved==="expand"){f.expanded=f.walker.node.id;if(MathJax.Hub.Browser.isEdge){f.ignoreFocusOut=true;f.DeactivateWalker();return}if(MathJax.Hub.Browser.isFirefox||MathJax.Hub.Browser.isMSIE){f.DeactivateWalker();return}}f.liveRegion.Update(f.walker.speech());f.Highlight()}else{f.PlayEarcon()}e(l);return}var k=l.target;if(l.keyCode===b.SPACE){if(l.shiftKey&&c.hook){var i=MathJax.Hub.getJaxFor(k);f.ActivateWalker(k,i);f.AddHook(i)}else{MathJax.Extension.MathEvents.Event.ContextMenu(l,k)}e(l);return}},GetHighlighter:function(i){f.highlighter=sre.HighlighterFactory.highlighter({color:c.getOption("background"),alpha:i},{color:c.getOption("foreground"),alpha:1},{renderer:MathJax.Hub.outputJax["jax/mml"][0].id,browser:MathJax.Hub.Browser.name})},AddMouseEvents:function(i){sre.HighlighterFactory.addEvents(i,{mouseover:f.MouseOver,mouseout:f.MouseOut},{renderer:MathJax.Hub.outputJax["jax/mml"][0].id,browser:MathJax.Hub.Browser.name})},MouseOver:function(i){if(c.getOption("highlight")==="none"){return}if(c.getOption("highlight")==="hover"){var j=i.currentTarget;f.GetHighlighter(0.1);f.highlighter.highlight([j]);f.hoverer=true}e(i)},MouseOut:function(i){if(f.hoverer){f.highlighter.unhighlight();f.hoverer=false}return e(i)},Flame:function(i){if(c.getOption("highlight")==="flame"){f.GetHighlighter(0.05);f.highlighter.highlightAll(i);f.flamer=true;return}},UnFlame:function(){if(f.flamer){f.highlighter.unhighlightAll();f.flamer=null}},FlameEnriched:function(){f.UnFlame();for(var k=0,l=MathJax.Hub.getAllJax(),j;j=l[k];k++){f.Flame(j.SourceElement().previousSibling)}},Walkers:{syntactic:sre.SyntaxWalker,table:sre.TableWalker,semantic:sre.SemanticWalker,none:sre.DummyWalker},ActivateWalker:function(m,i){var k=c.getOption("speech");var j=c.getOption("walker")?f.Walkers[MathJax.Hub.config.explorer.walker]:f.Walkers.none;var l=k?new sre.DirectSpeechGenerator():new sre.DummySpeechGenerator();f.GetHighlighter(0.2);f.walker=new j(m,l,f.highlighter,i.root.toMathML());if(k&&!m.getAttribute("hasspeech")){f.AddSpeechLazy(m)}f.walker.activate();if(k){if(c.getOption("subtitle")){f.liveRegion.Show(m,f.highlighter)}f.liveRegion.Update(f.walker.speech())}f.Highlight();if(f.ignoreFocusOut){setTimeout(function(){f.ignoreFocusOut=false},500)}},DeactivateWalker:function(){f.liveRegion.Clear();f.liveRegion.Hide();f.Unhighlight();f.currentHighlight=null;f.walker.deactivate();f.walker=null},Highlight:function(){f.Unhighlight();f.highlighter.highlight(f.walker.getFocus().getNodes())},Unhighlight:function(){f.highlighter.unhighlight()},PlayEarcon:function(){var i=new Audio(f.earconFile);i.play()},SpeechOutput:function(){f.Reset();var i=["Subtitles"];i.forEach(function(j){var k=MathJax.Menu.menu.FindId("Accessibility","Explorer",j);if(k){k.disabled=!k.disabled}});f.Regenerate()},RemoveSpeech:function(){c.setSpeechOption();for(var k=0,l=MathJax.Hub.getAllJax(),j;j=l[k];k++){var m=document.getElementById(j.inputID+"-Frame");if(m){m.removeAttribute("hasspeech");m.removeAttribute("haslabel")}}},Regenerate:function(){for(var k=0,l=MathJax.Hub.getAllJax(),j;j=l[k];k++){var m=document.getElementById(j.inputID+"-Frame");if(m){m.removeAttribute("hasspeech");f.AddSpeech(m)}}},Startup:function(){var i=MathJax.Extension.collapsible;if(i){i.Dependent(c)}c.addDefaults()}};MathJax.Hub.Register.StartupHook("End Extensions",function(){c[d.explorer===false?"Disable":"Enable"]();MathJax.Hub.Startup.signal.Post("Explorer Ready");MathJax.Hub.Register.StartupHook("MathMenu Ready",function(){a=MathJax.Menu.cookie;var l=function(q){c[d.explorer?"Enable":"Disable"](true,true);MathJax.Menu.saveCookie()};var k=MathJax.Menu.ITEM,n=MathJax.Menu.menu;var p={action:f.Reset};var j={action:c.speechOption};var i=k.SUBMENU(["Explorer","Explorer"],k.CHECKBOX(["Active","Active"],"explorer",{action:l}),k.RULE(),k.CHECKBOX(["Walker","Walker"],"Assistive-walker"),k.SUBMENU(["Highlight","Highlight"],k.RADIO(["none","None"],"Assistive-highlight",p),k.RADIO(["hover","Hover"],"Assistive-highlight",p),k.RADIO(["flame","Flame"],"Assistive-highlight",p)),k.SUBMENU(["Background","Background"],k.RADIO(["blue","Blue"],"Assistive-background",p),k.RADIO(["red","Red"],"Assistive-background",p),k.RADIO(["green","Green"],"Assistive-background",p),k.RADIO(["yellow","Yellow"],"Assistive-background",p),k.RADIO(["cyan","Cyan"],"Assistive-background",p),k.RADIO(["magenta","Magenta"],"Assistive-background",p),k.RADIO(["white","White"],"Assistive-background",p),k.RADIO(["black","Black"],"Assistive-background",p)),k.SUBMENU(["Foreground","Foreground"],k.RADIO(["black","Black"],"Assistive-foreground",p),k.RADIO(["white","White"],"Assistive-foreground",p),k.RADIO(["magenta","Magenta"],"Assistive-foreground",p),k.RADIO(["cyan","Cyan"],"Assistive-foreground",p),k.RADIO(["yellow","Yellow"],"Assistive-foreground",p),k.RADIO(["green","Green"],"Assistive-foreground",p),k.RADIO(["red","Red"],"Assistive-foreground",p),k.RADIO(["blue","Blue"],"Assistive-foreground",p)),k.RULE(),k.CHECKBOX(["SpeechOutput","Speech Output"],"Assistive-speech",{action:f.SpeechOutput}),k.CHECKBOX(["Subtitles","Subtitles"],"Assistive-subtitle",{disabled:!d["Assistive-speech"]}),k.RULE(),k.SUBMENU(["Mathspeak","Mathspeak Rules"],k.RADIO(["mathspeak-default","Verbose"],"Assistive-ruleset",j),k.RADIO(["mathspeak-brief","Brief"],"Assistive-ruleset",j),k.RADIO(["mathspeak-sbrief","Superbrief"],"Assistive-ruleset",j)),k.SUBMENU(["Chromevox","ChromeVox Rules"],k.RADIO(["chromevox-default","Verbose"],"Assistive-ruleset",j),k.RADIO(["chromevox-short","Short"],"Assistive-ruleset",j),k.RADIO(["chromevox-alternative","Alternative"],"Assistive-ruleset",j)));var o=(n.FindId("Accessibility")||{}).submenu,m;if(o){m=o.IndexOfId("Explorer");if(m!==null){o.items[m]=i}else{m=o.IndexOfId("CollapsibleMath");o.items.splice(m+1,0,i)}}else{m=n.IndexOfId("CollapsibleMath");n.items.splice(m+1,0,i)}if(!d.explorer){c.DisableMenus(true)}},20)},20)});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){MathJax.Hub.Config({SVG:{addMMLclasses:true}});var b=MathJax.OutputJax.SVG;if(parseFloat(b.version)<2.7){var a=b.getJaxFromMath;b.Augment({getJaxFromMath:function(c){if(c.parentNode.className.match(/MathJax_SVG_Display/)){c=c.parentNode}return a.call(this,c)}})}});if(!MathJax.Ajax.config.path.a11y){MathJax.Ajax.config.path.a11y=MathJax.Hub.config.root+"/extensions/a11y"}MathJax.Ajax.Require("[a11y]/collapsible.js");MathJax.Hub.Register.StartupHook("Collapsible Ready",function(){MathJax.Extension.explorer.Explorer.Startup();MathJax.Ajax.loadComplete("[a11y]/explorer.js")});
